"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Grafana = void 0;
// generated by cdk8s
const cdk8s_1 = require("cdk8s");
/**
 *
 *
 * @schema Grafana
 */
class Grafana extends cdk8s_1.ApiObject {
    /**
     * Renders a Kubernetes manifest for "Grafana".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props
     */
    static manifest(props) {
        return {
            ...Grafana.GVK,
            ...props,
        };
    }
    /**
     * Defines a "Grafana" API object
     * @param scope the scope in which to define this object
     * @param id a scope-local name for the object
     * @param props initialization props
     */
    constructor(scope, id, props) {
        super(scope, id, Grafana.manifest(props));
    }
}
exports.Grafana = Grafana;
/**
 * Returns the apiVersion and kind for "Grafana"
 */
Grafana.GVK = {
    apiVersion: 'integreatly.org/v1alpha1',
    kind: 'Grafana',
};
//# sourceMappingURL=data:application/json;base64,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