import { Stack, CustomResource, aws_iam as iam } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * Properties of the RemoteOutputs
 */
export interface RemoteOutputsProps {
    /**
     * The remote CDK stack to get the outputs from.
     */
    readonly stack: Stack;
    /**
     * Indicate whether always update the custom resource to get the new stack output
     * @default true
     */
    readonly alwaysUpdate?: boolean;
}
/**
 * Represents the RemoteOutputs of the remote CDK stack
 */
export declare class RemoteOutputs extends Construct {
    /**
     * The outputs from the remote stack.
     */
    readonly outputs: CustomResource;
    constructor(scope: Construct, id: string, props: RemoteOutputsProps);
    /**
     * Get the attribute value from the outputs.
     * @param key output key
     */
    get(key: string): string;
}
/**
 * Properties of the RemoteParameters
 */
export interface RemoteParametersProps {
    /**
     * The region code of the remote stack.
     */
    readonly region: string;
    /**
     * The assumed role used to get remote parameters.
     */
    readonly role?: iam.IRole;
    /**
     * The parameter path.
     */
    readonly path: string;
    /**
     * Indicate whether always update the custom resource to get the new stack output
     * @default true
     */
    readonly alwaysUpdate?: boolean;
}
/**
 * Represents the RemoteParameters of the remote CDK stack
 */
export declare class RemoteParameters extends Construct {
    /**
     * The parameters in the SSM parameter store for the remote stack.
     */
    readonly parameters: CustomResource;
    constructor(scope: Construct, id: string, props: RemoteParametersProps);
    /**
     * Get the parameter.
     * @param key output key
     */
    get(key: string): string;
}
