"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CDK8sProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const provider_kubernetes_1 = require("@cdktf/provider-kubernetes");
const cdktf_1 = require("cdktf");
const yaml = require("yaml");
// TODO: Offer option that base64 encodes the strings and wraps them in btoa
// TODO: Order Terraform Manifests
function wrapLeafStringKeys(object) {
    if (typeof object === "string") {
        return object
            .replace(/\n/g, "\\n") // escape newlines
            .replace(/\${/g, "$$${"); // escape ${ to $${;
    }
    const ret = Object.entries(object).reduce((acc, [key, value]) => {
        if (typeof value === "string") {
            return {
                ...acc,
                [key]: wrapLeafStringKeys(value),
            };
        }
        if (typeof value === "object") {
            if (Array.isArray(value)) {
                return {
                    ...acc,
                    [key]: value.map(wrapLeafStringKeys),
                };
            }
            else {
                return {
                    ...acc,
                    [key]: wrapLeafStringKeys(value),
                };
            }
        }
        return { ...acc, [key]: value };
    }, {});
    return ret;
}
class CDK8sProvider extends provider_kubernetes_1.provider.KubernetesProvider {
    constructor(scope, id, config) {
        super(scope, id, config);
        this.alias = `cdktf-cdk8s-${id}`;
        cdktf_1.Aspects.of(scope).add({
            visit: (node) => {
                // Only run once
                if (node !== this)
                    return;
                const yamlManifests = yaml.parseAllDocuments(config.cdk8sApp.synthYaml());
                yamlManifests.forEach((yamlManifest) => {
                    const jsonManifest = yamlManifest.toJSON();
                    const type = `${jsonManifest.apiVersion}-${jsonManifest.kind}`;
                    const namespace = jsonManifest.metadata.namespace || "default";
                    const uniqueId = `${jsonManifest.metadata.name || jsonManifest.metadata.generateName}-${namespace}`;
                    const manifestContent = wrapLeafStringKeys(jsonManifest);
                    new provider_kubernetes_1.manifest.Manifest(this, `${id}-${type}-${uniqueId}`, {
                        provider: this,
                        manifest: manifestContent,
                    });
                });
            },
        });
    }
}
exports.CDK8sProvider = CDK8sProvider;
_a = JSII_RTTI_SYMBOL_1;
CDK8sProvider[_a] = { fqn: "cdktf-cdk8s.CDK8sProvider", version: "0.5.1" };
//# sourceMappingURL=data:application/json;base64,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