# -*- coding: utf-8 -*-
# *******************************************************
#   ____                     _               _
#  / ___|___  _ __ ___   ___| |_   _ __ ___ | |
# | |   / _ \| '_ ` _ \ / _ \ __| | '_ ` _ \| |
# | |__| (_) | | | | | |  __/ |_ _| | | | | | |
#  \____\___/|_| |_| |_|\___|\__(_)_| |_| |_|_|
#
#  Sign up for free at https://www.comet.com
#  Copyright (C) 2015-2025 Comet ML INC
#  This source code is licensed under the MIT license.
# *******************************************************

# global placeholder for comet_url_override
COMET_URL_OVERRIDE_CONFIG_KEY = "comet.url_override"

DEFAULT_UPLOAD_SIZE_LIMIT = 200 * 1024 * 1024  # 200 MebiBytes

DEFAULT_ASSET_UPLOAD_SIZE_LIMIT = 100 * 1024 * 1024 * 1024  # 100GiB

DEFAULT_3D_CLOUD_UPLOAD_LIMITS = {
    "maxPoints": 1000000,
    "maxPointsFileSizeInBytes": 0,
    "maxBoxes": 250000,
    "maxBoxesFileSizeInBytes": 0,
}

DEFAULT_STREAMER_MSG_TIMEOUT = 60 * 60  # 1 Hour

ADDITIONAL_STREAMER_UPLOAD_TIMEOUT = 3 * 60 * 60  # 3 hours

DEFAULT_FILE_UPLOAD_READ_TIMEOUT = 900

DEFAULT_ARTIFACT_DOWNLOAD_TIMEOUT = 3 * 60 * 60  # 3 hours

DEFAULT_REMOTE_MODEL_DOWNLOAD_TIMEOUT = 3 * 60 * 60  # 3 hours

DEFAULT_INITIAL_DATA_LOGGER_JOIN_TIMEOUT = 5 * 60

# the sleep interval in the experiment cleanup phase between checks if queue, batches, and retries is already flushed
DEFAULT_WAIT_FOR_FINISH_SLEEP_INTERVAL = 1  # 1 second

DEFAULT_OFFLINE_DATA_DIRECTORY = ".cometml-runs"

DEFAULT_POOL_RATIO = 4

DEFAULT_SYSTEM_MONITORING_INTERVAL = 30

MAX_POOL_SIZE = 64

ARTIFACT_REMOTE_ASSETS_BATCH_METRIC_INTERVAL_SECONDS = 10

ARTIFACT_REMOTE_ASSETS_BATCH_METRIC_MAX_BATCH_SIZE = 10000

MESSAGE_BATCH_USE_COMPRESSION_DEFAULT = True

MESSAGE_BATCH_PARAMETERS_INTERVAL_SECONDS = 60

MESSAGE_BATCH_METRIC_INTERVAL_SECONDS = 2

MESSAGE_BATCH_METRIC_MAX_BATCH_SIZE = 1000

MESSAGE_BATCH_STDOUT_INTERVAL_SECONDS = 5

MESSAGE_BATCH_STDOUT_MAX_BATCH_SIZE = 500

OFFLINE_EXPERIMENT_MESSAGES_JSON_FILE_NAME = "messages.json"

OFFLINE_EXPERIMENT_JSON_FILE_NAME = "experiment.json"

FALLBACK_STREAMER_CONNECTION_CHECK_INTERVAL_SECONDS = 2

UPLOAD_FILE_MAX_RETRIES = 4
UPLOAD_FILE_RETRY_BACKOFF_FACTOR = 3

S3_MULTIPART_SIZE_THRESHOLD_DEFAULT = 50 * 1024 * 1024  # 50MiB
S3_MULTIPART_EXPIRES_IN = 3 * 60 * 60  # 3 hours

HTTP_SESSION_RETRY_TOTAL_DEFAULT = 3
HTTP_SESSION_RETRY_BACKOFF_FACTOR_DEFAULT = 2

GET_OR_ADD_RUN_RETRY_CONNECT = 4
GET_OR_ADD_RUN_RETRY_STATUS = 4
GET_OR_ADD_RUN_RETRY_READ = 10
GET_OR_ADD_RUN_RETRY_TOTAL = 10
GET_OR_ADD_RUN_RETRY_BACKOFF_FACTOR = 1
GET_OR_ADD_RUN_RETRY_BACKOFF_MAX = 12

COMET_ROOT_URL = "https://www.comet.com/"
DEFAULT_COMET_BASE_URL = "https://www.comet.com"
DEFAULT_COMET_URL_OVERRIDE_PATH = "/clientlib/"
DEFAULT_COMET_URL_OVERRIDE = DEFAULT_COMET_BASE_URL + DEFAULT_COMET_URL_OVERRIDE_PATH

MAXIMAL_KEY_LENGTH = 100
MAXIMAL_VALUE_LENGTH = 1000

AUTO_OUTPUT_LOGGING_DEFAULT_VALUE = "simple"

DEFAULT_RETRY_AFTER_SECONDS = 60.0

INITIAL_HEARTBEAT_INTERVAL = 10  # 10 second

DEFAULT_STREAMER_BEAT_DURATION = 1

PROGRESS_CALLBACK_INTERVAL = 10

MAXIMAL_SVG_FIGURE_SIZE = 1024 * 1024  # 1 Mb

MAXIMAL_LENGTH_OF_OUTPUT_LINE = 5_000_000
