# -*- coding: utf-8 -*-
# *******************************************************
#   ____                     _               _
#  / ___|___  _ __ ___   ___| |_   _ __ ___ | |
# | |   / _ \| '_ ` _ \ / _ \ __| | '_ ` _ \| |
# | |__| (_) | | | | | |  __/ |_ _| | | | | | |
#  \____\___/|_| |_| |_|\___|\__(_)_| |_| |_|_|
#
#  Sign up for free at https://www.comet.com
#  Copyright (C) 2015-2021 Comet ML INC
#  This source code is licensed under the MIT license.
# *******************************************************

import atexit

import sentry_sdk


def register_flush():
    # this should probably be updated after we merge
    # CM-9290 which introduces new atexit mechanism
    client = sentry_sdk.Hub.current.client
    if client is not None:
        atexit.register(client.flush, timeout=2.0)
