# -*- coding: utf-8 -*-
# *******************************************************
#   ____                     _               _
#  / ___|___  _ __ ___   ___| |_   _ __ ___ | |
# | |   / _ \| '_ ` _ \ / _ \ __| | '_ ` _ \| |
# | |__| (_) | | | | | |  __/ |_ _| | | | | | |
#  \____\___/|_| |_| |_|\___|\__(_)_| |_| |_|_|
#
#  Sign up for free at https://www.comet.com
#  Copyright (C) 2015-2021 Comet ML INC
#  This source code is licensed under the MIT license.
# *******************************************************
import json

from comet_ml._typing import Any, Dict


def sanitize_environment_variables(pipeline_details):
    # type: (Dict[Any]) -> Dict[Any]
    if not isinstance(pipeline_details, dict):
        return pipeline_details

    for key, value in pipeline_details.items():
        if key == "env":
            if isinstance(value, dict):
                pipeline_details[key] = {}
            elif isinstance(value, str):
                pipeline_details[key] = ""
            else:
                pipeline_details[key] = []
        elif isinstance(value, list):
            for i, item in enumerate(value):
                value[i] = sanitize_environment_variables(item)
        elif isinstance(value, str):
            pipeline_details[key] = (
                _kubeflow_handle_string_which_is_itself_encoded_json(value)
            )
        sanitize_environment_variables(value)
    return pipeline_details


def _kubeflow_handle_string_which_is_itself_encoded_json(value):
    if _is_json(value):
        return json.dumps(sanitize_environment_variables(json.loads(value)))
    else:
        return value


def _is_json(myjson):
    try:
        json.loads(myjson)
    except ValueError:
        return False
    return True
