import click
import csv
from faker import Faker

"""
开发一个工具，用于批量模拟生成测试数据
"""

fake = Faker(locale='zh_CN')

@click.command()
@click.option('--output', '-o', default='data.csv', help='Output file name')
@click.option('--count', '-c', default=10, type=int, help='Number of data records to generate')
def generate_data(output, count):
    data = []
    for _ in range(count):
        username = fake.name()
        password = fake.password()
        phone = fake.phone_number()
        id_card = fake.ssn()
        company = fake.company()
        address = fake.address()
        position = fake.job()
        email = fake.email()
        data.append([username, password, phone, id_card, company, address, position, email])
        print(data)

    title_list = ["姓名", "密码", "手机号", "身份证号码", "公司名称", "地址", "职位", "邮箱"]
    with open(output, 'w', newline='') as f:
        writer = csv.writer(f)
        writer.writerow(title_list)
        writer.writerows(data)

if __name__ == '__main__':
    generate_data()