# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CustomDomainArgs', 'CustomDomain']

@pulumi.input_type
class CustomDomainArgs:
    def __init__(__self__, *,
                 api_management_id: pulumi.Input[_builtins.str],
                 developer_portals: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainDeveloperPortalArgs']]]] = None,
                 gateways: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainGatewayArgs']]]] = None,
                 managements: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainManagementArgs']]]] = None,
                 portals: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainPortalArgs']]]] = None,
                 scms: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainScmArgs']]]] = None):
        """
        The set of arguments for constructing a CustomDomain resource.
        :param pulumi.Input[_builtins.str] api_management_id: The ID of the API Management service for which to configure Custom Domains. Changing this forces a new API Management Custom Domain resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['CustomDomainDeveloperPortalArgs']]] developer_portals: One or more `developer_portal` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['CustomDomainGatewayArgs']]] gateways: One or more `gateway` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['CustomDomainManagementArgs']]] managements: One or more `management` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['CustomDomainPortalArgs']]] portals: One or more `portal` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['CustomDomainScmArgs']]] scms: One or more `scm` blocks as defined below.
        """
        pulumi.set(__self__, "api_management_id", api_management_id)
        if developer_portals is not None:
            pulumi.set(__self__, "developer_portals", developer_portals)
        if gateways is not None:
            pulumi.set(__self__, "gateways", gateways)
        if managements is not None:
            pulumi.set(__self__, "managements", managements)
        if portals is not None:
            pulumi.set(__self__, "portals", portals)
        if scms is not None:
            pulumi.set(__self__, "scms", scms)

    @_builtins.property
    @pulumi.getter(name="apiManagementId")
    def api_management_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the API Management service for which to configure Custom Domains. Changing this forces a new API Management Custom Domain resource to be created.
        """
        return pulumi.get(self, "api_management_id")

    @api_management_id.setter
    def api_management_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_management_id", value)

    @_builtins.property
    @pulumi.getter(name="developerPortals")
    def developer_portals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainDeveloperPortalArgs']]]]:
        """
        One or more `developer_portal` blocks as defined below.
        """
        return pulumi.get(self, "developer_portals")

    @developer_portals.setter
    def developer_portals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainDeveloperPortalArgs']]]]):
        pulumi.set(self, "developer_portals", value)

    @_builtins.property
    @pulumi.getter
    def gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainGatewayArgs']]]]:
        """
        One or more `gateway` blocks as defined below.
        """
        return pulumi.get(self, "gateways")

    @gateways.setter
    def gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainGatewayArgs']]]]):
        pulumi.set(self, "gateways", value)

    @_builtins.property
    @pulumi.getter
    def managements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainManagementArgs']]]]:
        """
        One or more `management` blocks as defined below.
        """
        return pulumi.get(self, "managements")

    @managements.setter
    def managements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainManagementArgs']]]]):
        pulumi.set(self, "managements", value)

    @_builtins.property
    @pulumi.getter
    def portals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainPortalArgs']]]]:
        """
        One or more `portal` blocks as defined below.
        """
        return pulumi.get(self, "portals")

    @portals.setter
    def portals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainPortalArgs']]]]):
        pulumi.set(self, "portals", value)

    @_builtins.property
    @pulumi.getter
    def scms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainScmArgs']]]]:
        """
        One or more `scm` blocks as defined below.
        """
        return pulumi.get(self, "scms")

    @scms.setter
    def scms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainScmArgs']]]]):
        pulumi.set(self, "scms", value)


@pulumi.input_type
class _CustomDomainState:
    def __init__(__self__, *,
                 api_management_id: Optional[pulumi.Input[_builtins.str]] = None,
                 developer_portals: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainDeveloperPortalArgs']]]] = None,
                 gateways: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainGatewayArgs']]]] = None,
                 managements: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainManagementArgs']]]] = None,
                 portals: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainPortalArgs']]]] = None,
                 scms: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainScmArgs']]]] = None):
        """
        Input properties used for looking up and filtering CustomDomain resources.
        :param pulumi.Input[_builtins.str] api_management_id: The ID of the API Management service for which to configure Custom Domains. Changing this forces a new API Management Custom Domain resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['CustomDomainDeveloperPortalArgs']]] developer_portals: One or more `developer_portal` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['CustomDomainGatewayArgs']]] gateways: One or more `gateway` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['CustomDomainManagementArgs']]] managements: One or more `management` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['CustomDomainPortalArgs']]] portals: One or more `portal` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['CustomDomainScmArgs']]] scms: One or more `scm` blocks as defined below.
        """
        if api_management_id is not None:
            pulumi.set(__self__, "api_management_id", api_management_id)
        if developer_portals is not None:
            pulumi.set(__self__, "developer_portals", developer_portals)
        if gateways is not None:
            pulumi.set(__self__, "gateways", gateways)
        if managements is not None:
            pulumi.set(__self__, "managements", managements)
        if portals is not None:
            pulumi.set(__self__, "portals", portals)
        if scms is not None:
            pulumi.set(__self__, "scms", scms)

    @_builtins.property
    @pulumi.getter(name="apiManagementId")
    def api_management_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the API Management service for which to configure Custom Domains. Changing this forces a new API Management Custom Domain resource to be created.
        """
        return pulumi.get(self, "api_management_id")

    @api_management_id.setter
    def api_management_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_management_id", value)

    @_builtins.property
    @pulumi.getter(name="developerPortals")
    def developer_portals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainDeveloperPortalArgs']]]]:
        """
        One or more `developer_portal` blocks as defined below.
        """
        return pulumi.get(self, "developer_portals")

    @developer_portals.setter
    def developer_portals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainDeveloperPortalArgs']]]]):
        pulumi.set(self, "developer_portals", value)

    @_builtins.property
    @pulumi.getter
    def gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainGatewayArgs']]]]:
        """
        One or more `gateway` blocks as defined below.
        """
        return pulumi.get(self, "gateways")

    @gateways.setter
    def gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainGatewayArgs']]]]):
        pulumi.set(self, "gateways", value)

    @_builtins.property
    @pulumi.getter
    def managements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainManagementArgs']]]]:
        """
        One or more `management` blocks as defined below.
        """
        return pulumi.get(self, "managements")

    @managements.setter
    def managements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainManagementArgs']]]]):
        pulumi.set(self, "managements", value)

    @_builtins.property
    @pulumi.getter
    def portals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainPortalArgs']]]]:
        """
        One or more `portal` blocks as defined below.
        """
        return pulumi.get(self, "portals")

    @portals.setter
    def portals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainPortalArgs']]]]):
        pulumi.set(self, "portals", value)

    @_builtins.property
    @pulumi.getter
    def scms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainScmArgs']]]]:
        """
        One or more `scm` blocks as defined below.
        """
        return pulumi.get(self, "scms")

    @scms.setter
    def scms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainScmArgs']]]]):
        pulumi.set(self, "scms", value)


@pulumi.type_token("azure:apimanagement/customDomain:CustomDomain")
class CustomDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_id: Optional[pulumi.Input[_builtins.str]] = None,
                 developer_portals: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainDeveloperPortalArgs', 'CustomDomainDeveloperPortalArgsDict']]]]] = None,
                 gateways: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainGatewayArgs', 'CustomDomainGatewayArgsDict']]]]] = None,
                 managements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainManagementArgs', 'CustomDomainManagementArgsDict']]]]] = None,
                 portals: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainPortalArgs', 'CustomDomainPortalArgsDict']]]]] = None,
                 scms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainScmArgs', 'CustomDomainScmArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a API Management Custom Domain.

        ## Disclaimers

        > **Note:** It's possible to define Custom Domains both within the `apimanagement.Service` resource via the `hostname_configurations` block and by using this resource. However it's not possible to use both methods to manage Custom Domains within an API Management Service, since there will be conflicts.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example = azure.keyvault.get_key_vault(name="mykeyvault",
            resource_group_name="some-resource-group")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            publisher_name="pub1",
            publisher_email="pub1@email.com",
            sku_name="Developer_1")
        example_certificate = azure.keyvault.Certificate("example",
            name="example-certificate",
            key_vault_id=example.id,
            certificate_policy={
                "issuer_parameters": {
                    "name": "Self",
                },
                "key_properties": {
                    "exportable": True,
                    "key_size": 2048,
                    "key_type": "RSA",
                    "reuse_key": True,
                },
                "lifetime_actions": [{
                    "action": {
                        "action_type": "AutoRenew",
                    },
                    "trigger": {
                        "days_before_expiry": 30,
                    },
                }],
                "secret_properties": {
                    "content_type": "application/x-pkcs12",
                },
                "x509_certificate_properties": {
                    "key_usages": [
                        "cRLSign",
                        "dataEncipherment",
                        "digitalSignature",
                        "keyAgreement",
                        "keyCertSign",
                        "keyEncipherment",
                    ],
                    "subject": "CN=api.example.com",
                    "validity_in_months": 12,
                    "subject_alternative_names": {
                        "dns_names": [
                            "api.example.com",
                            "portal.example.com",
                        ],
                    },
                },
            })
        example_custom_domain = azure.apimanagement.CustomDomain("example",
            api_management_id=example_service.id,
            gateways=[{
                "host_name": "api.example.com",
                "key_vault_id": example_certificate.versionless_secret_id,
            }],
            developer_portals=[{
                "host_name": "portal.example.com",
                "key_vault_id": example_certificate.versionless_secret_id,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement` - 2024-05-01

        ## Import

        API Management Custom Domains can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/customDomain:CustomDomain example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ApiManagement/service/instance1/customDomains/default
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_id: The ID of the API Management service for which to configure Custom Domains. Changing this forces a new API Management Custom Domain resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainDeveloperPortalArgs', 'CustomDomainDeveloperPortalArgsDict']]]] developer_portals: One or more `developer_portal` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainGatewayArgs', 'CustomDomainGatewayArgsDict']]]] gateways: One or more `gateway` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainManagementArgs', 'CustomDomainManagementArgsDict']]]] managements: One or more `management` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainPortalArgs', 'CustomDomainPortalArgsDict']]]] portals: One or more `portal` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainScmArgs', 'CustomDomainScmArgsDict']]]] scms: One or more `scm` blocks as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a API Management Custom Domain.

        ## Disclaimers

        > **Note:** It's possible to define Custom Domains both within the `apimanagement.Service` resource via the `hostname_configurations` block and by using this resource. However it's not possible to use both methods to manage Custom Domains within an API Management Service, since there will be conflicts.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example = azure.keyvault.get_key_vault(name="mykeyvault",
            resource_group_name="some-resource-group")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            publisher_name="pub1",
            publisher_email="pub1@email.com",
            sku_name="Developer_1")
        example_certificate = azure.keyvault.Certificate("example",
            name="example-certificate",
            key_vault_id=example.id,
            certificate_policy={
                "issuer_parameters": {
                    "name": "Self",
                },
                "key_properties": {
                    "exportable": True,
                    "key_size": 2048,
                    "key_type": "RSA",
                    "reuse_key": True,
                },
                "lifetime_actions": [{
                    "action": {
                        "action_type": "AutoRenew",
                    },
                    "trigger": {
                        "days_before_expiry": 30,
                    },
                }],
                "secret_properties": {
                    "content_type": "application/x-pkcs12",
                },
                "x509_certificate_properties": {
                    "key_usages": [
                        "cRLSign",
                        "dataEncipherment",
                        "digitalSignature",
                        "keyAgreement",
                        "keyCertSign",
                        "keyEncipherment",
                    ],
                    "subject": "CN=api.example.com",
                    "validity_in_months": 12,
                    "subject_alternative_names": {
                        "dns_names": [
                            "api.example.com",
                            "portal.example.com",
                        ],
                    },
                },
            })
        example_custom_domain = azure.apimanagement.CustomDomain("example",
            api_management_id=example_service.id,
            gateways=[{
                "host_name": "api.example.com",
                "key_vault_id": example_certificate.versionless_secret_id,
            }],
            developer_portals=[{
                "host_name": "portal.example.com",
                "key_vault_id": example_certificate.versionless_secret_id,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement` - 2024-05-01

        ## Import

        API Management Custom Domains can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/customDomain:CustomDomain example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ApiManagement/service/instance1/customDomains/default
        ```

        :param str resource_name: The name of the resource.
        :param CustomDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_id: Optional[pulumi.Input[_builtins.str]] = None,
                 developer_portals: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainDeveloperPortalArgs', 'CustomDomainDeveloperPortalArgsDict']]]]] = None,
                 gateways: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainGatewayArgs', 'CustomDomainGatewayArgsDict']]]]] = None,
                 managements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainManagementArgs', 'CustomDomainManagementArgsDict']]]]] = None,
                 portals: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainPortalArgs', 'CustomDomainPortalArgsDict']]]]] = None,
                 scms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainScmArgs', 'CustomDomainScmArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomDomainArgs.__new__(CustomDomainArgs)

            if api_management_id is None and not opts.urn:
                raise TypeError("Missing required property 'api_management_id'")
            __props__.__dict__["api_management_id"] = api_management_id
            __props__.__dict__["developer_portals"] = developer_portals
            __props__.__dict__["gateways"] = gateways
            __props__.__dict__["managements"] = managements
            __props__.__dict__["portals"] = portals
            __props__.__dict__["scms"] = scms
        super(CustomDomain, __self__).__init__(
            'azure:apimanagement/customDomain:CustomDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_management_id: Optional[pulumi.Input[_builtins.str]] = None,
            developer_portals: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainDeveloperPortalArgs', 'CustomDomainDeveloperPortalArgsDict']]]]] = None,
            gateways: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainGatewayArgs', 'CustomDomainGatewayArgsDict']]]]] = None,
            managements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainManagementArgs', 'CustomDomainManagementArgsDict']]]]] = None,
            portals: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainPortalArgs', 'CustomDomainPortalArgsDict']]]]] = None,
            scms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainScmArgs', 'CustomDomainScmArgsDict']]]]] = None) -> 'CustomDomain':
        """
        Get an existing CustomDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_id: The ID of the API Management service for which to configure Custom Domains. Changing this forces a new API Management Custom Domain resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainDeveloperPortalArgs', 'CustomDomainDeveloperPortalArgsDict']]]] developer_portals: One or more `developer_portal` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainGatewayArgs', 'CustomDomainGatewayArgsDict']]]] gateways: One or more `gateway` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainManagementArgs', 'CustomDomainManagementArgsDict']]]] managements: One or more `management` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainPortalArgs', 'CustomDomainPortalArgsDict']]]] portals: One or more `portal` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomDomainScmArgs', 'CustomDomainScmArgsDict']]]] scms: One or more `scm` blocks as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomDomainState.__new__(_CustomDomainState)

        __props__.__dict__["api_management_id"] = api_management_id
        __props__.__dict__["developer_portals"] = developer_portals
        __props__.__dict__["gateways"] = gateways
        __props__.__dict__["managements"] = managements
        __props__.__dict__["portals"] = portals
        __props__.__dict__["scms"] = scms
        return CustomDomain(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiManagementId")
    def api_management_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the API Management service for which to configure Custom Domains. Changing this forces a new API Management Custom Domain resource to be created.
        """
        return pulumi.get(self, "api_management_id")

    @_builtins.property
    @pulumi.getter(name="developerPortals")
    def developer_portals(self) -> pulumi.Output[Optional[Sequence['outputs.CustomDomainDeveloperPortal']]]:
        """
        One or more `developer_portal` blocks as defined below.
        """
        return pulumi.get(self, "developer_portals")

    @_builtins.property
    @pulumi.getter
    def gateways(self) -> pulumi.Output[Optional[Sequence['outputs.CustomDomainGateway']]]:
        """
        One or more `gateway` blocks as defined below.
        """
        return pulumi.get(self, "gateways")

    @_builtins.property
    @pulumi.getter
    def managements(self) -> pulumi.Output[Optional[Sequence['outputs.CustomDomainManagement']]]:
        """
        One or more `management` blocks as defined below.
        """
        return pulumi.get(self, "managements")

    @_builtins.property
    @pulumi.getter
    def portals(self) -> pulumi.Output[Optional[Sequence['outputs.CustomDomainPortal']]]:
        """
        One or more `portal` blocks as defined below.
        """
        return pulumi.get(self, "portals")

    @_builtins.property
    @pulumi.getter
    def scms(self) -> pulumi.Output[Optional[Sequence['outputs.CustomDomainScm']]]:
        """
        One or more `scm` blocks as defined below.
        """
        return pulumi.get(self, "scms")

