# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConfigurationStoreArgs', 'ConfigurationStore']

@pulumi.input_type
class ConfigurationStoreArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 data_plane_proxy_authentication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 data_plane_proxy_private_link_delegation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption: Optional[pulumi.Input['ConfigurationStoreEncryptionArgs']] = None,
                 identity: Optional[pulumi.Input['ConfigurationStoreIdentityArgs']] = None,
                 local_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 purge_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 replicas: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationStoreReplicaArgs']]]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 soft_delete_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ConfigurationStore resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the App Configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] data_plane_proxy_authentication_mode: The data plane proxy authentication mode. Possible values are `Local` and `Pass-through`. Defaults to `Local`.
        :param pulumi.Input[_builtins.bool] data_plane_proxy_private_link_delegation_enabled: Whether data plane proxy private link delegation is enabled. Defaults to `false`.
               
               > **Note:** `data_plane_proxy_private_link_delegation_enabled` cannot be set to `true` when `data_plane_proxy_authentication_mode` is set to `Local`.
        :param pulumi.Input['ConfigurationStoreEncryptionArgs'] encryption: An `encryption` block as defined below.
        :param pulumi.Input['ConfigurationStoreIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] local_auth_enabled: Whether local authentication methods is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the App Configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] public_network_access: The Public Network Access setting of the App Configuration. Possible values are `Enabled` and `Disabled`.
               
               > **Note:** If `public_network_access` is not specified, the App Configuration will be created as  `Automatic`. However, once a different value is defined, can not be set again as automatic.
        :param pulumi.Input[_builtins.bool] purge_protection_enabled: Whether Purge Protection is enabled. This field only works for `standard` sku. Defaults to `false`.
               
               !> **Note:** Once Purge Protection has been enabled it's not possible to disable it. Deleting the App Configuration with Purge Protection enabled will schedule the App Configuration to be deleted (which will happen by Azure in the configured number of days).
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationStoreReplicaArgs']]] replicas: One or more `replica` blocks as defined below.
        :param pulumi.Input[_builtins.str] sku: The SKU name of the App Configuration. Possible values are `free`, `developer`, `standard` and `premium`. Defaults to `free`.
               
               > **Note:** Azure does not support downgrading `sku` to a lower tier, except from `premium` to `standard`. Downgrading will force a new resource to be created.
        :param pulumi.Input[_builtins.int] soft_delete_retention_days: The number of days that items should be retained for once soft-deleted. This field only works for `standard` sku. This value can be between `1` and `7` days. Defaults to `7`. Changing this forces a new resource to be created.
               
               > **Note:** If Purge Protection is enabled, this field can only be configured one time and cannot be updated.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if data_plane_proxy_authentication_mode is not None:
            pulumi.set(__self__, "data_plane_proxy_authentication_mode", data_plane_proxy_authentication_mode)
        if data_plane_proxy_private_link_delegation_enabled is not None:
            pulumi.set(__self__, "data_plane_proxy_private_link_delegation_enabled", data_plane_proxy_private_link_delegation_enabled)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if local_auth_enabled is not None:
            pulumi.set(__self__, "local_auth_enabled", local_auth_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if purge_protection_enabled is not None:
            pulumi.set(__self__, "purge_protection_enabled", purge_protection_enabled)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if soft_delete_retention_days is not None:
            pulumi.set(__self__, "soft_delete_retention_days", soft_delete_retention_days)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the App Configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="dataPlaneProxyAuthenticationMode")
    def data_plane_proxy_authentication_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data plane proxy authentication mode. Possible values are `Local` and `Pass-through`. Defaults to `Local`.
        """
        return pulumi.get(self, "data_plane_proxy_authentication_mode")

    @data_plane_proxy_authentication_mode.setter
    def data_plane_proxy_authentication_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_plane_proxy_authentication_mode", value)

    @_builtins.property
    @pulumi.getter(name="dataPlaneProxyPrivateLinkDelegationEnabled")
    def data_plane_proxy_private_link_delegation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether data plane proxy private link delegation is enabled. Defaults to `false`.

        > **Note:** `data_plane_proxy_private_link_delegation_enabled` cannot be set to `true` when `data_plane_proxy_authentication_mode` is set to `Local`.
        """
        return pulumi.get(self, "data_plane_proxy_private_link_delegation_enabled")

    @data_plane_proxy_private_link_delegation_enabled.setter
    def data_plane_proxy_private_link_delegation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "data_plane_proxy_private_link_delegation_enabled", value)

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['ConfigurationStoreEncryptionArgs']]:
        """
        An `encryption` block as defined below.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['ConfigurationStoreEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ConfigurationStoreIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ConfigurationStoreIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="localAuthEnabled")
    def local_auth_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether local authentication methods is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "local_auth_enabled")

    @local_auth_enabled.setter
    def local_auth_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_auth_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the App Configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Public Network Access setting of the App Configuration. Possible values are `Enabled` and `Disabled`.

        > **Note:** If `public_network_access` is not specified, the App Configuration will be created as  `Automatic`. However, once a different value is defined, can not be set again as automatic.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_network_access", value)

    @_builtins.property
    @pulumi.getter(name="purgeProtectionEnabled")
    def purge_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether Purge Protection is enabled. This field only works for `standard` sku. Defaults to `false`.

        !> **Note:** Once Purge Protection has been enabled it's not possible to disable it. Deleting the App Configuration with Purge Protection enabled will schedule the App Configuration to be deleted (which will happen by Azure in the configured number of days).
        """
        return pulumi.get(self, "purge_protection_enabled")

    @purge_protection_enabled.setter
    def purge_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "purge_protection_enabled", value)

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationStoreReplicaArgs']]]]:
        """
        One or more `replica` blocks as defined below.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationStoreReplicaArgs']]]]):
        pulumi.set(self, "replicas", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU name of the App Configuration. Possible values are `free`, `developer`, `standard` and `premium`. Defaults to `free`.

        > **Note:** Azure does not support downgrading `sku` to a lower tier, except from `premium` to `standard`. Downgrading will force a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="softDeleteRetentionDays")
    def soft_delete_retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of days that items should be retained for once soft-deleted. This field only works for `standard` sku. This value can be between `1` and `7` days. Defaults to `7`. Changing this forces a new resource to be created.

        > **Note:** If Purge Protection is enabled, this field can only be configured one time and cannot be updated.
        """
        return pulumi.get(self, "soft_delete_retention_days")

    @soft_delete_retention_days.setter
    def soft_delete_retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "soft_delete_retention_days", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ConfigurationStoreState:
    def __init__(__self__, *,
                 data_plane_proxy_authentication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 data_plane_proxy_private_link_delegation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption: Optional[pulumi.Input['ConfigurationStoreEncryptionArgs']] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['ConfigurationStoreIdentityArgs']] = None,
                 local_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_read_keys: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationStorePrimaryReadKeyArgs']]]] = None,
                 primary_write_keys: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationStorePrimaryWriteKeyArgs']]]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 purge_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 replicas: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationStoreReplicaArgs']]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_read_keys: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationStoreSecondaryReadKeyArgs']]]] = None,
                 secondary_write_keys: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationStoreSecondaryWriteKeyArgs']]]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 soft_delete_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ConfigurationStore resources.
        :param pulumi.Input[_builtins.str] data_plane_proxy_authentication_mode: The data plane proxy authentication mode. Possible values are `Local` and `Pass-through`. Defaults to `Local`.
        :param pulumi.Input[_builtins.bool] data_plane_proxy_private_link_delegation_enabled: Whether data plane proxy private link delegation is enabled. Defaults to `false`.
               
               > **Note:** `data_plane_proxy_private_link_delegation_enabled` cannot be set to `true` when `data_plane_proxy_authentication_mode` is set to `Local`.
        :param pulumi.Input['ConfigurationStoreEncryptionArgs'] encryption: An `encryption` block as defined below.
        :param pulumi.Input[_builtins.str] endpoint: The URL of the App Configuration Replica.
        :param pulumi.Input['ConfigurationStoreIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] local_auth_enabled: Whether local authentication methods is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the App Configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationStorePrimaryReadKeyArgs']]] primary_read_keys: A `primary_read_key` block as defined below containing the primary read access key.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationStorePrimaryWriteKeyArgs']]] primary_write_keys: A `primary_write_key` block as defined below containing the primary write access key.
        :param pulumi.Input[_builtins.str] public_network_access: The Public Network Access setting of the App Configuration. Possible values are `Enabled` and `Disabled`.
               
               > **Note:** If `public_network_access` is not specified, the App Configuration will be created as  `Automatic`. However, once a different value is defined, can not be set again as automatic.
        :param pulumi.Input[_builtins.bool] purge_protection_enabled: Whether Purge Protection is enabled. This field only works for `standard` sku. Defaults to `false`.
               
               !> **Note:** Once Purge Protection has been enabled it's not possible to disable it. Deleting the App Configuration with Purge Protection enabled will schedule the App Configuration to be deleted (which will happen by Azure in the configured number of days).
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationStoreReplicaArgs']]] replicas: One or more `replica` blocks as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the App Configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationStoreSecondaryReadKeyArgs']]] secondary_read_keys: A `secondary_read_key` block as defined below containing the secondary read access key.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationStoreSecondaryWriteKeyArgs']]] secondary_write_keys: A `secondary_write_key` block as defined below containing the secondary write access key.
        :param pulumi.Input[_builtins.str] sku: The SKU name of the App Configuration. Possible values are `free`, `developer`, `standard` and `premium`. Defaults to `free`.
               
               > **Note:** Azure does not support downgrading `sku` to a lower tier, except from `premium` to `standard`. Downgrading will force a new resource to be created.
        :param pulumi.Input[_builtins.int] soft_delete_retention_days: The number of days that items should be retained for once soft-deleted. This field only works for `standard` sku. This value can be between `1` and `7` days. Defaults to `7`. Changing this forces a new resource to be created.
               
               > **Note:** If Purge Protection is enabled, this field can only be configured one time and cannot be updated.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if data_plane_proxy_authentication_mode is not None:
            pulumi.set(__self__, "data_plane_proxy_authentication_mode", data_plane_proxy_authentication_mode)
        if data_plane_proxy_private_link_delegation_enabled is not None:
            pulumi.set(__self__, "data_plane_proxy_private_link_delegation_enabled", data_plane_proxy_private_link_delegation_enabled)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if local_auth_enabled is not None:
            pulumi.set(__self__, "local_auth_enabled", local_auth_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_read_keys is not None:
            pulumi.set(__self__, "primary_read_keys", primary_read_keys)
        if primary_write_keys is not None:
            pulumi.set(__self__, "primary_write_keys", primary_write_keys)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if purge_protection_enabled is not None:
            pulumi.set(__self__, "purge_protection_enabled", purge_protection_enabled)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if secondary_read_keys is not None:
            pulumi.set(__self__, "secondary_read_keys", secondary_read_keys)
        if secondary_write_keys is not None:
            pulumi.set(__self__, "secondary_write_keys", secondary_write_keys)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if soft_delete_retention_days is not None:
            pulumi.set(__self__, "soft_delete_retention_days", soft_delete_retention_days)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="dataPlaneProxyAuthenticationMode")
    def data_plane_proxy_authentication_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The data plane proxy authentication mode. Possible values are `Local` and `Pass-through`. Defaults to `Local`.
        """
        return pulumi.get(self, "data_plane_proxy_authentication_mode")

    @data_plane_proxy_authentication_mode.setter
    def data_plane_proxy_authentication_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_plane_proxy_authentication_mode", value)

    @_builtins.property
    @pulumi.getter(name="dataPlaneProxyPrivateLinkDelegationEnabled")
    def data_plane_proxy_private_link_delegation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether data plane proxy private link delegation is enabled. Defaults to `false`.

        > **Note:** `data_plane_proxy_private_link_delegation_enabled` cannot be set to `true` when `data_plane_proxy_authentication_mode` is set to `Local`.
        """
        return pulumi.get(self, "data_plane_proxy_private_link_delegation_enabled")

    @data_plane_proxy_private_link_delegation_enabled.setter
    def data_plane_proxy_private_link_delegation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "data_plane_proxy_private_link_delegation_enabled", value)

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['ConfigurationStoreEncryptionArgs']]:
        """
        An `encryption` block as defined below.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['ConfigurationStoreEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the App Configuration Replica.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ConfigurationStoreIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ConfigurationStoreIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="localAuthEnabled")
    def local_auth_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether local authentication methods is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "local_auth_enabled")

    @local_auth_enabled.setter
    def local_auth_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_auth_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the App Configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="primaryReadKeys")
    def primary_read_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationStorePrimaryReadKeyArgs']]]]:
        """
        A `primary_read_key` block as defined below containing the primary read access key.
        """
        return pulumi.get(self, "primary_read_keys")

    @primary_read_keys.setter
    def primary_read_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationStorePrimaryReadKeyArgs']]]]):
        pulumi.set(self, "primary_read_keys", value)

    @_builtins.property
    @pulumi.getter(name="primaryWriteKeys")
    def primary_write_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationStorePrimaryWriteKeyArgs']]]]:
        """
        A `primary_write_key` block as defined below containing the primary write access key.
        """
        return pulumi.get(self, "primary_write_keys")

    @primary_write_keys.setter
    def primary_write_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationStorePrimaryWriteKeyArgs']]]]):
        pulumi.set(self, "primary_write_keys", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Public Network Access setting of the App Configuration. Possible values are `Enabled` and `Disabled`.

        > **Note:** If `public_network_access` is not specified, the App Configuration will be created as  `Automatic`. However, once a different value is defined, can not be set again as automatic.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_network_access", value)

    @_builtins.property
    @pulumi.getter(name="purgeProtectionEnabled")
    def purge_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether Purge Protection is enabled. This field only works for `standard` sku. Defaults to `false`.

        !> **Note:** Once Purge Protection has been enabled it's not possible to disable it. Deleting the App Configuration with Purge Protection enabled will schedule the App Configuration to be deleted (which will happen by Azure in the configured number of days).
        """
        return pulumi.get(self, "purge_protection_enabled")

    @purge_protection_enabled.setter
    def purge_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "purge_protection_enabled", value)

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationStoreReplicaArgs']]]]:
        """
        One or more `replica` blocks as defined below.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationStoreReplicaArgs']]]]):
        pulumi.set(self, "replicas", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the App Configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="secondaryReadKeys")
    def secondary_read_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationStoreSecondaryReadKeyArgs']]]]:
        """
        A `secondary_read_key` block as defined below containing the secondary read access key.
        """
        return pulumi.get(self, "secondary_read_keys")

    @secondary_read_keys.setter
    def secondary_read_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationStoreSecondaryReadKeyArgs']]]]):
        pulumi.set(self, "secondary_read_keys", value)

    @_builtins.property
    @pulumi.getter(name="secondaryWriteKeys")
    def secondary_write_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationStoreSecondaryWriteKeyArgs']]]]:
        """
        A `secondary_write_key` block as defined below containing the secondary write access key.
        """
        return pulumi.get(self, "secondary_write_keys")

    @secondary_write_keys.setter
    def secondary_write_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationStoreSecondaryWriteKeyArgs']]]]):
        pulumi.set(self, "secondary_write_keys", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU name of the App Configuration. Possible values are `free`, `developer`, `standard` and `premium`. Defaults to `free`.

        > **Note:** Azure does not support downgrading `sku` to a lower tier, except from `premium` to `standard`. Downgrading will force a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="softDeleteRetentionDays")
    def soft_delete_retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of days that items should be retained for once soft-deleted. This field only works for `standard` sku. This value can be between `1` and `7` days. Defaults to `7`. Changing this forces a new resource to be created.

        > **Note:** If Purge Protection is enabled, this field can only be configured one time and cannot be updated.
        """
        return pulumi.get(self, "soft_delete_retention_days")

    @soft_delete_retention_days.setter
    def soft_delete_retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "soft_delete_retention_days", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:appconfiguration/configurationStore:ConfigurationStore")
class ConfigurationStore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_plane_proxy_authentication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 data_plane_proxy_private_link_delegation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption: Optional[pulumi.Input[Union['ConfigurationStoreEncryptionArgs', 'ConfigurationStoreEncryptionArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['ConfigurationStoreIdentityArgs', 'ConfigurationStoreIdentityArgsDict']]] = None,
                 local_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 purge_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 replicas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationStoreReplicaArgs', 'ConfigurationStoreReplicaArgsDict']]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 soft_delete_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        appconf = azure.appconfiguration.ConfigurationStore("appconf",
            name="appConf1",
            resource_group_name=example.name,
            location=example.location)
        ```

        ### Encryption)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="example-identity",
            location=example.location,
            resource_group_name=example.name)
        current = azure.core.get_client_config()
        example_key_vault = azure.keyvault.KeyVault("example",
            name="exampleKVt123",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            soft_delete_retention_days=7,
            purge_protection_enabled=True)
        server = azure.keyvault.AccessPolicy("server",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=example_user_assigned_identity.principal_id,
            key_permissions=[
                "Get",
                "UnwrapKey",
                "WrapKey",
            ],
            secret_permissions=["Get"])
        client = azure.keyvault.AccessPolicy("client",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            key_permissions=[
                "Get",
                "Create",
                "Delete",
                "List",
                "Restore",
                "Recover",
                "UnwrapKey",
                "WrapKey",
                "Purge",
                "Encrypt",
                "Decrypt",
                "Sign",
                "Verify",
                "GetRotationPolicy",
            ],
            secret_permissions=["Get"])
        example_key = azure.keyvault.Key("example",
            name="exampleKVkey",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "decrypt",
                "encrypt",
                "sign",
                "unwrapKey",
                "verify",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    client,
                    server,
                ]))
        example_configuration_store = azure.appconfiguration.ConfigurationStore("example",
            name="appConf2",
            resource_group_name=example.name,
            location=example.location,
            sku="standard",
            local_auth_enabled=True,
            public_network_access="Enabled",
            purge_protection_enabled=False,
            soft_delete_retention_days=1,
            identity={
                "type": "UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            },
            encryption={
                "key_vault_key_identifier": example_key.id,
                "identity_client_id": example_user_assigned_identity.client_id,
            },
            replicas=[{
                "name": "replica1",
                "location": "West US",
            }],
            tags={
                "environment": "development",
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    client,
                    server,
                ]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AppConfiguration` - 2024-05-01

        ## Import

        App Configurations can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appconfiguration/configurationStore:ConfigurationStore appconf /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.AppConfiguration/configurationStores/appConf1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data_plane_proxy_authentication_mode: The data plane proxy authentication mode. Possible values are `Local` and `Pass-through`. Defaults to `Local`.
        :param pulumi.Input[_builtins.bool] data_plane_proxy_private_link_delegation_enabled: Whether data plane proxy private link delegation is enabled. Defaults to `false`.
               
               > **Note:** `data_plane_proxy_private_link_delegation_enabled` cannot be set to `true` when `data_plane_proxy_authentication_mode` is set to `Local`.
        :param pulumi.Input[Union['ConfigurationStoreEncryptionArgs', 'ConfigurationStoreEncryptionArgsDict']] encryption: An `encryption` block as defined below.
        :param pulumi.Input[Union['ConfigurationStoreIdentityArgs', 'ConfigurationStoreIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] local_auth_enabled: Whether local authentication methods is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the App Configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] public_network_access: The Public Network Access setting of the App Configuration. Possible values are `Enabled` and `Disabled`.
               
               > **Note:** If `public_network_access` is not specified, the App Configuration will be created as  `Automatic`. However, once a different value is defined, can not be set again as automatic.
        :param pulumi.Input[_builtins.bool] purge_protection_enabled: Whether Purge Protection is enabled. This field only works for `standard` sku. Defaults to `false`.
               
               !> **Note:** Once Purge Protection has been enabled it's not possible to disable it. Deleting the App Configuration with Purge Protection enabled will schedule the App Configuration to be deleted (which will happen by Azure in the configured number of days).
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationStoreReplicaArgs', 'ConfigurationStoreReplicaArgsDict']]]] replicas: One or more `replica` blocks as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the App Configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: The SKU name of the App Configuration. Possible values are `free`, `developer`, `standard` and `premium`. Defaults to `free`.
               
               > **Note:** Azure does not support downgrading `sku` to a lower tier, except from `premium` to `standard`. Downgrading will force a new resource to be created.
        :param pulumi.Input[_builtins.int] soft_delete_retention_days: The number of days that items should be retained for once soft-deleted. This field only works for `standard` sku. This value can be between `1` and `7` days. Defaults to `7`. Changing this forces a new resource to be created.
               
               > **Note:** If Purge Protection is enabled, this field can only be configured one time and cannot be updated.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigurationStoreArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        appconf = azure.appconfiguration.ConfigurationStore("appconf",
            name="appConf1",
            resource_group_name=example.name,
            location=example.location)
        ```

        ### Encryption)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="example-identity",
            location=example.location,
            resource_group_name=example.name)
        current = azure.core.get_client_config()
        example_key_vault = azure.keyvault.KeyVault("example",
            name="exampleKVt123",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            soft_delete_retention_days=7,
            purge_protection_enabled=True)
        server = azure.keyvault.AccessPolicy("server",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=example_user_assigned_identity.principal_id,
            key_permissions=[
                "Get",
                "UnwrapKey",
                "WrapKey",
            ],
            secret_permissions=["Get"])
        client = azure.keyvault.AccessPolicy("client",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            key_permissions=[
                "Get",
                "Create",
                "Delete",
                "List",
                "Restore",
                "Recover",
                "UnwrapKey",
                "WrapKey",
                "Purge",
                "Encrypt",
                "Decrypt",
                "Sign",
                "Verify",
                "GetRotationPolicy",
            ],
            secret_permissions=["Get"])
        example_key = azure.keyvault.Key("example",
            name="exampleKVkey",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "decrypt",
                "encrypt",
                "sign",
                "unwrapKey",
                "verify",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    client,
                    server,
                ]))
        example_configuration_store = azure.appconfiguration.ConfigurationStore("example",
            name="appConf2",
            resource_group_name=example.name,
            location=example.location,
            sku="standard",
            local_auth_enabled=True,
            public_network_access="Enabled",
            purge_protection_enabled=False,
            soft_delete_retention_days=1,
            identity={
                "type": "UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            },
            encryption={
                "key_vault_key_identifier": example_key.id,
                "identity_client_id": example_user_assigned_identity.client_id,
            },
            replicas=[{
                "name": "replica1",
                "location": "West US",
            }],
            tags={
                "environment": "development",
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    client,
                    server,
                ]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AppConfiguration` - 2024-05-01

        ## Import

        App Configurations can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appconfiguration/configurationStore:ConfigurationStore appconf /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.AppConfiguration/configurationStores/appConf1
        ```

        :param str resource_name: The name of the resource.
        :param ConfigurationStoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigurationStoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_plane_proxy_authentication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 data_plane_proxy_private_link_delegation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption: Optional[pulumi.Input[Union['ConfigurationStoreEncryptionArgs', 'ConfigurationStoreEncryptionArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['ConfigurationStoreIdentityArgs', 'ConfigurationStoreIdentityArgsDict']]] = None,
                 local_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 purge_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 replicas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationStoreReplicaArgs', 'ConfigurationStoreReplicaArgsDict']]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 soft_delete_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigurationStoreArgs.__new__(ConfigurationStoreArgs)

            __props__.__dict__["data_plane_proxy_authentication_mode"] = data_plane_proxy_authentication_mode
            __props__.__dict__["data_plane_proxy_private_link_delegation_enabled"] = data_plane_proxy_private_link_delegation_enabled
            __props__.__dict__["encryption"] = encryption
            __props__.__dict__["identity"] = identity
            __props__.__dict__["local_auth_enabled"] = local_auth_enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["public_network_access"] = public_network_access
            __props__.__dict__["purge_protection_enabled"] = purge_protection_enabled
            __props__.__dict__["replicas"] = replicas
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["sku"] = sku
            __props__.__dict__["soft_delete_retention_days"] = soft_delete_retention_days
            __props__.__dict__["tags"] = tags
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["primary_read_keys"] = None
            __props__.__dict__["primary_write_keys"] = None
            __props__.__dict__["secondary_read_keys"] = None
            __props__.__dict__["secondary_write_keys"] = None
        super(ConfigurationStore, __self__).__init__(
            'azure:appconfiguration/configurationStore:ConfigurationStore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data_plane_proxy_authentication_mode: Optional[pulumi.Input[_builtins.str]] = None,
            data_plane_proxy_private_link_delegation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            encryption: Optional[pulumi.Input[Union['ConfigurationStoreEncryptionArgs', 'ConfigurationStoreEncryptionArgsDict']]] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['ConfigurationStoreIdentityArgs', 'ConfigurationStoreIdentityArgsDict']]] = None,
            local_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            primary_read_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationStorePrimaryReadKeyArgs', 'ConfigurationStorePrimaryReadKeyArgsDict']]]]] = None,
            primary_write_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationStorePrimaryWriteKeyArgs', 'ConfigurationStorePrimaryWriteKeyArgsDict']]]]] = None,
            public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
            purge_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            replicas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationStoreReplicaArgs', 'ConfigurationStoreReplicaArgsDict']]]]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_read_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationStoreSecondaryReadKeyArgs', 'ConfigurationStoreSecondaryReadKeyArgsDict']]]]] = None,
            secondary_write_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationStoreSecondaryWriteKeyArgs', 'ConfigurationStoreSecondaryWriteKeyArgsDict']]]]] = None,
            sku: Optional[pulumi.Input[_builtins.str]] = None,
            soft_delete_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'ConfigurationStore':
        """
        Get an existing ConfigurationStore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data_plane_proxy_authentication_mode: The data plane proxy authentication mode. Possible values are `Local` and `Pass-through`. Defaults to `Local`.
        :param pulumi.Input[_builtins.bool] data_plane_proxy_private_link_delegation_enabled: Whether data plane proxy private link delegation is enabled. Defaults to `false`.
               
               > **Note:** `data_plane_proxy_private_link_delegation_enabled` cannot be set to `true` when `data_plane_proxy_authentication_mode` is set to `Local`.
        :param pulumi.Input[Union['ConfigurationStoreEncryptionArgs', 'ConfigurationStoreEncryptionArgsDict']] encryption: An `encryption` block as defined below.
        :param pulumi.Input[_builtins.str] endpoint: The URL of the App Configuration Replica.
        :param pulumi.Input[Union['ConfigurationStoreIdentityArgs', 'ConfigurationStoreIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] local_auth_enabled: Whether local authentication methods is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the App Configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationStorePrimaryReadKeyArgs', 'ConfigurationStorePrimaryReadKeyArgsDict']]]] primary_read_keys: A `primary_read_key` block as defined below containing the primary read access key.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationStorePrimaryWriteKeyArgs', 'ConfigurationStorePrimaryWriteKeyArgsDict']]]] primary_write_keys: A `primary_write_key` block as defined below containing the primary write access key.
        :param pulumi.Input[_builtins.str] public_network_access: The Public Network Access setting of the App Configuration. Possible values are `Enabled` and `Disabled`.
               
               > **Note:** If `public_network_access` is not specified, the App Configuration will be created as  `Automatic`. However, once a different value is defined, can not be set again as automatic.
        :param pulumi.Input[_builtins.bool] purge_protection_enabled: Whether Purge Protection is enabled. This field only works for `standard` sku. Defaults to `false`.
               
               !> **Note:** Once Purge Protection has been enabled it's not possible to disable it. Deleting the App Configuration with Purge Protection enabled will schedule the App Configuration to be deleted (which will happen by Azure in the configured number of days).
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationStoreReplicaArgs', 'ConfigurationStoreReplicaArgsDict']]]] replicas: One or more `replica` blocks as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the App Configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationStoreSecondaryReadKeyArgs', 'ConfigurationStoreSecondaryReadKeyArgsDict']]]] secondary_read_keys: A `secondary_read_key` block as defined below containing the secondary read access key.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationStoreSecondaryWriteKeyArgs', 'ConfigurationStoreSecondaryWriteKeyArgsDict']]]] secondary_write_keys: A `secondary_write_key` block as defined below containing the secondary write access key.
        :param pulumi.Input[_builtins.str] sku: The SKU name of the App Configuration. Possible values are `free`, `developer`, `standard` and `premium`. Defaults to `free`.
               
               > **Note:** Azure does not support downgrading `sku` to a lower tier, except from `premium` to `standard`. Downgrading will force a new resource to be created.
        :param pulumi.Input[_builtins.int] soft_delete_retention_days: The number of days that items should be retained for once soft-deleted. This field only works for `standard` sku. This value can be between `1` and `7` days. Defaults to `7`. Changing this forces a new resource to be created.
               
               > **Note:** If Purge Protection is enabled, this field can only be configured one time and cannot be updated.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigurationStoreState.__new__(_ConfigurationStoreState)

        __props__.__dict__["data_plane_proxy_authentication_mode"] = data_plane_proxy_authentication_mode
        __props__.__dict__["data_plane_proxy_private_link_delegation_enabled"] = data_plane_proxy_private_link_delegation_enabled
        __props__.__dict__["encryption"] = encryption
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["identity"] = identity
        __props__.__dict__["local_auth_enabled"] = local_auth_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["primary_read_keys"] = primary_read_keys
        __props__.__dict__["primary_write_keys"] = primary_write_keys
        __props__.__dict__["public_network_access"] = public_network_access
        __props__.__dict__["purge_protection_enabled"] = purge_protection_enabled
        __props__.__dict__["replicas"] = replicas
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["secondary_read_keys"] = secondary_read_keys
        __props__.__dict__["secondary_write_keys"] = secondary_write_keys
        __props__.__dict__["sku"] = sku
        __props__.__dict__["soft_delete_retention_days"] = soft_delete_retention_days
        __props__.__dict__["tags"] = tags
        return ConfigurationStore(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dataPlaneProxyAuthenticationMode")
    def data_plane_proxy_authentication_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The data plane proxy authentication mode. Possible values are `Local` and `Pass-through`. Defaults to `Local`.
        """
        return pulumi.get(self, "data_plane_proxy_authentication_mode")

    @_builtins.property
    @pulumi.getter(name="dataPlaneProxyPrivateLinkDelegationEnabled")
    def data_plane_proxy_private_link_delegation_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether data plane proxy private link delegation is enabled. Defaults to `false`.

        > **Note:** `data_plane_proxy_private_link_delegation_enabled` cannot be set to `true` when `data_plane_proxy_authentication_mode` is set to `Local`.
        """
        return pulumi.get(self, "data_plane_proxy_private_link_delegation_enabled")

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> pulumi.Output[Optional['outputs.ConfigurationStoreEncryption']]:
        """
        An `encryption` block as defined below.
        """
        return pulumi.get(self, "encryption")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the App Configuration Replica.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.ConfigurationStoreIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="localAuthEnabled")
    def local_auth_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether local authentication methods is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "local_auth_enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the App Configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="primaryReadKeys")
    def primary_read_keys(self) -> pulumi.Output[Sequence['outputs.ConfigurationStorePrimaryReadKey']]:
        """
        A `primary_read_key` block as defined below containing the primary read access key.
        """
        return pulumi.get(self, "primary_read_keys")

    @_builtins.property
    @pulumi.getter(name="primaryWriteKeys")
    def primary_write_keys(self) -> pulumi.Output[Sequence['outputs.ConfigurationStorePrimaryWriteKey']]:
        """
        A `primary_write_key` block as defined below containing the primary write access key.
        """
        return pulumi.get(self, "primary_write_keys")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Public Network Access setting of the App Configuration. Possible values are `Enabled` and `Disabled`.

        > **Note:** If `public_network_access` is not specified, the App Configuration will be created as  `Automatic`. However, once a different value is defined, can not be set again as automatic.
        """
        return pulumi.get(self, "public_network_access")

    @_builtins.property
    @pulumi.getter(name="purgeProtectionEnabled")
    def purge_protection_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether Purge Protection is enabled. This field only works for `standard` sku. Defaults to `false`.

        !> **Note:** Once Purge Protection has been enabled it's not possible to disable it. Deleting the App Configuration with Purge Protection enabled will schedule the App Configuration to be deleted (which will happen by Azure in the configured number of days).
        """
        return pulumi.get(self, "purge_protection_enabled")

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> pulumi.Output[Optional[Sequence['outputs.ConfigurationStoreReplica']]]:
        """
        One or more `replica` blocks as defined below.
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the App Configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="secondaryReadKeys")
    def secondary_read_keys(self) -> pulumi.Output[Sequence['outputs.ConfigurationStoreSecondaryReadKey']]:
        """
        A `secondary_read_key` block as defined below containing the secondary read access key.
        """
        return pulumi.get(self, "secondary_read_keys")

    @_builtins.property
    @pulumi.getter(name="secondaryWriteKeys")
    def secondary_write_keys(self) -> pulumi.Output[Sequence['outputs.ConfigurationStoreSecondaryWriteKey']]:
        """
        A `secondary_write_key` block as defined below containing the secondary write access key.
        """
        return pulumi.get(self, "secondary_write_keys")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The SKU name of the App Configuration. Possible values are `free`, `developer`, `standard` and `premium`. Defaults to `free`.

        > **Note:** Azure does not support downgrading `sku` to a lower tier, except from `premium` to `standard`. Downgrading will force a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter(name="softDeleteRetentionDays")
    def soft_delete_retention_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of days that items should be retained for once soft-deleted. This field only works for `standard` sku. This value can be between `1` and `7` days. Defaults to `7`. Changing this forces a new resource to be created.

        > **Note:** If Purge Protection is enabled, this field can only be configured one time and cannot be updated.
        """
        return pulumi.get(self, "soft_delete_retention_days")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

