# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SpringCloudCertificateArgs', 'SpringCloudCertificate']

@pulumi.input_type
class SpringCloudCertificateArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 service_name: pulumi.Input[_builtins.str],
                 certificate_content: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_private_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_vault_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SpringCloudCertificate resource.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the resource group in which to create the Spring Cloud Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] service_name: Specifies the name of the Spring Cloud Service resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] certificate_content: The content of uploaded certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] exclude_private_key: Specifies whether the private key should be excluded from the Key Vault Certificate. Changing this forces a new resource to be created. Defaults to `false`.
        :param pulumi.Input[_builtins.str] key_vault_certificate_id: Specifies the ID of the Key Vault Certificate resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Spring Cloud Certificate. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "service_name", service_name)
        if certificate_content is not None:
            pulumi.set(__self__, "certificate_content", certificate_content)
        if exclude_private_key is not None:
            pulumi.set(__self__, "exclude_private_key", exclude_private_key)
        if key_vault_certificate_id is not None:
            pulumi.set(__self__, "key_vault_certificate_id", key_vault_certificate_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the resource group in which to create the Spring Cloud Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Spring Cloud Service resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="certificateContent")
    def certificate_content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of uploaded certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "certificate_content")

    @certificate_content.setter
    def certificate_content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_content", value)

    @_builtins.property
    @pulumi.getter(name="excludePrivateKey")
    def exclude_private_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the private key should be excluded from the Key Vault Certificate. Changing this forces a new resource to be created. Defaults to `false`.
        """
        return pulumi.get(self, "exclude_private_key")

    @exclude_private_key.setter
    def exclude_private_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exclude_private_key", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultCertificateId")
    def key_vault_certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the Key Vault Certificate resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_certificate_id")

    @key_vault_certificate_id.setter
    def key_vault_certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_certificate_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Spring Cloud Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _SpringCloudCertificateState:
    def __init__(__self__, *,
                 certificate_content: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_private_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_vault_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 thumbprint: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SpringCloudCertificate resources.
        :param pulumi.Input[_builtins.str] certificate_content: The content of uploaded certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] exclude_private_key: Specifies whether the private key should be excluded from the Key Vault Certificate. Changing this forces a new resource to be created. Defaults to `false`.
        :param pulumi.Input[_builtins.str] key_vault_certificate_id: Specifies the ID of the Key Vault Certificate resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Spring Cloud Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the resource group in which to create the Spring Cloud Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] service_name: Specifies the name of the Spring Cloud Service resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] thumbprint: The thumbprint of the Spring Cloud certificate.
        """
        if certificate_content is not None:
            pulumi.set(__self__, "certificate_content", certificate_content)
        if exclude_private_key is not None:
            pulumi.set(__self__, "exclude_private_key", exclude_private_key)
        if key_vault_certificate_id is not None:
            pulumi.set(__self__, "key_vault_certificate_id", key_vault_certificate_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @_builtins.property
    @pulumi.getter(name="certificateContent")
    def certificate_content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of uploaded certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "certificate_content")

    @certificate_content.setter
    def certificate_content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_content", value)

    @_builtins.property
    @pulumi.getter(name="excludePrivateKey")
    def exclude_private_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the private key should be excluded from the Key Vault Certificate. Changing this forces a new resource to be created. Defaults to `false`.
        """
        return pulumi.get(self, "exclude_private_key")

    @exclude_private_key.setter
    def exclude_private_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exclude_private_key", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultCertificateId")
    def key_vault_certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the Key Vault Certificate resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_certificate_id")

    @key_vault_certificate_id.setter
    def key_vault_certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_certificate_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Spring Cloud Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the resource group in which to create the Spring Cloud Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Spring Cloud Service resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The thumbprint of the Spring Cloud certificate.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "thumbprint", value)


@pulumi.type_token("azure:appplatform/springCloudCertificate:SpringCloudCertificate")
class SpringCloudCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_content: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_private_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_vault_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure Spring Cloud Certificate.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudCertificate` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        current = azure.core.get_client_config()
        example = azuread.get_service_principal(display_name="Azure Spring Cloud Resource Provider")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="keyvaultcertexample",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            access_policies=[
                {
                    "tenant_id": current.tenant_id,
                    "object_id": current.object_id,
                    "secret_permissions": ["Set"],
                    "certificate_permissions": [
                        "Create",
                        "Delete",
                        "Get",
                        "Update",
                    ],
                },
                {
                    "tenant_id": current.tenant_id,
                    "object_id": example.object_id,
                    "secret_permissions": [
                        "Get",
                        "List",
                    ],
                    "certificate_permissions": [
                        "Get",
                        "List",
                    ],
                },
            ])
        example_certificate = azure.keyvault.Certificate("example",
            name="cert-example",
            key_vault_id=example_key_vault.id,
            certificate_policy={
                "issuer_parameters": {
                    "name": "Self",
                },
                "key_properties": {
                    "exportable": True,
                    "key_size": 2048,
                    "key_type": "RSA",
                    "reuse_key": True,
                },
                "lifetime_actions": [{
                    "action": {
                        "action_type": "AutoRenew",
                    },
                    "trigger": {
                        "days_before_expiry": 30,
                    },
                }],
                "secret_properties": {
                    "content_type": "application/x-pkcs12",
                },
                "x509_certificate_properties": {
                    "key_usages": [
                        "cRLSign",
                        "dataEncipherment",
                        "digitalSignature",
                        "keyAgreement",
                        "keyCertSign",
                        "keyEncipherment",
                    ],
                    "subject": "CN=contoso.com",
                    "validity_in_months": 12,
                },
            })
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example-springcloud",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location)
        example_spring_cloud_certificate = azure.appplatform.SpringCloudCertificate("example",
            name="example-scc",
            resource_group_name=example_spring_cloud_service.resource_group_name,
            service_name=example_spring_cloud_service.name,
            key_vault_certificate_id=example_certificate.id,
            exclude_private_key=True)
        ```

        ## Import

        Spring Cloud Certificate can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudCertificate:SpringCloudCertificate example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourcegroup1/providers/Microsoft.AppPlatform/spring/spring1/certificates/cert1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_content: The content of uploaded certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] exclude_private_key: Specifies whether the private key should be excluded from the Key Vault Certificate. Changing this forces a new resource to be created. Defaults to `false`.
        :param pulumi.Input[_builtins.str] key_vault_certificate_id: Specifies the ID of the Key Vault Certificate resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Spring Cloud Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the resource group in which to create the Spring Cloud Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] service_name: Specifies the name of the Spring Cloud Service resource. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpringCloudCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Spring Cloud Certificate.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudCertificate` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        current = azure.core.get_client_config()
        example = azuread.get_service_principal(display_name="Azure Spring Cloud Resource Provider")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="keyvaultcertexample",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            access_policies=[
                {
                    "tenant_id": current.tenant_id,
                    "object_id": current.object_id,
                    "secret_permissions": ["Set"],
                    "certificate_permissions": [
                        "Create",
                        "Delete",
                        "Get",
                        "Update",
                    ],
                },
                {
                    "tenant_id": current.tenant_id,
                    "object_id": example.object_id,
                    "secret_permissions": [
                        "Get",
                        "List",
                    ],
                    "certificate_permissions": [
                        "Get",
                        "List",
                    ],
                },
            ])
        example_certificate = azure.keyvault.Certificate("example",
            name="cert-example",
            key_vault_id=example_key_vault.id,
            certificate_policy={
                "issuer_parameters": {
                    "name": "Self",
                },
                "key_properties": {
                    "exportable": True,
                    "key_size": 2048,
                    "key_type": "RSA",
                    "reuse_key": True,
                },
                "lifetime_actions": [{
                    "action": {
                        "action_type": "AutoRenew",
                    },
                    "trigger": {
                        "days_before_expiry": 30,
                    },
                }],
                "secret_properties": {
                    "content_type": "application/x-pkcs12",
                },
                "x509_certificate_properties": {
                    "key_usages": [
                        "cRLSign",
                        "dataEncipherment",
                        "digitalSignature",
                        "keyAgreement",
                        "keyCertSign",
                        "keyEncipherment",
                    ],
                    "subject": "CN=contoso.com",
                    "validity_in_months": 12,
                },
            })
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example-springcloud",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location)
        example_spring_cloud_certificate = azure.appplatform.SpringCloudCertificate("example",
            name="example-scc",
            resource_group_name=example_spring_cloud_service.resource_group_name,
            service_name=example_spring_cloud_service.name,
            key_vault_certificate_id=example_certificate.id,
            exclude_private_key=True)
        ```

        ## Import

        Spring Cloud Certificate can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudCertificate:SpringCloudCertificate example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourcegroup1/providers/Microsoft.AppPlatform/spring/spring1/certificates/cert1
        ```

        :param str resource_name: The name of the resource.
        :param SpringCloudCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpringCloudCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_content: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_private_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_vault_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpringCloudCertificateArgs.__new__(SpringCloudCertificateArgs)

            __props__.__dict__["certificate_content"] = certificate_content
            __props__.__dict__["exclude_private_key"] = exclude_private_key
            __props__.__dict__["key_vault_certificate_id"] = key_vault_certificate_id
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["thumbprint"] = None
        super(SpringCloudCertificate, __self__).__init__(
            'azure:appplatform/springCloudCertificate:SpringCloudCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_content: Optional[pulumi.Input[_builtins.str]] = None,
            exclude_private_key: Optional[pulumi.Input[_builtins.bool]] = None,
            key_vault_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            thumbprint: Optional[pulumi.Input[_builtins.str]] = None) -> 'SpringCloudCertificate':
        """
        Get an existing SpringCloudCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_content: The content of uploaded certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] exclude_private_key: Specifies whether the private key should be excluded from the Key Vault Certificate. Changing this forces a new resource to be created. Defaults to `false`.
        :param pulumi.Input[_builtins.str] key_vault_certificate_id: Specifies the ID of the Key Vault Certificate resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Spring Cloud Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the resource group in which to create the Spring Cloud Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] service_name: Specifies the name of the Spring Cloud Service resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] thumbprint: The thumbprint of the Spring Cloud certificate.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpringCloudCertificateState.__new__(_SpringCloudCertificateState)

        __props__.__dict__["certificate_content"] = certificate_content
        __props__.__dict__["exclude_private_key"] = exclude_private_key
        __props__.__dict__["key_vault_certificate_id"] = key_vault_certificate_id
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["thumbprint"] = thumbprint
        return SpringCloudCertificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="certificateContent")
    def certificate_content(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The content of uploaded certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "certificate_content")

    @_builtins.property
    @pulumi.getter(name="excludePrivateKey")
    def exclude_private_key(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the private key should be excluded from the Key Vault Certificate. Changing this forces a new resource to be created. Defaults to `false`.
        """
        return pulumi.get(self, "exclude_private_key")

    @_builtins.property
    @pulumi.getter(name="keyVaultCertificateId")
    def key_vault_certificate_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ID of the Key Vault Certificate resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_certificate_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Spring Cloud Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the resource group in which to create the Spring Cloud Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Spring Cloud Service resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def thumbprint(self) -> pulumi.Output[_builtins.str]:
        """
        The thumbprint of the Spring Cloud certificate.
        """
        return pulumi.get(self, "thumbprint")

