# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SpringCloudConnectionArgs', 'SpringCloudConnection']

@pulumi.input_type
class SpringCloudConnectionArgs:
    def __init__(__self__, *,
                 authentication: pulumi.Input['SpringCloudConnectionAuthenticationArgs'],
                 spring_cloud_id: pulumi.Input[_builtins.str],
                 target_resource_id: pulumi.Input[_builtins.str],
                 client_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_store: Optional[pulumi.Input['SpringCloudConnectionSecretStoreArgs']] = None,
                 vnet_solution: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SpringCloudConnection resource.
        :param pulumi.Input['SpringCloudConnectionAuthenticationArgs'] authentication: The authentication info. An `authentication` block as defined below.
        :param pulumi.Input[_builtins.str] spring_cloud_id: The ID of the data source spring cloud. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of the target resource. Changing this forces a new resource to be created. Possible target resources are `Postgres`, `PostgresFlexible`, `Mysql`, `Sql`, `Redis`, `RedisEnterprise`, `CosmosCassandra`, `CosmosGremlin`, `CosmosMongo`, `CosmosSql`, `CosmosTable`, `StorageBlob`, `StorageQueue`, `StorageFile`, `StorageTable`, `AppConfig`, `EventHub`, `ServiceBus`, `SignalR`, `WebPubSub`, `ConfluentKafka`. The integration guide can be found [here](https://learn.microsoft.com/en-us/azure/service-connector/how-to-integrate-postgres).
        :param pulumi.Input[_builtins.str] name: The name of the service connection. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "authentication", authentication)
        pulumi.set(__self__, "spring_cloud_id", spring_cloud_id)
        pulumi.set(__self__, "target_resource_id", target_resource_id)
        if client_type is not None:
            pulumi.set(__self__, "client_type", client_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret_store is not None:
            pulumi.set(__self__, "secret_store", secret_store)
        if vnet_solution is not None:
            pulumi.set(__self__, "vnet_solution", vnet_solution)

    @_builtins.property
    @pulumi.getter
    def authentication(self) -> pulumi.Input['SpringCloudConnectionAuthenticationArgs']:
        """
        The authentication info. An `authentication` block as defined below.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: pulumi.Input['SpringCloudConnectionAuthenticationArgs']):
        pulumi.set(self, "authentication", value)

    @_builtins.property
    @pulumi.getter(name="springCloudId")
    def spring_cloud_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the data source spring cloud. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_id")

    @spring_cloud_id.setter
    def spring_cloud_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "spring_cloud_id", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the target resource. Changing this forces a new resource to be created. Possible target resources are `Postgres`, `PostgresFlexible`, `Mysql`, `Sql`, `Redis`, `RedisEnterprise`, `CosmosCassandra`, `CosmosGremlin`, `CosmosMongo`, `CosmosSql`, `CosmosTable`, `StorageBlob`, `StorageQueue`, `StorageFile`, `StorageTable`, `AppConfig`, `EventHub`, `ServiceBus`, `SignalR`, `WebPubSub`, `ConfluentKafka`. The integration guide can be found [here](https://learn.microsoft.com/en-us/azure/service-connector/how-to-integrate-postgres).
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="clientType")
    def client_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "client_type")

    @client_type.setter
    def client_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="secretStore")
    def secret_store(self) -> Optional[pulumi.Input['SpringCloudConnectionSecretStoreArgs']]:
        return pulumi.get(self, "secret_store")

    @secret_store.setter
    def secret_store(self, value: Optional[pulumi.Input['SpringCloudConnectionSecretStoreArgs']]):
        pulumi.set(self, "secret_store", value)

    @_builtins.property
    @pulumi.getter(name="vnetSolution")
    def vnet_solution(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "vnet_solution")

    @vnet_solution.setter
    def vnet_solution(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vnet_solution", value)


@pulumi.input_type
class _SpringCloudConnectionState:
    def __init__(__self__, *,
                 authentication: Optional[pulumi.Input['SpringCloudConnectionAuthenticationArgs']] = None,
                 client_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_store: Optional[pulumi.Input['SpringCloudConnectionSecretStoreArgs']] = None,
                 spring_cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vnet_solution: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SpringCloudConnection resources.
        :param pulumi.Input['SpringCloudConnectionAuthenticationArgs'] authentication: The authentication info. An `authentication` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name of the service connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] spring_cloud_id: The ID of the data source spring cloud. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of the target resource. Changing this forces a new resource to be created. Possible target resources are `Postgres`, `PostgresFlexible`, `Mysql`, `Sql`, `Redis`, `RedisEnterprise`, `CosmosCassandra`, `CosmosGremlin`, `CosmosMongo`, `CosmosSql`, `CosmosTable`, `StorageBlob`, `StorageQueue`, `StorageFile`, `StorageTable`, `AppConfig`, `EventHub`, `ServiceBus`, `SignalR`, `WebPubSub`, `ConfluentKafka`. The integration guide can be found [here](https://learn.microsoft.com/en-us/azure/service-connector/how-to-integrate-postgres).
        """
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if client_type is not None:
            pulumi.set(__self__, "client_type", client_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret_store is not None:
            pulumi.set(__self__, "secret_store", secret_store)
        if spring_cloud_id is not None:
            pulumi.set(__self__, "spring_cloud_id", spring_cloud_id)
        if target_resource_id is not None:
            pulumi.set(__self__, "target_resource_id", target_resource_id)
        if vnet_solution is not None:
            pulumi.set(__self__, "vnet_solution", vnet_solution)

    @_builtins.property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input['SpringCloudConnectionAuthenticationArgs']]:
        """
        The authentication info. An `authentication` block as defined below.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input['SpringCloudConnectionAuthenticationArgs']]):
        pulumi.set(self, "authentication", value)

    @_builtins.property
    @pulumi.getter(name="clientType")
    def client_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "client_type")

    @client_type.setter
    def client_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="secretStore")
    def secret_store(self) -> Optional[pulumi.Input['SpringCloudConnectionSecretStoreArgs']]:
        return pulumi.get(self, "secret_store")

    @secret_store.setter
    def secret_store(self, value: Optional[pulumi.Input['SpringCloudConnectionSecretStoreArgs']]):
        pulumi.set(self, "secret_store", value)

    @_builtins.property
    @pulumi.getter(name="springCloudId")
    def spring_cloud_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the data source spring cloud. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_id")

    @spring_cloud_id.setter
    def spring_cloud_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spring_cloud_id", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the target resource. Changing this forces a new resource to be created. Possible target resources are `Postgres`, `PostgresFlexible`, `Mysql`, `Sql`, `Redis`, `RedisEnterprise`, `CosmosCassandra`, `CosmosGremlin`, `CosmosMongo`, `CosmosSql`, `CosmosTable`, `StorageBlob`, `StorageQueue`, `StorageFile`, `StorageTable`, `AppConfig`, `EventHub`, `ServiceBus`, `SignalR`, `WebPubSub`, `ConfluentKafka`. The integration guide can be found [here](https://learn.microsoft.com/en-us/azure/service-connector/how-to-integrate-postgres).
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="vnetSolution")
    def vnet_solution(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "vnet_solution")

    @vnet_solution.setter
    def vnet_solution(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vnet_solution", value)


@pulumi.type_token("azure:appplatform/springCloudConnection:SpringCloudConnection")
class SpringCloudConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication: Optional[pulumi.Input[Union['SpringCloudConnectionAuthenticationArgs', 'SpringCloudConnectionAuthenticationArgsDict']]] = None,
                 client_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_store: Optional[pulumi.Input[Union['SpringCloudConnectionSecretStoreArgs', 'SpringCloudConnectionSecretStoreArgsDict']]] = None,
                 spring_cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vnet_solution: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a service connector for spring cloud app.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudConnection` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Import

        Service Connector for spring cloud can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudConnection:SpringCloudConnection example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AppPlatform/Spring/springcloud/apps/springcloudapp/deployments/deployment/providers/Microsoft.ServiceLinker/linkers/serviceconnector1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SpringCloudConnectionAuthenticationArgs', 'SpringCloudConnectionAuthenticationArgsDict']] authentication: The authentication info. An `authentication` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name of the service connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] spring_cloud_id: The ID of the data source spring cloud. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of the target resource. Changing this forces a new resource to be created. Possible target resources are `Postgres`, `PostgresFlexible`, `Mysql`, `Sql`, `Redis`, `RedisEnterprise`, `CosmosCassandra`, `CosmosGremlin`, `CosmosMongo`, `CosmosSql`, `CosmosTable`, `StorageBlob`, `StorageQueue`, `StorageFile`, `StorageTable`, `AppConfig`, `EventHub`, `ServiceBus`, `SignalR`, `WebPubSub`, `ConfluentKafka`. The integration guide can be found [here](https://learn.microsoft.com/en-us/azure/service-connector/how-to-integrate-postgres).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpringCloudConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a service connector for spring cloud app.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudConnection` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Import

        Service Connector for spring cloud can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudConnection:SpringCloudConnection example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AppPlatform/Spring/springcloud/apps/springcloudapp/deployments/deployment/providers/Microsoft.ServiceLinker/linkers/serviceconnector1
        ```

        :param str resource_name: The name of the resource.
        :param SpringCloudConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpringCloudConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication: Optional[pulumi.Input[Union['SpringCloudConnectionAuthenticationArgs', 'SpringCloudConnectionAuthenticationArgsDict']]] = None,
                 client_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_store: Optional[pulumi.Input[Union['SpringCloudConnectionSecretStoreArgs', 'SpringCloudConnectionSecretStoreArgsDict']]] = None,
                 spring_cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vnet_solution: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpringCloudConnectionArgs.__new__(SpringCloudConnectionArgs)

            if authentication is None and not opts.urn:
                raise TypeError("Missing required property 'authentication'")
            __props__.__dict__["authentication"] = authentication
            __props__.__dict__["client_type"] = client_type
            __props__.__dict__["name"] = name
            __props__.__dict__["secret_store"] = secret_store
            if spring_cloud_id is None and not opts.urn:
                raise TypeError("Missing required property 'spring_cloud_id'")
            __props__.__dict__["spring_cloud_id"] = spring_cloud_id
            if target_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_resource_id'")
            __props__.__dict__["target_resource_id"] = target_resource_id
            __props__.__dict__["vnet_solution"] = vnet_solution
        super(SpringCloudConnection, __self__).__init__(
            'azure:appplatform/springCloudConnection:SpringCloudConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication: Optional[pulumi.Input[Union['SpringCloudConnectionAuthenticationArgs', 'SpringCloudConnectionAuthenticationArgsDict']]] = None,
            client_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            secret_store: Optional[pulumi.Input[Union['SpringCloudConnectionSecretStoreArgs', 'SpringCloudConnectionSecretStoreArgsDict']]] = None,
            spring_cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
            target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            vnet_solution: Optional[pulumi.Input[_builtins.str]] = None) -> 'SpringCloudConnection':
        """
        Get an existing SpringCloudConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SpringCloudConnectionAuthenticationArgs', 'SpringCloudConnectionAuthenticationArgsDict']] authentication: The authentication info. An `authentication` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name of the service connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] spring_cloud_id: The ID of the data source spring cloud. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of the target resource. Changing this forces a new resource to be created. Possible target resources are `Postgres`, `PostgresFlexible`, `Mysql`, `Sql`, `Redis`, `RedisEnterprise`, `CosmosCassandra`, `CosmosGremlin`, `CosmosMongo`, `CosmosSql`, `CosmosTable`, `StorageBlob`, `StorageQueue`, `StorageFile`, `StorageTable`, `AppConfig`, `EventHub`, `ServiceBus`, `SignalR`, `WebPubSub`, `ConfluentKafka`. The integration guide can be found [here](https://learn.microsoft.com/en-us/azure/service-connector/how-to-integrate-postgres).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpringCloudConnectionState.__new__(_SpringCloudConnectionState)

        __props__.__dict__["authentication"] = authentication
        __props__.__dict__["client_type"] = client_type
        __props__.__dict__["name"] = name
        __props__.__dict__["secret_store"] = secret_store
        __props__.__dict__["spring_cloud_id"] = spring_cloud_id
        __props__.__dict__["target_resource_id"] = target_resource_id
        __props__.__dict__["vnet_solution"] = vnet_solution
        return SpringCloudConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def authentication(self) -> pulumi.Output['outputs.SpringCloudConnectionAuthentication']:
        """
        The authentication info. An `authentication` block as defined below.
        """
        return pulumi.get(self, "authentication")

    @_builtins.property
    @pulumi.getter(name="clientType")
    def client_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "client_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the service connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="secretStore")
    def secret_store(self) -> pulumi.Output[Optional['outputs.SpringCloudConnectionSecretStore']]:
        return pulumi.get(self, "secret_store")

    @_builtins.property
    @pulumi.getter(name="springCloudId")
    def spring_cloud_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the data source spring cloud. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_id")

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the target resource. Changing this forces a new resource to be created. Possible target resources are `Postgres`, `PostgresFlexible`, `Mysql`, `Sql`, `Redis`, `RedisEnterprise`, `CosmosCassandra`, `CosmosGremlin`, `CosmosMongo`, `CosmosSql`, `CosmosTable`, `StorageBlob`, `StorageQueue`, `StorageFile`, `StorageTable`, `AppConfig`, `EventHub`, `ServiceBus`, `SignalR`, `WebPubSub`, `ConfluentKafka`. The integration guide can be found [here](https://learn.microsoft.com/en-us/azure/service-connector/how-to-integrate-postgres).
        """
        return pulumi.get(self, "target_resource_id")

    @_builtins.property
    @pulumi.getter(name="vnetSolution")
    def vnet_solution(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "vnet_solution")

