# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVariablesResult',
    'AwaitableGetVariablesResult',
    'get_variables',
    'get_variables_output',
]

@pulumi.output_type
class GetVariablesResult:
    """
    A collection of values returned by getVariables.
    """
    def __init__(__self__, automation_account_id=None, bools=None, datetimes=None, encrypteds=None, id=None, ints=None, nulls=None, objects=None, strings=None):
        if automation_account_id and not isinstance(automation_account_id, str):
            raise TypeError("Expected argument 'automation_account_id' to be a str")
        pulumi.set(__self__, "automation_account_id", automation_account_id)
        if bools and not isinstance(bools, list):
            raise TypeError("Expected argument 'bools' to be a list")
        pulumi.set(__self__, "bools", bools)
        if datetimes and not isinstance(datetimes, list):
            raise TypeError("Expected argument 'datetimes' to be a list")
        pulumi.set(__self__, "datetimes", datetimes)
        if encrypteds and not isinstance(encrypteds, list):
            raise TypeError("Expected argument 'encrypteds' to be a list")
        pulumi.set(__self__, "encrypteds", encrypteds)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ints and not isinstance(ints, list):
            raise TypeError("Expected argument 'ints' to be a list")
        pulumi.set(__self__, "ints", ints)
        if nulls and not isinstance(nulls, list):
            raise TypeError("Expected argument 'nulls' to be a list")
        pulumi.set(__self__, "nulls", nulls)
        if objects and not isinstance(objects, list):
            raise TypeError("Expected argument 'objects' to be a list")
        pulumi.set(__self__, "objects", objects)
        if strings and not isinstance(strings, list):
            raise TypeError("Expected argument 'strings' to be a list")
        pulumi.set(__self__, "strings", strings)

    @_builtins.property
    @pulumi.getter(name="automationAccountId")
    def automation_account_id(self) -> _builtins.str:
        return pulumi.get(self, "automation_account_id")

    @_builtins.property
    @pulumi.getter
    def bools(self) -> Sequence['outputs.GetVariablesBoolResult']:
        """
        One or more `variable` blocks as defined below for each boolean variable.
        """
        return pulumi.get(self, "bools")

    @_builtins.property
    @pulumi.getter
    def datetimes(self) -> Sequence['outputs.GetVariablesDatetimeResult']:
        """
        One or more `variable` blocks as defined below for each datetime variable.
        """
        return pulumi.get(self, "datetimes")

    @_builtins.property
    @pulumi.getter
    def encrypteds(self) -> Sequence['outputs.GetVariablesEncryptedResult']:
        """
        Specifies if the Automation Variable is encrypted.
        """
        return pulumi.get(self, "encrypteds")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ints(self) -> Sequence['outputs.GetVariablesIntResult']:
        """
        One or more `variable` blocks as defined below for each int variable.
        """
        return pulumi.get(self, "ints")

    @_builtins.property
    @pulumi.getter
    def nulls(self) -> Sequence['outputs.GetVariablesNullResult']:
        """
        One or more `variable` blocks as defined below for each null variable.
        """
        return pulumi.get(self, "nulls")

    @_builtins.property
    @pulumi.getter
    def objects(self) -> Sequence['outputs.GetVariablesObjectResult']:
        return pulumi.get(self, "objects")

    @_builtins.property
    @pulumi.getter
    def strings(self) -> Sequence['outputs.GetVariablesStringResult']:
        """
        One or more `variable` blocks as defined below for each string variable.
        """
        return pulumi.get(self, "strings")


class AwaitableGetVariablesResult(GetVariablesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVariablesResult(
            automation_account_id=self.automation_account_id,
            bools=self.bools,
            datetimes=self.datetimes,
            encrypteds=self.encrypteds,
            id=self.id,
            ints=self.ints,
            nulls=self.nulls,
            objects=self.objects,
            strings=self.strings)


def get_variables(automation_account_id: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVariablesResult:
    """
    Use this data source to get all variables in an Automation Account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.automation.get_account(name="example-account",
        resource_group_name="example-resources")
    example_get_variables = azure.automation.get_variables(automation_account_id=example.id)
    pulumi.export("stringVars", example_azurerm_automation_variable_string["string"])
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Automation` - 2023-11-01


    :param _builtins.str automation_account_id: The resource ID of the automation account.
    """
    __args__ = dict()
    __args__['automationAccountId'] = automation_account_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:automation/getVariables:getVariables', __args__, opts=opts, typ=GetVariablesResult).value

    return AwaitableGetVariablesResult(
        automation_account_id=pulumi.get(__ret__, 'automation_account_id'),
        bools=pulumi.get(__ret__, 'bools'),
        datetimes=pulumi.get(__ret__, 'datetimes'),
        encrypteds=pulumi.get(__ret__, 'encrypteds'),
        id=pulumi.get(__ret__, 'id'),
        ints=pulumi.get(__ret__, 'ints'),
        nulls=pulumi.get(__ret__, 'nulls'),
        objects=pulumi.get(__ret__, 'objects'),
        strings=pulumi.get(__ret__, 'strings'))
def get_variables_output(automation_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVariablesResult]:
    """
    Use this data source to get all variables in an Automation Account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.automation.get_account(name="example-account",
        resource_group_name="example-resources")
    example_get_variables = azure.automation.get_variables(automation_account_id=example.id)
    pulumi.export("stringVars", example_azurerm_automation_variable_string["string"])
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Automation` - 2023-11-01


    :param _builtins.str automation_account_id: The resource ID of the automation account.
    """
    __args__ = dict()
    __args__['automationAccountId'] = automation_account_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:automation/getVariables:getVariables', __args__, opts=opts, typ=GetVariablesResult)
    return __ret__.apply(lambda __response__: GetVariablesResult(
        automation_account_id=pulumi.get(__response__, 'automation_account_id'),
        bools=pulumi.get(__response__, 'bools'),
        datetimes=pulumi.get(__response__, 'datetimes'),
        encrypteds=pulumi.get(__response__, 'encrypteds'),
        id=pulumi.get(__response__, 'id'),
        ints=pulumi.get(__response__, 'ints'),
        nulls=pulumi.get(__response__, 'nulls'),
        objects=pulumi.get(__response__, 'objects'),
        strings=pulumi.get(__response__, 'strings')))
