# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PrivateCloudArgs', 'PrivateCloud']

@pulumi.input_type
class PrivateCloudArgs:
    def __init__(__self__, *,
                 management_cluster: pulumi.Input['PrivateCloudManagementClusterArgs'],
                 network_subnet_cidr: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku_name: pulumi.Input[_builtins.str],
                 internet_connection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nsxt_password: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vcenter_password: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PrivateCloud resource.
        :param pulumi.Input['PrivateCloudManagementClusterArgs'] management_cluster: A `management_cluster` block as defined below.
               > **Note:** `internet_connection_enabled` and `management_cluster[0].size` cannot be updated at the same time.
        :param pulumi.Input[_builtins.str] network_subnet_cidr: The subnet which should be unique across virtual network in your subscription as well as on-premise. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure VMware Solution Private Cloud should exist. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        :param pulumi.Input[_builtins.str] sku_name: The Name of the SKU used for this Azure VMware Solution Private Cloud. Possible values are `av20`, `av36`, `av36t`, `av36p`, `av36pt`, `av48`, `av48t`, `av52`, `av52t`, and `av64`. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        :param pulumi.Input[_builtins.bool] internet_connection_enabled: Is the Azure VMware Solution Private Cloud connected to the internet? This field can not be updated with `management_cluster[0].size` together.
               > **Note:** `internet_connection_enabled` and `management_cluster[0].size` cannot be updated at the same time.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure VMware Solution Private Cloud should exist. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure VMware Solution Private Cloud. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        :param pulumi.Input[_builtins.str] nsxt_password: The password of the VMware NSX Manager cloudadmin. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure VMware Solution Private Cloud.
        :param pulumi.Input[_builtins.str] vcenter_password: The password of the VMware vCenter Server cloudadmin. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        """
        pulumi.set(__self__, "management_cluster", management_cluster)
        pulumi.set(__self__, "network_subnet_cidr", network_subnet_cidr)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku_name", sku_name)
        if internet_connection_enabled is not None:
            pulumi.set(__self__, "internet_connection_enabled", internet_connection_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nsxt_password is not None:
            pulumi.set(__self__, "nsxt_password", nsxt_password)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vcenter_password is not None:
            pulumi.set(__self__, "vcenter_password", vcenter_password)

    @_builtins.property
    @pulumi.getter(name="managementCluster")
    def management_cluster(self) -> pulumi.Input['PrivateCloudManagementClusterArgs']:
        """
        A `management_cluster` block as defined below.
        > **Note:** `internet_connection_enabled` and `management_cluster[0].size` cannot be updated at the same time.
        """
        return pulumi.get(self, "management_cluster")

    @management_cluster.setter
    def management_cluster(self, value: pulumi.Input['PrivateCloudManagementClusterArgs']):
        pulumi.set(self, "management_cluster", value)

    @_builtins.property
    @pulumi.getter(name="networkSubnetCidr")
    def network_subnet_cidr(self) -> pulumi.Input[_builtins.str]:
        """
        The subnet which should be unique across virtual network in your subscription as well as on-premise. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        """
        return pulumi.get(self, "network_subnet_cidr")

    @network_subnet_cidr.setter
    def network_subnet_cidr(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_subnet_cidr", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Azure VMware Solution Private Cloud should exist. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Name of the SKU used for this Azure VMware Solution Private Cloud. Possible values are `av20`, `av36`, `av36t`, `av36p`, `av36pt`, `av48`, `av48t`, `av52`, `av52t`, and `av64`. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="internetConnectionEnabled")
    def internet_connection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the Azure VMware Solution Private Cloud connected to the internet? This field can not be updated with `management_cluster[0].size` together.
        > **Note:** `internet_connection_enabled` and `management_cluster[0].size` cannot be updated at the same time.
        """
        return pulumi.get(self, "internet_connection_enabled")

    @internet_connection_enabled.setter
    def internet_connection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "internet_connection_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Azure VMware Solution Private Cloud should exist. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Azure VMware Solution Private Cloud. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nsxtPassword")
    def nsxt_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the VMware NSX Manager cloudadmin. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        """
        return pulumi.get(self, "nsxt_password")

    @nsxt_password.setter
    def nsxt_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nsxt_password", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Azure VMware Solution Private Cloud.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vcenterPassword")
    def vcenter_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the VMware vCenter Server cloudadmin. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        """
        return pulumi.get(self, "vcenter_password")

    @vcenter_password.setter
    def vcenter_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vcenter_password", value)


@pulumi.input_type
class _PrivateCloudState:
    def __init__(__self__, *,
                 circuits: Optional[pulumi.Input[Sequence[pulumi.Input['PrivateCloudCircuitArgs']]]] = None,
                 hcx_cloud_manager_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_connection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 management_cluster: Optional[pulumi.Input['PrivateCloudManagementClusterArgs']] = None,
                 management_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 nsxt_certificate_thumbprint: Optional[pulumi.Input[_builtins.str]] = None,
                 nsxt_manager_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 nsxt_password: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioning_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vcenter_certificate_thumbprint: Optional[pulumi.Input[_builtins.str]] = None,
                 vcenter_password: Optional[pulumi.Input[_builtins.str]] = None,
                 vcsa_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 vmotion_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PrivateCloud resources.
        :param pulumi.Input[Sequence[pulumi.Input['PrivateCloudCircuitArgs']]] circuits: A `circuit` block as defined below.
        :param pulumi.Input[_builtins.str] hcx_cloud_manager_endpoint: The endpoint for the VMware HCX Cloud Manager.
        :param pulumi.Input[_builtins.bool] internet_connection_enabled: Is the Azure VMware Solution Private Cloud connected to the internet? This field can not be updated with `management_cluster[0].size` together.
               > **Note:** `internet_connection_enabled` and `management_cluster[0].size` cannot be updated at the same time.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure VMware Solution Private Cloud should exist. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        :param pulumi.Input['PrivateCloudManagementClusterArgs'] management_cluster: A `management_cluster` block as defined below.
               > **Note:** `internet_connection_enabled` and `management_cluster[0].size` cannot be updated at the same time.
        :param pulumi.Input[_builtins.str] management_subnet_cidr: The network used to access VMware vCenter Server and NSX Manager.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure VMware Solution Private Cloud. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        :param pulumi.Input[_builtins.str] network_subnet_cidr: The subnet which should be unique across virtual network in your subscription as well as on-premise. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        :param pulumi.Input[_builtins.str] nsxt_certificate_thumbprint: The thumbprint of the VMware NSX Manager SSL certificate.
        :param pulumi.Input[_builtins.str] nsxt_manager_endpoint: The endpoint for the VMware NSX Manager.
        :param pulumi.Input[_builtins.str] nsxt_password: The password of the VMware NSX Manager cloudadmin. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        :param pulumi.Input[_builtins.str] provisioning_subnet_cidr: The network which is used for virtual machine cold migration, cloning, and snapshot migration.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure VMware Solution Private Cloud should exist. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        :param pulumi.Input[_builtins.str] sku_name: The Name of the SKU used for this Azure VMware Solution Private Cloud. Possible values are `av20`, `av36`, `av36t`, `av36p`, `av36pt`, `av48`, `av48t`, `av52`, `av52t`, and `av64`. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure VMware Solution Private Cloud.
        :param pulumi.Input[_builtins.str] vcenter_certificate_thumbprint: The thumbprint of the VMware vCenter Server SSL certificate.
        :param pulumi.Input[_builtins.str] vcenter_password: The password of the VMware vCenter Server cloudadmin. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        :param pulumi.Input[_builtins.str] vcsa_endpoint: The endpoint for VMware vCenter Server Appliance.
        :param pulumi.Input[_builtins.str] vmotion_subnet_cidr: The network which is used for live migration of virtual machines.
        """
        if circuits is not None:
            pulumi.set(__self__, "circuits", circuits)
        if hcx_cloud_manager_endpoint is not None:
            pulumi.set(__self__, "hcx_cloud_manager_endpoint", hcx_cloud_manager_endpoint)
        if internet_connection_enabled is not None:
            pulumi.set(__self__, "internet_connection_enabled", internet_connection_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if management_cluster is not None:
            pulumi.set(__self__, "management_cluster", management_cluster)
        if management_subnet_cidr is not None:
            pulumi.set(__self__, "management_subnet_cidr", management_subnet_cidr)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_subnet_cidr is not None:
            pulumi.set(__self__, "network_subnet_cidr", network_subnet_cidr)
        if nsxt_certificate_thumbprint is not None:
            pulumi.set(__self__, "nsxt_certificate_thumbprint", nsxt_certificate_thumbprint)
        if nsxt_manager_endpoint is not None:
            pulumi.set(__self__, "nsxt_manager_endpoint", nsxt_manager_endpoint)
        if nsxt_password is not None:
            pulumi.set(__self__, "nsxt_password", nsxt_password)
        if provisioning_subnet_cidr is not None:
            pulumi.set(__self__, "provisioning_subnet_cidr", provisioning_subnet_cidr)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vcenter_certificate_thumbprint is not None:
            pulumi.set(__self__, "vcenter_certificate_thumbprint", vcenter_certificate_thumbprint)
        if vcenter_password is not None:
            pulumi.set(__self__, "vcenter_password", vcenter_password)
        if vcsa_endpoint is not None:
            pulumi.set(__self__, "vcsa_endpoint", vcsa_endpoint)
        if vmotion_subnet_cidr is not None:
            pulumi.set(__self__, "vmotion_subnet_cidr", vmotion_subnet_cidr)

    @_builtins.property
    @pulumi.getter
    def circuits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PrivateCloudCircuitArgs']]]]:
        """
        A `circuit` block as defined below.
        """
        return pulumi.get(self, "circuits")

    @circuits.setter
    def circuits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PrivateCloudCircuitArgs']]]]):
        pulumi.set(self, "circuits", value)

    @_builtins.property
    @pulumi.getter(name="hcxCloudManagerEndpoint")
    def hcx_cloud_manager_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint for the VMware HCX Cloud Manager.
        """
        return pulumi.get(self, "hcx_cloud_manager_endpoint")

    @hcx_cloud_manager_endpoint.setter
    def hcx_cloud_manager_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hcx_cloud_manager_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="internetConnectionEnabled")
    def internet_connection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the Azure VMware Solution Private Cloud connected to the internet? This field can not be updated with `management_cluster[0].size` together.
        > **Note:** `internet_connection_enabled` and `management_cluster[0].size` cannot be updated at the same time.
        """
        return pulumi.get(self, "internet_connection_enabled")

    @internet_connection_enabled.setter
    def internet_connection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "internet_connection_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Azure VMware Solution Private Cloud should exist. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managementCluster")
    def management_cluster(self) -> Optional[pulumi.Input['PrivateCloudManagementClusterArgs']]:
        """
        A `management_cluster` block as defined below.
        > **Note:** `internet_connection_enabled` and `management_cluster[0].size` cannot be updated at the same time.
        """
        return pulumi.get(self, "management_cluster")

    @management_cluster.setter
    def management_cluster(self, value: Optional[pulumi.Input['PrivateCloudManagementClusterArgs']]):
        pulumi.set(self, "management_cluster", value)

    @_builtins.property
    @pulumi.getter(name="managementSubnetCidr")
    def management_subnet_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network used to access VMware vCenter Server and NSX Manager.
        """
        return pulumi.get(self, "management_subnet_cidr")

    @management_subnet_cidr.setter
    def management_subnet_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "management_subnet_cidr", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Azure VMware Solution Private Cloud. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkSubnetCidr")
    def network_subnet_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subnet which should be unique across virtual network in your subscription as well as on-premise. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        """
        return pulumi.get(self, "network_subnet_cidr")

    @network_subnet_cidr.setter
    def network_subnet_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_subnet_cidr", value)

    @_builtins.property
    @pulumi.getter(name="nsxtCertificateThumbprint")
    def nsxt_certificate_thumbprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The thumbprint of the VMware NSX Manager SSL certificate.
        """
        return pulumi.get(self, "nsxt_certificate_thumbprint")

    @nsxt_certificate_thumbprint.setter
    def nsxt_certificate_thumbprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nsxt_certificate_thumbprint", value)

    @_builtins.property
    @pulumi.getter(name="nsxtManagerEndpoint")
    def nsxt_manager_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint for the VMware NSX Manager.
        """
        return pulumi.get(self, "nsxt_manager_endpoint")

    @nsxt_manager_endpoint.setter
    def nsxt_manager_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nsxt_manager_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="nsxtPassword")
    def nsxt_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the VMware NSX Manager cloudadmin. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        """
        return pulumi.get(self, "nsxt_password")

    @nsxt_password.setter
    def nsxt_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nsxt_password", value)

    @_builtins.property
    @pulumi.getter(name="provisioningSubnetCidr")
    def provisioning_subnet_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network which is used for virtual machine cold migration, cloning, and snapshot migration.
        """
        return pulumi.get(self, "provisioning_subnet_cidr")

    @provisioning_subnet_cidr.setter
    def provisioning_subnet_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provisioning_subnet_cidr", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Azure VMware Solution Private Cloud should exist. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name of the SKU used for this Azure VMware Solution Private Cloud. Possible values are `av20`, `av36`, `av36t`, `av36p`, `av36pt`, `av48`, `av48t`, `av52`, `av52t`, and `av64`. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Azure VMware Solution Private Cloud.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vcenterCertificateThumbprint")
    def vcenter_certificate_thumbprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The thumbprint of the VMware vCenter Server SSL certificate.
        """
        return pulumi.get(self, "vcenter_certificate_thumbprint")

    @vcenter_certificate_thumbprint.setter
    def vcenter_certificate_thumbprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vcenter_certificate_thumbprint", value)

    @_builtins.property
    @pulumi.getter(name="vcenterPassword")
    def vcenter_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the VMware vCenter Server cloudadmin. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        """
        return pulumi.get(self, "vcenter_password")

    @vcenter_password.setter
    def vcenter_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vcenter_password", value)

    @_builtins.property
    @pulumi.getter(name="vcsaEndpoint")
    def vcsa_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint for VMware vCenter Server Appliance.
        """
        return pulumi.get(self, "vcsa_endpoint")

    @vcsa_endpoint.setter
    def vcsa_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vcsa_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="vmotionSubnetCidr")
    def vmotion_subnet_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network which is used for live migration of virtual machines.
        """
        return pulumi.get(self, "vmotion_subnet_cidr")

    @vmotion_subnet_cidr.setter
    def vmotion_subnet_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vmotion_subnet_cidr", value)


@pulumi.type_token("azure:avs/privateCloud:PrivateCloud")
class PrivateCloud(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 internet_connection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 management_cluster: Optional[pulumi.Input[Union['PrivateCloudManagementClusterArgs', 'PrivateCloudManagementClusterArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 nsxt_password: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vcenter_password: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure VMware Solution Private Cloud.

        ## Example Usage

        > **Note:** Normal `pulumi up` could ignore this note. Please disable correlation request id for continuous operations in one build (like acctest). The continuous operations like `update` or `delete` could not be triggered when it shares the same `correlation-id` with its previous operation.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_private_cloud = azure.avs.PrivateCloud("example",
            name="example-vmware-private-cloud",
            resource_group_name=example.name,
            location=example.location,
            sku_name="av36",
            management_cluster={
                "size": 3,
            },
            network_subnet_cidr="192.168.48.0/22",
            internet_connection_enabled=False,
            nsxt_password="QazWsx13$Edc",
            vcenter_password="WsxEdc23$Rfv")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AVS` - 2022-05-01

        ## Import

        Azure VMware Solution Private Clouds can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:avs/privateCloud:PrivateCloud example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/privateCloud1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] internet_connection_enabled: Is the Azure VMware Solution Private Cloud connected to the internet? This field can not be updated with `management_cluster[0].size` together.
               > **Note:** `internet_connection_enabled` and `management_cluster[0].size` cannot be updated at the same time.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure VMware Solution Private Cloud should exist. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        :param pulumi.Input[Union['PrivateCloudManagementClusterArgs', 'PrivateCloudManagementClusterArgsDict']] management_cluster: A `management_cluster` block as defined below.
               > **Note:** `internet_connection_enabled` and `management_cluster[0].size` cannot be updated at the same time.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure VMware Solution Private Cloud. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        :param pulumi.Input[_builtins.str] network_subnet_cidr: The subnet which should be unique across virtual network in your subscription as well as on-premise. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        :param pulumi.Input[_builtins.str] nsxt_password: The password of the VMware NSX Manager cloudadmin. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure VMware Solution Private Cloud should exist. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        :param pulumi.Input[_builtins.str] sku_name: The Name of the SKU used for this Azure VMware Solution Private Cloud. Possible values are `av20`, `av36`, `av36t`, `av36p`, `av36pt`, `av48`, `av48t`, `av52`, `av52t`, and `av64`. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure VMware Solution Private Cloud.
        :param pulumi.Input[_builtins.str] vcenter_password: The password of the VMware vCenter Server cloudadmin. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PrivateCloudArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure VMware Solution Private Cloud.

        ## Example Usage

        > **Note:** Normal `pulumi up` could ignore this note. Please disable correlation request id for continuous operations in one build (like acctest). The continuous operations like `update` or `delete` could not be triggered when it shares the same `correlation-id` with its previous operation.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_private_cloud = azure.avs.PrivateCloud("example",
            name="example-vmware-private-cloud",
            resource_group_name=example.name,
            location=example.location,
            sku_name="av36",
            management_cluster={
                "size": 3,
            },
            network_subnet_cidr="192.168.48.0/22",
            internet_connection_enabled=False,
            nsxt_password="QazWsx13$Edc",
            vcenter_password="WsxEdc23$Rfv")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AVS` - 2022-05-01

        ## Import

        Azure VMware Solution Private Clouds can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:avs/privateCloud:PrivateCloud example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/privateCloud1
        ```

        :param str resource_name: The name of the resource.
        :param PrivateCloudArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PrivateCloudArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 internet_connection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 management_cluster: Optional[pulumi.Input[Union['PrivateCloudManagementClusterArgs', 'PrivateCloudManagementClusterArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 nsxt_password: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vcenter_password: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PrivateCloudArgs.__new__(PrivateCloudArgs)

            __props__.__dict__["internet_connection_enabled"] = internet_connection_enabled
            __props__.__dict__["location"] = location
            if management_cluster is None and not opts.urn:
                raise TypeError("Missing required property 'management_cluster'")
            __props__.__dict__["management_cluster"] = management_cluster
            __props__.__dict__["name"] = name
            if network_subnet_cidr is None and not opts.urn:
                raise TypeError("Missing required property 'network_subnet_cidr'")
            __props__.__dict__["network_subnet_cidr"] = network_subnet_cidr
            __props__.__dict__["nsxt_password"] = None if nsxt_password is None else pulumi.Output.secret(nsxt_password)
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku_name is None and not opts.urn:
                raise TypeError("Missing required property 'sku_name'")
            __props__.__dict__["sku_name"] = sku_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vcenter_password"] = None if vcenter_password is None else pulumi.Output.secret(vcenter_password)
            __props__.__dict__["circuits"] = None
            __props__.__dict__["hcx_cloud_manager_endpoint"] = None
            __props__.__dict__["management_subnet_cidr"] = None
            __props__.__dict__["nsxt_certificate_thumbprint"] = None
            __props__.__dict__["nsxt_manager_endpoint"] = None
            __props__.__dict__["provisioning_subnet_cidr"] = None
            __props__.__dict__["vcenter_certificate_thumbprint"] = None
            __props__.__dict__["vcsa_endpoint"] = None
            __props__.__dict__["vmotion_subnet_cidr"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["nsxtPassword", "vcenterPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(PrivateCloud, __self__).__init__(
            'azure:avs/privateCloud:PrivateCloud',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            circuits: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PrivateCloudCircuitArgs', 'PrivateCloudCircuitArgsDict']]]]] = None,
            hcx_cloud_manager_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            internet_connection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            management_cluster: Optional[pulumi.Input[Union['PrivateCloudManagementClusterArgs', 'PrivateCloudManagementClusterArgsDict']]] = None,
            management_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            nsxt_certificate_thumbprint: Optional[pulumi.Input[_builtins.str]] = None,
            nsxt_manager_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            nsxt_password: Optional[pulumi.Input[_builtins.str]] = None,
            provisioning_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vcenter_certificate_thumbprint: Optional[pulumi.Input[_builtins.str]] = None,
            vcenter_password: Optional[pulumi.Input[_builtins.str]] = None,
            vcsa_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            vmotion_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None) -> 'PrivateCloud':
        """
        Get an existing PrivateCloud resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PrivateCloudCircuitArgs', 'PrivateCloudCircuitArgsDict']]]] circuits: A `circuit` block as defined below.
        :param pulumi.Input[_builtins.str] hcx_cloud_manager_endpoint: The endpoint for the VMware HCX Cloud Manager.
        :param pulumi.Input[_builtins.bool] internet_connection_enabled: Is the Azure VMware Solution Private Cloud connected to the internet? This field can not be updated with `management_cluster[0].size` together.
               > **Note:** `internet_connection_enabled` and `management_cluster[0].size` cannot be updated at the same time.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure VMware Solution Private Cloud should exist. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        :param pulumi.Input[Union['PrivateCloudManagementClusterArgs', 'PrivateCloudManagementClusterArgsDict']] management_cluster: A `management_cluster` block as defined below.
               > **Note:** `internet_connection_enabled` and `management_cluster[0].size` cannot be updated at the same time.
        :param pulumi.Input[_builtins.str] management_subnet_cidr: The network used to access VMware vCenter Server and NSX Manager.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure VMware Solution Private Cloud. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        :param pulumi.Input[_builtins.str] network_subnet_cidr: The subnet which should be unique across virtual network in your subscription as well as on-premise. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        :param pulumi.Input[_builtins.str] nsxt_certificate_thumbprint: The thumbprint of the VMware NSX Manager SSL certificate.
        :param pulumi.Input[_builtins.str] nsxt_manager_endpoint: The endpoint for the VMware NSX Manager.
        :param pulumi.Input[_builtins.str] nsxt_password: The password of the VMware NSX Manager cloudadmin. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        :param pulumi.Input[_builtins.str] provisioning_subnet_cidr: The network which is used for virtual machine cold migration, cloning, and snapshot migration.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure VMware Solution Private Cloud should exist. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        :param pulumi.Input[_builtins.str] sku_name: The Name of the SKU used for this Azure VMware Solution Private Cloud. Possible values are `av20`, `av36`, `av36t`, `av36p`, `av36pt`, `av48`, `av48t`, `av52`, `av52t`, and `av64`. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure VMware Solution Private Cloud.
        :param pulumi.Input[_builtins.str] vcenter_certificate_thumbprint: The thumbprint of the VMware vCenter Server SSL certificate.
        :param pulumi.Input[_builtins.str] vcenter_password: The password of the VMware vCenter Server cloudadmin. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        :param pulumi.Input[_builtins.str] vcsa_endpoint: The endpoint for VMware vCenter Server Appliance.
        :param pulumi.Input[_builtins.str] vmotion_subnet_cidr: The network which is used for live migration of virtual machines.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PrivateCloudState.__new__(_PrivateCloudState)

        __props__.__dict__["circuits"] = circuits
        __props__.__dict__["hcx_cloud_manager_endpoint"] = hcx_cloud_manager_endpoint
        __props__.__dict__["internet_connection_enabled"] = internet_connection_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["management_cluster"] = management_cluster
        __props__.__dict__["management_subnet_cidr"] = management_subnet_cidr
        __props__.__dict__["name"] = name
        __props__.__dict__["network_subnet_cidr"] = network_subnet_cidr
        __props__.__dict__["nsxt_certificate_thumbprint"] = nsxt_certificate_thumbprint
        __props__.__dict__["nsxt_manager_endpoint"] = nsxt_manager_endpoint
        __props__.__dict__["nsxt_password"] = nsxt_password
        __props__.__dict__["provisioning_subnet_cidr"] = provisioning_subnet_cidr
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vcenter_certificate_thumbprint"] = vcenter_certificate_thumbprint
        __props__.__dict__["vcenter_password"] = vcenter_password
        __props__.__dict__["vcsa_endpoint"] = vcsa_endpoint
        __props__.__dict__["vmotion_subnet_cidr"] = vmotion_subnet_cidr
        return PrivateCloud(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def circuits(self) -> pulumi.Output[Sequence['outputs.PrivateCloudCircuit']]:
        """
        A `circuit` block as defined below.
        """
        return pulumi.get(self, "circuits")

    @_builtins.property
    @pulumi.getter(name="hcxCloudManagerEndpoint")
    def hcx_cloud_manager_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The endpoint for the VMware HCX Cloud Manager.
        """
        return pulumi.get(self, "hcx_cloud_manager_endpoint")

    @_builtins.property
    @pulumi.getter(name="internetConnectionEnabled")
    def internet_connection_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is the Azure VMware Solution Private Cloud connected to the internet? This field can not be updated with `management_cluster[0].size` together.
        > **Note:** `internet_connection_enabled` and `management_cluster[0].size` cannot be updated at the same time.
        """
        return pulumi.get(self, "internet_connection_enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Azure VMware Solution Private Cloud should exist. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="managementCluster")
    def management_cluster(self) -> pulumi.Output['outputs.PrivateCloudManagementCluster']:
        """
        A `management_cluster` block as defined below.
        > **Note:** `internet_connection_enabled` and `management_cluster[0].size` cannot be updated at the same time.
        """
        return pulumi.get(self, "management_cluster")

    @_builtins.property
    @pulumi.getter(name="managementSubnetCidr")
    def management_subnet_cidr(self) -> pulumi.Output[_builtins.str]:
        """
        The network used to access VMware vCenter Server and NSX Manager.
        """
        return pulumi.get(self, "management_subnet_cidr")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Azure VMware Solution Private Cloud. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkSubnetCidr")
    def network_subnet_cidr(self) -> pulumi.Output[_builtins.str]:
        """
        The subnet which should be unique across virtual network in your subscription as well as on-premise. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        """
        return pulumi.get(self, "network_subnet_cidr")

    @_builtins.property
    @pulumi.getter(name="nsxtCertificateThumbprint")
    def nsxt_certificate_thumbprint(self) -> pulumi.Output[_builtins.str]:
        """
        The thumbprint of the VMware NSX Manager SSL certificate.
        """
        return pulumi.get(self, "nsxt_certificate_thumbprint")

    @_builtins.property
    @pulumi.getter(name="nsxtManagerEndpoint")
    def nsxt_manager_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The endpoint for the VMware NSX Manager.
        """
        return pulumi.get(self, "nsxt_manager_endpoint")

    @_builtins.property
    @pulumi.getter(name="nsxtPassword")
    def nsxt_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password of the VMware NSX Manager cloudadmin. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        """
        return pulumi.get(self, "nsxt_password")

    @_builtins.property
    @pulumi.getter(name="provisioningSubnetCidr")
    def provisioning_subnet_cidr(self) -> pulumi.Output[_builtins.str]:
        """
        The network which is used for virtual machine cold migration, cloning, and snapshot migration.
        """
        return pulumi.get(self, "provisioning_subnet_cidr")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Azure VMware Solution Private Cloud should exist. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Name of the SKU used for this Azure VMware Solution Private Cloud. Possible values are `av20`, `av36`, `av36t`, `av36p`, `av36pt`, `av48`, `av48t`, `av52`, `av52t`, and `av64`. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Azure VMware Solution Private Cloud.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vcenterCertificateThumbprint")
    def vcenter_certificate_thumbprint(self) -> pulumi.Output[_builtins.str]:
        """
        The thumbprint of the VMware vCenter Server SSL certificate.
        """
        return pulumi.get(self, "vcenter_certificate_thumbprint")

    @_builtins.property
    @pulumi.getter(name="vcenterPassword")
    def vcenter_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password of the VMware vCenter Server cloudadmin. Changing this forces a new Azure VMware Solution Private Cloud to be created.
        """
        return pulumi.get(self, "vcenter_password")

    @_builtins.property
    @pulumi.getter(name="vcsaEndpoint")
    def vcsa_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The endpoint for VMware vCenter Server Appliance.
        """
        return pulumi.get(self, "vcsa_endpoint")

    @_builtins.property
    @pulumi.getter(name="vmotionSubnetCidr")
    def vmotion_subnet_cidr(self) -> pulumi.Output[_builtins.str]:
        """
        The network which is used for live migration of virtual machines.
        """
        return pulumi.get(self, "vmotion_subnet_cidr")

