# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FrontdoorSecretArgs', 'FrontdoorSecret']

@pulumi.input_type
class FrontdoorSecretArgs:
    def __init__(__self__, *,
                 cdn_frontdoor_profile_id: pulumi.Input[_builtins.str],
                 secret: pulumi.Input['FrontdoorSecretSecretArgs'],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FrontdoorSecret resource.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_profile_id: The Resource ID of the Front Door Profile. Changing this forces a new Front Door Secret to be created.
        :param pulumi.Input['FrontdoorSecretSecretArgs'] secret: A `secret` block as defined below. Changing this forces a new Front Door Secret to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Front Door Secret. Possible values must start with a letter or a number, only contain letters, numbers and hyphens and have a length of between 2 and 260 characters. Changing this forces a new Front Door Secret to be created.
        """
        pulumi.set(__self__, "cdn_frontdoor_profile_id", cdn_frontdoor_profile_id)
        pulumi.set(__self__, "secret", secret)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorProfileId")
    def cdn_frontdoor_profile_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Resource ID of the Front Door Profile. Changing this forces a new Front Door Secret to be created.
        """
        return pulumi.get(self, "cdn_frontdoor_profile_id")

    @cdn_frontdoor_profile_id.setter
    def cdn_frontdoor_profile_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cdn_frontdoor_profile_id", value)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> pulumi.Input['FrontdoorSecretSecretArgs']:
        """
        A `secret` block as defined below. Changing this forces a new Front Door Secret to be created.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: pulumi.Input['FrontdoorSecretSecretArgs']):
        pulumi.set(self, "secret", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Front Door Secret. Possible values must start with a letter or a number, only contain letters, numbers and hyphens and have a length of between 2 and 260 characters. Changing this forces a new Front Door Secret to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _FrontdoorSecretState:
    def __init__(__self__, *,
                 cdn_frontdoor_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cdn_frontdoor_profile_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input['FrontdoorSecretSecretArgs']] = None):
        """
        Input properties used for looking up and filtering FrontdoorSecret resources.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_profile_id: The Resource ID of the Front Door Profile. Changing this forces a new Front Door Secret to be created.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_profile_name: The name of the Front Door Profile containing this Front Door Secret.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Front Door Secret. Possible values must start with a letter or a number, only contain letters, numbers and hyphens and have a length of between 2 and 260 characters. Changing this forces a new Front Door Secret to be created.
        :param pulumi.Input['FrontdoorSecretSecretArgs'] secret: A `secret` block as defined below. Changing this forces a new Front Door Secret to be created.
        """
        if cdn_frontdoor_profile_id is not None:
            pulumi.set(__self__, "cdn_frontdoor_profile_id", cdn_frontdoor_profile_id)
        if cdn_frontdoor_profile_name is not None:
            pulumi.set(__self__, "cdn_frontdoor_profile_name", cdn_frontdoor_profile_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorProfileId")
    def cdn_frontdoor_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Resource ID of the Front Door Profile. Changing this forces a new Front Door Secret to be created.
        """
        return pulumi.get(self, "cdn_frontdoor_profile_id")

    @cdn_frontdoor_profile_id.setter
    def cdn_frontdoor_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cdn_frontdoor_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorProfileName")
    def cdn_frontdoor_profile_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Front Door Profile containing this Front Door Secret.
        """
        return pulumi.get(self, "cdn_frontdoor_profile_name")

    @cdn_frontdoor_profile_name.setter
    def cdn_frontdoor_profile_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cdn_frontdoor_profile_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Front Door Secret. Possible values must start with a letter or a number, only contain letters, numbers and hyphens and have a length of between 2 and 260 characters. Changing this forces a new Front Door Secret to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input['FrontdoorSecretSecretArgs']]:
        """
        A `secret` block as defined below. Changing this forces a new Front Door Secret to be created.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input['FrontdoorSecretSecretArgs']]):
        pulumi.set(self, "secret", value)


@pulumi.type_token("azure:cdn/frontdoorSecret:FrontdoorSecret")
class FrontdoorSecret(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cdn_frontdoor_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input[Union['FrontdoorSecretSecretArgs', 'FrontdoorSecretSecretArgsDict']]] = None,
                 __props__=None):
        """
        Manages a Front Door (standard/premium) Secret.

        ## Required Key Vault Permissions

        !> **Note:** You must add an `Access Policy` to your `keyvault.KeyVault` for the `Microsoft.AzurefrontDoor-Cdn` Enterprise Application Object ID.

        This can be created by running Az Powershell command like this:

        ```New-AzADServicePrincipal -ApplicationId "00000000-0000-0000-0000-000000000000"```

        | Object ID                                | Key Permissions | Secret Permissions   | Certificate Permissions                       |
        |:-----------------------------------------|:---------------:|:--------------------:|:---------------------------------------------:|
        | `Microsoft.Azure.Cdn` Object ID          | -               | **Get**              | -                                             |
        | Your Personal AAD Object ID              | -               | **Get** and **List** | **Get**, **List**, **Purge** and **Recover**  |
        | Terraform Service Principal              | -               | **Get**              | **Get**, **Import**, **Delete** and **Purge** |

        -> **Note:** You only need to add the `Access Policy` for your personal AAD Object ID if you are planning to view the `secrets` via the Azure Portal.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread
        import pulumi_std as std

        current = azure.core.get_client_config()
        frontdoor = azuread.get_service_principal(display_name="Microsoft.AzurefrontDoor-Cdn")
        example = azure.core.ResourceGroup("example",
            name="example-cdn-frontdoor",
            location="West Europe")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example-keyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium",
            soft_delete_retention_days=7,
            network_acls={
                "default_action": "Deny",
                "bypass": "AzureServices",
                "ip_rules": ["10.0.0.0/24"],
            },
            access_policies=[
                {
                    "tenant_id": current.tenant_id,
                    "object_id": frontdoor.object_id,
                    "secret_permissions": ["Get"],
                },
                {
                    "tenant_id": current.tenant_id,
                    "object_id": current.object_id,
                    "certificate_permissions": [
                        "Get",
                        "Import",
                        "Delete",
                        "Purge",
                    ],
                    "secret_permissions": ["Get"],
                },
            ])
        example_certificate = azure.keyvault.Certificate("example",
            name="example-cert",
            key_vault_id=example_key_vault.id,
            certificate={
                "contents": std.filebase64(input="my-certificate.pfx").result,
            })
        example_frontdoor_profile = azure.cdn.FrontdoorProfile("example",
            name="example-cdn-profile",
            resource_group_name=example.name,
            sku_name="Standard_AzureFrontDoor")
        example_frontdoor_secret = azure.cdn.FrontdoorSecret("example",
            name="example-customer-managed-secret",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            secret={
                "customer_certificates": [{
                    "key_vault_certificate_id": example_certificate.id,
                }],
            })
        ```

        ## Import

        Front Door Secrets can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cdn/frontdoorSecret:FrontdoorSecret example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Cdn/profiles/profile1/secrets/secrets1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_profile_id: The Resource ID of the Front Door Profile. Changing this forces a new Front Door Secret to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Front Door Secret. Possible values must start with a letter or a number, only contain letters, numbers and hyphens and have a length of between 2 and 260 characters. Changing this forces a new Front Door Secret to be created.
        :param pulumi.Input[Union['FrontdoorSecretSecretArgs', 'FrontdoorSecretSecretArgsDict']] secret: A `secret` block as defined below. Changing this forces a new Front Door Secret to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FrontdoorSecretArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Front Door (standard/premium) Secret.

        ## Required Key Vault Permissions

        !> **Note:** You must add an `Access Policy` to your `keyvault.KeyVault` for the `Microsoft.AzurefrontDoor-Cdn` Enterprise Application Object ID.

        This can be created by running Az Powershell command like this:

        ```New-AzADServicePrincipal -ApplicationId "00000000-0000-0000-0000-000000000000"```

        | Object ID                                | Key Permissions | Secret Permissions   | Certificate Permissions                       |
        |:-----------------------------------------|:---------------:|:--------------------:|:---------------------------------------------:|
        | `Microsoft.Azure.Cdn` Object ID          | -               | **Get**              | -                                             |
        | Your Personal AAD Object ID              | -               | **Get** and **List** | **Get**, **List**, **Purge** and **Recover**  |
        | Terraform Service Principal              | -               | **Get**              | **Get**, **Import**, **Delete** and **Purge** |

        -> **Note:** You only need to add the `Access Policy` for your personal AAD Object ID if you are planning to view the `secrets` via the Azure Portal.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread
        import pulumi_std as std

        current = azure.core.get_client_config()
        frontdoor = azuread.get_service_principal(display_name="Microsoft.AzurefrontDoor-Cdn")
        example = azure.core.ResourceGroup("example",
            name="example-cdn-frontdoor",
            location="West Europe")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example-keyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium",
            soft_delete_retention_days=7,
            network_acls={
                "default_action": "Deny",
                "bypass": "AzureServices",
                "ip_rules": ["10.0.0.0/24"],
            },
            access_policies=[
                {
                    "tenant_id": current.tenant_id,
                    "object_id": frontdoor.object_id,
                    "secret_permissions": ["Get"],
                },
                {
                    "tenant_id": current.tenant_id,
                    "object_id": current.object_id,
                    "certificate_permissions": [
                        "Get",
                        "Import",
                        "Delete",
                        "Purge",
                    ],
                    "secret_permissions": ["Get"],
                },
            ])
        example_certificate = azure.keyvault.Certificate("example",
            name="example-cert",
            key_vault_id=example_key_vault.id,
            certificate={
                "contents": std.filebase64(input="my-certificate.pfx").result,
            })
        example_frontdoor_profile = azure.cdn.FrontdoorProfile("example",
            name="example-cdn-profile",
            resource_group_name=example.name,
            sku_name="Standard_AzureFrontDoor")
        example_frontdoor_secret = azure.cdn.FrontdoorSecret("example",
            name="example-customer-managed-secret",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            secret={
                "customer_certificates": [{
                    "key_vault_certificate_id": example_certificate.id,
                }],
            })
        ```

        ## Import

        Front Door Secrets can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cdn/frontdoorSecret:FrontdoorSecret example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Cdn/profiles/profile1/secrets/secrets1
        ```

        :param str resource_name: The name of the resource.
        :param FrontdoorSecretArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FrontdoorSecretArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cdn_frontdoor_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input[Union['FrontdoorSecretSecretArgs', 'FrontdoorSecretSecretArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FrontdoorSecretArgs.__new__(FrontdoorSecretArgs)

            if cdn_frontdoor_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'cdn_frontdoor_profile_id'")
            __props__.__dict__["cdn_frontdoor_profile_id"] = cdn_frontdoor_profile_id
            __props__.__dict__["name"] = name
            if secret is None and not opts.urn:
                raise TypeError("Missing required property 'secret'")
            __props__.__dict__["secret"] = secret
            __props__.__dict__["cdn_frontdoor_profile_name"] = None
        super(FrontdoorSecret, __self__).__init__(
            'azure:cdn/frontdoorSecret:FrontdoorSecret',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cdn_frontdoor_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            cdn_frontdoor_profile_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            secret: Optional[pulumi.Input[Union['FrontdoorSecretSecretArgs', 'FrontdoorSecretSecretArgsDict']]] = None) -> 'FrontdoorSecret':
        """
        Get an existing FrontdoorSecret resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_profile_id: The Resource ID of the Front Door Profile. Changing this forces a new Front Door Secret to be created.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_profile_name: The name of the Front Door Profile containing this Front Door Secret.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Front Door Secret. Possible values must start with a letter or a number, only contain letters, numbers and hyphens and have a length of between 2 and 260 characters. Changing this forces a new Front Door Secret to be created.
        :param pulumi.Input[Union['FrontdoorSecretSecretArgs', 'FrontdoorSecretSecretArgsDict']] secret: A `secret` block as defined below. Changing this forces a new Front Door Secret to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FrontdoorSecretState.__new__(_FrontdoorSecretState)

        __props__.__dict__["cdn_frontdoor_profile_id"] = cdn_frontdoor_profile_id
        __props__.__dict__["cdn_frontdoor_profile_name"] = cdn_frontdoor_profile_name
        __props__.__dict__["name"] = name
        __props__.__dict__["secret"] = secret
        return FrontdoorSecret(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorProfileId")
    def cdn_frontdoor_profile_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Resource ID of the Front Door Profile. Changing this forces a new Front Door Secret to be created.
        """
        return pulumi.get(self, "cdn_frontdoor_profile_id")

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorProfileName")
    def cdn_frontdoor_profile_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Front Door Profile containing this Front Door Secret.
        """
        return pulumi.get(self, "cdn_frontdoor_profile_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Front Door Secret. Possible values must start with a letter or a number, only contain letters, numbers and hyphens and have a length of between 2 and 260 characters. Changing this forces a new Front Door Secret to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> pulumi.Output['outputs.FrontdoorSecretSecret']:
        """
        A `secret` block as defined below. Changing this forces a new Front Door Secret to be created.
        """
        return pulumi.get(self, "secret")

