# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AppDapr',
    'AppIdentity',
    'AppIngress',
    'AppIngressCors',
    'AppIngressCustomDomain',
    'AppIngressIpSecurityRestriction',
    'AppIngressTrafficWeight',
    'AppRegistry',
    'AppSecret',
    'AppTemplate',
    'AppTemplateAzureQueueScaleRule',
    'AppTemplateAzureQueueScaleRuleAuthentication',
    'AppTemplateContainer',
    'AppTemplateContainerEnv',
    'AppTemplateContainerLivenessProbe',
    'AppTemplateContainerLivenessProbeHeader',
    'AppTemplateContainerReadinessProbe',
    'AppTemplateContainerReadinessProbeHeader',
    'AppTemplateContainerStartupProbe',
    'AppTemplateContainerStartupProbeHeader',
    'AppTemplateContainerVolumeMount',
    'AppTemplateCustomScaleRule',
    'AppTemplateCustomScaleRuleAuthentication',
    'AppTemplateHttpScaleRule',
    'AppTemplateHttpScaleRuleAuthentication',
    'AppTemplateInitContainer',
    'AppTemplateInitContainerEnv',
    'AppTemplateInitContainerVolumeMount',
    'AppTemplateTcpScaleRule',
    'AppTemplateTcpScaleRuleAuthentication',
    'AppTemplateVolume',
    'EnvironmentDaprComponentMetadata',
    'EnvironmentDaprComponentSecret',
    'EnvironmentIdentity',
    'EnvironmentWorkloadProfile',
    'JobEventTriggerConfig',
    'JobEventTriggerConfigScale',
    'JobEventTriggerConfigScaleRule',
    'JobEventTriggerConfigScaleRuleAuthentication',
    'JobIdentity',
    'JobManualTriggerConfig',
    'JobRegistry',
    'JobScheduleTriggerConfig',
    'JobSecret',
    'JobTemplate',
    'JobTemplateContainer',
    'JobTemplateContainerEnv',
    'JobTemplateContainerLivenessProbe',
    'JobTemplateContainerLivenessProbeHeader',
    'JobTemplateContainerReadinessProbe',
    'JobTemplateContainerReadinessProbeHeader',
    'JobTemplateContainerStartupProbe',
    'JobTemplateContainerStartupProbeHeader',
    'JobTemplateContainerVolumeMount',
    'JobTemplateInitContainer',
    'JobTemplateInitContainerEnv',
    'JobTemplateInitContainerVolumeMount',
    'JobTemplateVolume',
    'GetAppDaprResult',
    'GetAppIdentityResult',
    'GetAppIngressResult',
    'GetAppIngressCorResult',
    'GetAppIngressCustomDomainResult',
    'GetAppIngressIpSecurityRestrictionResult',
    'GetAppIngressTrafficWeightResult',
    'GetAppRegistryResult',
    'GetAppSecretResult',
    'GetAppTemplateResult',
    'GetAppTemplateAzureQueueScaleRuleResult',
    'GetAppTemplateAzureQueueScaleRuleAuthenticationResult',
    'GetAppTemplateContainerResult',
    'GetAppTemplateContainerEnvResult',
    'GetAppTemplateContainerLivenessProbeResult',
    'GetAppTemplateContainerLivenessProbeHeaderResult',
    'GetAppTemplateContainerReadinessProbeResult',
    'GetAppTemplateContainerReadinessProbeHeaderResult',
    'GetAppTemplateContainerStartupProbeResult',
    'GetAppTemplateContainerStartupProbeHeaderResult',
    'GetAppTemplateContainerVolumeMountResult',
    'GetAppTemplateCustomScaleRuleResult',
    'GetAppTemplateCustomScaleRuleAuthenticationResult',
    'GetAppTemplateHttpScaleRuleResult',
    'GetAppTemplateHttpScaleRuleAuthenticationResult',
    'GetAppTemplateInitContainerResult',
    'GetAppTemplateInitContainerEnvResult',
    'GetAppTemplateInitContainerVolumeMountResult',
    'GetAppTemplateTcpScaleRuleResult',
    'GetAppTemplateTcpScaleRuleAuthenticationResult',
    'GetAppTemplateVolumeResult',
]

@pulumi.output_type
class AppDapr(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appId":
            suggest = "app_id"
        elif key == "appPort":
            suggest = "app_port"
        elif key == "appProtocol":
            suggest = "app_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppDapr. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppDapr.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppDapr.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_id: _builtins.str,
                 app_port: Optional[_builtins.int] = None,
                 app_protocol: Optional[_builtins.str] = None):
        """
        :param _builtins.str app_id: The Dapr Application Identifier.
        :param _builtins.int app_port: The port which the application is listening on. This is the same as the `ingress` port.
        :param _builtins.str app_protocol: The protocol for the app. Possible values include `http` and `grpc`. Defaults to `http`.
        """
        pulumi.set(__self__, "app_id", app_id)
        if app_port is not None:
            pulumi.set(__self__, "app_port", app_port)
        if app_protocol is not None:
            pulumi.set(__self__, "app_protocol", app_protocol)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> _builtins.str:
        """
        The Dapr Application Identifier.
        """
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter(name="appPort")
    def app_port(self) -> Optional[_builtins.int]:
        """
        The port which the application is listening on. This is the same as the `ingress` port.
        """
        return pulumi.get(self, "app_port")

    @_builtins.property
    @pulumi.getter(name="appProtocol")
    def app_protocol(self) -> Optional[_builtins.str]:
        """
        The protocol for the app. Possible values include `http` and `grpc`. Defaults to `http`.
        """
        return pulumi.get(self, "app_protocol")


@pulumi.output_type
class AppIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The type of managed identity to assign. Possible values are `SystemAssigned`, `UserAssigned`, and `SystemAssigned, UserAssigned` (to enable both).
        :param Sequence[_builtins.str] identity_ids: A list of one or more Resource IDs for User Assigned Managed identities to assign. Required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of managed identity to assign. Possible values are `SystemAssigned`, `UserAssigned`, and `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of one or more Resource IDs for User Assigned Managed identities to assign. Required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class AppIngress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetPort":
            suggest = "target_port"
        elif key == "trafficWeights":
            suggest = "traffic_weights"
        elif key == "allowInsecureConnections":
            suggest = "allow_insecure_connections"
        elif key == "clientCertificateMode":
            suggest = "client_certificate_mode"
        elif key == "customDomains":
            suggest = "custom_domains"
        elif key == "exposedPort":
            suggest = "exposed_port"
        elif key == "externalEnabled":
            suggest = "external_enabled"
        elif key == "ipSecurityRestrictions":
            suggest = "ip_security_restrictions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppIngress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppIngress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppIngress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_port: _builtins.int,
                 traffic_weights: Sequence['outputs.AppIngressTrafficWeight'],
                 allow_insecure_connections: Optional[_builtins.bool] = None,
                 client_certificate_mode: Optional[_builtins.str] = None,
                 cors: Optional['outputs.AppIngressCors'] = None,
                 custom_domains: Optional[Sequence['outputs.AppIngressCustomDomain']] = None,
                 exposed_port: Optional[_builtins.int] = None,
                 external_enabled: Optional[_builtins.bool] = None,
                 fqdn: Optional[_builtins.str] = None,
                 ip_security_restrictions: Optional[Sequence['outputs.AppIngressIpSecurityRestriction']] = None,
                 transport: Optional[_builtins.str] = None):
        """
        :param _builtins.int target_port: The target port on the container for the Ingress traffic.
        :param Sequence['AppIngressTrafficWeightArgs'] traffic_weights: One or more `traffic_weight` blocks as detailed below.
        :param _builtins.bool allow_insecure_connections: Should this ingress allow insecure connections?
        :param _builtins.str client_certificate_mode: The client certificate mode for the Ingress. Possible values are `require`, `accept`, and `ignore`.
        :param 'AppIngressCorsArgs' cors: A `cors` block as defined below.
        :param Sequence['AppIngressCustomDomainArgs'] custom_domains: One or more `custom_domain` block as detailed below.
        :param _builtins.int exposed_port: The exposed port on the container for the Ingress traffic.
               
               > **Note:** `exposed_port` can only be specified when `transport` is set to `tcp`.
        :param _builtins.bool external_enabled: Are connections to this Ingress from outside the Container App Environment enabled? Defaults to `false`.
        :param _builtins.str fqdn: The FQDN of the ingress.
        :param Sequence['AppIngressIpSecurityRestrictionArgs'] ip_security_restrictions: One or more `ip_security_restriction` blocks for IP-filtering rules as defined below.
        :param _builtins.str transport: The transport method for the Ingress. Possible values are `auto`, `http`, `http2` and `tcp`. Defaults to `auto`.
               
               > **Note:** if `transport` is set to `tcp`, `exposed_port` and `target_port` should be set at the same time.
        """
        pulumi.set(__self__, "target_port", target_port)
        pulumi.set(__self__, "traffic_weights", traffic_weights)
        if allow_insecure_connections is not None:
            pulumi.set(__self__, "allow_insecure_connections", allow_insecure_connections)
        if client_certificate_mode is not None:
            pulumi.set(__self__, "client_certificate_mode", client_certificate_mode)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if custom_domains is not None:
            pulumi.set(__self__, "custom_domains", custom_domains)
        if exposed_port is not None:
            pulumi.set(__self__, "exposed_port", exposed_port)
        if external_enabled is not None:
            pulumi.set(__self__, "external_enabled", external_enabled)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if ip_security_restrictions is not None:
            pulumi.set(__self__, "ip_security_restrictions", ip_security_restrictions)
        if transport is not None:
            pulumi.set(__self__, "transport", transport)

    @_builtins.property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> _builtins.int:
        """
        The target port on the container for the Ingress traffic.
        """
        return pulumi.get(self, "target_port")

    @_builtins.property
    @pulumi.getter(name="trafficWeights")
    def traffic_weights(self) -> Sequence['outputs.AppIngressTrafficWeight']:
        """
        One or more `traffic_weight` blocks as detailed below.
        """
        return pulumi.get(self, "traffic_weights")

    @_builtins.property
    @pulumi.getter(name="allowInsecureConnections")
    def allow_insecure_connections(self) -> Optional[_builtins.bool]:
        """
        Should this ingress allow insecure connections?
        """
        return pulumi.get(self, "allow_insecure_connections")

    @_builtins.property
    @pulumi.getter(name="clientCertificateMode")
    def client_certificate_mode(self) -> Optional[_builtins.str]:
        """
        The client certificate mode for the Ingress. Possible values are `require`, `accept`, and `ignore`.
        """
        return pulumi.get(self, "client_certificate_mode")

    @_builtins.property
    @pulumi.getter
    def cors(self) -> Optional['outputs.AppIngressCors']:
        """
        A `cors` block as defined below.
        """
        return pulumi.get(self, "cors")

    @_builtins.property
    @pulumi.getter(name="customDomains")
    def custom_domains(self) -> Optional[Sequence['outputs.AppIngressCustomDomain']]:
        """
        One or more `custom_domain` block as detailed below.
        """
        return pulumi.get(self, "custom_domains")

    @_builtins.property
    @pulumi.getter(name="exposedPort")
    def exposed_port(self) -> Optional[_builtins.int]:
        """
        The exposed port on the container for the Ingress traffic.

        > **Note:** `exposed_port` can only be specified when `transport` is set to `tcp`.
        """
        return pulumi.get(self, "exposed_port")

    @_builtins.property
    @pulumi.getter(name="externalEnabled")
    def external_enabled(self) -> Optional[_builtins.bool]:
        """
        Are connections to this Ingress from outside the Container App Environment enabled? Defaults to `false`.
        """
        return pulumi.get(self, "external_enabled")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[_builtins.str]:
        """
        The FQDN of the ingress.
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter(name="ipSecurityRestrictions")
    def ip_security_restrictions(self) -> Optional[Sequence['outputs.AppIngressIpSecurityRestriction']]:
        """
        One or more `ip_security_restriction` blocks for IP-filtering rules as defined below.
        """
        return pulumi.get(self, "ip_security_restrictions")

    @_builtins.property
    @pulumi.getter
    def transport(self) -> Optional[_builtins.str]:
        """
        The transport method for the Ingress. Possible values are `auto`, `http`, `http2` and `tcp`. Defaults to `auto`.

        > **Note:** if `transport` is set to `tcp`, `exposed_port` and `target_port` should be set at the same time.
        """
        return pulumi.get(self, "transport")


@pulumi.output_type
class AppIngressCors(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "allowCredentialsEnabled":
            suggest = "allow_credentials_enabled"
        elif key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "exposedHeaders":
            suggest = "exposed_headers"
        elif key == "maxAgeInSeconds":
            suggest = "max_age_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppIngressCors. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppIngressCors.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppIngressCors.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_origins: Sequence[_builtins.str],
                 allow_credentials_enabled: Optional[_builtins.bool] = None,
                 allowed_headers: Optional[Sequence[_builtins.str]] = None,
                 allowed_methods: Optional[Sequence[_builtins.str]] = None,
                 exposed_headers: Optional[Sequence[_builtins.str]] = None,
                 max_age_in_seconds: Optional[_builtins.int] = None):
        """
        :param Sequence[_builtins.str] allowed_origins: Specifies the list of origins that are allowed to make cross-origin calls.
        :param _builtins.bool allow_credentials_enabled: Whether user credentials are allowed in the cross-origin request is enabled. Defaults to `false`.
        :param Sequence[_builtins.str] allowed_headers: Specifies the list of request headers that are permitted in the actual request.
        :param Sequence[_builtins.str] allowed_methods: Specifies the list of HTTP methods are allowed when accessing the resource in a cross-origin request.
        :param Sequence[_builtins.str] exposed_headers: Specifies the list of headers exposed to the browser in the response to a cross-origin request.
        :param _builtins.int max_age_in_seconds: Specifies the number of seconds that the browser can cache the results of a preflight request.
        """
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allow_credentials_enabled is not None:
            pulumi.set(__self__, "allow_credentials_enabled", allow_credentials_enabled)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if allowed_methods is not None:
            pulumi.set(__self__, "allowed_methods", allowed_methods)
        if exposed_headers is not None:
            pulumi.set(__self__, "exposed_headers", exposed_headers)
        if max_age_in_seconds is not None:
            pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[_builtins.str]:
        """
        Specifies the list of origins that are allowed to make cross-origin calls.
        """
        return pulumi.get(self, "allowed_origins")

    @_builtins.property
    @pulumi.getter(name="allowCredentialsEnabled")
    def allow_credentials_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether user credentials are allowed in the cross-origin request is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "allow_credentials_enabled")

    @_builtins.property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the list of request headers that are permitted in the actual request.
        """
        return pulumi.get(self, "allowed_headers")

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the list of HTTP methods are allowed when accessing the resource in a cross-origin request.
        """
        return pulumi.get(self, "allowed_methods")

    @_builtins.property
    @pulumi.getter(name="exposedHeaders")
    def exposed_headers(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the list of headers exposed to the browser in the response to a cross-origin request.
        """
        return pulumi.get(self, "exposed_headers")

    @_builtins.property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> Optional[_builtins.int]:
        """
        Specifies the number of seconds that the browser can cache the results of a preflight request.
        """
        return pulumi.get(self, "max_age_in_seconds")


@pulumi.output_type
class AppIngressCustomDomain(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateBindingType":
            suggest = "certificate_binding_type"
        elif key == "certificateId":
            suggest = "certificate_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppIngressCustomDomain. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppIngressCustomDomain.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppIngressCustomDomain.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_binding_type: Optional[_builtins.str] = None,
                 certificate_id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str certificate_binding_type: The Binding type.
        :param _builtins.str certificate_id: The ID of the Container App Environment Certificate.
        :param _builtins.str name: The name for this Container App. Changing this forces a new resource to be created.
        """
        if certificate_binding_type is not None:
            pulumi.set(__self__, "certificate_binding_type", certificate_binding_type)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="certificateBindingType")
    def certificate_binding_type(self) -> Optional[_builtins.str]:
        """
        The Binding type.
        """
        return pulumi.get(self, "certificate_binding_type")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Container App Environment Certificate.
        """
        return pulumi.get(self, "certificate_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name for this Container App. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class AppIngressIpSecurityRestriction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddressRange":
            suggest = "ip_address_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppIngressIpSecurityRestriction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppIngressIpSecurityRestriction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppIngressIpSecurityRestriction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: _builtins.str,
                 ip_address_range: _builtins.str,
                 name: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str action: The IP-filter action. `Allow` or `Deny`.
               
               > **Note:** The `action` types in an all `ip_security_restriction` blocks must be the same for the `ingress`, mixing `Allow` and `Deny` rules is not currently supported by the service.
        :param _builtins.str ip_address_range: The incoming IP address or range of IP addresses (in CIDR notation).
        :param _builtins.str name: Name for the IP restriction rule.
        :param _builtins.str description: Describe the IP restriction rule that is being sent to the container-app.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "ip_address_range", ip_address_range)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The IP-filter action. `Allow` or `Deny`.

        > **Note:** The `action` types in an all `ip_security_restriction` blocks must be the same for the `ingress`, mixing `Allow` and `Deny` rules is not currently supported by the service.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="ipAddressRange")
    def ip_address_range(self) -> _builtins.str:
        """
        The incoming IP address or range of IP addresses (in CIDR notation).
        """
        return pulumi.get(self, "ip_address_range")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name for the IP restriction rule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Describe the IP restriction rule that is being sent to the container-app.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class AppIngressTrafficWeight(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "latestRevision":
            suggest = "latest_revision"
        elif key == "revisionSuffix":
            suggest = "revision_suffix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppIngressTrafficWeight. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppIngressTrafficWeight.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppIngressTrafficWeight.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 percentage: _builtins.int,
                 label: Optional[_builtins.str] = None,
                 latest_revision: Optional[_builtins.bool] = None,
                 revision_suffix: Optional[_builtins.str] = None):
        """
        :param _builtins.int percentage: The percentage of traffic which should be sent this revision.
               
               > **Note:** The cumulative values for `weight` must equal 100 exactly and explicitly, no default weights are assumed.
        :param _builtins.str label: The label to apply to the revision as a name prefix for routing traffic.
        :param _builtins.bool latest_revision: This traffic Weight applies to the latest stable Container Revision. At most only one `traffic_weight` block can have the `latest_revision` set to `true`.
        :param _builtins.str revision_suffix: The suffix string to which this `traffic_weight` applies.
               
               > **Note:** If `latest_revision` is `false`, the `revision_suffix` shall be specified.
        """
        pulumi.set(__self__, "percentage", percentage)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if latest_revision is not None:
            pulumi.set(__self__, "latest_revision", latest_revision)
        if revision_suffix is not None:
            pulumi.set(__self__, "revision_suffix", revision_suffix)

    @_builtins.property
    @pulumi.getter
    def percentage(self) -> _builtins.int:
        """
        The percentage of traffic which should be sent this revision.

        > **Note:** The cumulative values for `weight` must equal 100 exactly and explicitly, no default weights are assumed.
        """
        return pulumi.get(self, "percentage")

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[_builtins.str]:
        """
        The label to apply to the revision as a name prefix for routing traffic.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="latestRevision")
    def latest_revision(self) -> Optional[_builtins.bool]:
        """
        This traffic Weight applies to the latest stable Container Revision. At most only one `traffic_weight` block can have the `latest_revision` set to `true`.
        """
        return pulumi.get(self, "latest_revision")

    @_builtins.property
    @pulumi.getter(name="revisionSuffix")
    def revision_suffix(self) -> Optional[_builtins.str]:
        """
        The suffix string to which this `traffic_weight` applies.

        > **Note:** If `latest_revision` is `false`, the `revision_suffix` shall be specified.
        """
        return pulumi.get(self, "revision_suffix")


@pulumi.output_type
class AppRegistry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordSecretName":
            suggest = "password_secret_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppRegistry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppRegistry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppRegistry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 server: _builtins.str,
                 identity: Optional[_builtins.str] = None,
                 password_secret_name: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.str server: The hostname for the Container Registry.
               
               The authentication details must also be supplied, `identity` and `username`/`password_secret_name` are mutually exclusive.
        :param _builtins.str identity: Resource ID for the User Assigned Managed identity to use when pulling from the Container Registry.
               
               > **Note:** The Resource ID must be of a User Assigned Managed identity defined in an `identity` block.
        :param _builtins.str password_secret_name: The name of the Secret Reference containing the password value for this user on the Container Registry, `username` must also be supplied.
        :param _builtins.str username: The username to use for this Container Registry, `password_secret_name` must also be supplied..
        """
        pulumi.set(__self__, "server", server)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if password_secret_name is not None:
            pulumi.set(__self__, "password_secret_name", password_secret_name)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.str:
        """
        The hostname for the Container Registry.

        The authentication details must also be supplied, `identity` and `username`/`password_secret_name` are mutually exclusive.
        """
        return pulumi.get(self, "server")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[_builtins.str]:
        """
        Resource ID for the User Assigned Managed identity to use when pulling from the Container Registry.

        > **Note:** The Resource ID must be of a User Assigned Managed identity defined in an `identity` block.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="passwordSecretName")
    def password_secret_name(self) -> Optional[_builtins.str]:
        """
        The name of the Secret Reference containing the password value for this user on the Container Registry, `username` must also be supplied.
        """
        return pulumi.get(self, "password_secret_name")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The username to use for this Container Registry, `password_secret_name` must also be supplied..
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class AppSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultSecretId":
            suggest = "key_vault_secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 identity: Optional[_builtins.str] = None,
                 key_vault_secret_id: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The secret name.
        :param _builtins.str identity: The identity to use for accessing the Key Vault secret reference. This can either be the Resource ID of a User Assigned Identity, or `System` for the System Assigned Identity.
               
               !> **Note:** `identity` must be used together with `key_vault_secret_id`
        :param _builtins.str key_vault_secret_id: The ID of a Key Vault secret. This can be a versioned or version-less ID.
               
               !> **Note:** When using `key_vault_secret_id`, `ignore_changes` should be used to ignore any changes to `value`.
        :param _builtins.str value: The value for this secret.
               
               !> **Note:** `value` will be ignored if `key_vault_secret_id` and `identity` are provided.
        """
        pulumi.set(__self__, "name", name)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_vault_secret_id is not None:
            pulumi.set(__self__, "key_vault_secret_id", key_vault_secret_id)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The secret name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[_builtins.str]:
        """
        The identity to use for accessing the Key Vault secret reference. This can either be the Resource ID of a User Assigned Identity, or `System` for the System Assigned Identity.

        !> **Note:** `identity` must be used together with `key_vault_secret_id`
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="keyVaultSecretId")
    def key_vault_secret_id(self) -> Optional[_builtins.str]:
        """
        The ID of a Key Vault secret. This can be a versioned or version-less ID.

        !> **Note:** When using `key_vault_secret_id`, `ignore_changes` should be used to ignore any changes to `value`.
        """
        return pulumi.get(self, "key_vault_secret_id")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value for this secret.

        !> **Note:** `value` will be ignored if `key_vault_secret_id` and `identity` are provided.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AppTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureQueueScaleRules":
            suggest = "azure_queue_scale_rules"
        elif key == "customScaleRules":
            suggest = "custom_scale_rules"
        elif key == "httpScaleRules":
            suggest = "http_scale_rules"
        elif key == "initContainers":
            suggest = "init_containers"
        elif key == "maxReplicas":
            suggest = "max_replicas"
        elif key == "minReplicas":
            suggest = "min_replicas"
        elif key == "revisionSuffix":
            suggest = "revision_suffix"
        elif key == "tcpScaleRules":
            suggest = "tcp_scale_rules"
        elif key == "terminationGracePeriodSeconds":
            suggest = "termination_grace_period_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 containers: Sequence['outputs.AppTemplateContainer'],
                 azure_queue_scale_rules: Optional[Sequence['outputs.AppTemplateAzureQueueScaleRule']] = None,
                 custom_scale_rules: Optional[Sequence['outputs.AppTemplateCustomScaleRule']] = None,
                 http_scale_rules: Optional[Sequence['outputs.AppTemplateHttpScaleRule']] = None,
                 init_containers: Optional[Sequence['outputs.AppTemplateInitContainer']] = None,
                 max_replicas: Optional[_builtins.int] = None,
                 min_replicas: Optional[_builtins.int] = None,
                 revision_suffix: Optional[_builtins.str] = None,
                 tcp_scale_rules: Optional[Sequence['outputs.AppTemplateTcpScaleRule']] = None,
                 termination_grace_period_seconds: Optional[_builtins.int] = None,
                 volumes: Optional[Sequence['outputs.AppTemplateVolume']] = None):
        """
        :param Sequence['AppTemplateContainerArgs'] containers: One or more `container` blocks as detailed below.
        :param Sequence['AppTemplateAzureQueueScaleRuleArgs'] azure_queue_scale_rules: One or more `azure_queue_scale_rule` blocks as defined below.
        :param Sequence['AppTemplateCustomScaleRuleArgs'] custom_scale_rules: One or more `custom_scale_rule` blocks as defined below.
        :param Sequence['AppTemplateHttpScaleRuleArgs'] http_scale_rules: One or more `http_scale_rule` blocks as defined below.
        :param Sequence['AppTemplateInitContainerArgs'] init_containers: The definition of an init container that is part of the group as documented in the `init_container` block below.
        :param _builtins.int max_replicas: The maximum number of replicas for this container.
        :param _builtins.int min_replicas: The minimum number of replicas for this container.
        :param _builtins.str revision_suffix: The suffix for the revision. This value must be unique for the lifetime of the Resource. If omitted the service will use a hash function to create one.
        :param Sequence['AppTemplateTcpScaleRuleArgs'] tcp_scale_rules: One or more `tcp_scale_rule` blocks as defined below.
        :param _builtins.int termination_grace_period_seconds: The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        :param Sequence['AppTemplateVolumeArgs'] volumes: A `volume` block as detailed below.
        """
        pulumi.set(__self__, "containers", containers)
        if azure_queue_scale_rules is not None:
            pulumi.set(__self__, "azure_queue_scale_rules", azure_queue_scale_rules)
        if custom_scale_rules is not None:
            pulumi.set(__self__, "custom_scale_rules", custom_scale_rules)
        if http_scale_rules is not None:
            pulumi.set(__self__, "http_scale_rules", http_scale_rules)
        if init_containers is not None:
            pulumi.set(__self__, "init_containers", init_containers)
        if max_replicas is not None:
            pulumi.set(__self__, "max_replicas", max_replicas)
        if min_replicas is not None:
            pulumi.set(__self__, "min_replicas", min_replicas)
        if revision_suffix is not None:
            pulumi.set(__self__, "revision_suffix", revision_suffix)
        if tcp_scale_rules is not None:
            pulumi.set(__self__, "tcp_scale_rules", tcp_scale_rules)
        if termination_grace_period_seconds is not None:
            pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.AppTemplateContainer']:
        """
        One or more `container` blocks as detailed below.
        """
        return pulumi.get(self, "containers")

    @_builtins.property
    @pulumi.getter(name="azureQueueScaleRules")
    def azure_queue_scale_rules(self) -> Optional[Sequence['outputs.AppTemplateAzureQueueScaleRule']]:
        """
        One or more `azure_queue_scale_rule` blocks as defined below.
        """
        return pulumi.get(self, "azure_queue_scale_rules")

    @_builtins.property
    @pulumi.getter(name="customScaleRules")
    def custom_scale_rules(self) -> Optional[Sequence['outputs.AppTemplateCustomScaleRule']]:
        """
        One or more `custom_scale_rule` blocks as defined below.
        """
        return pulumi.get(self, "custom_scale_rules")

    @_builtins.property
    @pulumi.getter(name="httpScaleRules")
    def http_scale_rules(self) -> Optional[Sequence['outputs.AppTemplateHttpScaleRule']]:
        """
        One or more `http_scale_rule` blocks as defined below.
        """
        return pulumi.get(self, "http_scale_rules")

    @_builtins.property
    @pulumi.getter(name="initContainers")
    def init_containers(self) -> Optional[Sequence['outputs.AppTemplateInitContainer']]:
        """
        The definition of an init container that is part of the group as documented in the `init_container` block below.
        """
        return pulumi.get(self, "init_containers")

    @_builtins.property
    @pulumi.getter(name="maxReplicas")
    def max_replicas(self) -> Optional[_builtins.int]:
        """
        The maximum number of replicas for this container.
        """
        return pulumi.get(self, "max_replicas")

    @_builtins.property
    @pulumi.getter(name="minReplicas")
    def min_replicas(self) -> Optional[_builtins.int]:
        """
        The minimum number of replicas for this container.
        """
        return pulumi.get(self, "min_replicas")

    @_builtins.property
    @pulumi.getter(name="revisionSuffix")
    def revision_suffix(self) -> Optional[_builtins.str]:
        """
        The suffix for the revision. This value must be unique for the lifetime of the Resource. If omitted the service will use a hash function to create one.
        """
        return pulumi.get(self, "revision_suffix")

    @_builtins.property
    @pulumi.getter(name="tcpScaleRules")
    def tcp_scale_rules(self) -> Optional[Sequence['outputs.AppTemplateTcpScaleRule']]:
        """
        One or more `tcp_scale_rule` blocks as defined below.
        """
        return pulumi.get(self, "tcp_scale_rules")

    @_builtins.property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> Optional[_builtins.int]:
        """
        The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.AppTemplateVolume']]:
        """
        A `volume` block as detailed below.
        """
        return pulumi.get(self, "volumes")


@pulumi.output_type
class AppTemplateAzureQueueScaleRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queueLength":
            suggest = "queue_length"
        elif key == "queueName":
            suggest = "queue_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppTemplateAzureQueueScaleRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppTemplateAzureQueueScaleRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppTemplateAzureQueueScaleRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentications: Sequence['outputs.AppTemplateAzureQueueScaleRuleAuthentication'],
                 name: _builtins.str,
                 queue_length: _builtins.int,
                 queue_name: _builtins.str):
        """
        :param Sequence['AppTemplateAzureQueueScaleRuleAuthenticationArgs'] authentications: One or more `authentication` blocks as defined below.
        :param _builtins.str name: The name of the Scaling Rule
        :param _builtins.int queue_length: The value of the length of the queue to trigger scaling actions.
        :param _builtins.str queue_name: The name of the Azure Queue
        """
        pulumi.set(__self__, "authentications", authentications)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "queue_length", queue_length)
        pulumi.set(__self__, "queue_name", queue_name)

    @_builtins.property
    @pulumi.getter
    def authentications(self) -> Sequence['outputs.AppTemplateAzureQueueScaleRuleAuthentication']:
        """
        One or more `authentication` blocks as defined below.
        """
        return pulumi.get(self, "authentications")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Scaling Rule
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="queueLength")
    def queue_length(self) -> _builtins.int:
        """
        The value of the length of the queue to trigger scaling actions.
        """
        return pulumi.get(self, "queue_length")

    @_builtins.property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> _builtins.str:
        """
        The name of the Azure Queue
        """
        return pulumi.get(self, "queue_name")


@pulumi.output_type
class AppTemplateAzureQueueScaleRuleAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretName":
            suggest = "secret_name"
        elif key == "triggerParameter":
            suggest = "trigger_parameter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppTemplateAzureQueueScaleRuleAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppTemplateAzureQueueScaleRuleAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppTemplateAzureQueueScaleRuleAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_name: _builtins.str,
                 trigger_parameter: _builtins.str):
        """
        :param _builtins.str secret_name: The name of the Container App Secret to use for this Scale Rule Authentication.
        :param _builtins.str trigger_parameter: The Trigger Parameter name to use the supply the value retrieved from the `secret_name`.
        """
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "trigger_parameter", trigger_parameter)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> _builtins.str:
        """
        The name of the Container App Secret to use for this Scale Rule Authentication.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter(name="triggerParameter")
    def trigger_parameter(self) -> _builtins.str:
        """
        The Trigger Parameter name to use the supply the value retrieved from the `secret_name`.
        """
        return pulumi.get(self, "trigger_parameter")


@pulumi.output_type
class AppTemplateContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ephemeralStorage":
            suggest = "ephemeral_storage"
        elif key == "livenessProbes":
            suggest = "liveness_probes"
        elif key == "readinessProbes":
            suggest = "readiness_probes"
        elif key == "startupProbes":
            suggest = "startup_probes"
        elif key == "volumeMounts":
            suggest = "volume_mounts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppTemplateContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppTemplateContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppTemplateContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu: _builtins.float,
                 image: _builtins.str,
                 memory: _builtins.str,
                 name: _builtins.str,
                 args: Optional[Sequence[_builtins.str]] = None,
                 commands: Optional[Sequence[_builtins.str]] = None,
                 envs: Optional[Sequence['outputs.AppTemplateContainerEnv']] = None,
                 ephemeral_storage: Optional[_builtins.str] = None,
                 liveness_probes: Optional[Sequence['outputs.AppTemplateContainerLivenessProbe']] = None,
                 readiness_probes: Optional[Sequence['outputs.AppTemplateContainerReadinessProbe']] = None,
                 startup_probes: Optional[Sequence['outputs.AppTemplateContainerStartupProbe']] = None,
                 volume_mounts: Optional[Sequence['outputs.AppTemplateContainerVolumeMount']] = None):
        """
        :param _builtins.float cpu: The amount of vCPU to allocate to the container. Possible values include `0.25`, `0.5`, `0.75`, `1.0`, `1.25`, `1.5`, `1.75`, and `2.0`. When there's a workload profile specified, there's no such constraint.
               
               > **Note:** `cpu` and `memory` must be specified in `0.25'/'0.5Gi` combination increments. e.g. `1.0` / `2.0` or `0.5` / `1.0`
        :param _builtins.str image: The image to use to create the container.
        :param _builtins.str memory: The amount of memory to allocate to the container. Possible values are `0.5Gi`, `1Gi`, `1.5Gi`, `2Gi`, `2.5Gi`, `3Gi`, `3.5Gi` and `4Gi`. When there's a workload profile specified, there's no such constraint.
               
               > **Note:** `cpu` and `memory` must be specified in `0.25'/'0.5Gi` combination increments. e.g. `1.25` / `2.5Gi` or `0.75` / `1.5Gi`
        :param _builtins.str name: The name of the container
        :param Sequence[_builtins.str] args: A list of extra arguments to pass to the container.
        :param Sequence[_builtins.str] commands: A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
        :param Sequence['AppTemplateContainerEnvArgs'] envs: One or more `env` blocks as detailed below.
        :param _builtins.str ephemeral_storage: The amount of ephemeral storage available to the Container App.
               
               > **Note:** `ephemeral_storage` is currently in preview and not configurable at this time.
        :param Sequence['AppTemplateContainerLivenessProbeArgs'] liveness_probes: A `liveness_probe` block as detailed below.
        :param Sequence['AppTemplateContainerReadinessProbeArgs'] readiness_probes: A `readiness_probe` block as detailed below.
        :param Sequence['AppTemplateContainerStartupProbeArgs'] startup_probes: A `startup_probe` block as detailed below.
        :param Sequence['AppTemplateContainerVolumeMountArgs'] volume_mounts: A `volume_mounts` block as detailed below.
        """
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "name", name)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if liveness_probes is not None:
            pulumi.set(__self__, "liveness_probes", liveness_probes)
        if readiness_probes is not None:
            pulumi.set(__self__, "readiness_probes", readiness_probes)
        if startup_probes is not None:
            pulumi.set(__self__, "startup_probes", startup_probes)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.float:
        """
        The amount of vCPU to allocate to the container. Possible values include `0.25`, `0.5`, `0.75`, `1.0`, `1.25`, `1.5`, `1.75`, and `2.0`. When there's a workload profile specified, there's no such constraint.

        > **Note:** `cpu` and `memory` must be specified in `0.25'/'0.5Gi` combination increments. e.g. `1.0` / `2.0` or `0.5` / `1.0`
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        The image to use to create the container.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> _builtins.str:
        """
        The amount of memory to allocate to the container. Possible values are `0.5Gi`, `1Gi`, `1.5Gi`, `2Gi`, `2.5Gi`, `3Gi`, `3.5Gi` and `4Gi`. When there's a workload profile specified, there's no such constraint.

        > **Note:** `cpu` and `memory` must be specified in `0.25'/'0.5Gi` combination increments. e.g. `1.25` / `2.5Gi` or `0.75` / `1.5Gi`
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the container
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of extra arguments to pass to the container.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[_builtins.str]]:
        """
        A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.AppTemplateContainerEnv']]:
        """
        One or more `env` blocks as detailed below.
        """
        return pulumi.get(self, "envs")

    @_builtins.property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[_builtins.str]:
        """
        The amount of ephemeral storage available to the Container App.

        > **Note:** `ephemeral_storage` is currently in preview and not configurable at this time.
        """
        return pulumi.get(self, "ephemeral_storage")

    @_builtins.property
    @pulumi.getter(name="livenessProbes")
    def liveness_probes(self) -> Optional[Sequence['outputs.AppTemplateContainerLivenessProbe']]:
        """
        A `liveness_probe` block as detailed below.
        """
        return pulumi.get(self, "liveness_probes")

    @_builtins.property
    @pulumi.getter(name="readinessProbes")
    def readiness_probes(self) -> Optional[Sequence['outputs.AppTemplateContainerReadinessProbe']]:
        """
        A `readiness_probe` block as detailed below.
        """
        return pulumi.get(self, "readiness_probes")

    @_builtins.property
    @pulumi.getter(name="startupProbes")
    def startup_probes(self) -> Optional[Sequence['outputs.AppTemplateContainerStartupProbe']]:
        """
        A `startup_probe` block as detailed below.
        """
        return pulumi.get(self, "startup_probes")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.AppTemplateContainerVolumeMount']]:
        """
        A `volume_mounts` block as detailed below.
        """
        return pulumi.get(self, "volume_mounts")


@pulumi.output_type
class AppTemplateContainerEnv(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretName":
            suggest = "secret_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppTemplateContainerEnv. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppTemplateContainerEnv.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppTemplateContainerEnv.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 secret_name: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the environment variable for the container.
        :param _builtins.str secret_name: The name of the secret that contains the value for this environment variable.
        :param _builtins.str value: The value for this environment variable.
               
               > **Note:** This value is ignored if `secret_name` is used
        """
        pulumi.set(__self__, "name", name)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the environment variable for the container.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[_builtins.str]:
        """
        The name of the secret that contains the value for this environment variable.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value for this environment variable.

        > **Note:** This value is ignored if `secret_name` is used
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AppTemplateContainerLivenessProbe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureCountThreshold":
            suggest = "failure_count_threshold"
        elif key == "initialDelay":
            suggest = "initial_delay"
        elif key == "intervalSeconds":
            suggest = "interval_seconds"
        elif key == "terminationGracePeriodSeconds":
            suggest = "termination_grace_period_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppTemplateContainerLivenessProbe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppTemplateContainerLivenessProbe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppTemplateContainerLivenessProbe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: _builtins.int,
                 transport: _builtins.str,
                 failure_count_threshold: Optional[_builtins.int] = None,
                 headers: Optional[Sequence['outputs.AppTemplateContainerLivenessProbeHeader']] = None,
                 host: Optional[_builtins.str] = None,
                 initial_delay: Optional[_builtins.int] = None,
                 interval_seconds: Optional[_builtins.int] = None,
                 path: Optional[_builtins.str] = None,
                 termination_grace_period_seconds: Optional[_builtins.int] = None,
                 timeout: Optional[_builtins.int] = None):
        """
        :param _builtins.int port: The port number on which to connect. Possible values are between `1` and `65535`.
        :param _builtins.str transport: Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        :param _builtins.int failure_count_threshold: The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `10`. Defaults to `3`.
        :param Sequence['AppTemplateContainerLivenessProbeHeaderArgs'] headers: A `header` block as detailed below.
        :param _builtins.str host: The probe hostname. Defaults to the pod IP address. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        :param _builtins.int initial_delay: The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `1` seconds.
        :param _builtins.int interval_seconds: How often, in seconds, the probe should run. Possible values are in the range `1` - `240`. Defaults to `10`.
        :param _builtins.str path: The URI to use with the `host` for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        :param _builtins.int termination_grace_period_seconds: The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        :param _builtins.int timeout: Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "transport", transport)
        if failure_count_threshold is not None:
            pulumi.set(__self__, "failure_count_threshold", failure_count_threshold)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if initial_delay is not None:
            pulumi.set(__self__, "initial_delay", initial_delay)
        if interval_seconds is not None:
            pulumi.set(__self__, "interval_seconds", interval_seconds)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if termination_grace_period_seconds is not None:
            pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port number on which to connect. Possible values are between `1` and `65535`.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def transport(self) -> _builtins.str:
        """
        Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        """
        return pulumi.get(self, "transport")

    @_builtins.property
    @pulumi.getter(name="failureCountThreshold")
    def failure_count_threshold(self) -> Optional[_builtins.int]:
        """
        The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `10`. Defaults to `3`.
        """
        return pulumi.get(self, "failure_count_threshold")

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.AppTemplateContainerLivenessProbeHeader']]:
        """
        A `header` block as detailed below.
        """
        return pulumi.get(self, "headers")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        The probe hostname. Defaults to the pod IP address. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="initialDelay")
    def initial_delay(self) -> Optional[_builtins.int]:
        """
        The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `1` seconds.
        """
        return pulumi.get(self, "initial_delay")

    @_builtins.property
    @pulumi.getter(name="intervalSeconds")
    def interval_seconds(self) -> Optional[_builtins.int]:
        """
        How often, in seconds, the probe should run. Possible values are in the range `1` - `240`. Defaults to `10`.
        """
        return pulumi.get(self, "interval_seconds")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        The URI to use with the `host` for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> Optional[_builtins.int]:
        """
        The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.int]:
        """
        Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class AppTemplateContainerLivenessProbeHeader(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The HTTP Header Name.
        :param _builtins.str value: The HTTP Header value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The HTTP Header Name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The HTTP Header value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AppTemplateContainerReadinessProbe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureCountThreshold":
            suggest = "failure_count_threshold"
        elif key == "initialDelay":
            suggest = "initial_delay"
        elif key == "intervalSeconds":
            suggest = "interval_seconds"
        elif key == "successCountThreshold":
            suggest = "success_count_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppTemplateContainerReadinessProbe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppTemplateContainerReadinessProbe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppTemplateContainerReadinessProbe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: _builtins.int,
                 transport: _builtins.str,
                 failure_count_threshold: Optional[_builtins.int] = None,
                 headers: Optional[Sequence['outputs.AppTemplateContainerReadinessProbeHeader']] = None,
                 host: Optional[_builtins.str] = None,
                 initial_delay: Optional[_builtins.int] = None,
                 interval_seconds: Optional[_builtins.int] = None,
                 path: Optional[_builtins.str] = None,
                 success_count_threshold: Optional[_builtins.int] = None,
                 timeout: Optional[_builtins.int] = None):
        """
        :param _builtins.int port: The port number on which to connect. Possible values are between `1` and `65535`.
        :param _builtins.str transport: Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        :param _builtins.int failure_count_threshold: The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `30`. Defaults to `3`.
        :param Sequence['AppTemplateContainerReadinessProbeHeaderArgs'] headers: A `header` block as detailed below.
        :param _builtins.str host: The probe hostname. Defaults to the pod IP address. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        :param _builtins.int initial_delay: The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
        :param _builtins.int interval_seconds: How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
        :param _builtins.str path: The URI to use for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        :param _builtins.int success_count_threshold: The number of consecutive successful responses required to consider this probe as successful. Possible values are between `1` and `10`. Defaults to `3`.
        :param _builtins.int timeout: Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "transport", transport)
        if failure_count_threshold is not None:
            pulumi.set(__self__, "failure_count_threshold", failure_count_threshold)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if initial_delay is not None:
            pulumi.set(__self__, "initial_delay", initial_delay)
        if interval_seconds is not None:
            pulumi.set(__self__, "interval_seconds", interval_seconds)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if success_count_threshold is not None:
            pulumi.set(__self__, "success_count_threshold", success_count_threshold)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port number on which to connect. Possible values are between `1` and `65535`.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def transport(self) -> _builtins.str:
        """
        Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        """
        return pulumi.get(self, "transport")

    @_builtins.property
    @pulumi.getter(name="failureCountThreshold")
    def failure_count_threshold(self) -> Optional[_builtins.int]:
        """
        The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `30`. Defaults to `3`.
        """
        return pulumi.get(self, "failure_count_threshold")

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.AppTemplateContainerReadinessProbeHeader']]:
        """
        A `header` block as detailed below.
        """
        return pulumi.get(self, "headers")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        The probe hostname. Defaults to the pod IP address. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="initialDelay")
    def initial_delay(self) -> Optional[_builtins.int]:
        """
        The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
        """
        return pulumi.get(self, "initial_delay")

    @_builtins.property
    @pulumi.getter(name="intervalSeconds")
    def interval_seconds(self) -> Optional[_builtins.int]:
        """
        How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
        """
        return pulumi.get(self, "interval_seconds")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        The URI to use for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="successCountThreshold")
    def success_count_threshold(self) -> Optional[_builtins.int]:
        """
        The number of consecutive successful responses required to consider this probe as successful. Possible values are between `1` and `10`. Defaults to `3`.
        """
        return pulumi.get(self, "success_count_threshold")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.int]:
        """
        Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class AppTemplateContainerReadinessProbeHeader(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The HTTP Header Name.
        :param _builtins.str value: The HTTP Header value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The HTTP Header Name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The HTTP Header value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AppTemplateContainerStartupProbe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureCountThreshold":
            suggest = "failure_count_threshold"
        elif key == "initialDelay":
            suggest = "initial_delay"
        elif key == "intervalSeconds":
            suggest = "interval_seconds"
        elif key == "terminationGracePeriodSeconds":
            suggest = "termination_grace_period_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppTemplateContainerStartupProbe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppTemplateContainerStartupProbe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppTemplateContainerStartupProbe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: _builtins.int,
                 transport: _builtins.str,
                 failure_count_threshold: Optional[_builtins.int] = None,
                 headers: Optional[Sequence['outputs.AppTemplateContainerStartupProbeHeader']] = None,
                 host: Optional[_builtins.str] = None,
                 initial_delay: Optional[_builtins.int] = None,
                 interval_seconds: Optional[_builtins.int] = None,
                 path: Optional[_builtins.str] = None,
                 termination_grace_period_seconds: Optional[_builtins.int] = None,
                 timeout: Optional[_builtins.int] = None):
        """
        :param _builtins.int port: The port number on which to connect. Possible values are between `1` and `65535`.
        :param _builtins.str transport: Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        :param _builtins.int failure_count_threshold: The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `30`. Defaults to `3`.
        :param Sequence['AppTemplateContainerStartupProbeHeaderArgs'] headers: A `header` block as detailed below.
        :param _builtins.str host: The value for the host header which should be sent with this probe. If unspecified, the IP Address of the Pod is used as the host header. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        :param _builtins.int initial_delay: The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
        :param _builtins.int interval_seconds: How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
        :param _builtins.str path: The URI to use with the `host` for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        :param _builtins.int termination_grace_period_seconds: The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        :param _builtins.int timeout: Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "transport", transport)
        if failure_count_threshold is not None:
            pulumi.set(__self__, "failure_count_threshold", failure_count_threshold)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if initial_delay is not None:
            pulumi.set(__self__, "initial_delay", initial_delay)
        if interval_seconds is not None:
            pulumi.set(__self__, "interval_seconds", interval_seconds)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if termination_grace_period_seconds is not None:
            pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port number on which to connect. Possible values are between `1` and `65535`.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def transport(self) -> _builtins.str:
        """
        Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        """
        return pulumi.get(self, "transport")

    @_builtins.property
    @pulumi.getter(name="failureCountThreshold")
    def failure_count_threshold(self) -> Optional[_builtins.int]:
        """
        The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `30`. Defaults to `3`.
        """
        return pulumi.get(self, "failure_count_threshold")

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.AppTemplateContainerStartupProbeHeader']]:
        """
        A `header` block as detailed below.
        """
        return pulumi.get(self, "headers")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        The value for the host header which should be sent with this probe. If unspecified, the IP Address of the Pod is used as the host header. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="initialDelay")
    def initial_delay(self) -> Optional[_builtins.int]:
        """
        The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
        """
        return pulumi.get(self, "initial_delay")

    @_builtins.property
    @pulumi.getter(name="intervalSeconds")
    def interval_seconds(self) -> Optional[_builtins.int]:
        """
        How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
        """
        return pulumi.get(self, "interval_seconds")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        The URI to use with the `host` for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> Optional[_builtins.int]:
        """
        The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.int]:
        """
        Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class AppTemplateContainerStartupProbeHeader(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The HTTP Header Name.
        :param _builtins.str value: The HTTP Header value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The HTTP Header Name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The HTTP Header value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AppTemplateContainerVolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subPath":
            suggest = "sub_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppTemplateContainerVolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppTemplateContainerVolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppTemplateContainerVolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 path: _builtins.str,
                 sub_path: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the Volume to be mounted in the container.
        :param _builtins.str path: The path in the container at which to mount this volume.
        :param _builtins.str sub_path: The sub path of the volume to be mounted in the container.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        if sub_path is not None:
            pulumi.set(__self__, "sub_path", sub_path)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Volume to be mounted in the container.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path in the container at which to mount this volume.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="subPath")
    def sub_path(self) -> Optional[_builtins.str]:
        """
        The sub path of the volume to be mounted in the container.
        """
        return pulumi.get(self, "sub_path")


@pulumi.output_type
class AppTemplateCustomScaleRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customRuleType":
            suggest = "custom_rule_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppTemplateCustomScaleRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppTemplateCustomScaleRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppTemplateCustomScaleRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_rule_type: _builtins.str,
                 metadata: Mapping[str, _builtins.str],
                 name: _builtins.str,
                 authentications: Optional[Sequence['outputs.AppTemplateCustomScaleRuleAuthentication']] = None):
        """
        :param _builtins.str custom_rule_type: The Custom rule type. Possible values include: `activemq`, `artemis-queue`, `kafka`, `pulsar`, `aws-cloudwatch`, `aws-dynamodb`, `aws-dynamodb-streams`, `aws-kinesis-stream`, `aws-sqs-queue`, `azure-app-insights`, `azure-blob`, `azure-data-explorer`, `azure-eventhub`, `azure-log-analytics`, `azure-monitor`, `azure-pipelines`, `azure-servicebus`, `azure-queue`, `cassandra`, `cpu`, `cron`, `datadog`, `elasticsearch`, `external`, `external-push`, `gcp-stackdriver`, `gcp-storage`, `gcp-pubsub`, `graphite`, `http`, `huawei-cloudeye`, `ibmmq`, `influxdb`, `kubernetes-workload`, `liiklus`, `memory`, `metrics-api`, `mongodb`, `mssql`, `mysql`, `nats-jetstream`, `stan`, `tcp`, `new-relic`, `openstack-metric`, `openstack-swift`, `postgresql`, `predictkube`, `prometheus`, `rabbitmq`, `redis`, `redis-cluster`, `redis-sentinel`, `redis-streams`, `redis-cluster-streams`, `redis-sentinel-streams`, `selenium-grid`,`solace-event-queue`, and `github-runner`.
        :param Mapping[str, _builtins.str] metadata: A map of string key-value pairs to configure the Custom Scale Rule.
        :param _builtins.str name: The name of the Scaling Rule
        :param Sequence['AppTemplateCustomScaleRuleAuthenticationArgs'] authentications: Zero or more `authentication` blocks as defined below.
        """
        pulumi.set(__self__, "custom_rule_type", custom_rule_type)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "name", name)
        if authentications is not None:
            pulumi.set(__self__, "authentications", authentications)

    @_builtins.property
    @pulumi.getter(name="customRuleType")
    def custom_rule_type(self) -> _builtins.str:
        """
        The Custom rule type. Possible values include: `activemq`, `artemis-queue`, `kafka`, `pulsar`, `aws-cloudwatch`, `aws-dynamodb`, `aws-dynamodb-streams`, `aws-kinesis-stream`, `aws-sqs-queue`, `azure-app-insights`, `azure-blob`, `azure-data-explorer`, `azure-eventhub`, `azure-log-analytics`, `azure-monitor`, `azure-pipelines`, `azure-servicebus`, `azure-queue`, `cassandra`, `cpu`, `cron`, `datadog`, `elasticsearch`, `external`, `external-push`, `gcp-stackdriver`, `gcp-storage`, `gcp-pubsub`, `graphite`, `http`, `huawei-cloudeye`, `ibmmq`, `influxdb`, `kubernetes-workload`, `liiklus`, `memory`, `metrics-api`, `mongodb`, `mssql`, `mysql`, `nats-jetstream`, `stan`, `tcp`, `new-relic`, `openstack-metric`, `openstack-swift`, `postgresql`, `predictkube`, `prometheus`, `rabbitmq`, `redis`, `redis-cluster`, `redis-sentinel`, `redis-streams`, `redis-cluster-streams`, `redis-sentinel-streams`, `selenium-grid`,`solace-event-queue`, and `github-runner`.
        """
        return pulumi.get(self, "custom_rule_type")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        """
        A map of string key-value pairs to configure the Custom Scale Rule.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Scaling Rule
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def authentications(self) -> Optional[Sequence['outputs.AppTemplateCustomScaleRuleAuthentication']]:
        """
        Zero or more `authentication` blocks as defined below.
        """
        return pulumi.get(self, "authentications")


@pulumi.output_type
class AppTemplateCustomScaleRuleAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretName":
            suggest = "secret_name"
        elif key == "triggerParameter":
            suggest = "trigger_parameter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppTemplateCustomScaleRuleAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppTemplateCustomScaleRuleAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppTemplateCustomScaleRuleAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_name: _builtins.str,
                 trigger_parameter: _builtins.str):
        """
        :param _builtins.str secret_name: The name of the Container App Secret to use for this Scale Rule Authentication.
        :param _builtins.str trigger_parameter: The Trigger Parameter name to use the supply the value retrieved from the `secret_name`.
        """
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "trigger_parameter", trigger_parameter)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> _builtins.str:
        """
        The name of the Container App Secret to use for this Scale Rule Authentication.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter(name="triggerParameter")
    def trigger_parameter(self) -> _builtins.str:
        """
        The Trigger Parameter name to use the supply the value retrieved from the `secret_name`.
        """
        return pulumi.get(self, "trigger_parameter")


@pulumi.output_type
class AppTemplateHttpScaleRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "concurrentRequests":
            suggest = "concurrent_requests"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppTemplateHttpScaleRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppTemplateHttpScaleRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppTemplateHttpScaleRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 concurrent_requests: _builtins.str,
                 name: _builtins.str,
                 authentications: Optional[Sequence['outputs.AppTemplateHttpScaleRuleAuthentication']] = None):
        """
        :param _builtins.str concurrent_requests: The number of concurrent requests to trigger scaling.
        :param _builtins.str name: The name of the Scaling Rule
        :param Sequence['AppTemplateHttpScaleRuleAuthenticationArgs'] authentications: Zero or more `authentication` blocks as defined below.
        """
        pulumi.set(__self__, "concurrent_requests", concurrent_requests)
        pulumi.set(__self__, "name", name)
        if authentications is not None:
            pulumi.set(__self__, "authentications", authentications)

    @_builtins.property
    @pulumi.getter(name="concurrentRequests")
    def concurrent_requests(self) -> _builtins.str:
        """
        The number of concurrent requests to trigger scaling.
        """
        return pulumi.get(self, "concurrent_requests")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Scaling Rule
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def authentications(self) -> Optional[Sequence['outputs.AppTemplateHttpScaleRuleAuthentication']]:
        """
        Zero or more `authentication` blocks as defined below.
        """
        return pulumi.get(self, "authentications")


@pulumi.output_type
class AppTemplateHttpScaleRuleAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretName":
            suggest = "secret_name"
        elif key == "triggerParameter":
            suggest = "trigger_parameter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppTemplateHttpScaleRuleAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppTemplateHttpScaleRuleAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppTemplateHttpScaleRuleAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_name: _builtins.str,
                 trigger_parameter: Optional[_builtins.str] = None):
        """
        :param _builtins.str secret_name: The name of the Container App Secret to use for this Scale Rule Authentication.
        :param _builtins.str trigger_parameter: The Trigger Parameter name to use the supply the value retrieved from the `secret_name`.
        """
        pulumi.set(__self__, "secret_name", secret_name)
        if trigger_parameter is not None:
            pulumi.set(__self__, "trigger_parameter", trigger_parameter)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> _builtins.str:
        """
        The name of the Container App Secret to use for this Scale Rule Authentication.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter(name="triggerParameter")
    def trigger_parameter(self) -> Optional[_builtins.str]:
        """
        The Trigger Parameter name to use the supply the value retrieved from the `secret_name`.
        """
        return pulumi.get(self, "trigger_parameter")


@pulumi.output_type
class AppTemplateInitContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ephemeralStorage":
            suggest = "ephemeral_storage"
        elif key == "volumeMounts":
            suggest = "volume_mounts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppTemplateInitContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppTemplateInitContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppTemplateInitContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: _builtins.str,
                 name: _builtins.str,
                 args: Optional[Sequence[_builtins.str]] = None,
                 commands: Optional[Sequence[_builtins.str]] = None,
                 cpu: Optional[_builtins.float] = None,
                 envs: Optional[Sequence['outputs.AppTemplateInitContainerEnv']] = None,
                 ephemeral_storage: Optional[_builtins.str] = None,
                 memory: Optional[_builtins.str] = None,
                 volume_mounts: Optional[Sequence['outputs.AppTemplateInitContainerVolumeMount']] = None):
        """
        :param _builtins.str image: The image to use to create the container.
        :param _builtins.str name: The name of the container
        :param Sequence[_builtins.str] args: A list of extra arguments to pass to the container.
        :param Sequence[_builtins.str] commands: A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
        :param _builtins.float cpu: The amount of vCPU to allocate to the container. Possible values include `0.25`, `0.5`, `0.75`, `1.0`, `1.25`, `1.5`, `1.75`, and `2.0`. When there's a workload profile specified, there's no such constraint.
               
               > **Note:** `cpu` and `memory` must be specified in `0.25'/'0.5Gi` combination increments. e.g. `1.0` / `2.0` or `0.5` / `1.0`
        :param Sequence['AppTemplateInitContainerEnvArgs'] envs: One or more `env` blocks as detailed below.
        :param _builtins.str ephemeral_storage: The amount of ephemeral storage available to the Container App.
               
               > **Note:** `ephemeral_storage` is currently in preview and not configurable at this time.
        :param _builtins.str memory: The amount of memory to allocate to the container. Possible values are `0.5Gi`, `1Gi`, `1.5Gi`, `2Gi`, `2.5Gi`, `3Gi`, `3.5Gi` and `4Gi`. When there's a workload profile specified, there's no such constraint.
               
               > **Note:** `cpu` and `memory` must be specified in `0.25'/'0.5Gi` combination increments. e.g. `1.25` / `2.5Gi` or `0.75` / `1.5Gi`
        :param Sequence['AppTemplateInitContainerVolumeMountArgs'] volume_mounts: A `volume_mounts` block as detailed below.
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "name", name)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        The image to use to create the container.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the container
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of extra arguments to pass to the container.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[_builtins.str]]:
        """
        A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[_builtins.float]:
        """
        The amount of vCPU to allocate to the container. Possible values include `0.25`, `0.5`, `0.75`, `1.0`, `1.25`, `1.5`, `1.75`, and `2.0`. When there's a workload profile specified, there's no such constraint.

        > **Note:** `cpu` and `memory` must be specified in `0.25'/'0.5Gi` combination increments. e.g. `1.0` / `2.0` or `0.5` / `1.0`
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.AppTemplateInitContainerEnv']]:
        """
        One or more `env` blocks as detailed below.
        """
        return pulumi.get(self, "envs")

    @_builtins.property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[_builtins.str]:
        """
        The amount of ephemeral storage available to the Container App.

        > **Note:** `ephemeral_storage` is currently in preview and not configurable at this time.
        """
        return pulumi.get(self, "ephemeral_storage")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[_builtins.str]:
        """
        The amount of memory to allocate to the container. Possible values are `0.5Gi`, `1Gi`, `1.5Gi`, `2Gi`, `2.5Gi`, `3Gi`, `3.5Gi` and `4Gi`. When there's a workload profile specified, there's no such constraint.

        > **Note:** `cpu` and `memory` must be specified in `0.25'/'0.5Gi` combination increments. e.g. `1.25` / `2.5Gi` or `0.75` / `1.5Gi`
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.AppTemplateInitContainerVolumeMount']]:
        """
        A `volume_mounts` block as detailed below.
        """
        return pulumi.get(self, "volume_mounts")


@pulumi.output_type
class AppTemplateInitContainerEnv(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretName":
            suggest = "secret_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppTemplateInitContainerEnv. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppTemplateInitContainerEnv.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppTemplateInitContainerEnv.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 secret_name: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the environment variable for the container.
        :param _builtins.str secret_name: The name of the secret that contains the value for this environment variable.
        :param _builtins.str value: The value for this environment variable.
               
               > **Note:** This value is ignored if `secret_name` is used
        """
        pulumi.set(__self__, "name", name)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the environment variable for the container.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[_builtins.str]:
        """
        The name of the secret that contains the value for this environment variable.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value for this environment variable.

        > **Note:** This value is ignored if `secret_name` is used
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AppTemplateInitContainerVolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subPath":
            suggest = "sub_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppTemplateInitContainerVolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppTemplateInitContainerVolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppTemplateInitContainerVolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 path: _builtins.str,
                 sub_path: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the Volume to be mounted in the container.
        :param _builtins.str path: The path in the container at which to mount this volume.
        :param _builtins.str sub_path: The sub path of the volume to be mounted in the container.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        if sub_path is not None:
            pulumi.set(__self__, "sub_path", sub_path)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Volume to be mounted in the container.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path in the container at which to mount this volume.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="subPath")
    def sub_path(self) -> Optional[_builtins.str]:
        """
        The sub path of the volume to be mounted in the container.
        """
        return pulumi.get(self, "sub_path")


@pulumi.output_type
class AppTemplateTcpScaleRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "concurrentRequests":
            suggest = "concurrent_requests"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppTemplateTcpScaleRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppTemplateTcpScaleRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppTemplateTcpScaleRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 concurrent_requests: _builtins.str,
                 name: _builtins.str,
                 authentications: Optional[Sequence['outputs.AppTemplateTcpScaleRuleAuthentication']] = None):
        """
        :param _builtins.str concurrent_requests: The number of concurrent requests to trigger scaling.
        :param _builtins.str name: The name of the Scaling Rule
        :param Sequence['AppTemplateTcpScaleRuleAuthenticationArgs'] authentications: Zero or more `authentication` blocks as defined below.
        """
        pulumi.set(__self__, "concurrent_requests", concurrent_requests)
        pulumi.set(__self__, "name", name)
        if authentications is not None:
            pulumi.set(__self__, "authentications", authentications)

    @_builtins.property
    @pulumi.getter(name="concurrentRequests")
    def concurrent_requests(self) -> _builtins.str:
        """
        The number of concurrent requests to trigger scaling.
        """
        return pulumi.get(self, "concurrent_requests")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Scaling Rule
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def authentications(self) -> Optional[Sequence['outputs.AppTemplateTcpScaleRuleAuthentication']]:
        """
        Zero or more `authentication` blocks as defined below.
        """
        return pulumi.get(self, "authentications")


@pulumi.output_type
class AppTemplateTcpScaleRuleAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretName":
            suggest = "secret_name"
        elif key == "triggerParameter":
            suggest = "trigger_parameter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppTemplateTcpScaleRuleAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppTemplateTcpScaleRuleAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppTemplateTcpScaleRuleAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_name: _builtins.str,
                 trigger_parameter: Optional[_builtins.str] = None):
        """
        :param _builtins.str secret_name: The name of the Container App Secret to use for this Scale Rule Authentication.
        :param _builtins.str trigger_parameter: The Trigger Parameter name to use the supply the value retrieved from the `secret_name`.
        """
        pulumi.set(__self__, "secret_name", secret_name)
        if trigger_parameter is not None:
            pulumi.set(__self__, "trigger_parameter", trigger_parameter)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> _builtins.str:
        """
        The name of the Container App Secret to use for this Scale Rule Authentication.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter(name="triggerParameter")
    def trigger_parameter(self) -> Optional[_builtins.str]:
        """
        The Trigger Parameter name to use the supply the value retrieved from the `secret_name`.
        """
        return pulumi.get(self, "trigger_parameter")


@pulumi.output_type
class AppTemplateVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountOptions":
            suggest = "mount_options"
        elif key == "storageName":
            suggest = "storage_name"
        elif key == "storageType":
            suggest = "storage_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppTemplateVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppTemplateVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppTemplateVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 mount_options: Optional[_builtins.str] = None,
                 storage_name: Optional[_builtins.str] = None,
                 storage_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the volume.
        :param _builtins.str mount_options: Mount options used while mounting the AzureFile. Must be a comma-separated string e.g. `dir_mode=0751,file_mode=0751`.
        :param _builtins.str storage_name: The name of the `AzureFile` storage.
        :param _builtins.str storage_type: The type of storage volume. Possible values are `AzureFile`, `EmptyDir` and `Secret`. Defaults to `EmptyDir`.
        """
        pulumi.set(__self__, "name", name)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if storage_name is not None:
            pulumi.set(__self__, "storage_name", storage_name)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the volume.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[_builtins.str]:
        """
        Mount options used while mounting the AzureFile. Must be a comma-separated string e.g. `dir_mode=0751,file_mode=0751`.
        """
        return pulumi.get(self, "mount_options")

    @_builtins.property
    @pulumi.getter(name="storageName")
    def storage_name(self) -> Optional[_builtins.str]:
        """
        The name of the `AzureFile` storage.
        """
        return pulumi.get(self, "storage_name")

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[_builtins.str]:
        """
        The type of storage volume. Possible values are `AzureFile`, `EmptyDir` and `Secret`. Defaults to `EmptyDir`.
        """
        return pulumi.get(self, "storage_type")


@pulumi.output_type
class EnvironmentDaprComponentMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretName":
            suggest = "secret_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentDaprComponentMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentDaprComponentMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentDaprComponentMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 secret_name: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the Metadata configuration item.
        :param _builtins.str secret_name: The name of a secret specified in the `secrets` block that contains the value for this metadata configuration item.
        :param _builtins.str value: The value for this metadata configuration item.
        """
        pulumi.set(__self__, "name", name)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Metadata configuration item.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[_builtins.str]:
        """
        The name of a secret specified in the `secrets` block that contains the value for this metadata configuration item.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value for this metadata configuration item.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EnvironmentDaprComponentSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultSecretId":
            suggest = "key_vault_secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentDaprComponentSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentDaprComponentSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentDaprComponentSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 identity: Optional[_builtins.str] = None,
                 key_vault_secret_id: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The Secret name.
        :param _builtins.str identity: The identity to use for accessing key vault reference.
        :param _builtins.str key_vault_secret_id: The Key Vault Secret ID. Could be either one of `id` or `versionless_id`.
        :param _builtins.str value: The value for this secret.
        """
        pulumi.set(__self__, "name", name)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_vault_secret_id is not None:
            pulumi.set(__self__, "key_vault_secret_id", key_vault_secret_id)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The Secret name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[_builtins.str]:
        """
        The identity to use for accessing key vault reference.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="keyVaultSecretId")
    def key_vault_secret_id(self) -> Optional[_builtins.str]:
        """
        The Key Vault Secret ID. Could be either one of `id` or `versionless_id`.
        """
        return pulumi.get(self, "key_vault_secret_id")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value for this secret.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EnvironmentIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The type of managed identity to assign. Possible values are `SystemAssigned`, `UserAssigned`, and `SystemAssigned, UserAssigned` (to enable both).
        :param Sequence[_builtins.str] identity_ids: A list of one or more Resource IDs for User Assigned Managed identities to assign. Required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of managed identity to assign. Possible values are `SystemAssigned`, `UserAssigned`, and `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of one or more Resource IDs for User Assigned Managed identities to assign. Required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class EnvironmentWorkloadProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "workloadProfileType":
            suggest = "workload_profile_type"
        elif key == "maximumCount":
            suggest = "maximum_count"
        elif key == "minimumCount":
            suggest = "minimum_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentWorkloadProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentWorkloadProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentWorkloadProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 workload_profile_type: _builtins.str,
                 maximum_count: Optional[_builtins.int] = None,
                 minimum_count: Optional[_builtins.int] = None):
        """
        :param _builtins.str name: The name of the workload profile.
        :param _builtins.str workload_profile_type: Workload profile type for the workloads to run on. Possible values include `Consumption`, `D4`, `D8`, `D16`, `D32`, `E4`, `E8`, `E16` and `E32`.
               
               > **Note:** A `Consumption` type must have a name of `Consumption` and an environment may only have one `Consumption` Workload Profile.
               
               > **Note:** Defining a `Consumption` profile is optional, however, Environments created without an initial Workload Profile cannot have them added at a later time and must be recreated. Similarly, an environment created with Profiles must always have at least one defined Profile, removing all profiles will force a recreation of the resource.
        :param _builtins.int maximum_count: The maximum number of instances of workload profile that can be deployed in the Container App Environment.
        :param _builtins.int minimum_count: The minimum number of instances of workload profile that can be deployed in the Container App Environment.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "workload_profile_type", workload_profile_type)
        if maximum_count is not None:
            pulumi.set(__self__, "maximum_count", maximum_count)
        if minimum_count is not None:
            pulumi.set(__self__, "minimum_count", minimum_count)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the workload profile.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="workloadProfileType")
    def workload_profile_type(self) -> _builtins.str:
        """
        Workload profile type for the workloads to run on. Possible values include `Consumption`, `D4`, `D8`, `D16`, `D32`, `E4`, `E8`, `E16` and `E32`.

        > **Note:** A `Consumption` type must have a name of `Consumption` and an environment may only have one `Consumption` Workload Profile.

        > **Note:** Defining a `Consumption` profile is optional, however, Environments created without an initial Workload Profile cannot have them added at a later time and must be recreated. Similarly, an environment created with Profiles must always have at least one defined Profile, removing all profiles will force a recreation of the resource.
        """
        return pulumi.get(self, "workload_profile_type")

    @_builtins.property
    @pulumi.getter(name="maximumCount")
    def maximum_count(self) -> Optional[_builtins.int]:
        """
        The maximum number of instances of workload profile that can be deployed in the Container App Environment.
        """
        return pulumi.get(self, "maximum_count")

    @_builtins.property
    @pulumi.getter(name="minimumCount")
    def minimum_count(self) -> Optional[_builtins.int]:
        """
        The minimum number of instances of workload profile that can be deployed in the Container App Environment.
        """
        return pulumi.get(self, "minimum_count")


@pulumi.output_type
class JobEventTriggerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicaCompletionCount":
            suggest = "replica_completion_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobEventTriggerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobEventTriggerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobEventTriggerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parallelism: Optional[_builtins.int] = None,
                 replica_completion_count: Optional[_builtins.int] = None,
                 scales: Optional[Sequence['outputs.JobEventTriggerConfigScale']] = None):
        """
        :param _builtins.int parallelism: Number of parallel replicas of a job that can run at a given time.
        :param _builtins.int replica_completion_count: Minimum number of successful replica completions before overall job completion.
        :param Sequence['JobEventTriggerConfigScaleArgs'] scales: A `scale` block as defined below.
        """
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)
        if replica_completion_count is not None:
            pulumi.set(__self__, "replica_completion_count", replica_completion_count)
        if scales is not None:
            pulumi.set(__self__, "scales", scales)

    @_builtins.property
    @pulumi.getter
    def parallelism(self) -> Optional[_builtins.int]:
        """
        Number of parallel replicas of a job that can run at a given time.
        """
        return pulumi.get(self, "parallelism")

    @_builtins.property
    @pulumi.getter(name="replicaCompletionCount")
    def replica_completion_count(self) -> Optional[_builtins.int]:
        """
        Minimum number of successful replica completions before overall job completion.
        """
        return pulumi.get(self, "replica_completion_count")

    @_builtins.property
    @pulumi.getter
    def scales(self) -> Optional[Sequence['outputs.JobEventTriggerConfigScale']]:
        """
        A `scale` block as defined below.
        """
        return pulumi.get(self, "scales")


@pulumi.output_type
class JobEventTriggerConfigScale(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxExecutions":
            suggest = "max_executions"
        elif key == "minExecutions":
            suggest = "min_executions"
        elif key == "pollingIntervalInSeconds":
            suggest = "polling_interval_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobEventTriggerConfigScale. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobEventTriggerConfigScale.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobEventTriggerConfigScale.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_executions: Optional[_builtins.int] = None,
                 min_executions: Optional[_builtins.int] = None,
                 polling_interval_in_seconds: Optional[_builtins.int] = None,
                 rules: Optional[Sequence['outputs.JobEventTriggerConfigScaleRule']] = None):
        """
        :param _builtins.int max_executions: Maximum number of job executions that are created for a trigger.
        :param _builtins.int min_executions: Minimum number of job executions that are created for a trigger.
        :param _builtins.int polling_interval_in_seconds: Interval to check each event source in seconds.
        :param Sequence['JobEventTriggerConfigScaleRuleArgs'] rules: A `rules` block as defined below.
        """
        if max_executions is not None:
            pulumi.set(__self__, "max_executions", max_executions)
        if min_executions is not None:
            pulumi.set(__self__, "min_executions", min_executions)
        if polling_interval_in_seconds is not None:
            pulumi.set(__self__, "polling_interval_in_seconds", polling_interval_in_seconds)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter(name="maxExecutions")
    def max_executions(self) -> Optional[_builtins.int]:
        """
        Maximum number of job executions that are created for a trigger.
        """
        return pulumi.get(self, "max_executions")

    @_builtins.property
    @pulumi.getter(name="minExecutions")
    def min_executions(self) -> Optional[_builtins.int]:
        """
        Minimum number of job executions that are created for a trigger.
        """
        return pulumi.get(self, "min_executions")

    @_builtins.property
    @pulumi.getter(name="pollingIntervalInSeconds")
    def polling_interval_in_seconds(self) -> Optional[_builtins.int]:
        """
        Interval to check each event source in seconds.
        """
        return pulumi.get(self, "polling_interval_in_seconds")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.JobEventTriggerConfigScaleRule']]:
        """
        A `rules` block as defined below.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class JobEventTriggerConfigScaleRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customRuleType":
            suggest = "custom_rule_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobEventTriggerConfigScaleRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobEventTriggerConfigScaleRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobEventTriggerConfigScaleRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_rule_type: _builtins.str,
                 metadata: Mapping[str, _builtins.str],
                 name: _builtins.str,
                 authentications: Optional[Sequence['outputs.JobEventTriggerConfigScaleRuleAuthentication']] = None):
        """
        :param _builtins.str custom_rule_type: Type of the scale rule.
        :param Mapping[str, _builtins.str] metadata: Metadata properties to describe the scale rule.
        :param _builtins.str name: Name of the scale rule.
        :param Sequence['JobEventTriggerConfigScaleRuleAuthenticationArgs'] authentications: A `authentication` block as defined below.
        """
        pulumi.set(__self__, "custom_rule_type", custom_rule_type)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "name", name)
        if authentications is not None:
            pulumi.set(__self__, "authentications", authentications)

    @_builtins.property
    @pulumi.getter(name="customRuleType")
    def custom_rule_type(self) -> _builtins.str:
        """
        Type of the scale rule.
        """
        return pulumi.get(self, "custom_rule_type")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        """
        Metadata properties to describe the scale rule.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the scale rule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def authentications(self) -> Optional[Sequence['outputs.JobEventTriggerConfigScaleRuleAuthentication']]:
        """
        A `authentication` block as defined below.
        """
        return pulumi.get(self, "authentications")


@pulumi.output_type
class JobEventTriggerConfigScaleRuleAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretName":
            suggest = "secret_name"
        elif key == "triggerParameter":
            suggest = "trigger_parameter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobEventTriggerConfigScaleRuleAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobEventTriggerConfigScaleRuleAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobEventTriggerConfigScaleRuleAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_name: _builtins.str,
                 trigger_parameter: _builtins.str):
        """
        :param _builtins.str secret_name: Name of the secret from which to pull the auth params.
        :param _builtins.str trigger_parameter: Trigger Parameter that uses the secret.
        """
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "trigger_parameter", trigger_parameter)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> _builtins.str:
        """
        Name of the secret from which to pull the auth params.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter(name="triggerParameter")
    def trigger_parameter(self) -> _builtins.str:
        """
        Trigger Parameter that uses the secret.
        """
        return pulumi.get(self, "trigger_parameter")


@pulumi.output_type
class JobIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The type of identity used for the Container App Job. Possible values are `SystemAssigned`, `UserAssigned` and `None`. Defaults to `None`.
        :param Sequence[_builtins.str] identity_ids: A list of Managed Identity IDs to assign to the Container App Job.
        :param _builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param _builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of identity used for the Container App Job. Possible values are `SystemAssigned`, `UserAssigned` and `None`. Defaults to `None`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of Managed Identity IDs to assign to the Container App Job.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class JobManualTriggerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicaCompletionCount":
            suggest = "replica_completion_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobManualTriggerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobManualTriggerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobManualTriggerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parallelism: Optional[_builtins.int] = None,
                 replica_completion_count: Optional[_builtins.int] = None):
        """
        :param _builtins.int parallelism: Number of parallel replicas of a job that can run at a given time.
        :param _builtins.int replica_completion_count: Minimum number of successful replica completions before overall job completion.
        """
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)
        if replica_completion_count is not None:
            pulumi.set(__self__, "replica_completion_count", replica_completion_count)

    @_builtins.property
    @pulumi.getter
    def parallelism(self) -> Optional[_builtins.int]:
        """
        Number of parallel replicas of a job that can run at a given time.
        """
        return pulumi.get(self, "parallelism")

    @_builtins.property
    @pulumi.getter(name="replicaCompletionCount")
    def replica_completion_count(self) -> Optional[_builtins.int]:
        """
        Minimum number of successful replica completions before overall job completion.
        """
        return pulumi.get(self, "replica_completion_count")


@pulumi.output_type
class JobRegistry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordSecretName":
            suggest = "password_secret_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobRegistry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobRegistry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobRegistry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 server: _builtins.str,
                 identity: Optional[_builtins.str] = None,
                 password_secret_name: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.str server: The URL of the Azure Container Registry server.
        :param _builtins.str identity: A Managed Identity to use to authenticate with Azure Container Registry.
        :param _builtins.str password_secret_name: The name of the Secret that contains the registry login password.
        :param _builtins.str username: The username to use to authenticate with Azure Container Registry.
        """
        pulumi.set(__self__, "server", server)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if password_secret_name is not None:
            pulumi.set(__self__, "password_secret_name", password_secret_name)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.str:
        """
        The URL of the Azure Container Registry server.
        """
        return pulumi.get(self, "server")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[_builtins.str]:
        """
        A Managed Identity to use to authenticate with Azure Container Registry.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="passwordSecretName")
    def password_secret_name(self) -> Optional[_builtins.str]:
        """
        The name of the Secret that contains the registry login password.
        """
        return pulumi.get(self, "password_secret_name")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The username to use to authenticate with Azure Container Registry.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class JobScheduleTriggerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cronExpression":
            suggest = "cron_expression"
        elif key == "replicaCompletionCount":
            suggest = "replica_completion_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobScheduleTriggerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobScheduleTriggerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobScheduleTriggerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cron_expression: _builtins.str,
                 parallelism: Optional[_builtins.int] = None,
                 replica_completion_count: Optional[_builtins.int] = None):
        """
        :param _builtins.str cron_expression: Cron formatted repeating schedule of a Cron Job.
        :param _builtins.int parallelism: Number of parallel replicas of a job that can run at a given time.
        :param _builtins.int replica_completion_count: Minimum number of successful replica completions before overall job completion.
        """
        pulumi.set(__self__, "cron_expression", cron_expression)
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)
        if replica_completion_count is not None:
            pulumi.set(__self__, "replica_completion_count", replica_completion_count)

    @_builtins.property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> _builtins.str:
        """
        Cron formatted repeating schedule of a Cron Job.
        """
        return pulumi.get(self, "cron_expression")

    @_builtins.property
    @pulumi.getter
    def parallelism(self) -> Optional[_builtins.int]:
        """
        Number of parallel replicas of a job that can run at a given time.
        """
        return pulumi.get(self, "parallelism")

    @_builtins.property
    @pulumi.getter(name="replicaCompletionCount")
    def replica_completion_count(self) -> Optional[_builtins.int]:
        """
        Minimum number of successful replica completions before overall job completion.
        """
        return pulumi.get(self, "replica_completion_count")


@pulumi.output_type
class JobSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultSecretId":
            suggest = "key_vault_secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 identity: Optional[_builtins.str] = None,
                 key_vault_secret_id: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The secret name.
        :param _builtins.str identity: The identity to use for accessing the Key Vault secret reference. This can either be the Resource ID of a User Assigned Identity, or `System` for the System Assigned Identity.
               
               !> **Note:** `identity` must be used together with `key_vault_secret_id`
        :param _builtins.str key_vault_secret_id: The ID of a Key Vault secret. This can be a versioned or version-less ID.
               
               !> **Note:** When using `key_vault_secret_id`, `ignore_changes` should be used to ignore any changes to `value`.
        :param _builtins.str value: The value for this secret.
               
               !> **Note:** `value` will be ignored if `key_vault_secret_id` and `identity` are provided.
        """
        pulumi.set(__self__, "name", name)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_vault_secret_id is not None:
            pulumi.set(__self__, "key_vault_secret_id", key_vault_secret_id)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The secret name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[_builtins.str]:
        """
        The identity to use for accessing the Key Vault secret reference. This can either be the Resource ID of a User Assigned Identity, or `System` for the System Assigned Identity.

        !> **Note:** `identity` must be used together with `key_vault_secret_id`
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="keyVaultSecretId")
    def key_vault_secret_id(self) -> Optional[_builtins.str]:
        """
        The ID of a Key Vault secret. This can be a versioned or version-less ID.

        !> **Note:** When using `key_vault_secret_id`, `ignore_changes` should be used to ignore any changes to `value`.
        """
        return pulumi.get(self, "key_vault_secret_id")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value for this secret.

        !> **Note:** `value` will be ignored if `key_vault_secret_id` and `identity` are provided.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class JobTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "initContainers":
            suggest = "init_containers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 containers: Sequence['outputs.JobTemplateContainer'],
                 init_containers: Optional[Sequence['outputs.JobTemplateInitContainer']] = None,
                 volumes: Optional[Sequence['outputs.JobTemplateVolume']] = None):
        """
        :param Sequence['JobTemplateContainerArgs'] containers: A `container` block as defined below.
        :param Sequence['JobTemplateInitContainerArgs'] init_containers: A `init_container` block as defined below.
        :param Sequence['JobTemplateVolumeArgs'] volumes: A `volume` block as defined below.
        """
        pulumi.set(__self__, "containers", containers)
        if init_containers is not None:
            pulumi.set(__self__, "init_containers", init_containers)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.JobTemplateContainer']:
        """
        A `container` block as defined below.
        """
        return pulumi.get(self, "containers")

    @_builtins.property
    @pulumi.getter(name="initContainers")
    def init_containers(self) -> Optional[Sequence['outputs.JobTemplateInitContainer']]:
        """
        A `init_container` block as defined below.
        """
        return pulumi.get(self, "init_containers")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.JobTemplateVolume']]:
        """
        A `volume` block as defined below.
        """
        return pulumi.get(self, "volumes")


@pulumi.output_type
class JobTemplateContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ephemeralStorage":
            suggest = "ephemeral_storage"
        elif key == "livenessProbes":
            suggest = "liveness_probes"
        elif key == "readinessProbes":
            suggest = "readiness_probes"
        elif key == "startupProbes":
            suggest = "startup_probes"
        elif key == "volumeMounts":
            suggest = "volume_mounts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu: _builtins.float,
                 image: _builtins.str,
                 memory: _builtins.str,
                 name: _builtins.str,
                 args: Optional[Sequence[_builtins.str]] = None,
                 commands: Optional[Sequence[_builtins.str]] = None,
                 envs: Optional[Sequence['outputs.JobTemplateContainerEnv']] = None,
                 ephemeral_storage: Optional[_builtins.str] = None,
                 liveness_probes: Optional[Sequence['outputs.JobTemplateContainerLivenessProbe']] = None,
                 readiness_probes: Optional[Sequence['outputs.JobTemplateContainerReadinessProbe']] = None,
                 startup_probes: Optional[Sequence['outputs.JobTemplateContainerStartupProbe']] = None,
                 volume_mounts: Optional[Sequence['outputs.JobTemplateContainerVolumeMount']] = None):
        """
        :param _builtins.float cpu: The amount of vCPU to allocate to the container. Possible values include `0.25`, `0.5`, `0.75`, `1.0`, `1.25`, `1.5`, `1.75`, and `2.0`.
               
               > **Note:** `cpu` and `memory` must be specified in `0.25'/'0.5Gi` combination increments. e.g. `1.0` / `2.0` or `0.5` / `1.0`
        :param _builtins.str image: The image to use to create the container.
        :param _builtins.str memory: The amount of memory to allocate to the container. Possible values are `0.5Gi`, `1Gi`, `1.5Gi`, `2Gi`, `2.5Gi`, `3Gi`, `3.5Gi` and `4Gi`.
               
               > **Note:** `cpu` and `memory` must be specified in `0.25'/'0.5Gi` combination increments. e.g. `1.25` / `2.5Gi` or `0.75` / `1.5Gi`
        :param _builtins.str name: The name of the container.
        :param Sequence[_builtins.str] args: A list of extra arguments to pass to the container.
        :param Sequence[_builtins.str] commands: A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
        :param Sequence['JobTemplateContainerEnvArgs'] envs: One or more `env` blocks as detailed below.
        :param _builtins.str ephemeral_storage: The amount of ephemeral storage available to the Container App.
               
               > **Note:** `ephemeral_storage` is currently in preview and not configurable at this time.
        :param Sequence['JobTemplateContainerLivenessProbeArgs'] liveness_probes: A `liveness_probe` block as detailed below.
        :param Sequence['JobTemplateContainerReadinessProbeArgs'] readiness_probes: A `readiness_probe` block as detailed below.
        :param Sequence['JobTemplateContainerStartupProbeArgs'] startup_probes: A `startup_probe` block as detailed below.
        :param Sequence['JobTemplateContainerVolumeMountArgs'] volume_mounts: A `volume_mounts` block as detailed below.
        """
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "name", name)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if liveness_probes is not None:
            pulumi.set(__self__, "liveness_probes", liveness_probes)
        if readiness_probes is not None:
            pulumi.set(__self__, "readiness_probes", readiness_probes)
        if startup_probes is not None:
            pulumi.set(__self__, "startup_probes", startup_probes)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.float:
        """
        The amount of vCPU to allocate to the container. Possible values include `0.25`, `0.5`, `0.75`, `1.0`, `1.25`, `1.5`, `1.75`, and `2.0`.

        > **Note:** `cpu` and `memory` must be specified in `0.25'/'0.5Gi` combination increments. e.g. `1.0` / `2.0` or `0.5` / `1.0`
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        The image to use to create the container.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> _builtins.str:
        """
        The amount of memory to allocate to the container. Possible values are `0.5Gi`, `1Gi`, `1.5Gi`, `2Gi`, `2.5Gi`, `3Gi`, `3.5Gi` and `4Gi`.

        > **Note:** `cpu` and `memory` must be specified in `0.25'/'0.5Gi` combination increments. e.g. `1.25` / `2.5Gi` or `0.75` / `1.5Gi`
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the container.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of extra arguments to pass to the container.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[_builtins.str]]:
        """
        A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.JobTemplateContainerEnv']]:
        """
        One or more `env` blocks as detailed below.
        """
        return pulumi.get(self, "envs")

    @_builtins.property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[_builtins.str]:
        """
        The amount of ephemeral storage available to the Container App.

        > **Note:** `ephemeral_storage` is currently in preview and not configurable at this time.
        """
        return pulumi.get(self, "ephemeral_storage")

    @_builtins.property
    @pulumi.getter(name="livenessProbes")
    def liveness_probes(self) -> Optional[Sequence['outputs.JobTemplateContainerLivenessProbe']]:
        """
        A `liveness_probe` block as detailed below.
        """
        return pulumi.get(self, "liveness_probes")

    @_builtins.property
    @pulumi.getter(name="readinessProbes")
    def readiness_probes(self) -> Optional[Sequence['outputs.JobTemplateContainerReadinessProbe']]:
        """
        A `readiness_probe` block as detailed below.
        """
        return pulumi.get(self, "readiness_probes")

    @_builtins.property
    @pulumi.getter(name="startupProbes")
    def startup_probes(self) -> Optional[Sequence['outputs.JobTemplateContainerStartupProbe']]:
        """
        A `startup_probe` block as detailed below.
        """
        return pulumi.get(self, "startup_probes")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.JobTemplateContainerVolumeMount']]:
        """
        A `volume_mounts` block as detailed below.
        """
        return pulumi.get(self, "volume_mounts")


@pulumi.output_type
class JobTemplateContainerEnv(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretName":
            suggest = "secret_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateContainerEnv. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateContainerEnv.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateContainerEnv.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 secret_name: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the environment variable.
        :param _builtins.str secret_name: Name of the Container App secret from which to pull the environment variable value.
        :param _builtins.str value: The value of the environment variable.
        """
        pulumi.set(__self__, "name", name)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[_builtins.str]:
        """
        Name of the Container App secret from which to pull the environment variable value.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class JobTemplateContainerLivenessProbe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureCountThreshold":
            suggest = "failure_count_threshold"
        elif key == "initialDelay":
            suggest = "initial_delay"
        elif key == "intervalSeconds":
            suggest = "interval_seconds"
        elif key == "terminationGracePeriodSeconds":
            suggest = "termination_grace_period_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateContainerLivenessProbe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateContainerLivenessProbe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateContainerLivenessProbe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: _builtins.int,
                 transport: _builtins.str,
                 failure_count_threshold: Optional[_builtins.int] = None,
                 headers: Optional[Sequence['outputs.JobTemplateContainerLivenessProbeHeader']] = None,
                 host: Optional[_builtins.str] = None,
                 initial_delay: Optional[_builtins.int] = None,
                 interval_seconds: Optional[_builtins.int] = None,
                 path: Optional[_builtins.str] = None,
                 termination_grace_period_seconds: Optional[_builtins.int] = None,
                 timeout: Optional[_builtins.int] = None):
        """
        :param _builtins.int port: The port number on which to connect. Possible values are between `1` and `65535`.
        :param _builtins.str transport: Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        :param _builtins.int failure_count_threshold: The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `10`. Defaults to `3`.
        :param Sequence['JobTemplateContainerLivenessProbeHeaderArgs'] headers: A `header` block as detailed below.
        :param _builtins.str host: The probe hostname. Defaults to the pod IP address. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        :param _builtins.int initial_delay: The time in seconds to wait after the container has started before the probe is started.
        :param _builtins.int interval_seconds: How often, in seconds, the probe should run. Possible values are in the range `1` - `240`. Defaults to `10`.
        :param _builtins.str path: The URI to use with the `host` for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        :param _builtins.int termination_grace_period_seconds: The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        :param _builtins.int timeout: Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "transport", transport)
        if failure_count_threshold is not None:
            pulumi.set(__self__, "failure_count_threshold", failure_count_threshold)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if initial_delay is not None:
            pulumi.set(__self__, "initial_delay", initial_delay)
        if interval_seconds is not None:
            pulumi.set(__self__, "interval_seconds", interval_seconds)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if termination_grace_period_seconds is not None:
            pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port number on which to connect. Possible values are between `1` and `65535`.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def transport(self) -> _builtins.str:
        """
        Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        """
        return pulumi.get(self, "transport")

    @_builtins.property
    @pulumi.getter(name="failureCountThreshold")
    def failure_count_threshold(self) -> Optional[_builtins.int]:
        """
        The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `10`. Defaults to `3`.
        """
        return pulumi.get(self, "failure_count_threshold")

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.JobTemplateContainerLivenessProbeHeader']]:
        """
        A `header` block as detailed below.
        """
        return pulumi.get(self, "headers")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        The probe hostname. Defaults to the pod IP address. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="initialDelay")
    def initial_delay(self) -> Optional[_builtins.int]:
        """
        The time in seconds to wait after the container has started before the probe is started.
        """
        return pulumi.get(self, "initial_delay")

    @_builtins.property
    @pulumi.getter(name="intervalSeconds")
    def interval_seconds(self) -> Optional[_builtins.int]:
        """
        How often, in seconds, the probe should run. Possible values are in the range `1` - `240`. Defaults to `10`.
        """
        return pulumi.get(self, "interval_seconds")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        The URI to use with the `host` for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> Optional[_builtins.int]:
        """
        The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.int]:
        """
        Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class JobTemplateContainerLivenessProbeHeader(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The HTTP Header Name.
        :param _builtins.str value: The HTTP Header value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The HTTP Header Name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The HTTP Header value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class JobTemplateContainerReadinessProbe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureCountThreshold":
            suggest = "failure_count_threshold"
        elif key == "initialDelay":
            suggest = "initial_delay"
        elif key == "intervalSeconds":
            suggest = "interval_seconds"
        elif key == "successCountThreshold":
            suggest = "success_count_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateContainerReadinessProbe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateContainerReadinessProbe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateContainerReadinessProbe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: _builtins.int,
                 transport: _builtins.str,
                 failure_count_threshold: Optional[_builtins.int] = None,
                 headers: Optional[Sequence['outputs.JobTemplateContainerReadinessProbeHeader']] = None,
                 host: Optional[_builtins.str] = None,
                 initial_delay: Optional[_builtins.int] = None,
                 interval_seconds: Optional[_builtins.int] = None,
                 path: Optional[_builtins.str] = None,
                 success_count_threshold: Optional[_builtins.int] = None,
                 timeout: Optional[_builtins.int] = None):
        """
        :param _builtins.int port: The port number on which to connect. Possible values are between `1` and `65535`.
        :param _builtins.str transport: Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        :param _builtins.int failure_count_threshold: The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `10`. Defaults to `3`.
        :param Sequence['JobTemplateContainerReadinessProbeHeaderArgs'] headers: A `header` block as detailed below.
        :param _builtins.str host: The probe hostname. Defaults to the pod IP address. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        :param _builtins.int initial_delay: The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
        :param _builtins.int interval_seconds: How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
        :param _builtins.str path: The URI to use for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        :param _builtins.int success_count_threshold: The number of consecutive successful responses required to consider this probe as successful. Possible values are between `1` and `10`. Defaults to `3`.
        :param _builtins.int timeout: Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "transport", transport)
        if failure_count_threshold is not None:
            pulumi.set(__self__, "failure_count_threshold", failure_count_threshold)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if initial_delay is not None:
            pulumi.set(__self__, "initial_delay", initial_delay)
        if interval_seconds is not None:
            pulumi.set(__self__, "interval_seconds", interval_seconds)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if success_count_threshold is not None:
            pulumi.set(__self__, "success_count_threshold", success_count_threshold)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port number on which to connect. Possible values are between `1` and `65535`.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def transport(self) -> _builtins.str:
        """
        Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        """
        return pulumi.get(self, "transport")

    @_builtins.property
    @pulumi.getter(name="failureCountThreshold")
    def failure_count_threshold(self) -> Optional[_builtins.int]:
        """
        The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `10`. Defaults to `3`.
        """
        return pulumi.get(self, "failure_count_threshold")

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.JobTemplateContainerReadinessProbeHeader']]:
        """
        A `header` block as detailed below.
        """
        return pulumi.get(self, "headers")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        The probe hostname. Defaults to the pod IP address. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="initialDelay")
    def initial_delay(self) -> Optional[_builtins.int]:
        """
        The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
        """
        return pulumi.get(self, "initial_delay")

    @_builtins.property
    @pulumi.getter(name="intervalSeconds")
    def interval_seconds(self) -> Optional[_builtins.int]:
        """
        How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
        """
        return pulumi.get(self, "interval_seconds")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        The URI to use for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="successCountThreshold")
    def success_count_threshold(self) -> Optional[_builtins.int]:
        """
        The number of consecutive successful responses required to consider this probe as successful. Possible values are between `1` and `10`. Defaults to `3`.
        """
        return pulumi.get(self, "success_count_threshold")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.int]:
        """
        Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class JobTemplateContainerReadinessProbeHeader(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The HTTP Header Name.
        :param _builtins.str value: The HTTP Header value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The HTTP Header Name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The HTTP Header value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class JobTemplateContainerStartupProbe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureCountThreshold":
            suggest = "failure_count_threshold"
        elif key == "initialDelay":
            suggest = "initial_delay"
        elif key == "intervalSeconds":
            suggest = "interval_seconds"
        elif key == "terminationGracePeriodSeconds":
            suggest = "termination_grace_period_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateContainerStartupProbe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateContainerStartupProbe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateContainerStartupProbe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: _builtins.int,
                 transport: _builtins.str,
                 failure_count_threshold: Optional[_builtins.int] = None,
                 headers: Optional[Sequence['outputs.JobTemplateContainerStartupProbeHeader']] = None,
                 host: Optional[_builtins.str] = None,
                 initial_delay: Optional[_builtins.int] = None,
                 interval_seconds: Optional[_builtins.int] = None,
                 path: Optional[_builtins.str] = None,
                 termination_grace_period_seconds: Optional[_builtins.int] = None,
                 timeout: Optional[_builtins.int] = None):
        """
        :param _builtins.int port: The port number on which to connect. Possible values are between `1` and `65535`.
        :param _builtins.str transport: Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        :param _builtins.int failure_count_threshold: The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `10`. Defaults to `3`.
        :param Sequence['JobTemplateContainerStartupProbeHeaderArgs'] headers: A `header` block as detailed below.
        :param _builtins.str host: The value for the host header which should be sent with this probe. If unspecified, the IP Address of the Pod is used as the host header. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        :param _builtins.int initial_delay: The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
        :param _builtins.int interval_seconds: How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
        :param _builtins.str path: The URI to use with the `host` for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        :param _builtins.int termination_grace_period_seconds: The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        :param _builtins.int timeout: Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "transport", transport)
        if failure_count_threshold is not None:
            pulumi.set(__self__, "failure_count_threshold", failure_count_threshold)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if initial_delay is not None:
            pulumi.set(__self__, "initial_delay", initial_delay)
        if interval_seconds is not None:
            pulumi.set(__self__, "interval_seconds", interval_seconds)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if termination_grace_period_seconds is not None:
            pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port number on which to connect. Possible values are between `1` and `65535`.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def transport(self) -> _builtins.str:
        """
        Type of probe. Possible values are `TCP`, `HTTP`, and `HTTPS`.
        """
        return pulumi.get(self, "transport")

    @_builtins.property
    @pulumi.getter(name="failureCountThreshold")
    def failure_count_threshold(self) -> Optional[_builtins.int]:
        """
        The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `10`. Defaults to `3`.
        """
        return pulumi.get(self, "failure_count_threshold")

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.JobTemplateContainerStartupProbeHeader']]:
        """
        A `header` block as detailed below.
        """
        return pulumi.get(self, "headers")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        The value for the host header which should be sent with this probe. If unspecified, the IP Address of the Pod is used as the host header. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="initialDelay")
    def initial_delay(self) -> Optional[_builtins.int]:
        """
        The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
        """
        return pulumi.get(self, "initial_delay")

    @_builtins.property
    @pulumi.getter(name="intervalSeconds")
    def interval_seconds(self) -> Optional[_builtins.int]:
        """
        How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
        """
        return pulumi.get(self, "interval_seconds")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        The URI to use with the `host` for http type probes. Not valid for `TCP` type probes. Defaults to `/`.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> Optional[_builtins.int]:
        """
        The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.int]:
        """
        Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class JobTemplateContainerStartupProbeHeader(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The HTTP Header Name.
        :param _builtins.str value: The HTTP Header value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The HTTP Header Name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The HTTP Header value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class JobTemplateContainerVolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subPath":
            suggest = "sub_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateContainerVolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateContainerVolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateContainerVolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 path: _builtins.str,
                 sub_path: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the volume to mount. This must match the name of a volume defined in the `volume` block.
        :param _builtins.str path: The path within the container at which the volume should be mounted. Must not contain `:`.
        :param _builtins.str sub_path: The sub path of the volume to be mounted in the container.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        if sub_path is not None:
            pulumi.set(__self__, "sub_path", sub_path)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the volume to mount. This must match the name of a volume defined in the `volume` block.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path within the container at which the volume should be mounted. Must not contain `:`.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="subPath")
    def sub_path(self) -> Optional[_builtins.str]:
        """
        The sub path of the volume to be mounted in the container.
        """
        return pulumi.get(self, "sub_path")


@pulumi.output_type
class JobTemplateInitContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ephemeralStorage":
            suggest = "ephemeral_storage"
        elif key == "volumeMounts":
            suggest = "volume_mounts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateInitContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateInitContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateInitContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: _builtins.str,
                 name: _builtins.str,
                 args: Optional[Sequence[_builtins.str]] = None,
                 commands: Optional[Sequence[_builtins.str]] = None,
                 cpu: Optional[_builtins.float] = None,
                 envs: Optional[Sequence['outputs.JobTemplateInitContainerEnv']] = None,
                 ephemeral_storage: Optional[_builtins.str] = None,
                 memory: Optional[_builtins.str] = None,
                 volume_mounts: Optional[Sequence['outputs.JobTemplateInitContainerVolumeMount']] = None):
        """
        :param _builtins.str image: The image to use to create the container.
        :param _builtins.str name: The name of the container.
        :param Sequence[_builtins.str] args: A list of extra arguments to pass to the container.
        :param Sequence[_builtins.str] commands: A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
        :param _builtins.float cpu: The amount of vCPU to allocate to the container. Possible values include `0.25`, `0.5`, `0.75`, `1.0`, `1.25`, `1.5`, `1.75`, and `2.0`.
               
               > **Note:** `cpu` and `memory` must be specified in `0.25'/'0.5Gi` combination increments. e.g. `1.0` / `2.0` or `0.5` / `1.0`
        :param Sequence['JobTemplateInitContainerEnvArgs'] envs: One or more `env` blocks as detailed below.
        :param _builtins.str ephemeral_storage: The amount of ephemeral storage available to the Container App.
               
               > **Note:** `ephemeral_storage` is currently in preview and not configurable at this time.
        :param _builtins.str memory: The amount of memory to allocate to the container. Possible values are `0.5Gi`, `1Gi`, `1.5Gi`, `2Gi`, `2.5Gi`, `3Gi`, `3.5Gi` and `4Gi`.
               
               > **Note:** `cpu` and `memory` must be specified in `0.25'/'0.5Gi` combination increments. e.g. `1.25` / `2.5Gi` or `0.75` / `1.5Gi`
        :param Sequence['JobTemplateInitContainerVolumeMountArgs'] volume_mounts: A `volume_mounts` block as detailed below.
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "name", name)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        The image to use to create the container.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the container.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of extra arguments to pass to the container.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[_builtins.str]]:
        """
        A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[_builtins.float]:
        """
        The amount of vCPU to allocate to the container. Possible values include `0.25`, `0.5`, `0.75`, `1.0`, `1.25`, `1.5`, `1.75`, and `2.0`.

        > **Note:** `cpu` and `memory` must be specified in `0.25'/'0.5Gi` combination increments. e.g. `1.0` / `2.0` or `0.5` / `1.0`
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.JobTemplateInitContainerEnv']]:
        """
        One or more `env` blocks as detailed below.
        """
        return pulumi.get(self, "envs")

    @_builtins.property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[_builtins.str]:
        """
        The amount of ephemeral storage available to the Container App.

        > **Note:** `ephemeral_storage` is currently in preview and not configurable at this time.
        """
        return pulumi.get(self, "ephemeral_storage")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[_builtins.str]:
        """
        The amount of memory to allocate to the container. Possible values are `0.5Gi`, `1Gi`, `1.5Gi`, `2Gi`, `2.5Gi`, `3Gi`, `3.5Gi` and `4Gi`.

        > **Note:** `cpu` and `memory` must be specified in `0.25'/'0.5Gi` combination increments. e.g. `1.25` / `2.5Gi` or `0.75` / `1.5Gi`
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.JobTemplateInitContainerVolumeMount']]:
        """
        A `volume_mounts` block as detailed below.
        """
        return pulumi.get(self, "volume_mounts")


@pulumi.output_type
class JobTemplateInitContainerEnv(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretName":
            suggest = "secret_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateInitContainerEnv. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateInitContainerEnv.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateInitContainerEnv.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 secret_name: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the environment variable.
        :param _builtins.str secret_name: Name of the Container App secret from which to pull the environment variable value.
        :param _builtins.str value: The value of the environment variable.
        """
        pulumi.set(__self__, "name", name)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[_builtins.str]:
        """
        Name of the Container App secret from which to pull the environment variable value.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class JobTemplateInitContainerVolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subPath":
            suggest = "sub_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateInitContainerVolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateInitContainerVolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateInitContainerVolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 path: _builtins.str,
                 sub_path: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the volume to mount. This must match the name of a volume defined in the `volume` block.
        :param _builtins.str path: The path within the container at which the volume should be mounted. Must not contain `:`.
        :param _builtins.str sub_path: The sub path of the volume to be mounted in the container.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        if sub_path is not None:
            pulumi.set(__self__, "sub_path", sub_path)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the volume to mount. This must match the name of a volume defined in the `volume` block.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path within the container at which the volume should be mounted. Must not contain `:`.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="subPath")
    def sub_path(self) -> Optional[_builtins.str]:
        """
        The sub path of the volume to be mounted in the container.
        """
        return pulumi.get(self, "sub_path")


@pulumi.output_type
class JobTemplateVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountOptions":
            suggest = "mount_options"
        elif key == "storageName":
            suggest = "storage_name"
        elif key == "storageType":
            suggest = "storage_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 mount_options: Optional[_builtins.str] = None,
                 storage_name: Optional[_builtins.str] = None,
                 storage_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the volume.
        :param _builtins.str mount_options: Mount options used while mounting the AzureFile. Must be a comma-separated string e.g. `dir_mode=0751,file_mode=0751`.
        :param _builtins.str storage_name: The name of the storage to use for the volume.
        :param _builtins.str storage_type: The type of storage to use for the volume. Possible values are `AzureFile`, `EmptyDir` and `Secret`.
        """
        pulumi.set(__self__, "name", name)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if storage_name is not None:
            pulumi.set(__self__, "storage_name", storage_name)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the volume.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[_builtins.str]:
        """
        Mount options used while mounting the AzureFile. Must be a comma-separated string e.g. `dir_mode=0751,file_mode=0751`.
        """
        return pulumi.get(self, "mount_options")

    @_builtins.property
    @pulumi.getter(name="storageName")
    def storage_name(self) -> Optional[_builtins.str]:
        """
        The name of the storage to use for the volume.
        """
        return pulumi.get(self, "storage_name")

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[_builtins.str]:
        """
        The type of storage to use for the volume. Possible values are `AzureFile`, `EmptyDir` and `Secret`.
        """
        return pulumi.get(self, "storage_type")


@pulumi.output_type
class GetAppDaprResult(dict):
    def __init__(__self__, *,
                 app_id: _builtins.str,
                 app_port: _builtins.int,
                 app_protocol: _builtins.str):
        """
        :param _builtins.str app_id: The Dapr Application Identifier.
        :param _builtins.int app_port: The port which the application is listening on. This is the same as the `ingress` port.
        :param _builtins.str app_protocol: The protocol for the app. Possible values include `http` and `grpc`. Defaults to `http`.
        """
        pulumi.set(__self__, "app_id", app_id)
        pulumi.set(__self__, "app_port", app_port)
        pulumi.set(__self__, "app_protocol", app_protocol)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> _builtins.str:
        """
        The Dapr Application Identifier.
        """
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter(name="appPort")
    def app_port(self) -> _builtins.int:
        """
        The port which the application is listening on. This is the same as the `ingress` port.
        """
        return pulumi.get(self, "app_port")

    @_builtins.property
    @pulumi.getter(name="appProtocol")
    def app_protocol(self) -> _builtins.str:
        """
        The protocol for the app. Possible values include `http` and `grpc`. Defaults to `http`.
        """
        return pulumi.get(self, "app_protocol")


@pulumi.output_type
class GetAppIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[_builtins.str],
                 principal_id: _builtins.str,
                 tenant_id: _builtins.str,
                 type: _builtins.str):
        """
        :param Sequence[_builtins.str] identity_ids: A list of one or more Resource IDs for User Assigned Managed identities to assign. Required when `type` is set to `UserAssigned`.
        :param _builtins.str type: The type of managed identity to assign. Possible values are `UserAssigned` and `SystemAssigned`
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[_builtins.str]:
        """
        A list of one or more Resource IDs for User Assigned Managed identities to assign. Required when `type` is set to `UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of managed identity to assign. Possible values are `UserAssigned` and `SystemAssigned`
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAppIngressResult(dict):
    def __init__(__self__, *,
                 allow_insecure_connections: _builtins.bool,
                 client_certificate_mode: _builtins.str,
                 cors: Sequence['outputs.GetAppIngressCorResult'],
                 custom_domains: Sequence['outputs.GetAppIngressCustomDomainResult'],
                 exposed_port: _builtins.int,
                 external_enabled: _builtins.bool,
                 fqdn: _builtins.str,
                 ip_security_restrictions: Sequence['outputs.GetAppIngressIpSecurityRestrictionResult'],
                 target_port: _builtins.int,
                 traffic_weights: Sequence['outputs.GetAppIngressTrafficWeightResult'],
                 transport: _builtins.str):
        """
        :param _builtins.bool allow_insecure_connections: Should this ingress allow insecure connections?
        :param _builtins.str client_certificate_mode: The client certificate mode for the Ingress.
        :param Sequence['GetAppIngressCorArgs'] cors: A `cors` block as detailed below.
        :param Sequence['GetAppIngressCustomDomainArgs'] custom_domains: One or more `custom_domain` block as detailed below.
        :param _builtins.int exposed_port: The exposed port on the container for the Ingress traffic.
        :param _builtins.bool external_enabled: Is this an external Ingress.
        :param _builtins.str fqdn: The FQDN of the ingress.
        :param Sequence['GetAppIngressIpSecurityRestrictionArgs'] ip_security_restrictions: One or more `ip_security_restriction` blocks for IP-filtering rules as defined below.
        :param _builtins.int target_port: The target port on the container for the Ingress traffic.
        :param Sequence['GetAppIngressTrafficWeightArgs'] traffic_weights: A `traffic_weight` block as detailed below.
        :param _builtins.str transport: The transport method for the Ingress. Possible values include `auto`, `http`, and `http2`. Defaults to `auto`
        """
        pulumi.set(__self__, "allow_insecure_connections", allow_insecure_connections)
        pulumi.set(__self__, "client_certificate_mode", client_certificate_mode)
        pulumi.set(__self__, "cors", cors)
        pulumi.set(__self__, "custom_domains", custom_domains)
        pulumi.set(__self__, "exposed_port", exposed_port)
        pulumi.set(__self__, "external_enabled", external_enabled)
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "ip_security_restrictions", ip_security_restrictions)
        pulumi.set(__self__, "target_port", target_port)
        pulumi.set(__self__, "traffic_weights", traffic_weights)
        pulumi.set(__self__, "transport", transport)

    @_builtins.property
    @pulumi.getter(name="allowInsecureConnections")
    def allow_insecure_connections(self) -> _builtins.bool:
        """
        Should this ingress allow insecure connections?
        """
        return pulumi.get(self, "allow_insecure_connections")

    @_builtins.property
    @pulumi.getter(name="clientCertificateMode")
    def client_certificate_mode(self) -> _builtins.str:
        """
        The client certificate mode for the Ingress.
        """
        return pulumi.get(self, "client_certificate_mode")

    @_builtins.property
    @pulumi.getter
    def cors(self) -> Sequence['outputs.GetAppIngressCorResult']:
        """
        A `cors` block as detailed below.
        """
        return pulumi.get(self, "cors")

    @_builtins.property
    @pulumi.getter(name="customDomains")
    def custom_domains(self) -> Sequence['outputs.GetAppIngressCustomDomainResult']:
        """
        One or more `custom_domain` block as detailed below.
        """
        return pulumi.get(self, "custom_domains")

    @_builtins.property
    @pulumi.getter(name="exposedPort")
    def exposed_port(self) -> _builtins.int:
        """
        The exposed port on the container for the Ingress traffic.
        """
        return pulumi.get(self, "exposed_port")

    @_builtins.property
    @pulumi.getter(name="externalEnabled")
    def external_enabled(self) -> _builtins.bool:
        """
        Is this an external Ingress.
        """
        return pulumi.get(self, "external_enabled")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> _builtins.str:
        """
        The FQDN of the ingress.
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter(name="ipSecurityRestrictions")
    def ip_security_restrictions(self) -> Sequence['outputs.GetAppIngressIpSecurityRestrictionResult']:
        """
        One or more `ip_security_restriction` blocks for IP-filtering rules as defined below.
        """
        return pulumi.get(self, "ip_security_restrictions")

    @_builtins.property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> _builtins.int:
        """
        The target port on the container for the Ingress traffic.
        """
        return pulumi.get(self, "target_port")

    @_builtins.property
    @pulumi.getter(name="trafficWeights")
    def traffic_weights(self) -> Sequence['outputs.GetAppIngressTrafficWeightResult']:
        """
        A `traffic_weight` block as detailed below.
        """
        return pulumi.get(self, "traffic_weights")

    @_builtins.property
    @pulumi.getter
    def transport(self) -> _builtins.str:
        """
        The transport method for the Ingress. Possible values include `auto`, `http`, and `http2`. Defaults to `auto`
        """
        return pulumi.get(self, "transport")


@pulumi.output_type
class GetAppIngressCorResult(dict):
    def __init__(__self__, *,
                 allow_credentials_enabled: _builtins.bool,
                 allowed_headers: Sequence[_builtins.str],
                 allowed_methods: Sequence[_builtins.str],
                 allowed_origins: Sequence[_builtins.str],
                 exposed_headers: Sequence[_builtins.str],
                 max_age_in_seconds: _builtins.int):
        """
        :param _builtins.bool allow_credentials_enabled: Whether user credentials are allowed in the cross-origin request.
        :param Sequence[_builtins.str] allowed_headers: The list of request headers that are permitted in the actual request.
        :param Sequence[_builtins.str] allowed_methods: The list of HTTP methods are allowed when accessing the resource in a cross-origin request.
        :param Sequence[_builtins.str] allowed_origins: The list of origins that are allowed to make cross-origin calls.
        :param Sequence[_builtins.str] exposed_headers: The list of headers exposed to the browser in the response to a cross-origin request.
        :param _builtins.int max_age_in_seconds: The number of seconds that the browser can cache the results of a preflight request.
        """
        pulumi.set(__self__, "allow_credentials_enabled", allow_credentials_enabled)
        pulumi.set(__self__, "allowed_headers", allowed_headers)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        pulumi.set(__self__, "exposed_headers", exposed_headers)
        pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @_builtins.property
    @pulumi.getter(name="allowCredentialsEnabled")
    def allow_credentials_enabled(self) -> _builtins.bool:
        """
        Whether user credentials are allowed in the cross-origin request.
        """
        return pulumi.get(self, "allow_credentials_enabled")

    @_builtins.property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Sequence[_builtins.str]:
        """
        The list of request headers that are permitted in the actual request.
        """
        return pulumi.get(self, "allowed_headers")

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[_builtins.str]:
        """
        The list of HTTP methods are allowed when accessing the resource in a cross-origin request.
        """
        return pulumi.get(self, "allowed_methods")

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[_builtins.str]:
        """
        The list of origins that are allowed to make cross-origin calls.
        """
        return pulumi.get(self, "allowed_origins")

    @_builtins.property
    @pulumi.getter(name="exposedHeaders")
    def exposed_headers(self) -> Sequence[_builtins.str]:
        """
        The list of headers exposed to the browser in the response to a cross-origin request.
        """
        return pulumi.get(self, "exposed_headers")

    @_builtins.property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> _builtins.int:
        """
        The number of seconds that the browser can cache the results of a preflight request.
        """
        return pulumi.get(self, "max_age_in_seconds")


@pulumi.output_type
class GetAppIngressCustomDomainResult(dict):
    def __init__(__self__, *,
                 certificate_binding_type: _builtins.str,
                 certificate_id: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str certificate_binding_type: The Binding type. Possible values include `Disabled` and `SniEnabled`. Defaults to `Disabled`.
        :param _builtins.str certificate_id: The ID of the Container App Environment Certificate.
        :param _builtins.str name: The name of the Container App.
        """
        pulumi.set(__self__, "certificate_binding_type", certificate_binding_type)
        pulumi.set(__self__, "certificate_id", certificate_id)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="certificateBindingType")
    def certificate_binding_type(self) -> _builtins.str:
        """
        The Binding type. Possible values include `Disabled` and `SniEnabled`. Defaults to `Disabled`.
        """
        return pulumi.get(self, "certificate_binding_type")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> _builtins.str:
        """
        The ID of the Container App Environment Certificate.
        """
        return pulumi.get(self, "certificate_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Container App.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAppIngressIpSecurityRestrictionResult(dict):
    def __init__(__self__, *,
                 action: _builtins.str,
                 description: _builtins.str,
                 ip_address_range: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str action: The IP-filter action.
        :param _builtins.str description: Description of the IP restriction rule that is being sent to the container-app.
        :param _builtins.str ip_address_range: CIDR notation that matches the incoming IP address.
        :param _builtins.str name: The name of the Container App.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "ip_address_range", ip_address_range)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The IP-filter action.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the IP restriction rule that is being sent to the container-app.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="ipAddressRange")
    def ip_address_range(self) -> _builtins.str:
        """
        CIDR notation that matches the incoming IP address.
        """
        return pulumi.get(self, "ip_address_range")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Container App.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAppIngressTrafficWeightResult(dict):
    def __init__(__self__, *,
                 label: _builtins.str,
                 latest_revision: _builtins.bool,
                 percentage: _builtins.int,
                 revision_suffix: _builtins.str):
        """
        :param _builtins.str label: The label to apply to the revision as a name prefix for routing traffic.
        :param _builtins.bool latest_revision: This traffic Weight relates to the latest stable Container Revision.
        :param _builtins.int percentage: The percentage of traffic which should be sent this revision.
        :param _builtins.str revision_suffix: The suffix string to which this `traffic_weight` applies.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "latest_revision", latest_revision)
        pulumi.set(__self__, "percentage", percentage)
        pulumi.set(__self__, "revision_suffix", revision_suffix)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        The label to apply to the revision as a name prefix for routing traffic.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="latestRevision")
    def latest_revision(self) -> _builtins.bool:
        """
        This traffic Weight relates to the latest stable Container Revision.
        """
        return pulumi.get(self, "latest_revision")

    @_builtins.property
    @pulumi.getter
    def percentage(self) -> _builtins.int:
        """
        The percentage of traffic which should be sent this revision.
        """
        return pulumi.get(self, "percentage")

    @_builtins.property
    @pulumi.getter(name="revisionSuffix")
    def revision_suffix(self) -> _builtins.str:
        """
        The suffix string to which this `traffic_weight` applies.
        """
        return pulumi.get(self, "revision_suffix")


@pulumi.output_type
class GetAppRegistryResult(dict):
    def __init__(__self__, *,
                 identity: _builtins.str,
                 password_secret_name: _builtins.str,
                 server: _builtins.str,
                 username: _builtins.str):
        """
        :param _builtins.str identity: Resource ID for the User Assigned Managed identity to use when pulling from the Container Registry.
        :param _builtins.str password_secret_name: The name of the Secret Reference containing the password value for this user on the Container Registry, `username` must also be supplied.
        :param _builtins.str server: The hostname for the Container Registry.
        :param _builtins.str username: The username to use for this Container Registry, `password_secret_name` must also be supplied..
        """
        pulumi.set(__self__, "identity", identity)
        pulumi.set(__self__, "password_secret_name", password_secret_name)
        pulumi.set(__self__, "server", server)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> _builtins.str:
        """
        Resource ID for the User Assigned Managed identity to use when pulling from the Container Registry.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="passwordSecretName")
    def password_secret_name(self) -> _builtins.str:
        """
        The name of the Secret Reference containing the password value for this user on the Container Registry, `username` must also be supplied.
        """
        return pulumi.get(self, "password_secret_name")

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.str:
        """
        The hostname for the Container Registry.
        """
        return pulumi.get(self, "server")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The username to use for this Container Registry, `password_secret_name` must also be supplied..
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetAppSecretResult(dict):
    def __init__(__self__, *,
                 identity: _builtins.str,
                 key_vault_secret_id: _builtins.str,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str identity: Resource ID for the User Assigned Managed identity to use when pulling from the Container Registry.
        :param _builtins.str key_vault_secret_id: The ID of a Key Vault secret.
        :param _builtins.str name: The name of the Container App.
        :param _builtins.str value: The HTTP Header value.
        """
        pulumi.set(__self__, "identity", identity)
        pulumi.set(__self__, "key_vault_secret_id", key_vault_secret_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> _builtins.str:
        """
        Resource ID for the User Assigned Managed identity to use when pulling from the Container Registry.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="keyVaultSecretId")
    def key_vault_secret_id(self) -> _builtins.str:
        """
        The ID of a Key Vault secret.
        """
        return pulumi.get(self, "key_vault_secret_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Container App.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The HTTP Header value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAppTemplateResult(dict):
    def __init__(__self__, *,
                 azure_queue_scale_rules: Sequence['outputs.GetAppTemplateAzureQueueScaleRuleResult'],
                 containers: Sequence['outputs.GetAppTemplateContainerResult'],
                 http_scale_rules: Sequence['outputs.GetAppTemplateHttpScaleRuleResult'],
                 init_containers: Sequence['outputs.GetAppTemplateInitContainerResult'],
                 max_replicas: _builtins.int,
                 min_replicas: _builtins.int,
                 revision_suffix: _builtins.str,
                 tcp_scale_rules: Sequence['outputs.GetAppTemplateTcpScaleRuleResult'],
                 termination_grace_period_seconds: _builtins.int,
                 volumes: Sequence['outputs.GetAppTemplateVolumeResult'],
                 custom_scale_rules: Optional[Sequence['outputs.GetAppTemplateCustomScaleRuleResult']] = None):
        """
        :param Sequence['GetAppTemplateContainerArgs'] containers: One or more `container` blocks as detailed below.
        :param Sequence['GetAppTemplateInitContainerArgs'] init_containers: One or more `init_container` blocks as detailed below.
        :param _builtins.int max_replicas: The maximum number of replicas for this container.
        :param _builtins.int min_replicas: The minimum number of replicas for this container.
        :param _builtins.str revision_suffix: The suffix string to which this `traffic_weight` applies.
        :param _builtins.int termination_grace_period_seconds: The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        :param Sequence['GetAppTemplateVolumeArgs'] volumes: A `volume` block as detailed below.
        """
        pulumi.set(__self__, "azure_queue_scale_rules", azure_queue_scale_rules)
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "http_scale_rules", http_scale_rules)
        pulumi.set(__self__, "init_containers", init_containers)
        pulumi.set(__self__, "max_replicas", max_replicas)
        pulumi.set(__self__, "min_replicas", min_replicas)
        pulumi.set(__self__, "revision_suffix", revision_suffix)
        pulumi.set(__self__, "tcp_scale_rules", tcp_scale_rules)
        pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        pulumi.set(__self__, "volumes", volumes)
        if custom_scale_rules is not None:
            pulumi.set(__self__, "custom_scale_rules", custom_scale_rules)

    @_builtins.property
    @pulumi.getter(name="azureQueueScaleRules")
    def azure_queue_scale_rules(self) -> Sequence['outputs.GetAppTemplateAzureQueueScaleRuleResult']:
        return pulumi.get(self, "azure_queue_scale_rules")

    @_builtins.property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.GetAppTemplateContainerResult']:
        """
        One or more `container` blocks as detailed below.
        """
        return pulumi.get(self, "containers")

    @_builtins.property
    @pulumi.getter(name="httpScaleRules")
    def http_scale_rules(self) -> Sequence['outputs.GetAppTemplateHttpScaleRuleResult']:
        return pulumi.get(self, "http_scale_rules")

    @_builtins.property
    @pulumi.getter(name="initContainers")
    def init_containers(self) -> Sequence['outputs.GetAppTemplateInitContainerResult']:
        """
        One or more `init_container` blocks as detailed below.
        """
        return pulumi.get(self, "init_containers")

    @_builtins.property
    @pulumi.getter(name="maxReplicas")
    def max_replicas(self) -> _builtins.int:
        """
        The maximum number of replicas for this container.
        """
        return pulumi.get(self, "max_replicas")

    @_builtins.property
    @pulumi.getter(name="minReplicas")
    def min_replicas(self) -> _builtins.int:
        """
        The minimum number of replicas for this container.
        """
        return pulumi.get(self, "min_replicas")

    @_builtins.property
    @pulumi.getter(name="revisionSuffix")
    def revision_suffix(self) -> _builtins.str:
        """
        The suffix string to which this `traffic_weight` applies.
        """
        return pulumi.get(self, "revision_suffix")

    @_builtins.property
    @pulumi.getter(name="tcpScaleRules")
    def tcp_scale_rules(self) -> Sequence['outputs.GetAppTemplateTcpScaleRuleResult']:
        return pulumi.get(self, "tcp_scale_rules")

    @_builtins.property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> _builtins.int:
        """
        The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.GetAppTemplateVolumeResult']:
        """
        A `volume` block as detailed below.
        """
        return pulumi.get(self, "volumes")

    @_builtins.property
    @pulumi.getter(name="customScaleRules")
    def custom_scale_rules(self) -> Optional[Sequence['outputs.GetAppTemplateCustomScaleRuleResult']]:
        return pulumi.get(self, "custom_scale_rules")


@pulumi.output_type
class GetAppTemplateAzureQueueScaleRuleResult(dict):
    def __init__(__self__, *,
                 authentications: Sequence['outputs.GetAppTemplateAzureQueueScaleRuleAuthenticationResult'],
                 name: _builtins.str,
                 queue_length: _builtins.int,
                 queue_name: _builtins.str):
        """
        :param _builtins.str name: The name of the Container App.
        """
        pulumi.set(__self__, "authentications", authentications)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "queue_length", queue_length)
        pulumi.set(__self__, "queue_name", queue_name)

    @_builtins.property
    @pulumi.getter
    def authentications(self) -> Sequence['outputs.GetAppTemplateAzureQueueScaleRuleAuthenticationResult']:
        return pulumi.get(self, "authentications")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Container App.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="queueLength")
    def queue_length(self) -> _builtins.int:
        return pulumi.get(self, "queue_length")

    @_builtins.property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> _builtins.str:
        return pulumi.get(self, "queue_name")


@pulumi.output_type
class GetAppTemplateAzureQueueScaleRuleAuthenticationResult(dict):
    def __init__(__self__, *,
                 secret_name: _builtins.str,
                 trigger_parameter: _builtins.str):
        """
        :param _builtins.str secret_name: The name of the secret that contains the value for this environment variable.
        """
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "trigger_parameter", trigger_parameter)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> _builtins.str:
        """
        The name of the secret that contains the value for this environment variable.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter(name="triggerParameter")
    def trigger_parameter(self) -> _builtins.str:
        return pulumi.get(self, "trigger_parameter")


@pulumi.output_type
class GetAppTemplateContainerResult(dict):
    def __init__(__self__, *,
                 args: Sequence[_builtins.str],
                 commands: Sequence[_builtins.str],
                 cpu: _builtins.float,
                 envs: Sequence['outputs.GetAppTemplateContainerEnvResult'],
                 ephemeral_storage: _builtins.str,
                 image: _builtins.str,
                 liveness_probes: Sequence['outputs.GetAppTemplateContainerLivenessProbeResult'],
                 memory: _builtins.str,
                 name: _builtins.str,
                 readiness_probes: Sequence['outputs.GetAppTemplateContainerReadinessProbeResult'],
                 startup_probes: Sequence['outputs.GetAppTemplateContainerStartupProbeResult'],
                 volume_mounts: Sequence['outputs.GetAppTemplateContainerVolumeMountResult']):
        """
        :param Sequence[_builtins.str] args: A list of extra arguments to pass to the container.
        :param Sequence[_builtins.str] commands: A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
        :param _builtins.float cpu: The amount of vCPU to allocate to the container. Possible values include `0.25`, `0.5`, `0.75`, `1.0`, `1.25`, `1.5`, `1.75`, and `2.0`.
        :param Sequence['GetAppTemplateContainerEnvArgs'] envs: One or more `env` blocks as detailed below.
        :param _builtins.str ephemeral_storage: The amount of ephemeral storage available to the Container App.
        :param _builtins.str image: The image to use to create the container.
        :param Sequence['GetAppTemplateContainerLivenessProbeArgs'] liveness_probes: A `liveness_probe` block as detailed below.
        :param _builtins.str memory: The amount of memory to allocate to the container. Possible values include `0.5Gi`, `1Gi`, `1.5Gi`, `2Gi`, `2.5Gi`, `3Gi`, `3.5Gi`, and `4Gi`.
        :param _builtins.str name: The name of the Container App.
        :param Sequence['GetAppTemplateContainerReadinessProbeArgs'] readiness_probes: A `readiness_probe` block as detailed below.
        :param Sequence['GetAppTemplateContainerStartupProbeArgs'] startup_probes: A `startup_probe` block as detailed below.
        :param Sequence['GetAppTemplateContainerVolumeMountArgs'] volume_mounts: A `volume_mounts` block as detailed below.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "envs", envs)
        pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "liveness_probes", liveness_probes)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "readiness_probes", readiness_probes)
        pulumi.set(__self__, "startup_probes", startup_probes)
        pulumi.set(__self__, "volume_mounts", volume_mounts)

    @_builtins.property
    @pulumi.getter
    def args(self) -> Sequence[_builtins.str]:
        """
        A list of extra arguments to pass to the container.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Sequence[_builtins.str]:
        """
        A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.float:
        """
        The amount of vCPU to allocate to the container. Possible values include `0.25`, `0.5`, `0.75`, `1.0`, `1.25`, `1.5`, `1.75`, and `2.0`.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Sequence['outputs.GetAppTemplateContainerEnvResult']:
        """
        One or more `env` blocks as detailed below.
        """
        return pulumi.get(self, "envs")

    @_builtins.property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> _builtins.str:
        """
        The amount of ephemeral storage available to the Container App.
        """
        return pulumi.get(self, "ephemeral_storage")

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        The image to use to create the container.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="livenessProbes")
    def liveness_probes(self) -> Sequence['outputs.GetAppTemplateContainerLivenessProbeResult']:
        """
        A `liveness_probe` block as detailed below.
        """
        return pulumi.get(self, "liveness_probes")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> _builtins.str:
        """
        The amount of memory to allocate to the container. Possible values include `0.5Gi`, `1Gi`, `1.5Gi`, `2Gi`, `2.5Gi`, `3Gi`, `3.5Gi`, and `4Gi`.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Container App.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="readinessProbes")
    def readiness_probes(self) -> Sequence['outputs.GetAppTemplateContainerReadinessProbeResult']:
        """
        A `readiness_probe` block as detailed below.
        """
        return pulumi.get(self, "readiness_probes")

    @_builtins.property
    @pulumi.getter(name="startupProbes")
    def startup_probes(self) -> Sequence['outputs.GetAppTemplateContainerStartupProbeResult']:
        """
        A `startup_probe` block as detailed below.
        """
        return pulumi.get(self, "startup_probes")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Sequence['outputs.GetAppTemplateContainerVolumeMountResult']:
        """
        A `volume_mounts` block as detailed below.
        """
        return pulumi.get(self, "volume_mounts")


@pulumi.output_type
class GetAppTemplateContainerEnvResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 secret_name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the Container App.
        :param _builtins.str secret_name: The name of the secret that contains the value for this environment variable.
        :param _builtins.str value: The HTTP Header value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Container App.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> _builtins.str:
        """
        The name of the secret that contains the value for this environment variable.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The HTTP Header value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAppTemplateContainerLivenessProbeResult(dict):
    def __init__(__self__, *,
                 failure_count_threshold: _builtins.int,
                 headers: Sequence['outputs.GetAppTemplateContainerLivenessProbeHeaderResult'],
                 host: _builtins.str,
                 initial_delay: _builtins.int,
                 interval_seconds: _builtins.int,
                 path: _builtins.str,
                 port: _builtins.int,
                 termination_grace_period_seconds: _builtins.int,
                 timeout: _builtins.int,
                 transport: _builtins.str):
        """
        :param _builtins.int failure_count_threshold: The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `30`. Defaults to `3`.
        :param Sequence['GetAppTemplateContainerLivenessProbeHeaderArgs'] headers: A `header` block as detailed below.
        :param _builtins.str host: The value for the host header which should be sent with this probe. If unspecified, the IP Address of the Pod is used as the host header. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        :param _builtins.int initial_delay: The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
        :param _builtins.int interval_seconds: How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
        :param _builtins.str path: The path in the container at which to mount this volume.
        :param _builtins.int port: The port number on which to connect. Possible values are between `1` and `65535`.
        :param _builtins.int termination_grace_period_seconds: The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        :param _builtins.int timeout: Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        :param _builtins.str transport: The transport method for the Ingress. Possible values include `auto`, `http`, and `http2`. Defaults to `auto`
        """
        pulumi.set(__self__, "failure_count_threshold", failure_count_threshold)
        pulumi.set(__self__, "headers", headers)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "initial_delay", initial_delay)
        pulumi.set(__self__, "interval_seconds", interval_seconds)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "transport", transport)

    @_builtins.property
    @pulumi.getter(name="failureCountThreshold")
    def failure_count_threshold(self) -> _builtins.int:
        """
        The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `30`. Defaults to `3`.
        """
        return pulumi.get(self, "failure_count_threshold")

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Sequence['outputs.GetAppTemplateContainerLivenessProbeHeaderResult']:
        """
        A `header` block as detailed below.
        """
        return pulumi.get(self, "headers")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The value for the host header which should be sent with this probe. If unspecified, the IP Address of the Pod is used as the host header. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="initialDelay")
    def initial_delay(self) -> _builtins.int:
        """
        The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
        """
        return pulumi.get(self, "initial_delay")

    @_builtins.property
    @pulumi.getter(name="intervalSeconds")
    def interval_seconds(self) -> _builtins.int:
        """
        How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
        """
        return pulumi.get(self, "interval_seconds")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path in the container at which to mount this volume.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port number on which to connect. Possible values are between `1` and `65535`.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> _builtins.int:
        """
        The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> _builtins.int:
        """
        Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter
    def transport(self) -> _builtins.str:
        """
        The transport method for the Ingress. Possible values include `auto`, `http`, and `http2`. Defaults to `auto`
        """
        return pulumi.get(self, "transport")


@pulumi.output_type
class GetAppTemplateContainerLivenessProbeHeaderResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the Container App.
        :param _builtins.str value: The HTTP Header value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Container App.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The HTTP Header value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAppTemplateContainerReadinessProbeResult(dict):
    def __init__(__self__, *,
                 failure_count_threshold: _builtins.int,
                 headers: Sequence['outputs.GetAppTemplateContainerReadinessProbeHeaderResult'],
                 host: _builtins.str,
                 initial_delay: _builtins.int,
                 interval_seconds: _builtins.int,
                 path: _builtins.str,
                 port: _builtins.int,
                 success_count_threshold: _builtins.int,
                 timeout: _builtins.int,
                 transport: _builtins.str):
        """
        :param _builtins.int failure_count_threshold: The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `30`. Defaults to `3`.
        :param Sequence['GetAppTemplateContainerReadinessProbeHeaderArgs'] headers: A `header` block as detailed below.
        :param _builtins.str host: The value for the host header which should be sent with this probe. If unspecified, the IP Address of the Pod is used as the host header. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        :param _builtins.int initial_delay: The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
        :param _builtins.int interval_seconds: How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
        :param _builtins.str path: The path in the container at which to mount this volume.
        :param _builtins.int port: The port number on which to connect. Possible values are between `1` and `65535`.
        :param _builtins.int success_count_threshold: The number of consecutive successful responses required to consider this probe as successful. Possible values are between `1` and `10`. Defaults to `3`.
        :param _builtins.int timeout: Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        :param _builtins.str transport: The transport method for the Ingress. Possible values include `auto`, `http`, and `http2`. Defaults to `auto`
        """
        pulumi.set(__self__, "failure_count_threshold", failure_count_threshold)
        pulumi.set(__self__, "headers", headers)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "initial_delay", initial_delay)
        pulumi.set(__self__, "interval_seconds", interval_seconds)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "success_count_threshold", success_count_threshold)
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "transport", transport)

    @_builtins.property
    @pulumi.getter(name="failureCountThreshold")
    def failure_count_threshold(self) -> _builtins.int:
        """
        The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `30`. Defaults to `3`.
        """
        return pulumi.get(self, "failure_count_threshold")

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Sequence['outputs.GetAppTemplateContainerReadinessProbeHeaderResult']:
        """
        A `header` block as detailed below.
        """
        return pulumi.get(self, "headers")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The value for the host header which should be sent with this probe. If unspecified, the IP Address of the Pod is used as the host header. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="initialDelay")
    def initial_delay(self) -> _builtins.int:
        """
        The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
        """
        return pulumi.get(self, "initial_delay")

    @_builtins.property
    @pulumi.getter(name="intervalSeconds")
    def interval_seconds(self) -> _builtins.int:
        """
        How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
        """
        return pulumi.get(self, "interval_seconds")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path in the container at which to mount this volume.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port number on which to connect. Possible values are between `1` and `65535`.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="successCountThreshold")
    def success_count_threshold(self) -> _builtins.int:
        """
        The number of consecutive successful responses required to consider this probe as successful. Possible values are between `1` and `10`. Defaults to `3`.
        """
        return pulumi.get(self, "success_count_threshold")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> _builtins.int:
        """
        Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter
    def transport(self) -> _builtins.str:
        """
        The transport method for the Ingress. Possible values include `auto`, `http`, and `http2`. Defaults to `auto`
        """
        return pulumi.get(self, "transport")


@pulumi.output_type
class GetAppTemplateContainerReadinessProbeHeaderResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the Container App.
        :param _builtins.str value: The HTTP Header value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Container App.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The HTTP Header value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAppTemplateContainerStartupProbeResult(dict):
    def __init__(__self__, *,
                 failure_count_threshold: _builtins.int,
                 headers: Sequence['outputs.GetAppTemplateContainerStartupProbeHeaderResult'],
                 host: _builtins.str,
                 initial_delay: _builtins.int,
                 interval_seconds: _builtins.int,
                 path: _builtins.str,
                 port: _builtins.int,
                 termination_grace_period_seconds: _builtins.int,
                 timeout: _builtins.int,
                 transport: _builtins.str):
        """
        :param _builtins.int failure_count_threshold: The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `30`. Defaults to `3`.
        :param Sequence['GetAppTemplateContainerStartupProbeHeaderArgs'] headers: A `header` block as detailed below.
        :param _builtins.str host: The value for the host header which should be sent with this probe. If unspecified, the IP Address of the Pod is used as the host header. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        :param _builtins.int initial_delay: The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
        :param _builtins.int interval_seconds: How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
        :param _builtins.str path: The path in the container at which to mount this volume.
        :param _builtins.int port: The port number on which to connect. Possible values are between `1` and `65535`.
        :param _builtins.int termination_grace_period_seconds: The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        :param _builtins.int timeout: Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        :param _builtins.str transport: The transport method for the Ingress. Possible values include `auto`, `http`, and `http2`. Defaults to `auto`
        """
        pulumi.set(__self__, "failure_count_threshold", failure_count_threshold)
        pulumi.set(__self__, "headers", headers)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "initial_delay", initial_delay)
        pulumi.set(__self__, "interval_seconds", interval_seconds)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "transport", transport)

    @_builtins.property
    @pulumi.getter(name="failureCountThreshold")
    def failure_count_threshold(self) -> _builtins.int:
        """
        The number of consecutive failures required to consider this probe as failed. Possible values are between `1` and `30`. Defaults to `3`.
        """
        return pulumi.get(self, "failure_count_threshold")

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Sequence['outputs.GetAppTemplateContainerStartupProbeHeaderResult']:
        """
        A `header` block as detailed below.
        """
        return pulumi.get(self, "headers")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The value for the host header which should be sent with this probe. If unspecified, the IP Address of the Pod is used as the host header. Setting a value for `Host` in `headers` can be used to override this for `HTTP` and `HTTPS` type probes.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="initialDelay")
    def initial_delay(self) -> _builtins.int:
        """
        The number of seconds elapsed after the container has started before the probe is initiated. Possible values are between `0` and `60`. Defaults to `0` seconds.
        """
        return pulumi.get(self, "initial_delay")

    @_builtins.property
    @pulumi.getter(name="intervalSeconds")
    def interval_seconds(self) -> _builtins.int:
        """
        How often, in seconds, the probe should run. Possible values are between `1` and `240`. Defaults to `10`
        """
        return pulumi.get(self, "interval_seconds")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path in the container at which to mount this volume.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port number on which to connect. Possible values are between `1` and `65535`.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> _builtins.int:
        """
        The time in seconds after the container is sent the termination signal before the process if forcibly killed.
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> _builtins.int:
        """
        Time in seconds after which the probe times out. Possible values are in the range `1` - `240`. Defaults to `1`.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter
    def transport(self) -> _builtins.str:
        """
        The transport method for the Ingress. Possible values include `auto`, `http`, and `http2`. Defaults to `auto`
        """
        return pulumi.get(self, "transport")


@pulumi.output_type
class GetAppTemplateContainerStartupProbeHeaderResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the Container App.
        :param _builtins.str value: The HTTP Header value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Container App.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The HTTP Header value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAppTemplateContainerVolumeMountResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 path: _builtins.str,
                 sub_path: _builtins.str):
        """
        :param _builtins.str name: The name of the Container App.
        :param _builtins.str path: The path in the container at which to mount this volume.
        :param _builtins.str sub_path: The sub path of the volume to be mounted in the container.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "sub_path", sub_path)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Container App.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path in the container at which to mount this volume.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="subPath")
    def sub_path(self) -> _builtins.str:
        """
        The sub path of the volume to be mounted in the container.
        """
        return pulumi.get(self, "sub_path")


@pulumi.output_type
class GetAppTemplateCustomScaleRuleResult(dict):
    def __init__(__self__, *,
                 authentications: Sequence['outputs.GetAppTemplateCustomScaleRuleAuthenticationResult'],
                 custom_rule_type: _builtins.str,
                 metadata: Mapping[str, _builtins.str],
                 name: _builtins.str):
        """
        :param _builtins.str name: The name of the Container App.
        """
        pulumi.set(__self__, "authentications", authentications)
        pulumi.set(__self__, "custom_rule_type", custom_rule_type)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def authentications(self) -> Sequence['outputs.GetAppTemplateCustomScaleRuleAuthenticationResult']:
        return pulumi.get(self, "authentications")

    @_builtins.property
    @pulumi.getter(name="customRuleType")
    def custom_rule_type(self) -> _builtins.str:
        return pulumi.get(self, "custom_rule_type")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Container App.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAppTemplateCustomScaleRuleAuthenticationResult(dict):
    def __init__(__self__, *,
                 secret_name: _builtins.str,
                 trigger_parameter: _builtins.str):
        """
        :param _builtins.str secret_name: The name of the secret that contains the value for this environment variable.
        """
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "trigger_parameter", trigger_parameter)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> _builtins.str:
        """
        The name of the secret that contains the value for this environment variable.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter(name="triggerParameter")
    def trigger_parameter(self) -> _builtins.str:
        return pulumi.get(self, "trigger_parameter")


@pulumi.output_type
class GetAppTemplateHttpScaleRuleResult(dict):
    def __init__(__self__, *,
                 authentications: Sequence['outputs.GetAppTemplateHttpScaleRuleAuthenticationResult'],
                 concurrent_requests: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str name: The name of the Container App.
        """
        pulumi.set(__self__, "authentications", authentications)
        pulumi.set(__self__, "concurrent_requests", concurrent_requests)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def authentications(self) -> Sequence['outputs.GetAppTemplateHttpScaleRuleAuthenticationResult']:
        return pulumi.get(self, "authentications")

    @_builtins.property
    @pulumi.getter(name="concurrentRequests")
    def concurrent_requests(self) -> _builtins.str:
        return pulumi.get(self, "concurrent_requests")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Container App.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAppTemplateHttpScaleRuleAuthenticationResult(dict):
    def __init__(__self__, *,
                 secret_name: _builtins.str,
                 trigger_parameter: _builtins.str):
        """
        :param _builtins.str secret_name: The name of the secret that contains the value for this environment variable.
        """
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "trigger_parameter", trigger_parameter)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> _builtins.str:
        """
        The name of the secret that contains the value for this environment variable.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter(name="triggerParameter")
    def trigger_parameter(self) -> _builtins.str:
        return pulumi.get(self, "trigger_parameter")


@pulumi.output_type
class GetAppTemplateInitContainerResult(dict):
    def __init__(__self__, *,
                 args: Sequence[_builtins.str],
                 commands: Sequence[_builtins.str],
                 cpu: _builtins.float,
                 envs: Sequence['outputs.GetAppTemplateInitContainerEnvResult'],
                 ephemeral_storage: _builtins.str,
                 image: _builtins.str,
                 memory: _builtins.str,
                 name: _builtins.str,
                 volume_mounts: Sequence['outputs.GetAppTemplateInitContainerVolumeMountResult']):
        """
        :param Sequence[_builtins.str] args: A list of extra arguments to pass to the container.
        :param Sequence[_builtins.str] commands: A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
        :param _builtins.float cpu: The amount of vCPU to allocate to the container. Possible values include `0.25`, `0.5`, `0.75`, `1.0`, `1.25`, `1.5`, `1.75`, and `2.0`.
        :param Sequence['GetAppTemplateInitContainerEnvArgs'] envs: One or more `env` blocks as detailed below.
        :param _builtins.str ephemeral_storage: The amount of ephemeral storage available to the Container App.
        :param _builtins.str image: The image to use to create the container.
        :param _builtins.str memory: The amount of memory to allocate to the container. Possible values include `0.5Gi`, `1Gi`, `1.5Gi`, `2Gi`, `2.5Gi`, `3Gi`, `3.5Gi`, and `4Gi`.
        :param _builtins.str name: The name of the Container App.
        :param Sequence['GetAppTemplateInitContainerVolumeMountArgs'] volume_mounts: A `volume_mounts` block as detailed below.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "envs", envs)
        pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "volume_mounts", volume_mounts)

    @_builtins.property
    @pulumi.getter
    def args(self) -> Sequence[_builtins.str]:
        """
        A list of extra arguments to pass to the container.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Sequence[_builtins.str]:
        """
        A command to pass to the container to override the default. This is provided as a list of command line elements without spaces.
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> _builtins.float:
        """
        The amount of vCPU to allocate to the container. Possible values include `0.25`, `0.5`, `0.75`, `1.0`, `1.25`, `1.5`, `1.75`, and `2.0`.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Sequence['outputs.GetAppTemplateInitContainerEnvResult']:
        """
        One or more `env` blocks as detailed below.
        """
        return pulumi.get(self, "envs")

    @_builtins.property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> _builtins.str:
        """
        The amount of ephemeral storage available to the Container App.
        """
        return pulumi.get(self, "ephemeral_storage")

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        The image to use to create the container.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> _builtins.str:
        """
        The amount of memory to allocate to the container. Possible values include `0.5Gi`, `1Gi`, `1.5Gi`, `2Gi`, `2.5Gi`, `3Gi`, `3.5Gi`, and `4Gi`.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Container App.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Sequence['outputs.GetAppTemplateInitContainerVolumeMountResult']:
        """
        A `volume_mounts` block as detailed below.
        """
        return pulumi.get(self, "volume_mounts")


@pulumi.output_type
class GetAppTemplateInitContainerEnvResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 secret_name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the Container App.
        :param _builtins.str secret_name: The name of the secret that contains the value for this environment variable.
        :param _builtins.str value: The HTTP Header value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Container App.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> _builtins.str:
        """
        The name of the secret that contains the value for this environment variable.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The HTTP Header value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAppTemplateInitContainerVolumeMountResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 path: _builtins.str,
                 sub_path: _builtins.str):
        """
        :param _builtins.str name: The name of the Container App.
        :param _builtins.str path: The path in the container at which to mount this volume.
        :param _builtins.str sub_path: The sub path of the volume to be mounted in the container.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "sub_path", sub_path)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Container App.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path in the container at which to mount this volume.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="subPath")
    def sub_path(self) -> _builtins.str:
        """
        The sub path of the volume to be mounted in the container.
        """
        return pulumi.get(self, "sub_path")


@pulumi.output_type
class GetAppTemplateTcpScaleRuleResult(dict):
    def __init__(__self__, *,
                 authentications: Sequence['outputs.GetAppTemplateTcpScaleRuleAuthenticationResult'],
                 concurrent_requests: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str name: The name of the Container App.
        """
        pulumi.set(__self__, "authentications", authentications)
        pulumi.set(__self__, "concurrent_requests", concurrent_requests)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def authentications(self) -> Sequence['outputs.GetAppTemplateTcpScaleRuleAuthenticationResult']:
        return pulumi.get(self, "authentications")

    @_builtins.property
    @pulumi.getter(name="concurrentRequests")
    def concurrent_requests(self) -> _builtins.str:
        return pulumi.get(self, "concurrent_requests")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Container App.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAppTemplateTcpScaleRuleAuthenticationResult(dict):
    def __init__(__self__, *,
                 secret_name: _builtins.str,
                 trigger_parameter: _builtins.str):
        """
        :param _builtins.str secret_name: The name of the secret that contains the value for this environment variable.
        """
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "trigger_parameter", trigger_parameter)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> _builtins.str:
        """
        The name of the secret that contains the value for this environment variable.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter(name="triggerParameter")
    def trigger_parameter(self) -> _builtins.str:
        return pulumi.get(self, "trigger_parameter")


@pulumi.output_type
class GetAppTemplateVolumeResult(dict):
    def __init__(__self__, *,
                 mount_options: _builtins.str,
                 name: _builtins.str,
                 storage_name: _builtins.str,
                 storage_type: _builtins.str):
        """
        :param _builtins.str mount_options: Mount options used while mounting the AzureFile.
        :param _builtins.str name: The name of the Container App.
        :param _builtins.str storage_name: The name of the `AzureFile` storage.
        :param _builtins.str storage_type: The type of storage volume. Possible values include `AzureFile` and `EmptyDir`. Defaults to `EmptyDir`.
        """
        pulumi.set(__self__, "mount_options", mount_options)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "storage_name", storage_name)
        pulumi.set(__self__, "storage_type", storage_type)

    @_builtins.property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> _builtins.str:
        """
        Mount options used while mounting the AzureFile.
        """
        return pulumi.get(self, "mount_options")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Container App.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="storageName")
    def storage_name(self) -> _builtins.str:
        """
        The name of the `AzureFile` storage.
        """
        return pulumi.get(self, "storage_name")

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> _builtins.str:
        """
        The type of storage volume. Possible values include `AzureFile` and `EmptyDir`. Defaults to `EmptyDir`.
        """
        return pulumi.get(self, "storage_type")


