# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CassandraClusterArgs', 'CassandraCluster']

@pulumi.input_type
class CassandraClusterArgs:
    def __init__(__self__, *,
                 default_admin_password: pulumi.Input[_builtins.str],
                 delegated_management_subnet_id: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 authentication_method: Optional[pulumi.Input[_builtins.str]] = None,
                 client_certificate_pems: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_gossip_certificate_pems: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_seed_node_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hours_between_backups: Optional[pulumi.Input[_builtins.int]] = None,
                 identity: Optional[pulumi.Input['CassandraClusterIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 repair_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CassandraCluster resource.
        :param pulumi.Input[_builtins.str] default_admin_password: The initial admin password for this Cassandra Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] delegated_management_subnet_id: The ID of the delegated management subnet for this Cassandra Cluster. Changing this forces a new Cassandra Cluster to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Cassandra Cluster should exist. Changing this forces a new Cassandra Cluster to be created.
        :param pulumi.Input[_builtins.str] authentication_method: The authentication method that is used to authenticate clients. Possible values are `None` and `Cassandra`. Defaults to `Cassandra`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] client_certificate_pems: A list of TLS certificates that is used to authorize client connecting to the Cassandra Cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_gossip_certificate_pems: A list of TLS certificates that is used to authorize gossip from unmanaged Cassandra Data Center.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_seed_node_ip_addresses: A list of IP Addresses of the seed nodes in unmanaged the Cassandra Data Center which will be added to the seed node lists of all managed nodes.
        :param pulumi.Input[_builtins.int] hours_between_backups: The number of hours to wait between taking a backup of the Cassandra Cluster. Defaults to `24`.
               
               > **Note:** To disable this feature, set this property to `0`.
        :param pulumi.Input['CassandraClusterIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Cassandra Cluster should exist. Changing this forces a new Cassandra Cluster to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Cassandra Cluster. Changing this forces a new Cassandra Cluster to be created.
        :param pulumi.Input[_builtins.bool] repair_enabled: Is the automatic repair enabled on the Cassandra Cluster? Defaults to `true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags assigned to the resource.
        :param pulumi.Input[_builtins.str] version: The version of Cassandra what the Cluster converges to run. Possible values are `3.11` and `4.0`. Defaults to `3.11`. Changing this forces a new Cassandra Cluster to be created.
        """
        pulumi.set(__self__, "default_admin_password", default_admin_password)
        pulumi.set(__self__, "delegated_management_subnet_id", delegated_management_subnet_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if authentication_method is not None:
            pulumi.set(__self__, "authentication_method", authentication_method)
        if client_certificate_pems is not None:
            pulumi.set(__self__, "client_certificate_pems", client_certificate_pems)
        if external_gossip_certificate_pems is not None:
            pulumi.set(__self__, "external_gossip_certificate_pems", external_gossip_certificate_pems)
        if external_seed_node_ip_addresses is not None:
            pulumi.set(__self__, "external_seed_node_ip_addresses", external_seed_node_ip_addresses)
        if hours_between_backups is not None:
            pulumi.set(__self__, "hours_between_backups", hours_between_backups)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if repair_enabled is not None:
            pulumi.set(__self__, "repair_enabled", repair_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="defaultAdminPassword")
    def default_admin_password(self) -> pulumi.Input[_builtins.str]:
        """
        The initial admin password for this Cassandra Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "default_admin_password")

    @default_admin_password.setter
    def default_admin_password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "default_admin_password", value)

    @_builtins.property
    @pulumi.getter(name="delegatedManagementSubnetId")
    def delegated_management_subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the delegated management subnet for this Cassandra Cluster. Changing this forces a new Cassandra Cluster to be created.
        """
        return pulumi.get(self, "delegated_management_subnet_id")

    @delegated_management_subnet_id.setter
    def delegated_management_subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "delegated_management_subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Cassandra Cluster should exist. Changing this forces a new Cassandra Cluster to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication method that is used to authenticate clients. Possible values are `None` and `Cassandra`. Defaults to `Cassandra`.
        """
        return pulumi.get(self, "authentication_method")

    @authentication_method.setter
    def authentication_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_method", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificatePems")
    def client_certificate_pems(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of TLS certificates that is used to authorize client connecting to the Cassandra Cluster.
        """
        return pulumi.get(self, "client_certificate_pems")

    @client_certificate_pems.setter
    def client_certificate_pems(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "client_certificate_pems", value)

    @_builtins.property
    @pulumi.getter(name="externalGossipCertificatePems")
    def external_gossip_certificate_pems(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of TLS certificates that is used to authorize gossip from unmanaged Cassandra Data Center.
        """
        return pulumi.get(self, "external_gossip_certificate_pems")

    @external_gossip_certificate_pems.setter
    def external_gossip_certificate_pems(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_gossip_certificate_pems", value)

    @_builtins.property
    @pulumi.getter(name="externalSeedNodeIpAddresses")
    def external_seed_node_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IP Addresses of the seed nodes in unmanaged the Cassandra Data Center which will be added to the seed node lists of all managed nodes.
        """
        return pulumi.get(self, "external_seed_node_ip_addresses")

    @external_seed_node_ip_addresses.setter
    def external_seed_node_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_seed_node_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="hoursBetweenBackups")
    def hours_between_backups(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of hours to wait between taking a backup of the Cassandra Cluster. Defaults to `24`.

        > **Note:** To disable this feature, set this property to `0`.
        """
        return pulumi.get(self, "hours_between_backups")

    @hours_between_backups.setter
    def hours_between_backups(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hours_between_backups", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['CassandraClusterIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['CassandraClusterIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Cassandra Cluster should exist. Changing this forces a new Cassandra Cluster to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Cassandra Cluster. Changing this forces a new Cassandra Cluster to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="repairEnabled")
    def repair_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the automatic repair enabled on the Cassandra Cluster? Defaults to `true`.
        """
        return pulumi.get(self, "repair_enabled")

    @repair_enabled.setter
    def repair_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "repair_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of Cassandra what the Cluster converges to run. Possible values are `3.11` and `4.0`. Defaults to `3.11`. Changing this forces a new Cassandra Cluster to be created.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _CassandraClusterState:
    def __init__(__self__, *,
                 authentication_method: Optional[pulumi.Input[_builtins.str]] = None,
                 client_certificate_pems: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 delegated_management_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 external_gossip_certificate_pems: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_seed_node_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hours_between_backups: Optional[pulumi.Input[_builtins.int]] = None,
                 identity: Optional[pulumi.Input['CassandraClusterIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 repair_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CassandraCluster resources.
        :param pulumi.Input[_builtins.str] authentication_method: The authentication method that is used to authenticate clients. Possible values are `None` and `Cassandra`. Defaults to `Cassandra`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] client_certificate_pems: A list of TLS certificates that is used to authorize client connecting to the Cassandra Cluster.
        :param pulumi.Input[_builtins.str] default_admin_password: The initial admin password for this Cassandra Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] delegated_management_subnet_id: The ID of the delegated management subnet for this Cassandra Cluster. Changing this forces a new Cassandra Cluster to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_gossip_certificate_pems: A list of TLS certificates that is used to authorize gossip from unmanaged Cassandra Data Center.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_seed_node_ip_addresses: A list of IP Addresses of the seed nodes in unmanaged the Cassandra Data Center which will be added to the seed node lists of all managed nodes.
        :param pulumi.Input[_builtins.int] hours_between_backups: The number of hours to wait between taking a backup of the Cassandra Cluster. Defaults to `24`.
               
               > **Note:** To disable this feature, set this property to `0`.
        :param pulumi.Input['CassandraClusterIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Cassandra Cluster should exist. Changing this forces a new Cassandra Cluster to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Cassandra Cluster. Changing this forces a new Cassandra Cluster to be created.
        :param pulumi.Input[_builtins.bool] repair_enabled: Is the automatic repair enabled on the Cassandra Cluster? Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Cassandra Cluster should exist. Changing this forces a new Cassandra Cluster to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags assigned to the resource.
        :param pulumi.Input[_builtins.str] version: The version of Cassandra what the Cluster converges to run. Possible values are `3.11` and `4.0`. Defaults to `3.11`. Changing this forces a new Cassandra Cluster to be created.
        """
        if authentication_method is not None:
            pulumi.set(__self__, "authentication_method", authentication_method)
        if client_certificate_pems is not None:
            pulumi.set(__self__, "client_certificate_pems", client_certificate_pems)
        if default_admin_password is not None:
            pulumi.set(__self__, "default_admin_password", default_admin_password)
        if delegated_management_subnet_id is not None:
            pulumi.set(__self__, "delegated_management_subnet_id", delegated_management_subnet_id)
        if external_gossip_certificate_pems is not None:
            pulumi.set(__self__, "external_gossip_certificate_pems", external_gossip_certificate_pems)
        if external_seed_node_ip_addresses is not None:
            pulumi.set(__self__, "external_seed_node_ip_addresses", external_seed_node_ip_addresses)
        if hours_between_backups is not None:
            pulumi.set(__self__, "hours_between_backups", hours_between_backups)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if repair_enabled is not None:
            pulumi.set(__self__, "repair_enabled", repair_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication method that is used to authenticate clients. Possible values are `None` and `Cassandra`. Defaults to `Cassandra`.
        """
        return pulumi.get(self, "authentication_method")

    @authentication_method.setter
    def authentication_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_method", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificatePems")
    def client_certificate_pems(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of TLS certificates that is used to authorize client connecting to the Cassandra Cluster.
        """
        return pulumi.get(self, "client_certificate_pems")

    @client_certificate_pems.setter
    def client_certificate_pems(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "client_certificate_pems", value)

    @_builtins.property
    @pulumi.getter(name="defaultAdminPassword")
    def default_admin_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The initial admin password for this Cassandra Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "default_admin_password")

    @default_admin_password.setter
    def default_admin_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_admin_password", value)

    @_builtins.property
    @pulumi.getter(name="delegatedManagementSubnetId")
    def delegated_management_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the delegated management subnet for this Cassandra Cluster. Changing this forces a new Cassandra Cluster to be created.
        """
        return pulumi.get(self, "delegated_management_subnet_id")

    @delegated_management_subnet_id.setter
    def delegated_management_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delegated_management_subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="externalGossipCertificatePems")
    def external_gossip_certificate_pems(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of TLS certificates that is used to authorize gossip from unmanaged Cassandra Data Center.
        """
        return pulumi.get(self, "external_gossip_certificate_pems")

    @external_gossip_certificate_pems.setter
    def external_gossip_certificate_pems(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_gossip_certificate_pems", value)

    @_builtins.property
    @pulumi.getter(name="externalSeedNodeIpAddresses")
    def external_seed_node_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IP Addresses of the seed nodes in unmanaged the Cassandra Data Center which will be added to the seed node lists of all managed nodes.
        """
        return pulumi.get(self, "external_seed_node_ip_addresses")

    @external_seed_node_ip_addresses.setter
    def external_seed_node_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_seed_node_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="hoursBetweenBackups")
    def hours_between_backups(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of hours to wait between taking a backup of the Cassandra Cluster. Defaults to `24`.

        > **Note:** To disable this feature, set this property to `0`.
        """
        return pulumi.get(self, "hours_between_backups")

    @hours_between_backups.setter
    def hours_between_backups(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hours_between_backups", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['CassandraClusterIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['CassandraClusterIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Cassandra Cluster should exist. Changing this forces a new Cassandra Cluster to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Cassandra Cluster. Changing this forces a new Cassandra Cluster to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="repairEnabled")
    def repair_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the automatic repair enabled on the Cassandra Cluster? Defaults to `true`.
        """
        return pulumi.get(self, "repair_enabled")

    @repair_enabled.setter
    def repair_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "repair_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Cassandra Cluster should exist. Changing this forces a new Cassandra Cluster to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of Cassandra what the Cluster converges to run. Possible values are `3.11` and `4.0`. Defaults to `3.11`. Changing this forces a new Cassandra Cluster to be created.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("azure:cosmosdb/cassandraCluster:CassandraCluster")
class CassandraCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_method: Optional[pulumi.Input[_builtins.str]] = None,
                 client_certificate_pems: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 delegated_management_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 external_gossip_certificate_pems: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_seed_node_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hours_between_backups: Optional[pulumi.Input[_builtins.int]] = None,
                 identity: Optional[pulumi.Input[Union['CassandraClusterIdentityArgs', 'CassandraClusterIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 repair_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Cassandra Cluster.

        > **Note:** In order for the `Azure Managed Instances for Apache Cassandra` to work properly the product requires the `Azure Cosmos DB` Application ID to be present and working in your tenant. If the `Azure Cosmos DB` Application ID is missing in your environment you will need to have an administrator of your tenant run the following command to add the `Azure Cosmos DB` Application ID to your tenant:

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread

        example_resource_group = azure.core.ResourceGroup("example",
            name="accexample-rg",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            address_spaces=["10.0.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example_resource_group.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"])
        example = azuread.get_service_principal(display_name="Azure Cosmos DB")
        example_assignment = azure.authorization.Assignment("example",
            scope=example_virtual_network.id,
            role_definition_name="Network Contributor",
            principal_id=example.object_id)
        example_cassandra_cluster = azure.cosmosdb.CassandraCluster("example",
            name="example-cluster",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            delegated_management_subnet_id=example_subnet.id,
            default_admin_password="Password1234",
            opts = pulumi.ResourceOptions(depends_on=[example_assignment]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DocumentDB` - 2023-04-15

        ## Import

        Cassandra Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cosmosdb/cassandraCluster:CassandraCluster example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.DocumentDB/cassandraClusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authentication_method: The authentication method that is used to authenticate clients. Possible values are `None` and `Cassandra`. Defaults to `Cassandra`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] client_certificate_pems: A list of TLS certificates that is used to authorize client connecting to the Cassandra Cluster.
        :param pulumi.Input[_builtins.str] default_admin_password: The initial admin password for this Cassandra Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] delegated_management_subnet_id: The ID of the delegated management subnet for this Cassandra Cluster. Changing this forces a new Cassandra Cluster to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_gossip_certificate_pems: A list of TLS certificates that is used to authorize gossip from unmanaged Cassandra Data Center.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_seed_node_ip_addresses: A list of IP Addresses of the seed nodes in unmanaged the Cassandra Data Center which will be added to the seed node lists of all managed nodes.
        :param pulumi.Input[_builtins.int] hours_between_backups: The number of hours to wait between taking a backup of the Cassandra Cluster. Defaults to `24`.
               
               > **Note:** To disable this feature, set this property to `0`.
        :param pulumi.Input[Union['CassandraClusterIdentityArgs', 'CassandraClusterIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Cassandra Cluster should exist. Changing this forces a new Cassandra Cluster to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Cassandra Cluster. Changing this forces a new Cassandra Cluster to be created.
        :param pulumi.Input[_builtins.bool] repair_enabled: Is the automatic repair enabled on the Cassandra Cluster? Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Cassandra Cluster should exist. Changing this forces a new Cassandra Cluster to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags assigned to the resource.
        :param pulumi.Input[_builtins.str] version: The version of Cassandra what the Cluster converges to run. Possible values are `3.11` and `4.0`. Defaults to `3.11`. Changing this forces a new Cassandra Cluster to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CassandraClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Cassandra Cluster.

        > **Note:** In order for the `Azure Managed Instances for Apache Cassandra` to work properly the product requires the `Azure Cosmos DB` Application ID to be present and working in your tenant. If the `Azure Cosmos DB` Application ID is missing in your environment you will need to have an administrator of your tenant run the following command to add the `Azure Cosmos DB` Application ID to your tenant:

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread

        example_resource_group = azure.core.ResourceGroup("example",
            name="accexample-rg",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            address_spaces=["10.0.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example_resource_group.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"])
        example = azuread.get_service_principal(display_name="Azure Cosmos DB")
        example_assignment = azure.authorization.Assignment("example",
            scope=example_virtual_network.id,
            role_definition_name="Network Contributor",
            principal_id=example.object_id)
        example_cassandra_cluster = azure.cosmosdb.CassandraCluster("example",
            name="example-cluster",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            delegated_management_subnet_id=example_subnet.id,
            default_admin_password="Password1234",
            opts = pulumi.ResourceOptions(depends_on=[example_assignment]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DocumentDB` - 2023-04-15

        ## Import

        Cassandra Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cosmosdb/cassandraCluster:CassandraCluster example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.DocumentDB/cassandraClusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param CassandraClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CassandraClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_method: Optional[pulumi.Input[_builtins.str]] = None,
                 client_certificate_pems: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 default_admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 delegated_management_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 external_gossip_certificate_pems: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 external_seed_node_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hours_between_backups: Optional[pulumi.Input[_builtins.int]] = None,
                 identity: Optional[pulumi.Input[Union['CassandraClusterIdentityArgs', 'CassandraClusterIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 repair_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CassandraClusterArgs.__new__(CassandraClusterArgs)

            __props__.__dict__["authentication_method"] = authentication_method
            __props__.__dict__["client_certificate_pems"] = client_certificate_pems
            if default_admin_password is None and not opts.urn:
                raise TypeError("Missing required property 'default_admin_password'")
            __props__.__dict__["default_admin_password"] = None if default_admin_password is None else pulumi.Output.secret(default_admin_password)
            if delegated_management_subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'delegated_management_subnet_id'")
            __props__.__dict__["delegated_management_subnet_id"] = delegated_management_subnet_id
            __props__.__dict__["external_gossip_certificate_pems"] = external_gossip_certificate_pems
            __props__.__dict__["external_seed_node_ip_addresses"] = external_seed_node_ip_addresses
            __props__.__dict__["hours_between_backups"] = hours_between_backups
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["repair_enabled"] = repair_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["version"] = version
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["defaultAdminPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(CassandraCluster, __self__).__init__(
            'azure:cosmosdb/cassandraCluster:CassandraCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_method: Optional[pulumi.Input[_builtins.str]] = None,
            client_certificate_pems: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            default_admin_password: Optional[pulumi.Input[_builtins.str]] = None,
            delegated_management_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            external_gossip_certificate_pems: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            external_seed_node_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            hours_between_backups: Optional[pulumi.Input[_builtins.int]] = None,
            identity: Optional[pulumi.Input[Union['CassandraClusterIdentityArgs', 'CassandraClusterIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            repair_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'CassandraCluster':
        """
        Get an existing CassandraCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authentication_method: The authentication method that is used to authenticate clients. Possible values are `None` and `Cassandra`. Defaults to `Cassandra`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] client_certificate_pems: A list of TLS certificates that is used to authorize client connecting to the Cassandra Cluster.
        :param pulumi.Input[_builtins.str] default_admin_password: The initial admin password for this Cassandra Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] delegated_management_subnet_id: The ID of the delegated management subnet for this Cassandra Cluster. Changing this forces a new Cassandra Cluster to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_gossip_certificate_pems: A list of TLS certificates that is used to authorize gossip from unmanaged Cassandra Data Center.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] external_seed_node_ip_addresses: A list of IP Addresses of the seed nodes in unmanaged the Cassandra Data Center which will be added to the seed node lists of all managed nodes.
        :param pulumi.Input[_builtins.int] hours_between_backups: The number of hours to wait between taking a backup of the Cassandra Cluster. Defaults to `24`.
               
               > **Note:** To disable this feature, set this property to `0`.
        :param pulumi.Input[Union['CassandraClusterIdentityArgs', 'CassandraClusterIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Cassandra Cluster should exist. Changing this forces a new Cassandra Cluster to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Cassandra Cluster. Changing this forces a new Cassandra Cluster to be created.
        :param pulumi.Input[_builtins.bool] repair_enabled: Is the automatic repair enabled on the Cassandra Cluster? Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Cassandra Cluster should exist. Changing this forces a new Cassandra Cluster to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags assigned to the resource.
        :param pulumi.Input[_builtins.str] version: The version of Cassandra what the Cluster converges to run. Possible values are `3.11` and `4.0`. Defaults to `3.11`. Changing this forces a new Cassandra Cluster to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CassandraClusterState.__new__(_CassandraClusterState)

        __props__.__dict__["authentication_method"] = authentication_method
        __props__.__dict__["client_certificate_pems"] = client_certificate_pems
        __props__.__dict__["default_admin_password"] = default_admin_password
        __props__.__dict__["delegated_management_subnet_id"] = delegated_management_subnet_id
        __props__.__dict__["external_gossip_certificate_pems"] = external_gossip_certificate_pems
        __props__.__dict__["external_seed_node_ip_addresses"] = external_seed_node_ip_addresses
        __props__.__dict__["hours_between_backups"] = hours_between_backups
        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["repair_enabled"] = repair_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["version"] = version
        return CassandraCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The authentication method that is used to authenticate clients. Possible values are `None` and `Cassandra`. Defaults to `Cassandra`.
        """
        return pulumi.get(self, "authentication_method")

    @_builtins.property
    @pulumi.getter(name="clientCertificatePems")
    def client_certificate_pems(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of TLS certificates that is used to authorize client connecting to the Cassandra Cluster.
        """
        return pulumi.get(self, "client_certificate_pems")

    @_builtins.property
    @pulumi.getter(name="defaultAdminPassword")
    def default_admin_password(self) -> pulumi.Output[_builtins.str]:
        """
        The initial admin password for this Cassandra Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "default_admin_password")

    @_builtins.property
    @pulumi.getter(name="delegatedManagementSubnetId")
    def delegated_management_subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the delegated management subnet for this Cassandra Cluster. Changing this forces a new Cassandra Cluster to be created.
        """
        return pulumi.get(self, "delegated_management_subnet_id")

    @_builtins.property
    @pulumi.getter(name="externalGossipCertificatePems")
    def external_gossip_certificate_pems(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of TLS certificates that is used to authorize gossip from unmanaged Cassandra Data Center.
        """
        return pulumi.get(self, "external_gossip_certificate_pems")

    @_builtins.property
    @pulumi.getter(name="externalSeedNodeIpAddresses")
    def external_seed_node_ip_addresses(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of IP Addresses of the seed nodes in unmanaged the Cassandra Data Center which will be added to the seed node lists of all managed nodes.
        """
        return pulumi.get(self, "external_seed_node_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="hoursBetweenBackups")
    def hours_between_backups(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of hours to wait between taking a backup of the Cassandra Cluster. Defaults to `24`.

        > **Note:** To disable this feature, set this property to `0`.
        """
        return pulumi.get(self, "hours_between_backups")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.CassandraClusterIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Cassandra Cluster should exist. Changing this forces a new Cassandra Cluster to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Cassandra Cluster. Changing this forces a new Cassandra Cluster to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="repairEnabled")
    def repair_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is the automatic repair enabled on the Cassandra Cluster? Defaults to `true`.
        """
        return pulumi.get(self, "repair_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Cassandra Cluster should exist. Changing this forces a new Cassandra Cluster to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The version of Cassandra what the Cluster converges to run. Possible values are `3.11` and `4.0`. Defaults to `3.11`. Changing this forces a new Cassandra Cluster to be created.
        """
        return pulumi.get(self, "version")

