# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SqlTriggerArgs', 'SqlTrigger']

@pulumi.input_type
class SqlTriggerArgs:
    def __init__(__self__, *,
                 body: pulumi.Input[_builtins.str],
                 container_id: pulumi.Input[_builtins.str],
                 operation: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SqlTrigger resource.
        :param pulumi.Input[_builtins.str] body: Body of the Trigger.
        :param pulumi.Input[_builtins.str] container_id: The id of the Cosmos DB SQL Container to create the SQL Trigger within. Changing this forces a new SQL Trigger to be created.
        :param pulumi.Input[_builtins.str] operation: The operation the trigger is associated with. Possible values are `All`, `Create`, `Update`, `Delete` and `Replace`.
        :param pulumi.Input[_builtins.str] type: Type of the Trigger. Possible values are `Pre` and `Post`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this SQL Trigger. Changing this forces a new SQL Trigger to be created.
        """
        pulumi.set(__self__, "body", body)
        pulumi.set(__self__, "container_id", container_id)
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def body(self) -> pulumi.Input[_builtins.str]:
        """
        Body of the Trigger.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "body", value)

    @_builtins.property
    @pulumi.getter(name="containerId")
    def container_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the Cosmos DB SQL Container to create the SQL Trigger within. Changing this forces a new SQL Trigger to be created.
        """
        return pulumi.get(self, "container_id")

    @container_id.setter
    def container_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "container_id", value)

    @_builtins.property
    @pulumi.getter
    def operation(self) -> pulumi.Input[_builtins.str]:
        """
        The operation the trigger is associated with. Possible values are `All`, `Create`, `Update`, `Delete` and `Replace`.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "operation", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the Trigger. Possible values are `Pre` and `Post`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this SQL Trigger. Changing this forces a new SQL Trigger to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _SqlTriggerState:
    def __init__(__self__, *,
                 body: Optional[pulumi.Input[_builtins.str]] = None,
                 container_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 operation: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SqlTrigger resources.
        :param pulumi.Input[_builtins.str] body: Body of the Trigger.
        :param pulumi.Input[_builtins.str] container_id: The id of the Cosmos DB SQL Container to create the SQL Trigger within. Changing this forces a new SQL Trigger to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this SQL Trigger. Changing this forces a new SQL Trigger to be created.
        :param pulumi.Input[_builtins.str] operation: The operation the trigger is associated with. Possible values are `All`, `Create`, `Update`, `Delete` and `Replace`.
        :param pulumi.Input[_builtins.str] type: Type of the Trigger. Possible values are `Pre` and `Post`.
        """
        if body is not None:
            pulumi.set(__self__, "body", body)
        if container_id is not None:
            pulumi.set(__self__, "container_id", container_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Body of the Trigger.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "body", value)

    @_builtins.property
    @pulumi.getter(name="containerId")
    def container_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the Cosmos DB SQL Container to create the SQL Trigger within. Changing this forces a new SQL Trigger to be created.
        """
        return pulumi.get(self, "container_id")

    @container_id.setter
    def container_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this SQL Trigger. Changing this forces a new SQL Trigger to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def operation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operation the trigger is associated with. Possible values are `All`, `Create`, `Update`, `Delete` and `Replace`.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operation", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the Trigger. Possible values are `Pre` and `Post`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("azure:cosmosdb/sqlTrigger:SqlTrigger")
class SqlTrigger(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body: Optional[pulumi.Input[_builtins.str]] = None,
                 container_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 operation: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an SQL Trigger.

        ## Import

        SQL Triggers can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cosmosdb/sqlTrigger:SqlTrigger example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DocumentDB/databaseAccounts/account1/sqlDatabases/database1/containers/container1/triggers/trigger1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] body: Body of the Trigger.
        :param pulumi.Input[_builtins.str] container_id: The id of the Cosmos DB SQL Container to create the SQL Trigger within. Changing this forces a new SQL Trigger to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this SQL Trigger. Changing this forces a new SQL Trigger to be created.
        :param pulumi.Input[_builtins.str] operation: The operation the trigger is associated with. Possible values are `All`, `Create`, `Update`, `Delete` and `Replace`.
        :param pulumi.Input[_builtins.str] type: Type of the Trigger. Possible values are `Pre` and `Post`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SqlTriggerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an SQL Trigger.

        ## Import

        SQL Triggers can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cosmosdb/sqlTrigger:SqlTrigger example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DocumentDB/databaseAccounts/account1/sqlDatabases/database1/containers/container1/triggers/trigger1
        ```

        :param str resource_name: The name of the resource.
        :param SqlTriggerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SqlTriggerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body: Optional[pulumi.Input[_builtins.str]] = None,
                 container_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 operation: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SqlTriggerArgs.__new__(SqlTriggerArgs)

            if body is None and not opts.urn:
                raise TypeError("Missing required property 'body'")
            __props__.__dict__["body"] = body
            if container_id is None and not opts.urn:
                raise TypeError("Missing required property 'container_id'")
            __props__.__dict__["container_id"] = container_id
            __props__.__dict__["name"] = name
            if operation is None and not opts.urn:
                raise TypeError("Missing required property 'operation'")
            __props__.__dict__["operation"] = operation
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(SqlTrigger, __self__).__init__(
            'azure:cosmosdb/sqlTrigger:SqlTrigger',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            body: Optional[pulumi.Input[_builtins.str]] = None,
            container_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            operation: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'SqlTrigger':
        """
        Get an existing SqlTrigger resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] body: Body of the Trigger.
        :param pulumi.Input[_builtins.str] container_id: The id of the Cosmos DB SQL Container to create the SQL Trigger within. Changing this forces a new SQL Trigger to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this SQL Trigger. Changing this forces a new SQL Trigger to be created.
        :param pulumi.Input[_builtins.str] operation: The operation the trigger is associated with. Possible values are `All`, `Create`, `Update`, `Delete` and `Replace`.
        :param pulumi.Input[_builtins.str] type: Type of the Trigger. Possible values are `Pre` and `Post`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SqlTriggerState.__new__(_SqlTriggerState)

        __props__.__dict__["body"] = body
        __props__.__dict__["container_id"] = container_id
        __props__.__dict__["name"] = name
        __props__.__dict__["operation"] = operation
        __props__.__dict__["type"] = type
        return SqlTrigger(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def body(self) -> pulumi.Output[_builtins.str]:
        """
        Body of the Trigger.
        """
        return pulumi.get(self, "body")

    @_builtins.property
    @pulumi.getter(name="containerId")
    def container_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the Cosmos DB SQL Container to create the SQL Trigger within. Changing this forces a new SQL Trigger to be created.
        """
        return pulumi.get(self, "container_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this SQL Trigger. Changing this forces a new SQL Trigger to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> pulumi.Output[_builtins.str]:
        """
        The operation the trigger is associated with. Possible values are `All`, `Create`, `Update`, `Delete` and `Replace`.
        """
        return pulumi.get(self, "operation")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the Trigger. Possible values are `Pre` and `Post`.
        """
        return pulumi.get(self, "type")

