# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ScheduledActionArgs', 'ScheduledAction']

@pulumi.input_type
class ScheduledActionArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 email_address_sender: pulumi.Input[_builtins.str],
                 email_addresses: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 email_subject: pulumi.Input[_builtins.str],
                 end_date: pulumi.Input[_builtins.str],
                 frequency: pulumi.Input[_builtins.str],
                 start_date: pulumi.Input[_builtins.str],
                 view_id: pulumi.Input[_builtins.str],
                 day_of_month: Optional[pulumi.Input[_builtins.int]] = None,
                 days_of_weeks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hour_of_day: Optional[pulumi.Input[_builtins.int]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 weeks_of_months: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ScheduledAction resource.
        :param pulumi.Input[_builtins.str] display_name: User visible input name of the Cost Management Scheduled Action.
        :param pulumi.Input[_builtins.str] email_address_sender: Email address of the point of contact that should get the unsubscribe requests of Scheduled Action notification emails.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] email_addresses: Specifies a list of email addresses that will receive the Scheduled Action.
        :param pulumi.Input[_builtins.str] email_subject: Subject of the email. Length is limited to 70 characters.
        :param pulumi.Input[_builtins.str] end_date: The end date and time of the Scheduled Action (UTC).
        :param pulumi.Input[_builtins.str] frequency: Frequency of the schedule. Possible values are `Daily`, `Monthly` and `Weekly`. Value `Monthly` requires either `weeks_of_month` and `days_of_week` or `day_of_month` to be specified. Value `Weekly` requires `days_of_week` to be specified.
        :param pulumi.Input[_builtins.str] start_date: The start date and time of the Scheduled Action (UTC).
        :param pulumi.Input[_builtins.str] view_id: The ID of the Cost Management View that is used by the Scheduled Action. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] day_of_month: UTC day on which cost analysis data will be emailed. Must be between `1` and `31`. This property is applicable when `frequency` is `Monthly`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] days_of_weeks: Specifies a list of day names on which cost analysis data will be emailed. This property is applicable when frequency is `Weekly` or `Monthly`. Possible values are `Friday`, `Monday`, `Saturday`, `Sunday`, `Thursday`, `Tuesday` and `Wednesday`.
        :param pulumi.Input[_builtins.int] hour_of_day: UTC time at which cost analysis data will be emailed. Must be between `0` and `23`.
        :param pulumi.Input[_builtins.str] message: Message to be added in the email. Length is limited to 250 characters.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Cost Management Scheduled Action. Changing this forces a new Azure Cost Management Scheduled Action to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] weeks_of_months: Specifies a list of weeks in which cost analysis data will be emailed. This property is applicable when `frequency` is `Monthly` and used in combination with `days_of_week`. Possible values are `First`, `Fourth`, `Last`, `Second` and `Third`.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "email_address_sender", email_address_sender)
        pulumi.set(__self__, "email_addresses", email_addresses)
        pulumi.set(__self__, "email_subject", email_subject)
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "start_date", start_date)
        pulumi.set(__self__, "view_id", view_id)
        if day_of_month is not None:
            pulumi.set(__self__, "day_of_month", day_of_month)
        if days_of_weeks is not None:
            pulumi.set(__self__, "days_of_weeks", days_of_weeks)
        if hour_of_day is not None:
            pulumi.set(__self__, "hour_of_day", hour_of_day)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if weeks_of_months is not None:
            pulumi.set(__self__, "weeks_of_months", weeks_of_months)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        User visible input name of the Cost Management Scheduled Action.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="emailAddressSender")
    def email_address_sender(self) -> pulumi.Input[_builtins.str]:
        """
        Email address of the point of contact that should get the unsubscribe requests of Scheduled Action notification emails.
        """
        return pulumi.get(self, "email_address_sender")

    @email_address_sender.setter
    def email_address_sender(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "email_address_sender", value)

    @_builtins.property
    @pulumi.getter(name="emailAddresses")
    def email_addresses(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies a list of email addresses that will receive the Scheduled Action.
        """
        return pulumi.get(self, "email_addresses")

    @email_addresses.setter
    def email_addresses(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "email_addresses", value)

    @_builtins.property
    @pulumi.getter(name="emailSubject")
    def email_subject(self) -> pulumi.Input[_builtins.str]:
        """
        Subject of the email. Length is limited to 70 characters.
        """
        return pulumi.get(self, "email_subject")

    @email_subject.setter
    def email_subject(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "email_subject", value)

    @_builtins.property
    @pulumi.getter(name="endDate")
    def end_date(self) -> pulumi.Input[_builtins.str]:
        """
        The end date and time of the Scheduled Action (UTC).
        """
        return pulumi.get(self, "end_date")

    @end_date.setter
    def end_date(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "end_date", value)

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> pulumi.Input[_builtins.str]:
        """
        Frequency of the schedule. Possible values are `Daily`, `Monthly` and `Weekly`. Value `Monthly` requires either `weeks_of_month` and `days_of_week` or `day_of_month` to be specified. Value `Weekly` requires `days_of_week` to be specified.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "frequency", value)

    @_builtins.property
    @pulumi.getter(name="startDate")
    def start_date(self) -> pulumi.Input[_builtins.str]:
        """
        The start date and time of the Scheduled Action (UTC).
        """
        return pulumi.get(self, "start_date")

    @start_date.setter
    def start_date(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "start_date", value)

    @_builtins.property
    @pulumi.getter(name="viewId")
    def view_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Cost Management View that is used by the Scheduled Action. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "view_id")

    @view_id.setter
    def view_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "view_id", value)

    @_builtins.property
    @pulumi.getter(name="dayOfMonth")
    def day_of_month(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        UTC day on which cost analysis data will be emailed. Must be between `1` and `31`. This property is applicable when `frequency` is `Monthly`.
        """
        return pulumi.get(self, "day_of_month")

    @day_of_month.setter
    def day_of_month(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "day_of_month", value)

    @_builtins.property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of day names on which cost analysis data will be emailed. This property is applicable when frequency is `Weekly` or `Monthly`. Possible values are `Friday`, `Monday`, `Saturday`, `Sunday`, `Thursday`, `Tuesday` and `Wednesday`.
        """
        return pulumi.get(self, "days_of_weeks")

    @days_of_weeks.setter
    def days_of_weeks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "days_of_weeks", value)

    @_builtins.property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        UTC time at which cost analysis data will be emailed. Must be between `0` and `23`.
        """
        return pulumi.get(self, "hour_of_day")

    @hour_of_day.setter
    def hour_of_day(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hour_of_day", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Message to be added in the email. Length is limited to 250 characters.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Azure Cost Management Scheduled Action. Changing this forces a new Azure Cost Management Scheduled Action to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="weeksOfMonths")
    def weeks_of_months(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of weeks in which cost analysis data will be emailed. This property is applicable when `frequency` is `Monthly` and used in combination with `days_of_week`. Possible values are `First`, `Fourth`, `Last`, `Second` and `Third`.
        """
        return pulumi.get(self, "weeks_of_months")

    @weeks_of_months.setter
    def weeks_of_months(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "weeks_of_months", value)


@pulumi.input_type
class _ScheduledActionState:
    def __init__(__self__, *,
                 day_of_month: Optional[pulumi.Input[_builtins.int]] = None,
                 days_of_weeks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email_address_sender: Optional[pulumi.Input[_builtins.str]] = None,
                 email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 email_subject: Optional[pulumi.Input[_builtins.str]] = None,
                 end_date: Optional[pulumi.Input[_builtins.str]] = None,
                 frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 hour_of_day: Optional[pulumi.Input[_builtins.int]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 start_date: Optional[pulumi.Input[_builtins.str]] = None,
                 view_id: Optional[pulumi.Input[_builtins.str]] = None,
                 weeks_of_months: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ScheduledAction resources.
        :param pulumi.Input[_builtins.int] day_of_month: UTC day on which cost analysis data will be emailed. Must be between `1` and `31`. This property is applicable when `frequency` is `Monthly`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] days_of_weeks: Specifies a list of day names on which cost analysis data will be emailed. This property is applicable when frequency is `Weekly` or `Monthly`. Possible values are `Friday`, `Monday`, `Saturday`, `Sunday`, `Thursday`, `Tuesday` and `Wednesday`.
        :param pulumi.Input[_builtins.str] display_name: User visible input name of the Cost Management Scheduled Action.
        :param pulumi.Input[_builtins.str] email_address_sender: Email address of the point of contact that should get the unsubscribe requests of Scheduled Action notification emails.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] email_addresses: Specifies a list of email addresses that will receive the Scheduled Action.
        :param pulumi.Input[_builtins.str] email_subject: Subject of the email. Length is limited to 70 characters.
        :param pulumi.Input[_builtins.str] end_date: The end date and time of the Scheduled Action (UTC).
        :param pulumi.Input[_builtins.str] frequency: Frequency of the schedule. Possible values are `Daily`, `Monthly` and `Weekly`. Value `Monthly` requires either `weeks_of_month` and `days_of_week` or `day_of_month` to be specified. Value `Weekly` requires `days_of_week` to be specified.
        :param pulumi.Input[_builtins.int] hour_of_day: UTC time at which cost analysis data will be emailed. Must be between `0` and `23`.
        :param pulumi.Input[_builtins.str] message: Message to be added in the email. Length is limited to 250 characters.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Cost Management Scheduled Action. Changing this forces a new Azure Cost Management Scheduled Action to be created.
        :param pulumi.Input[_builtins.str] start_date: The start date and time of the Scheduled Action (UTC).
        :param pulumi.Input[_builtins.str] view_id: The ID of the Cost Management View that is used by the Scheduled Action. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] weeks_of_months: Specifies a list of weeks in which cost analysis data will be emailed. This property is applicable when `frequency` is `Monthly` and used in combination with `days_of_week`. Possible values are `First`, `Fourth`, `Last`, `Second` and `Third`.
        """
        if day_of_month is not None:
            pulumi.set(__self__, "day_of_month", day_of_month)
        if days_of_weeks is not None:
            pulumi.set(__self__, "days_of_weeks", days_of_weeks)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if email_address_sender is not None:
            pulumi.set(__self__, "email_address_sender", email_address_sender)
        if email_addresses is not None:
            pulumi.set(__self__, "email_addresses", email_addresses)
        if email_subject is not None:
            pulumi.set(__self__, "email_subject", email_subject)
        if end_date is not None:
            pulumi.set(__self__, "end_date", end_date)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if hour_of_day is not None:
            pulumi.set(__self__, "hour_of_day", hour_of_day)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if start_date is not None:
            pulumi.set(__self__, "start_date", start_date)
        if view_id is not None:
            pulumi.set(__self__, "view_id", view_id)
        if weeks_of_months is not None:
            pulumi.set(__self__, "weeks_of_months", weeks_of_months)

    @_builtins.property
    @pulumi.getter(name="dayOfMonth")
    def day_of_month(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        UTC day on which cost analysis data will be emailed. Must be between `1` and `31`. This property is applicable when `frequency` is `Monthly`.
        """
        return pulumi.get(self, "day_of_month")

    @day_of_month.setter
    def day_of_month(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "day_of_month", value)

    @_builtins.property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of day names on which cost analysis data will be emailed. This property is applicable when frequency is `Weekly` or `Monthly`. Possible values are `Friday`, `Monday`, `Saturday`, `Sunday`, `Thursday`, `Tuesday` and `Wednesday`.
        """
        return pulumi.get(self, "days_of_weeks")

    @days_of_weeks.setter
    def days_of_weeks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "days_of_weeks", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User visible input name of the Cost Management Scheduled Action.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="emailAddressSender")
    def email_address_sender(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email address of the point of contact that should get the unsubscribe requests of Scheduled Action notification emails.
        """
        return pulumi.get(self, "email_address_sender")

    @email_address_sender.setter
    def email_address_sender(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email_address_sender", value)

    @_builtins.property
    @pulumi.getter(name="emailAddresses")
    def email_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of email addresses that will receive the Scheduled Action.
        """
        return pulumi.get(self, "email_addresses")

    @email_addresses.setter
    def email_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "email_addresses", value)

    @_builtins.property
    @pulumi.getter(name="emailSubject")
    def email_subject(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subject of the email. Length is limited to 70 characters.
        """
        return pulumi.get(self, "email_subject")

    @email_subject.setter
    def email_subject(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email_subject", value)

    @_builtins.property
    @pulumi.getter(name="endDate")
    def end_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end date and time of the Scheduled Action (UTC).
        """
        return pulumi.get(self, "end_date")

    @end_date.setter
    def end_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_date", value)

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Frequency of the schedule. Possible values are `Daily`, `Monthly` and `Weekly`. Value `Monthly` requires either `weeks_of_month` and `days_of_week` or `day_of_month` to be specified. Value `Weekly` requires `days_of_week` to be specified.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "frequency", value)

    @_builtins.property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        UTC time at which cost analysis data will be emailed. Must be between `0` and `23`.
        """
        return pulumi.get(self, "hour_of_day")

    @hour_of_day.setter
    def hour_of_day(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hour_of_day", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Message to be added in the email. Length is limited to 250 characters.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Azure Cost Management Scheduled Action. Changing this forces a new Azure Cost Management Scheduled Action to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="startDate")
    def start_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The start date and time of the Scheduled Action (UTC).
        """
        return pulumi.get(self, "start_date")

    @start_date.setter
    def start_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_date", value)

    @_builtins.property
    @pulumi.getter(name="viewId")
    def view_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Cost Management View that is used by the Scheduled Action. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "view_id")

    @view_id.setter
    def view_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "view_id", value)

    @_builtins.property
    @pulumi.getter(name="weeksOfMonths")
    def weeks_of_months(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of weeks in which cost analysis data will be emailed. This property is applicable when `frequency` is `Monthly` and used in combination with `days_of_week`. Possible values are `First`, `Fourth`, `Last`, `Second` and `Third`.
        """
        return pulumi.get(self, "weeks_of_months")

    @weeks_of_months.setter
    def weeks_of_months(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "weeks_of_months", value)


@pulumi.type_token("azure:costmanagement/scheduledAction:ScheduledAction")
class ScheduledAction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 day_of_month: Optional[pulumi.Input[_builtins.int]] = None,
                 days_of_weeks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email_address_sender: Optional[pulumi.Input[_builtins.str]] = None,
                 email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 email_subject: Optional[pulumi.Input[_builtins.str]] = None,
                 end_date: Optional[pulumi.Input[_builtins.str]] = None,
                 frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 hour_of_day: Optional[pulumi.Input[_builtins.int]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 start_date: Optional[pulumi.Input[_builtins.str]] = None,
                 view_id: Optional[pulumi.Input[_builtins.str]] = None,
                 weeks_of_months: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Azure Cost Management Scheduled Action.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.costmanagement.ScheduledAction("example",
            name="examplescheduledaction",
            display_name="Report Last 6 Months",
            view_id="/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.CostManagement/views/ms:CostByService",
            email_address_sender="platformteam@test.com",
            email_subject="Cost Management Report",
            email_addresses=["example@example.com"],
            message="Hi all, take a look at last 6 months spending!",
            frequency="Daily",
            start_date="2023-01-02T00:00:00Z",
            end_date="2023-02-02T00:00:00Z")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.CostManagement` - 2023-08-01

        ## Import

        Azure Cost Management Scheduled Actions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:costmanagement/scheduledAction:ScheduledAction example /subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.CostManagement/scheduledActions/scheduledaction1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] day_of_month: UTC day on which cost analysis data will be emailed. Must be between `1` and `31`. This property is applicable when `frequency` is `Monthly`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] days_of_weeks: Specifies a list of day names on which cost analysis data will be emailed. This property is applicable when frequency is `Weekly` or `Monthly`. Possible values are `Friday`, `Monday`, `Saturday`, `Sunday`, `Thursday`, `Tuesday` and `Wednesday`.
        :param pulumi.Input[_builtins.str] display_name: User visible input name of the Cost Management Scheduled Action.
        :param pulumi.Input[_builtins.str] email_address_sender: Email address of the point of contact that should get the unsubscribe requests of Scheduled Action notification emails.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] email_addresses: Specifies a list of email addresses that will receive the Scheduled Action.
        :param pulumi.Input[_builtins.str] email_subject: Subject of the email. Length is limited to 70 characters.
        :param pulumi.Input[_builtins.str] end_date: The end date and time of the Scheduled Action (UTC).
        :param pulumi.Input[_builtins.str] frequency: Frequency of the schedule. Possible values are `Daily`, `Monthly` and `Weekly`. Value `Monthly` requires either `weeks_of_month` and `days_of_week` or `day_of_month` to be specified. Value `Weekly` requires `days_of_week` to be specified.
        :param pulumi.Input[_builtins.int] hour_of_day: UTC time at which cost analysis data will be emailed. Must be between `0` and `23`.
        :param pulumi.Input[_builtins.str] message: Message to be added in the email. Length is limited to 250 characters.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Cost Management Scheduled Action. Changing this forces a new Azure Cost Management Scheduled Action to be created.
        :param pulumi.Input[_builtins.str] start_date: The start date and time of the Scheduled Action (UTC).
        :param pulumi.Input[_builtins.str] view_id: The ID of the Cost Management View that is used by the Scheduled Action. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] weeks_of_months: Specifies a list of weeks in which cost analysis data will be emailed. This property is applicable when `frequency` is `Monthly` and used in combination with `days_of_week`. Possible values are `First`, `Fourth`, `Last`, `Second` and `Third`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScheduledActionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Cost Management Scheduled Action.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.costmanagement.ScheduledAction("example",
            name="examplescheduledaction",
            display_name="Report Last 6 Months",
            view_id="/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.CostManagement/views/ms:CostByService",
            email_address_sender="platformteam@test.com",
            email_subject="Cost Management Report",
            email_addresses=["example@example.com"],
            message="Hi all, take a look at last 6 months spending!",
            frequency="Daily",
            start_date="2023-01-02T00:00:00Z",
            end_date="2023-02-02T00:00:00Z")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.CostManagement` - 2023-08-01

        ## Import

        Azure Cost Management Scheduled Actions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:costmanagement/scheduledAction:ScheduledAction example /subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.CostManagement/scheduledActions/scheduledaction1
        ```

        :param str resource_name: The name of the resource.
        :param ScheduledActionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScheduledActionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 day_of_month: Optional[pulumi.Input[_builtins.int]] = None,
                 days_of_weeks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 email_address_sender: Optional[pulumi.Input[_builtins.str]] = None,
                 email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 email_subject: Optional[pulumi.Input[_builtins.str]] = None,
                 end_date: Optional[pulumi.Input[_builtins.str]] = None,
                 frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 hour_of_day: Optional[pulumi.Input[_builtins.int]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 start_date: Optional[pulumi.Input[_builtins.str]] = None,
                 view_id: Optional[pulumi.Input[_builtins.str]] = None,
                 weeks_of_months: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScheduledActionArgs.__new__(ScheduledActionArgs)

            __props__.__dict__["day_of_month"] = day_of_month
            __props__.__dict__["days_of_weeks"] = days_of_weeks
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if email_address_sender is None and not opts.urn:
                raise TypeError("Missing required property 'email_address_sender'")
            __props__.__dict__["email_address_sender"] = email_address_sender
            if email_addresses is None and not opts.urn:
                raise TypeError("Missing required property 'email_addresses'")
            __props__.__dict__["email_addresses"] = email_addresses
            if email_subject is None and not opts.urn:
                raise TypeError("Missing required property 'email_subject'")
            __props__.__dict__["email_subject"] = email_subject
            if end_date is None and not opts.urn:
                raise TypeError("Missing required property 'end_date'")
            __props__.__dict__["end_date"] = end_date
            if frequency is None and not opts.urn:
                raise TypeError("Missing required property 'frequency'")
            __props__.__dict__["frequency"] = frequency
            __props__.__dict__["hour_of_day"] = hour_of_day
            __props__.__dict__["message"] = message
            __props__.__dict__["name"] = name
            if start_date is None and not opts.urn:
                raise TypeError("Missing required property 'start_date'")
            __props__.__dict__["start_date"] = start_date
            if view_id is None and not opts.urn:
                raise TypeError("Missing required property 'view_id'")
            __props__.__dict__["view_id"] = view_id
            __props__.__dict__["weeks_of_months"] = weeks_of_months
        super(ScheduledAction, __self__).__init__(
            'azure:costmanagement/scheduledAction:ScheduledAction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            day_of_month: Optional[pulumi.Input[_builtins.int]] = None,
            days_of_weeks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            email_address_sender: Optional[pulumi.Input[_builtins.str]] = None,
            email_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            email_subject: Optional[pulumi.Input[_builtins.str]] = None,
            end_date: Optional[pulumi.Input[_builtins.str]] = None,
            frequency: Optional[pulumi.Input[_builtins.str]] = None,
            hour_of_day: Optional[pulumi.Input[_builtins.int]] = None,
            message: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            start_date: Optional[pulumi.Input[_builtins.str]] = None,
            view_id: Optional[pulumi.Input[_builtins.str]] = None,
            weeks_of_months: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'ScheduledAction':
        """
        Get an existing ScheduledAction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] day_of_month: UTC day on which cost analysis data will be emailed. Must be between `1` and `31`. This property is applicable when `frequency` is `Monthly`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] days_of_weeks: Specifies a list of day names on which cost analysis data will be emailed. This property is applicable when frequency is `Weekly` or `Monthly`. Possible values are `Friday`, `Monday`, `Saturday`, `Sunday`, `Thursday`, `Tuesday` and `Wednesday`.
        :param pulumi.Input[_builtins.str] display_name: User visible input name of the Cost Management Scheduled Action.
        :param pulumi.Input[_builtins.str] email_address_sender: Email address of the point of contact that should get the unsubscribe requests of Scheduled Action notification emails.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] email_addresses: Specifies a list of email addresses that will receive the Scheduled Action.
        :param pulumi.Input[_builtins.str] email_subject: Subject of the email. Length is limited to 70 characters.
        :param pulumi.Input[_builtins.str] end_date: The end date and time of the Scheduled Action (UTC).
        :param pulumi.Input[_builtins.str] frequency: Frequency of the schedule. Possible values are `Daily`, `Monthly` and `Weekly`. Value `Monthly` requires either `weeks_of_month` and `days_of_week` or `day_of_month` to be specified. Value `Weekly` requires `days_of_week` to be specified.
        :param pulumi.Input[_builtins.int] hour_of_day: UTC time at which cost analysis data will be emailed. Must be between `0` and `23`.
        :param pulumi.Input[_builtins.str] message: Message to be added in the email. Length is limited to 250 characters.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Cost Management Scheduled Action. Changing this forces a new Azure Cost Management Scheduled Action to be created.
        :param pulumi.Input[_builtins.str] start_date: The start date and time of the Scheduled Action (UTC).
        :param pulumi.Input[_builtins.str] view_id: The ID of the Cost Management View that is used by the Scheduled Action. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] weeks_of_months: Specifies a list of weeks in which cost analysis data will be emailed. This property is applicable when `frequency` is `Monthly` and used in combination with `days_of_week`. Possible values are `First`, `Fourth`, `Last`, `Second` and `Third`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScheduledActionState.__new__(_ScheduledActionState)

        __props__.__dict__["day_of_month"] = day_of_month
        __props__.__dict__["days_of_weeks"] = days_of_weeks
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["email_address_sender"] = email_address_sender
        __props__.__dict__["email_addresses"] = email_addresses
        __props__.__dict__["email_subject"] = email_subject
        __props__.__dict__["end_date"] = end_date
        __props__.__dict__["frequency"] = frequency
        __props__.__dict__["hour_of_day"] = hour_of_day
        __props__.__dict__["message"] = message
        __props__.__dict__["name"] = name
        __props__.__dict__["start_date"] = start_date
        __props__.__dict__["view_id"] = view_id
        __props__.__dict__["weeks_of_months"] = weeks_of_months
        return ScheduledAction(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dayOfMonth")
    def day_of_month(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        UTC day on which cost analysis data will be emailed. Must be between `1` and `31`. This property is applicable when `frequency` is `Monthly`.
        """
        return pulumi.get(self, "day_of_month")

    @_builtins.property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of day names on which cost analysis data will be emailed. This property is applicable when frequency is `Weekly` or `Monthly`. Possible values are `Friday`, `Monday`, `Saturday`, `Sunday`, `Thursday`, `Tuesday` and `Wednesday`.
        """
        return pulumi.get(self, "days_of_weeks")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        User visible input name of the Cost Management Scheduled Action.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="emailAddressSender")
    def email_address_sender(self) -> pulumi.Output[_builtins.str]:
        """
        Email address of the point of contact that should get the unsubscribe requests of Scheduled Action notification emails.
        """
        return pulumi.get(self, "email_address_sender")

    @_builtins.property
    @pulumi.getter(name="emailAddresses")
    def email_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies a list of email addresses that will receive the Scheduled Action.
        """
        return pulumi.get(self, "email_addresses")

    @_builtins.property
    @pulumi.getter(name="emailSubject")
    def email_subject(self) -> pulumi.Output[_builtins.str]:
        """
        Subject of the email. Length is limited to 70 characters.
        """
        return pulumi.get(self, "email_subject")

    @_builtins.property
    @pulumi.getter(name="endDate")
    def end_date(self) -> pulumi.Output[_builtins.str]:
        """
        The end date and time of the Scheduled Action (UTC).
        """
        return pulumi.get(self, "end_date")

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> pulumi.Output[_builtins.str]:
        """
        Frequency of the schedule. Possible values are `Daily`, `Monthly` and `Weekly`. Value `Monthly` requires either `weeks_of_month` and `days_of_week` or `day_of_month` to be specified. Value `Weekly` requires `days_of_week` to be specified.
        """
        return pulumi.get(self, "frequency")

    @_builtins.property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        UTC time at which cost analysis data will be emailed. Must be between `0` and `23`.
        """
        return pulumi.get(self, "hour_of_day")

    @_builtins.property
    @pulumi.getter
    def message(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Message to be added in the email. Length is limited to 250 characters.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Azure Cost Management Scheduled Action. Changing this forces a new Azure Cost Management Scheduled Action to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="startDate")
    def start_date(self) -> pulumi.Output[_builtins.str]:
        """
        The start date and time of the Scheduled Action (UTC).
        """
        return pulumi.get(self, "start_date")

    @_builtins.property
    @pulumi.getter(name="viewId")
    def view_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Cost Management View that is used by the Scheduled Action. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "view_id")

    @_builtins.property
    @pulumi.getter(name="weeksOfMonths")
    def weeks_of_months(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of weeks in which cost analysis data will be emailed. This property is applicable when `frequency` is `Monthly` and used in combination with `days_of_week`. Possible values are `First`, `Fourth`, `Last`, `Second` and `Third`.
        """
        return pulumi.get(self, "weeks_of_months")

