# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'DeviceDevicePropertyArgs',
    'DeviceDevicePropertyArgsDict',
]

MYPY = False

if not MYPY:
    class DeviceDevicePropertyArgsDict(TypedDict):
        capacity: NotRequired[pulumi.Input[_builtins.int]]
        """
        The Data Box Edge/Gateway device local capacity in MB.
        """
        configured_role_types: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Type of compute roles configured.
        """
        culture: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Data Box Edge/Gateway device culture.
        """
        hcs_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        The device software version number of the device (e.g. 1.2.18105.6).
        """
        model: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Data Box Edge/Gateway device model.
        """
        node_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of nodes in the cluster.
        """
        serial_number: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Serial Number of Data Box Edge/Gateway device.
        """
        software_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Data Box Edge/Gateway device software version.
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        The status of the Data Box Edge/Gateway device.
        """
        time_zone: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Data Box Edge/Gateway device timezone.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type of the Data Box Edge/Gateway device.
        """
elif False:
    DeviceDevicePropertyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceDevicePropertyArgs:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 configured_role_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 culture: Optional[pulumi.Input[_builtins.str]] = None,
                 hcs_version: Optional[pulumi.Input[_builtins.str]] = None,
                 model: Optional[pulumi.Input[_builtins.str]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 serial_number: Optional[pulumi.Input[_builtins.str]] = None,
                 software_version: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] capacity: The Data Box Edge/Gateway device local capacity in MB.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] configured_role_types: Type of compute roles configured.
        :param pulumi.Input[_builtins.str] culture: The Data Box Edge/Gateway device culture.
        :param pulumi.Input[_builtins.str] hcs_version: The device software version number of the device (e.g. 1.2.18105.6).
        :param pulumi.Input[_builtins.str] model: The Data Box Edge/Gateway device model.
        :param pulumi.Input[_builtins.int] node_count: The number of nodes in the cluster.
        :param pulumi.Input[_builtins.str] serial_number: The Serial Number of Data Box Edge/Gateway device.
        :param pulumi.Input[_builtins.str] software_version: The Data Box Edge/Gateway device software version.
        :param pulumi.Input[_builtins.str] status: The status of the Data Box Edge/Gateway device.
        :param pulumi.Input[_builtins.str] time_zone: The Data Box Edge/Gateway device timezone.
        :param pulumi.Input[_builtins.str] type: The type of the Data Box Edge/Gateway device.
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if configured_role_types is not None:
            pulumi.set(__self__, "configured_role_types", configured_role_types)
        if culture is not None:
            pulumi.set(__self__, "culture", culture)
        if hcs_version is not None:
            pulumi.set(__self__, "hcs_version", hcs_version)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if software_version is not None:
            pulumi.set(__self__, "software_version", software_version)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Data Box Edge/Gateway device local capacity in MB.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter(name="configuredRoleTypes")
    def configured_role_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Type of compute roles configured.
        """
        return pulumi.get(self, "configured_role_types")

    @configured_role_types.setter
    def configured_role_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "configured_role_types", value)

    @_builtins.property
    @pulumi.getter
    def culture(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Data Box Edge/Gateway device culture.
        """
        return pulumi.get(self, "culture")

    @culture.setter
    def culture(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "culture", value)

    @_builtins.property
    @pulumi.getter(name="hcsVersion")
    def hcs_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The device software version number of the device (e.g. 1.2.18105.6).
        """
        return pulumi.get(self, "hcs_version")

    @hcs_version.setter
    def hcs_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hcs_version", value)

    @_builtins.property
    @pulumi.getter
    def model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Data Box Edge/Gateway device model.
        """
        return pulumi.get(self, "model")

    @model.setter
    def model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model", value)

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of nodes in the cluster.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_count", value)

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Serial Number of Data Box Edge/Gateway device.
        """
        return pulumi.get(self, "serial_number")

    @serial_number.setter
    def serial_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serial_number", value)

    @_builtins.property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Data Box Edge/Gateway device software version.
        """
        return pulumi.get(self, "software_version")

    @software_version.setter
    def software_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "software_version", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Data Box Edge/Gateway device.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Data Box Edge/Gateway device timezone.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the Data Box Edge/Gateway device.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


