# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LinkedServiceAzureDatabricksArgs', 'LinkedServiceAzureDatabricks']

@pulumi.input_type
class LinkedServiceAzureDatabricksArgs:
    def __init__(__self__, *,
                 adb_domain: pulumi.Input[_builtins.str],
                 data_factory_id: pulumi.Input[_builtins.str],
                 access_token: Optional[pulumi.Input[_builtins.str]] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 existing_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_pool: Optional[pulumi.Input['LinkedServiceAzureDatabricksInstancePoolArgs']] = None,
                 integration_runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_password: Optional[pulumi.Input['LinkedServiceAzureDatabricksKeyVaultPasswordArgs']] = None,
                 msi_work_space_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 new_cluster_config: Optional[pulumi.Input['LinkedServiceAzureDatabricksNewClusterConfigArgs']] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a LinkedServiceAzureDatabricks resource.
        :param pulumi.Input[_builtins.str] adb_domain: The domain URL of the databricks instance.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] access_token: Authenticate to ADB via an access token.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Linked Service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] existing_cluster_id: The cluster_id of an existing cluster within the linked ADB instance.
        :param pulumi.Input['LinkedServiceAzureDatabricksInstancePoolArgs'] instance_pool: Leverages an instance pool within the linked ADB instance as one `instance_pool` block defined below.
        :param pulumi.Input[_builtins.str] integration_runtime_name: The integration runtime reference to associate with the Data Factory Linked Service.
        :param pulumi.Input['LinkedServiceAzureDatabricksKeyVaultPasswordArgs'] key_vault_password: Authenticate to ADB via Azure Key Vault Linked Service as defined in the `key_vault_password` block below.
        :param pulumi.Input[_builtins.str] msi_work_space_resource_id: Authenticate to ADB via managed service identity.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input['LinkedServiceAzureDatabricksNewClusterConfigArgs'] new_cluster_config: Creates new clusters within the linked ADB instance as defined in the `new_cluster_config` block below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Linked Service.
        """
        pulumi.set(__self__, "adb_domain", adb_domain)
        pulumi.set(__self__, "data_factory_id", data_factory_id)
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if existing_cluster_id is not None:
            pulumi.set(__self__, "existing_cluster_id", existing_cluster_id)
        if instance_pool is not None:
            pulumi.set(__self__, "instance_pool", instance_pool)
        if integration_runtime_name is not None:
            pulumi.set(__self__, "integration_runtime_name", integration_runtime_name)
        if key_vault_password is not None:
            pulumi.set(__self__, "key_vault_password", key_vault_password)
        if msi_work_space_resource_id is not None:
            pulumi.set(__self__, "msi_work_space_resource_id", msi_work_space_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_cluster_config is not None:
            pulumi.set(__self__, "new_cluster_config", new_cluster_config)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @_builtins.property
    @pulumi.getter(name="adbDomain")
    def adb_domain(self) -> pulumi.Input[_builtins.str]:
        """
        The domain URL of the databricks instance.
        """
        return pulumi.get(self, "adb_domain")

    @adb_domain.setter
    def adb_domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "adb_domain", value)

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_factory_id", value)

    @_builtins.property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authenticate to ADB via an access token.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_token", value)

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of additional properties to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "additional_properties")

    @additional_properties.setter
    def additional_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_properties", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags that can be used for describing the Data Factory Linked Service.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the Data Factory Linked Service.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="existingClusterId")
    def existing_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster_id of an existing cluster within the linked ADB instance.
        """
        return pulumi.get(self, "existing_cluster_id")

    @existing_cluster_id.setter
    def existing_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "existing_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="instancePool")
    def instance_pool(self) -> Optional[pulumi.Input['LinkedServiceAzureDatabricksInstancePoolArgs']]:
        """
        Leverages an instance pool within the linked ADB instance as one `instance_pool` block defined below.
        """
        return pulumi.get(self, "instance_pool")

    @instance_pool.setter
    def instance_pool(self, value: Optional[pulumi.Input['LinkedServiceAzureDatabricksInstancePoolArgs']]):
        pulumi.set(self, "instance_pool", value)

    @_builtins.property
    @pulumi.getter(name="integrationRuntimeName")
    def integration_runtime_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The integration runtime reference to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "integration_runtime_name")

    @integration_runtime_name.setter
    def integration_runtime_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "integration_runtime_name", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultPassword")
    def key_vault_password(self) -> Optional[pulumi.Input['LinkedServiceAzureDatabricksKeyVaultPasswordArgs']]:
        """
        Authenticate to ADB via Azure Key Vault Linked Service as defined in the `key_vault_password` block below.
        """
        return pulumi.get(self, "key_vault_password")

    @key_vault_password.setter
    def key_vault_password(self, value: Optional[pulumi.Input['LinkedServiceAzureDatabricksKeyVaultPasswordArgs']]):
        pulumi.set(self, "key_vault_password", value)

    @_builtins.property
    @pulumi.getter(name="msiWorkSpaceResourceId")
    def msi_work_space_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authenticate to ADB via managed service identity.
        """
        return pulumi.get(self, "msi_work_space_resource_id")

    @msi_work_space_resource_id.setter
    def msi_work_space_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "msi_work_space_resource_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="newClusterConfig")
    def new_cluster_config(self) -> Optional[pulumi.Input['LinkedServiceAzureDatabricksNewClusterConfigArgs']]:
        """
        Creates new clusters within the linked ADB instance as defined in the `new_cluster_config` block below.
        """
        return pulumi.get(self, "new_cluster_config")

    @new_cluster_config.setter
    def new_cluster_config(self, value: Optional[pulumi.Input['LinkedServiceAzureDatabricksNewClusterConfigArgs']]):
        pulumi.set(self, "new_cluster_config", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of parameters to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class _LinkedServiceAzureDatabricksState:
    def __init__(__self__, *,
                 access_token: Optional[pulumi.Input[_builtins.str]] = None,
                 adb_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 existing_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_pool: Optional[pulumi.Input['LinkedServiceAzureDatabricksInstancePoolArgs']] = None,
                 integration_runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_password: Optional[pulumi.Input['LinkedServiceAzureDatabricksKeyVaultPasswordArgs']] = None,
                 msi_work_space_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 new_cluster_config: Optional[pulumi.Input['LinkedServiceAzureDatabricksNewClusterConfigArgs']] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering LinkedServiceAzureDatabricks resources.
        :param pulumi.Input[_builtins.str] access_token: Authenticate to ADB via an access token.
        :param pulumi.Input[_builtins.str] adb_domain: The domain URL of the databricks instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Linked Service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] existing_cluster_id: The cluster_id of an existing cluster within the linked ADB instance.
        :param pulumi.Input['LinkedServiceAzureDatabricksInstancePoolArgs'] instance_pool: Leverages an instance pool within the linked ADB instance as one `instance_pool` block defined below.
        :param pulumi.Input[_builtins.str] integration_runtime_name: The integration runtime reference to associate with the Data Factory Linked Service.
        :param pulumi.Input['LinkedServiceAzureDatabricksKeyVaultPasswordArgs'] key_vault_password: Authenticate to ADB via Azure Key Vault Linked Service as defined in the `key_vault_password` block below.
        :param pulumi.Input[_builtins.str] msi_work_space_resource_id: Authenticate to ADB via managed service identity.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input['LinkedServiceAzureDatabricksNewClusterConfigArgs'] new_cluster_config: Creates new clusters within the linked ADB instance as defined in the `new_cluster_config` block below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Linked Service.
        """
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if adb_domain is not None:
            pulumi.set(__self__, "adb_domain", adb_domain)
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if data_factory_id is not None:
            pulumi.set(__self__, "data_factory_id", data_factory_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if existing_cluster_id is not None:
            pulumi.set(__self__, "existing_cluster_id", existing_cluster_id)
        if instance_pool is not None:
            pulumi.set(__self__, "instance_pool", instance_pool)
        if integration_runtime_name is not None:
            pulumi.set(__self__, "integration_runtime_name", integration_runtime_name)
        if key_vault_password is not None:
            pulumi.set(__self__, "key_vault_password", key_vault_password)
        if msi_work_space_resource_id is not None:
            pulumi.set(__self__, "msi_work_space_resource_id", msi_work_space_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_cluster_config is not None:
            pulumi.set(__self__, "new_cluster_config", new_cluster_config)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @_builtins.property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authenticate to ADB via an access token.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_token", value)

    @_builtins.property
    @pulumi.getter(name="adbDomain")
    def adb_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain URL of the databricks instance.
        """
        return pulumi.get(self, "adb_domain")

    @adb_domain.setter
    def adb_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "adb_domain", value)

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of additional properties to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "additional_properties")

    @additional_properties.setter
    def additional_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_properties", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags that can be used for describing the Data Factory Linked Service.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_factory_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the Data Factory Linked Service.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="existingClusterId")
    def existing_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster_id of an existing cluster within the linked ADB instance.
        """
        return pulumi.get(self, "existing_cluster_id")

    @existing_cluster_id.setter
    def existing_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "existing_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="instancePool")
    def instance_pool(self) -> Optional[pulumi.Input['LinkedServiceAzureDatabricksInstancePoolArgs']]:
        """
        Leverages an instance pool within the linked ADB instance as one `instance_pool` block defined below.
        """
        return pulumi.get(self, "instance_pool")

    @instance_pool.setter
    def instance_pool(self, value: Optional[pulumi.Input['LinkedServiceAzureDatabricksInstancePoolArgs']]):
        pulumi.set(self, "instance_pool", value)

    @_builtins.property
    @pulumi.getter(name="integrationRuntimeName")
    def integration_runtime_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The integration runtime reference to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "integration_runtime_name")

    @integration_runtime_name.setter
    def integration_runtime_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "integration_runtime_name", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultPassword")
    def key_vault_password(self) -> Optional[pulumi.Input['LinkedServiceAzureDatabricksKeyVaultPasswordArgs']]:
        """
        Authenticate to ADB via Azure Key Vault Linked Service as defined in the `key_vault_password` block below.
        """
        return pulumi.get(self, "key_vault_password")

    @key_vault_password.setter
    def key_vault_password(self, value: Optional[pulumi.Input['LinkedServiceAzureDatabricksKeyVaultPasswordArgs']]):
        pulumi.set(self, "key_vault_password", value)

    @_builtins.property
    @pulumi.getter(name="msiWorkSpaceResourceId")
    def msi_work_space_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authenticate to ADB via managed service identity.
        """
        return pulumi.get(self, "msi_work_space_resource_id")

    @msi_work_space_resource_id.setter
    def msi_work_space_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "msi_work_space_resource_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="newClusterConfig")
    def new_cluster_config(self) -> Optional[pulumi.Input['LinkedServiceAzureDatabricksNewClusterConfigArgs']]:
        """
        Creates new clusters within the linked ADB instance as defined in the `new_cluster_config` block below.
        """
        return pulumi.get(self, "new_cluster_config")

    @new_cluster_config.setter
    def new_cluster_config(self, value: Optional[pulumi.Input['LinkedServiceAzureDatabricksNewClusterConfigArgs']]):
        pulumi.set(self, "new_cluster_config", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of parameters to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)


@pulumi.type_token("azure:datafactory/linkedServiceAzureDatabricks:LinkedServiceAzureDatabricks")
class LinkedServiceAzureDatabricks(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token: Optional[pulumi.Input[_builtins.str]] = None,
                 adb_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 existing_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_pool: Optional[pulumi.Input[Union['LinkedServiceAzureDatabricksInstancePoolArgs', 'LinkedServiceAzureDatabricksInstancePoolArgsDict']]] = None,
                 integration_runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_password: Optional[pulumi.Input[Union['LinkedServiceAzureDatabricksKeyVaultPasswordArgs', 'LinkedServiceAzureDatabricksKeyVaultPasswordArgsDict']]] = None,
                 msi_work_space_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 new_cluster_config: Optional[pulumi.Input[Union['LinkedServiceAzureDatabricksNewClusterConfigArgs', 'LinkedServiceAzureDatabricksNewClusterConfigArgsDict']]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Linked Service (connection) between Azure Databricks and Azure Data Factory.

        ## Example Usage

        ### With Managed Identity & New Cluster

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="East US")
        #Create a Linked Service using managed identity and new cluster config
        example_factory = azure.datafactory.Factory("example",
            name="TestDtaFactory92783401247",
            location=example.location,
            resource_group_name=example.name,
            identity={
                "type": "SystemAssigned",
            })
        #Create a databricks instance
        example_workspace = azure.databricks.Workspace("example",
            name="databricks-test",
            resource_group_name=example.name,
            location=example.location,
            sku="standard")
        msi_linked = azure.datafactory.LinkedServiceAzureDatabricks("msi_linked",
            name="ADBLinkedServiceViaMSI",
            data_factory_id=example_factory.id,
            description="ADB Linked Service via MSI",
            adb_domain=example_workspace.workspace_url.apply(lambda workspace_url: f"https://{workspace_url}"),
            msi_work_space_resource_id=example_workspace.id,
            new_cluster_config={
                "node_type": "Standard_NC12",
                "cluster_version": "5.5.x-gpu-scala2.11",
                "min_number_of_workers": 1,
                "max_number_of_workers": 5,
                "driver_node_type": "Standard_NC12",
                "log_destination": "dbfs:/logs",
                "custom_tags": {
                    "custom_tag1": "sct_value_1",
                    "custom_tag2": "sct_value_2",
                },
                "spark_config": {
                    "config1": "value1",
                    "config2": "value2",
                },
                "spark_environment_variables": {
                    "envVar1": "value1",
                    "envVar2": "value2",
                },
                "init_scripts": [
                    "init.sh",
                    "init2.sh",
                ],
            })
        ```

        ### With Access Token & Existing Cluster

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="East US")
        #Link to an existing cluster via access token
        example_factory = azure.datafactory.Factory("example",
            name="TestDtaFactory92783401247",
            location=example.location,
            resource_group_name=example.name)
        #Create a databricks instance
        example_workspace = azure.databricks.Workspace("example",
            name="databricks-test",
            resource_group_name=example.name,
            location=example.location,
            sku="standard")
        at_linked = azure.datafactory.LinkedServiceAzureDatabricks("at_linked",
            name="ADBLinkedServiceViaAccessToken",
            data_factory_id=example_factory.id,
            description="ADB Linked Service via Access Token",
            existing_cluster_id="0308-201146-sly615",
            access_token="SomeDatabricksAccessToken",
            adb_domain=example_workspace.workspace_url.apply(lambda workspace_url: f"https://{workspace_url}"))
        ```

        ## Import

        Data Factory Linked Services can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/linkedServiceAzureDatabricks:LinkedServiceAzureDatabricks example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example/linkedservices/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_token: Authenticate to ADB via an access token.
        :param pulumi.Input[_builtins.str] adb_domain: The domain URL of the databricks instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Linked Service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] existing_cluster_id: The cluster_id of an existing cluster within the linked ADB instance.
        :param pulumi.Input[Union['LinkedServiceAzureDatabricksInstancePoolArgs', 'LinkedServiceAzureDatabricksInstancePoolArgsDict']] instance_pool: Leverages an instance pool within the linked ADB instance as one `instance_pool` block defined below.
        :param pulumi.Input[_builtins.str] integration_runtime_name: The integration runtime reference to associate with the Data Factory Linked Service.
        :param pulumi.Input[Union['LinkedServiceAzureDatabricksKeyVaultPasswordArgs', 'LinkedServiceAzureDatabricksKeyVaultPasswordArgsDict']] key_vault_password: Authenticate to ADB via Azure Key Vault Linked Service as defined in the `key_vault_password` block below.
        :param pulumi.Input[_builtins.str] msi_work_space_resource_id: Authenticate to ADB via managed service identity.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Union['LinkedServiceAzureDatabricksNewClusterConfigArgs', 'LinkedServiceAzureDatabricksNewClusterConfigArgsDict']] new_cluster_config: Creates new clusters within the linked ADB instance as defined in the `new_cluster_config` block below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Linked Service.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LinkedServiceAzureDatabricksArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Linked Service (connection) between Azure Databricks and Azure Data Factory.

        ## Example Usage

        ### With Managed Identity & New Cluster

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="East US")
        #Create a Linked Service using managed identity and new cluster config
        example_factory = azure.datafactory.Factory("example",
            name="TestDtaFactory92783401247",
            location=example.location,
            resource_group_name=example.name,
            identity={
                "type": "SystemAssigned",
            })
        #Create a databricks instance
        example_workspace = azure.databricks.Workspace("example",
            name="databricks-test",
            resource_group_name=example.name,
            location=example.location,
            sku="standard")
        msi_linked = azure.datafactory.LinkedServiceAzureDatabricks("msi_linked",
            name="ADBLinkedServiceViaMSI",
            data_factory_id=example_factory.id,
            description="ADB Linked Service via MSI",
            adb_domain=example_workspace.workspace_url.apply(lambda workspace_url: f"https://{workspace_url}"),
            msi_work_space_resource_id=example_workspace.id,
            new_cluster_config={
                "node_type": "Standard_NC12",
                "cluster_version": "5.5.x-gpu-scala2.11",
                "min_number_of_workers": 1,
                "max_number_of_workers": 5,
                "driver_node_type": "Standard_NC12",
                "log_destination": "dbfs:/logs",
                "custom_tags": {
                    "custom_tag1": "sct_value_1",
                    "custom_tag2": "sct_value_2",
                },
                "spark_config": {
                    "config1": "value1",
                    "config2": "value2",
                },
                "spark_environment_variables": {
                    "envVar1": "value1",
                    "envVar2": "value2",
                },
                "init_scripts": [
                    "init.sh",
                    "init2.sh",
                ],
            })
        ```

        ### With Access Token & Existing Cluster

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="East US")
        #Link to an existing cluster via access token
        example_factory = azure.datafactory.Factory("example",
            name="TestDtaFactory92783401247",
            location=example.location,
            resource_group_name=example.name)
        #Create a databricks instance
        example_workspace = azure.databricks.Workspace("example",
            name="databricks-test",
            resource_group_name=example.name,
            location=example.location,
            sku="standard")
        at_linked = azure.datafactory.LinkedServiceAzureDatabricks("at_linked",
            name="ADBLinkedServiceViaAccessToken",
            data_factory_id=example_factory.id,
            description="ADB Linked Service via Access Token",
            existing_cluster_id="0308-201146-sly615",
            access_token="SomeDatabricksAccessToken",
            adb_domain=example_workspace.workspace_url.apply(lambda workspace_url: f"https://{workspace_url}"))
        ```

        ## Import

        Data Factory Linked Services can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/linkedServiceAzureDatabricks:LinkedServiceAzureDatabricks example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example/linkedservices/example
        ```

        :param str resource_name: The name of the resource.
        :param LinkedServiceAzureDatabricksArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LinkedServiceAzureDatabricksArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token: Optional[pulumi.Input[_builtins.str]] = None,
                 adb_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 existing_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_pool: Optional[pulumi.Input[Union['LinkedServiceAzureDatabricksInstancePoolArgs', 'LinkedServiceAzureDatabricksInstancePoolArgsDict']]] = None,
                 integration_runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_password: Optional[pulumi.Input[Union['LinkedServiceAzureDatabricksKeyVaultPasswordArgs', 'LinkedServiceAzureDatabricksKeyVaultPasswordArgsDict']]] = None,
                 msi_work_space_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 new_cluster_config: Optional[pulumi.Input[Union['LinkedServiceAzureDatabricksNewClusterConfigArgs', 'LinkedServiceAzureDatabricksNewClusterConfigArgsDict']]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LinkedServiceAzureDatabricksArgs.__new__(LinkedServiceAzureDatabricksArgs)

            __props__.__dict__["access_token"] = None if access_token is None else pulumi.Output.secret(access_token)
            if adb_domain is None and not opts.urn:
                raise TypeError("Missing required property 'adb_domain'")
            __props__.__dict__["adb_domain"] = adb_domain
            __props__.__dict__["additional_properties"] = additional_properties
            __props__.__dict__["annotations"] = annotations
            if data_factory_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_factory_id'")
            __props__.__dict__["data_factory_id"] = data_factory_id
            __props__.__dict__["description"] = description
            __props__.__dict__["existing_cluster_id"] = existing_cluster_id
            __props__.__dict__["instance_pool"] = instance_pool
            __props__.__dict__["integration_runtime_name"] = integration_runtime_name
            __props__.__dict__["key_vault_password"] = key_vault_password
            __props__.__dict__["msi_work_space_resource_id"] = msi_work_space_resource_id
            __props__.__dict__["name"] = name
            __props__.__dict__["new_cluster_config"] = new_cluster_config
            __props__.__dict__["parameters"] = parameters
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accessToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(LinkedServiceAzureDatabricks, __self__).__init__(
            'azure:datafactory/linkedServiceAzureDatabricks:LinkedServiceAzureDatabricks',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_token: Optional[pulumi.Input[_builtins.str]] = None,
            adb_domain: Optional[pulumi.Input[_builtins.str]] = None,
            additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            existing_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_pool: Optional[pulumi.Input[Union['LinkedServiceAzureDatabricksInstancePoolArgs', 'LinkedServiceAzureDatabricksInstancePoolArgsDict']]] = None,
            integration_runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
            key_vault_password: Optional[pulumi.Input[Union['LinkedServiceAzureDatabricksKeyVaultPasswordArgs', 'LinkedServiceAzureDatabricksKeyVaultPasswordArgsDict']]] = None,
            msi_work_space_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            new_cluster_config: Optional[pulumi.Input[Union['LinkedServiceAzureDatabricksNewClusterConfigArgs', 'LinkedServiceAzureDatabricksNewClusterConfigArgsDict']]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'LinkedServiceAzureDatabricks':
        """
        Get an existing LinkedServiceAzureDatabricks resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_token: Authenticate to ADB via an access token.
        :param pulumi.Input[_builtins.str] adb_domain: The domain URL of the databricks instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Linked Service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] existing_cluster_id: The cluster_id of an existing cluster within the linked ADB instance.
        :param pulumi.Input[Union['LinkedServiceAzureDatabricksInstancePoolArgs', 'LinkedServiceAzureDatabricksInstancePoolArgsDict']] instance_pool: Leverages an instance pool within the linked ADB instance as one `instance_pool` block defined below.
        :param pulumi.Input[_builtins.str] integration_runtime_name: The integration runtime reference to associate with the Data Factory Linked Service.
        :param pulumi.Input[Union['LinkedServiceAzureDatabricksKeyVaultPasswordArgs', 'LinkedServiceAzureDatabricksKeyVaultPasswordArgsDict']] key_vault_password: Authenticate to ADB via Azure Key Vault Linked Service as defined in the `key_vault_password` block below.
        :param pulumi.Input[_builtins.str] msi_work_space_resource_id: Authenticate to ADB via managed service identity.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Union['LinkedServiceAzureDatabricksNewClusterConfigArgs', 'LinkedServiceAzureDatabricksNewClusterConfigArgsDict']] new_cluster_config: Creates new clusters within the linked ADB instance as defined in the `new_cluster_config` block below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Linked Service.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LinkedServiceAzureDatabricksState.__new__(_LinkedServiceAzureDatabricksState)

        __props__.__dict__["access_token"] = access_token
        __props__.__dict__["adb_domain"] = adb_domain
        __props__.__dict__["additional_properties"] = additional_properties
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["data_factory_id"] = data_factory_id
        __props__.__dict__["description"] = description
        __props__.__dict__["existing_cluster_id"] = existing_cluster_id
        __props__.__dict__["instance_pool"] = instance_pool
        __props__.__dict__["integration_runtime_name"] = integration_runtime_name
        __props__.__dict__["key_vault_password"] = key_vault_password
        __props__.__dict__["msi_work_space_resource_id"] = msi_work_space_resource_id
        __props__.__dict__["name"] = name
        __props__.__dict__["new_cluster_config"] = new_cluster_config
        __props__.__dict__["parameters"] = parameters
        return LinkedServiceAzureDatabricks(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Authenticate to ADB via an access token.
        """
        return pulumi.get(self, "access_token")

    @_builtins.property
    @pulumi.getter(name="adbDomain")
    def adb_domain(self) -> pulumi.Output[_builtins.str]:
        """
        The domain URL of the databricks instance.
        """
        return pulumi.get(self, "adb_domain")

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of additional properties to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "additional_properties")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of tags that can be used for describing the Data Factory Linked Service.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description for the Data Factory Linked Service.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="existingClusterId")
    def existing_cluster_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The cluster_id of an existing cluster within the linked ADB instance.
        """
        return pulumi.get(self, "existing_cluster_id")

    @_builtins.property
    @pulumi.getter(name="instancePool")
    def instance_pool(self) -> pulumi.Output[Optional['outputs.LinkedServiceAzureDatabricksInstancePool']]:
        """
        Leverages an instance pool within the linked ADB instance as one `instance_pool` block defined below.
        """
        return pulumi.get(self, "instance_pool")

    @_builtins.property
    @pulumi.getter(name="integrationRuntimeName")
    def integration_runtime_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The integration runtime reference to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "integration_runtime_name")

    @_builtins.property
    @pulumi.getter(name="keyVaultPassword")
    def key_vault_password(self) -> pulumi.Output[Optional['outputs.LinkedServiceAzureDatabricksKeyVaultPassword']]:
        """
        Authenticate to ADB via Azure Key Vault Linked Service as defined in the `key_vault_password` block below.
        """
        return pulumi.get(self, "key_vault_password")

    @_builtins.property
    @pulumi.getter(name="msiWorkSpaceResourceId")
    def msi_work_space_resource_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Authenticate to ADB via managed service identity.
        """
        return pulumi.get(self, "msi_work_space_resource_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="newClusterConfig")
    def new_cluster_config(self) -> pulumi.Output[Optional['outputs.LinkedServiceAzureDatabricksNewClusterConfig']]:
        """
        Creates new clusters within the linked ADB instance as defined in the `new_cluster_config` block below.
        """
        return pulumi.get(self, "new_cluster_config")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of parameters to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "parameters")

