# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetProjectPoolResult',
    'AwaitableGetProjectPoolResult',
    'get_project_pool',
    'get_project_pool_output',
]

@pulumi.output_type
class GetProjectPoolResult:
    """
    A collection of values returned by getProjectPool.
    """
    def __init__(__self__, dev_box_definition_name=None, dev_center_attached_network_name=None, dev_center_project_id=None, id=None, local_administrator_enabled=None, location=None, name=None, stop_on_disconnect_grace_period_minutes=None, tags=None):
        if dev_box_definition_name and not isinstance(dev_box_definition_name, str):
            raise TypeError("Expected argument 'dev_box_definition_name' to be a str")
        pulumi.set(__self__, "dev_box_definition_name", dev_box_definition_name)
        if dev_center_attached_network_name and not isinstance(dev_center_attached_network_name, str):
            raise TypeError("Expected argument 'dev_center_attached_network_name' to be a str")
        pulumi.set(__self__, "dev_center_attached_network_name", dev_center_attached_network_name)
        if dev_center_project_id and not isinstance(dev_center_project_id, str):
            raise TypeError("Expected argument 'dev_center_project_id' to be a str")
        pulumi.set(__self__, "dev_center_project_id", dev_center_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if local_administrator_enabled and not isinstance(local_administrator_enabled, bool):
            raise TypeError("Expected argument 'local_administrator_enabled' to be a bool")
        pulumi.set(__self__, "local_administrator_enabled", local_administrator_enabled)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if stop_on_disconnect_grace_period_minutes and not isinstance(stop_on_disconnect_grace_period_minutes, int):
            raise TypeError("Expected argument 'stop_on_disconnect_grace_period_minutes' to be a int")
        pulumi.set(__self__, "stop_on_disconnect_grace_period_minutes", stop_on_disconnect_grace_period_minutes)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="devBoxDefinitionName")
    def dev_box_definition_name(self) -> _builtins.str:
        """
        The name of the Dev Center Dev Box Definition.
        """
        return pulumi.get(self, "dev_box_definition_name")

    @_builtins.property
    @pulumi.getter(name="devCenterAttachedNetworkName")
    def dev_center_attached_network_name(self) -> _builtins.str:
        """
        The name of the Dev Center Attached Network in parent Project of the Dev Center Project Pool.
        """
        return pulumi.get(self, "dev_center_attached_network_name")

    @_builtins.property
    @pulumi.getter(name="devCenterProjectId")
    def dev_center_project_id(self) -> _builtins.str:
        return pulumi.get(self, "dev_center_project_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="localAdministratorEnabled")
    def local_administrator_enabled(self) -> _builtins.bool:
        """
        Specifies whether owners of Dev Boxes in the Dev Center Project Pool are added as local administrators on the Dev Box.
        """
        return pulumi.get(self, "local_administrator_enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Dev Center Project Pool exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="stopOnDisconnectGracePeriodMinutes")
    def stop_on_disconnect_grace_period_minutes(self) -> _builtins.int:
        """
        The specified time in minutes to wait before stopping a Dev Center Dev Box once disconnect is detected.
        """
        return pulumi.get(self, "stop_on_disconnect_grace_period_minutes")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the Dev Center Project Pool.
        """
        return pulumi.get(self, "tags")


class AwaitableGetProjectPoolResult(GetProjectPoolResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectPoolResult(
            dev_box_definition_name=self.dev_box_definition_name,
            dev_center_attached_network_name=self.dev_center_attached_network_name,
            dev_center_project_id=self.dev_center_project_id,
            id=self.id,
            local_administrator_enabled=self.local_administrator_enabled,
            location=self.location,
            name=self.name,
            stop_on_disconnect_grace_period_minutes=self.stop_on_disconnect_grace_period_minutes,
            tags=self.tags)


def get_project_pool(dev_center_project_id: Optional[_builtins.str] = None,
                     name: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectPoolResult:
    """
    Use this data source to access information about an existing Dev Center Project Pool.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.devcenter.get_project_pool(name=example_azurerm_dev_center_project_pool["name"],
        dev_center_project_id=example_azurerm_dev_center_project_pool["devCenterProjectId"])
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DevCenter` - 2025-02-01


    :param _builtins.str dev_center_project_id: The ID of the associated Dev Center Project.
    :param _builtins.str name: The name of this Dev Center Project Pool.
    """
    __args__ = dict()
    __args__['devCenterProjectId'] = dev_center_project_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:devcenter/getProjectPool:getProjectPool', __args__, opts=opts, typ=GetProjectPoolResult).value

    return AwaitableGetProjectPoolResult(
        dev_box_definition_name=pulumi.get(__ret__, 'dev_box_definition_name'),
        dev_center_attached_network_name=pulumi.get(__ret__, 'dev_center_attached_network_name'),
        dev_center_project_id=pulumi.get(__ret__, 'dev_center_project_id'),
        id=pulumi.get(__ret__, 'id'),
        local_administrator_enabled=pulumi.get(__ret__, 'local_administrator_enabled'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        stop_on_disconnect_grace_period_minutes=pulumi.get(__ret__, 'stop_on_disconnect_grace_period_minutes'),
        tags=pulumi.get(__ret__, 'tags'))
def get_project_pool_output(dev_center_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                            name: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectPoolResult]:
    """
    Use this data source to access information about an existing Dev Center Project Pool.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.devcenter.get_project_pool(name=example_azurerm_dev_center_project_pool["name"],
        dev_center_project_id=example_azurerm_dev_center_project_pool["devCenterProjectId"])
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DevCenter` - 2025-02-01


    :param _builtins.str dev_center_project_id: The ID of the associated Dev Center Project.
    :param _builtins.str name: The name of this Dev Center Project Pool.
    """
    __args__ = dict()
    __args__['devCenterProjectId'] = dev_center_project_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:devcenter/getProjectPool:getProjectPool', __args__, opts=opts, typ=GetProjectPoolResult)
    return __ret__.apply(lambda __response__: GetProjectPoolResult(
        dev_box_definition_name=pulumi.get(__response__, 'dev_box_definition_name'),
        dev_center_attached_network_name=pulumi.get(__response__, 'dev_center_attached_network_name'),
        dev_center_project_id=pulumi.get(__response__, 'dev_center_project_id'),
        id=pulumi.get(__response__, 'id'),
        local_administrator_enabled=pulumi.get(__response__, 'local_administrator_enabled'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        stop_on_disconnect_grace_period_minutes=pulumi.get(__response__, 'stop_on_disconnect_grace_period_minutes'),
        tags=pulumi.get(__response__, 'tags')))
