# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'CaaRecordRecord',
    'MxRecordRecord',
    'SrvRecordRecord',
    'TxtRecordRecord',
    'ZoneSoaRecord',
    'GetCAARecordRecordResult',
    'GetMxRecordRecordResult',
    'GetSrvRecordRecordResult',
    'GetTxtRecordRecordResult',
]

@pulumi.output_type
class CaaRecordRecord(dict):
    def __init__(__self__, *,
                 flags: _builtins.int,
                 tag: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.int flags: Extensible CAA flags, currently only 1 is implemented to set the issuer critical flag.
        :param _builtins.str tag: A property tag, options are `issue`, `issuewild`, `iodef`, and `contactemail`.
        :param _builtins.str value: A property value such as a registrar domain.
        """
        pulumi.set(__self__, "flags", flags)
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def flags(self) -> _builtins.int:
        """
        Extensible CAA flags, currently only 1 is implemented to set the issuer critical flag.
        """
        return pulumi.get(self, "flags")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> _builtins.str:
        """
        A property tag, options are `issue`, `issuewild`, `iodef`, and `contactemail`.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        A property value such as a registrar domain.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class MxRecordRecord(dict):
    def __init__(__self__, *,
                 exchange: _builtins.str,
                 preference: _builtins.str):
        """
        :param _builtins.str exchange: The mail server responsible for the domain covered by the MX record.
        :param _builtins.str preference: String representing the "preference” value of the MX records. Records with lower preference value take priority.
        """
        pulumi.set(__self__, "exchange", exchange)
        pulumi.set(__self__, "preference", preference)

    @_builtins.property
    @pulumi.getter
    def exchange(self) -> _builtins.str:
        """
        The mail server responsible for the domain covered by the MX record.
        """
        return pulumi.get(self, "exchange")

    @_builtins.property
    @pulumi.getter
    def preference(self) -> _builtins.str:
        """
        String representing the "preference” value of the MX records. Records with lower preference value take priority.
        """
        return pulumi.get(self, "preference")


@pulumi.output_type
class SrvRecordRecord(dict):
    def __init__(__self__, *,
                 port: _builtins.int,
                 priority: _builtins.int,
                 target: _builtins.str,
                 weight: _builtins.int):
        """
        :param _builtins.int port: Port the service is listening on.
        :param _builtins.int priority: Priority of the SRV record.
        :param _builtins.str target: FQDN of the service.
        :param _builtins.int weight: Weight of the SRV record.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port the service is listening on.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        Priority of the SRV record.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def target(self) -> _builtins.str:
        """
        FQDN of the service.
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        """
        Weight of the SRV record.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class TxtRecordRecord(dict):
    def __init__(__self__, *,
                 value: _builtins.str):
        """
        :param _builtins.str value: The value of the record. Max length: 4096 characters
        """
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the record. Max length: 4096 characters
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ZoneSoaRecord(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expireTime":
            suggest = "expire_time"
        elif key == "hostName":
            suggest = "host_name"
        elif key == "minimumTtl":
            suggest = "minimum_ttl"
        elif key == "refreshTime":
            suggest = "refresh_time"
        elif key == "retryTime":
            suggest = "retry_time"
        elif key == "serialNumber":
            suggest = "serial_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ZoneSoaRecord. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ZoneSoaRecord.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ZoneSoaRecord.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: _builtins.str,
                 expire_time: Optional[_builtins.int] = None,
                 fqdn: Optional[_builtins.str] = None,
                 host_name: Optional[_builtins.str] = None,
                 minimum_ttl: Optional[_builtins.int] = None,
                 refresh_time: Optional[_builtins.int] = None,
                 retry_time: Optional[_builtins.int] = None,
                 serial_number: Optional[_builtins.int] = None,
                 tags: Optional[Mapping[str, _builtins.str]] = None,
                 ttl: Optional[_builtins.int] = None):
        """
        :param _builtins.str email: The email contact for the SOA record.
        :param _builtins.int expire_time: The expire time for the SOA record. Defaults to `2419200`.
        :param _builtins.str host_name: The domain name of the authoritative name server for the SOA record. If not set, computed value from Azure will be used.
        :param _builtins.int minimum_ttl: The minimum Time To Live for the SOA record. By convention, it is used to determine the negative caching duration. Defaults to `300`.
        :param _builtins.int refresh_time: The refresh time for the SOA record. Defaults to `3600`.
        :param _builtins.int retry_time: The retry time for the SOA record. Defaults to `300`.
        :param _builtins.int serial_number: The serial number for the SOA record. Defaults to `1`.
        :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the Record Set.
        :param _builtins.int ttl: The Time To Live of the SOA Record in seconds. Defaults to `3600`.
        """
        pulumi.set(__self__, "email", email)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if minimum_ttl is not None:
            pulumi.set(__self__, "minimum_ttl", minimum_ttl)
        if refresh_time is not None:
            pulumi.set(__self__, "refresh_time", refresh_time)
        if retry_time is not None:
            pulumi.set(__self__, "retry_time", retry_time)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        The email contact for the SOA record.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[_builtins.int]:
        """
        The expire time for the SOA record. Defaults to `2419200`.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[_builtins.str]:
        """
        The domain name of the authoritative name server for the SOA record. If not set, computed value from Azure will be used.
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter(name="minimumTtl")
    def minimum_ttl(self) -> Optional[_builtins.int]:
        """
        The minimum Time To Live for the SOA record. By convention, it is used to determine the negative caching duration. Defaults to `300`.
        """
        return pulumi.get(self, "minimum_ttl")

    @_builtins.property
    @pulumi.getter(name="refreshTime")
    def refresh_time(self) -> Optional[_builtins.int]:
        """
        The refresh time for the SOA record. Defaults to `3600`.
        """
        return pulumi.get(self, "refresh_time")

    @_builtins.property
    @pulumi.getter(name="retryTime")
    def retry_time(self) -> Optional[_builtins.int]:
        """
        The retry time for the SOA record. Defaults to `300`.
        """
        return pulumi.get(self, "retry_time")

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[_builtins.int]:
        """
        The serial number for the SOA record. Defaults to `1`.
        """
        return pulumi.get(self, "serial_number")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A mapping of tags to assign to the Record Set.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[_builtins.int]:
        """
        The Time To Live of the SOA Record in seconds. Defaults to `3600`.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class GetCAARecordRecordResult(dict):
    def __init__(__self__, *,
                 flags: _builtins.int,
                 tag: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.int flags: Extensible CAA flags, currently only 1 is implemented to set the issuer critical flag.
        :param _builtins.str tag: A property tag, options are `issue`, `issuewild`, `iodef`, and `contactemail`.
        :param _builtins.str value: A property value such as a registrar domain.
        """
        pulumi.set(__self__, "flags", flags)
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def flags(self) -> _builtins.int:
        """
        Extensible CAA flags, currently only 1 is implemented to set the issuer critical flag.
        """
        return pulumi.get(self, "flags")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> _builtins.str:
        """
        A property tag, options are `issue`, `issuewild`, `iodef`, and `contactemail`.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        A property value such as a registrar domain.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetMxRecordRecordResult(dict):
    def __init__(__self__, *,
                 exchange: _builtins.str,
                 preference: _builtins.str):
        """
        :param _builtins.str exchange: The mail server responsible for the domain covered by the MX record.
        :param _builtins.str preference: String representing the "preference” value of the MX records. Records with lower preference value take priority.
        """
        pulumi.set(__self__, "exchange", exchange)
        pulumi.set(__self__, "preference", preference)

    @_builtins.property
    @pulumi.getter
    def exchange(self) -> _builtins.str:
        """
        The mail server responsible for the domain covered by the MX record.
        """
        return pulumi.get(self, "exchange")

    @_builtins.property
    @pulumi.getter
    def preference(self) -> _builtins.str:
        """
        String representing the "preference” value of the MX records. Records with lower preference value take priority.
        """
        return pulumi.get(self, "preference")


@pulumi.output_type
class GetSrvRecordRecordResult(dict):
    def __init__(__self__, *,
                 port: _builtins.int,
                 priority: _builtins.int,
                 target: _builtins.str,
                 weight: _builtins.int):
        """
        :param _builtins.int port: Port the service is listening on.
        :param _builtins.int priority: Priority of the SRV record.
        :param _builtins.str target: FQDN of the service.
        :param _builtins.int weight: Weight of the SRV record.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port the service is listening on.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        Priority of the SRV record.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def target(self) -> _builtins.str:
        """
        FQDN of the service.
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        """
        Weight of the SRV record.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetTxtRecordRecordResult(dict):
    def __init__(__self__, *,
                 value: _builtins.str):
        """
        :param _builtins.str value: The value of the record. Max length: 1024 characters
        """
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the record. Max length: 1024 characters
        """
        return pulumi.get(self, "value")


