# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMonitorResult',
    'AwaitableGetMonitorResult',
    'get_monitor',
    'get_monitor_output',
]

@pulumi.output_type
class GetMonitorResult:
    """
    A collection of values returned by getMonitor.
    """
    def __init__(__self__, environment_properties=None, id=None, identities=None, location=None, marketplace_subscription=None, monitoring_enabled=None, name=None, plans=None, resource_group_name=None, tags=None, users=None):
        if environment_properties and not isinstance(environment_properties, list):
            raise TypeError("Expected argument 'environment_properties' to be a list")
        pulumi.set(__self__, "environment_properties", environment_properties)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if marketplace_subscription and not isinstance(marketplace_subscription, str):
            raise TypeError("Expected argument 'marketplace_subscription' to be a str")
        pulumi.set(__self__, "marketplace_subscription", marketplace_subscription)
        if monitoring_enabled and not isinstance(monitoring_enabled, bool):
            raise TypeError("Expected argument 'monitoring_enabled' to be a bool")
        pulumi.set(__self__, "monitoring_enabled", monitoring_enabled)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if plans and not isinstance(plans, list):
            raise TypeError("Expected argument 'plans' to be a list")
        pulumi.set(__self__, "plans", plans)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter(name="environmentProperties")
    def environment_properties(self) -> Sequence['outputs.GetMonitorEnvironmentPropertyResult']:
        return pulumi.get(self, "environment_properties")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetMonitorIdentityResult']:
        """
        The kind of managed identity assigned to this resource.  A `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Dynatrace monitor should exist.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="marketplaceSubscription")
    def marketplace_subscription(self) -> _builtins.str:
        """
        Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in time, the resource will go in Suspended state.
        """
        return pulumi.get(self, "marketplace_subscription")

    @_builtins.property
    @pulumi.getter(name="monitoringEnabled")
    def monitoring_enabled(self) -> _builtins.bool:
        """
        Flag specifying if the resource monitoring is enabled or disabled.
        """
        return pulumi.get(self, "monitoring_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def plans(self) -> Sequence['outputs.GetMonitorPlanResult']:
        """
        Plan id as published by Dynatrace.
        """
        return pulumi.get(self, "plans")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetMonitorUserResult']:
        """
        User's information. A `user` block as defined below.
        """
        return pulumi.get(self, "users")


class AwaitableGetMonitorResult(GetMonitorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMonitorResult(
            environment_properties=self.environment_properties,
            id=self.id,
            identities=self.identities,
            location=self.location,
            marketplace_subscription=self.marketplace_subscription,
            monitoring_enabled=self.monitoring_enabled,
            name=self.name,
            plans=self.plans,
            resource_group_name=self.resource_group_name,
            tags=self.tags,
            users=self.users)


def get_monitor(name: Optional[_builtins.str] = None,
                resource_group_name: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMonitorResult:
    """
    Use this data source to access information about an existing Dynatrace Monitor.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.dynatrace.get_monitor(name="example-dynatracemonitor",
        resource_group_name="example-resources")
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Dynatrace.Observability` - 2023-04-27


    :param _builtins.str name: Name of the Dynatrace monitor.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Dynatrace monitor should exist.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:dynatrace/getMonitor:getMonitor', __args__, opts=opts, typ=GetMonitorResult).value

    return AwaitableGetMonitorResult(
        environment_properties=pulumi.get(__ret__, 'environment_properties'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        location=pulumi.get(__ret__, 'location'),
        marketplace_subscription=pulumi.get(__ret__, 'marketplace_subscription'),
        monitoring_enabled=pulumi.get(__ret__, 'monitoring_enabled'),
        name=pulumi.get(__ret__, 'name'),
        plans=pulumi.get(__ret__, 'plans'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'),
        users=pulumi.get(__ret__, 'users'))
def get_monitor_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                       resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMonitorResult]:
    """
    Use this data source to access information about an existing Dynatrace Monitor.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.dynatrace.get_monitor(name="example-dynatracemonitor",
        resource_group_name="example-resources")
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Dynatrace.Observability` - 2023-04-27


    :param _builtins.str name: Name of the Dynatrace monitor.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Dynatrace monitor should exist.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:dynatrace/getMonitor:getMonitor', __args__, opts=opts, typ=GetMonitorResult)
    return __ret__.apply(lambda __response__: GetMonitorResult(
        environment_properties=pulumi.get(__response__, 'environment_properties'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        location=pulumi.get(__response__, 'location'),
        marketplace_subscription=pulumi.get(__response__, 'marketplace_subscription'),
        monitoring_enabled=pulumi.get(__response__, 'monitoring_enabled'),
        name=pulumi.get(__response__, 'name'),
        plans=pulumi.get(__response__, 'plans'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags'),
        users=pulumi.get(__response__, 'users')))
