# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ElasticSanArgs', 'ElasticSan']

@pulumi.input_type
class ElasticSanArgs:
    def __init__(__self__, *,
                 base_size_in_tib: pulumi.Input[_builtins.int],
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku: pulumi.Input['ElasticSanSkuArgs'],
                 extended_size_in_tib: Optional[pulumi.Input[_builtins.int]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ElasticSan resource.
        :param pulumi.Input[_builtins.int] base_size_in_tib: Specifies the base size of the Elastic SAN resource in TiB. Possible values are between `1` and `100`.
               
               > **Note:** When updating `base_size_in_tib`, the new value should be greater than the existing one.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group within which this Elastic SAN resource should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['ElasticSanSkuArgs'] sku: A `sku` block as defined below.
        :param pulumi.Input[_builtins.int] extended_size_in_tib: Specifies the extended size of the Elastic SAN resource in TiB. Possible values are between `1` and `100`.
               
               > **Note:** `extended_size_in_tib` cannot be removed and when updating, the new value should be greater than the existing one.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Elastic SAN resource should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Elastic SAN resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Elastic SAN resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Logical zone for the Elastic SAN resource. Changing this forces a new resource to be created.
               
               > **Note:** `zones` cannot be specified if `sku.name` is set to `Premium_ZRS`.
        """
        pulumi.set(__self__, "base_size_in_tib", base_size_in_tib)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku", sku)
        if extended_size_in_tib is not None:
            pulumi.set(__self__, "extended_size_in_tib", extended_size_in_tib)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="baseSizeInTib")
    def base_size_in_tib(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the base size of the Elastic SAN resource in TiB. Possible values are between `1` and `100`.

        > **Note:** When updating `base_size_in_tib`, the new value should be greater than the existing one.
        """
        return pulumi.get(self, "base_size_in_tib")

    @base_size_in_tib.setter
    def base_size_in_tib(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "base_size_in_tib", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Resource Group within which this Elastic SAN resource should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Input['ElasticSanSkuArgs']:
        """
        A `sku` block as defined below.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input['ElasticSanSkuArgs']):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="extendedSizeInTib")
    def extended_size_in_tib(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the extended size of the Elastic SAN resource in TiB. Possible values are between `1` and `100`.

        > **Note:** `extended_size_in_tib` cannot be removed and when updating, the new value should be greater than the existing one.
        """
        return pulumi.get(self, "extended_size_in_tib")

    @extended_size_in_tib.setter
    def extended_size_in_tib(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "extended_size_in_tib", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Elastic SAN resource should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Elastic SAN resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Elastic SAN resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Logical zone for the Elastic SAN resource. Changing this forces a new resource to be created.

        > **Note:** `zones` cannot be specified if `sku.name` is set to `Premium_ZRS`.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class _ElasticSanState:
    def __init__(__self__, *,
                 base_size_in_tib: Optional[pulumi.Input[_builtins.int]] = None,
                 extended_size_in_tib: Optional[pulumi.Input[_builtins.int]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input['ElasticSanSkuArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 total_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 total_mbps: Optional[pulumi.Input[_builtins.int]] = None,
                 total_size_in_tib: Optional[pulumi.Input[_builtins.int]] = None,
                 total_volume_size_in_gib: Optional[pulumi.Input[_builtins.int]] = None,
                 volume_group_count: Optional[pulumi.Input[_builtins.int]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ElasticSan resources.
        :param pulumi.Input[_builtins.int] base_size_in_tib: Specifies the base size of the Elastic SAN resource in TiB. Possible values are between `1` and `100`.
               
               > **Note:** When updating `base_size_in_tib`, the new value should be greater than the existing one.
        :param pulumi.Input[_builtins.int] extended_size_in_tib: Specifies the extended size of the Elastic SAN resource in TiB. Possible values are between `1` and `100`.
               
               > **Note:** `extended_size_in_tib` cannot be removed and when updating, the new value should be greater than the existing one.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Elastic SAN resource should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Elastic SAN resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group within which this Elastic SAN resource should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['ElasticSanSkuArgs'] sku: A `sku` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Elastic SAN resource.
        :param pulumi.Input[_builtins.int] total_iops: Total Provisioned IOps of the Elastic SAN resource.
        :param pulumi.Input[_builtins.int] total_mbps: Total Provisioned MBps Elastic SAN resource.
        :param pulumi.Input[_builtins.int] total_size_in_tib: Total size of the Elastic SAN resource in TB.
        :param pulumi.Input[_builtins.int] total_volume_size_in_gib: Total size of the provisioned Volumes in GiB.
        :param pulumi.Input[_builtins.int] volume_group_count: Total number of volume groups in this Elastic SAN resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Logical zone for the Elastic SAN resource. Changing this forces a new resource to be created.
               
               > **Note:** `zones` cannot be specified if `sku.name` is set to `Premium_ZRS`.
        """
        if base_size_in_tib is not None:
            pulumi.set(__self__, "base_size_in_tib", base_size_in_tib)
        if extended_size_in_tib is not None:
            pulumi.set(__self__, "extended_size_in_tib", extended_size_in_tib)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if total_iops is not None:
            pulumi.set(__self__, "total_iops", total_iops)
        if total_mbps is not None:
            pulumi.set(__self__, "total_mbps", total_mbps)
        if total_size_in_tib is not None:
            pulumi.set(__self__, "total_size_in_tib", total_size_in_tib)
        if total_volume_size_in_gib is not None:
            pulumi.set(__self__, "total_volume_size_in_gib", total_volume_size_in_gib)
        if volume_group_count is not None:
            pulumi.set(__self__, "volume_group_count", volume_group_count)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="baseSizeInTib")
    def base_size_in_tib(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the base size of the Elastic SAN resource in TiB. Possible values are between `1` and `100`.

        > **Note:** When updating `base_size_in_tib`, the new value should be greater than the existing one.
        """
        return pulumi.get(self, "base_size_in_tib")

    @base_size_in_tib.setter
    def base_size_in_tib(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "base_size_in_tib", value)

    @_builtins.property
    @pulumi.getter(name="extendedSizeInTib")
    def extended_size_in_tib(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the extended size of the Elastic SAN resource in TiB. Possible values are between `1` and `100`.

        > **Note:** `extended_size_in_tib` cannot be removed and when updating, the new value should be greater than the existing one.
        """
        return pulumi.get(self, "extended_size_in_tib")

    @extended_size_in_tib.setter
    def extended_size_in_tib(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "extended_size_in_tib", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Elastic SAN resource should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Elastic SAN resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Resource Group within which this Elastic SAN resource should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['ElasticSanSkuArgs']]:
        """
        A `sku` block as defined below.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['ElasticSanSkuArgs']]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Elastic SAN resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="totalIops")
    def total_iops(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Total Provisioned IOps of the Elastic SAN resource.
        """
        return pulumi.get(self, "total_iops")

    @total_iops.setter
    def total_iops(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_iops", value)

    @_builtins.property
    @pulumi.getter(name="totalMbps")
    def total_mbps(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Total Provisioned MBps Elastic SAN resource.
        """
        return pulumi.get(self, "total_mbps")

    @total_mbps.setter
    def total_mbps(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_mbps", value)

    @_builtins.property
    @pulumi.getter(name="totalSizeInTib")
    def total_size_in_tib(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Total size of the Elastic SAN resource in TB.
        """
        return pulumi.get(self, "total_size_in_tib")

    @total_size_in_tib.setter
    def total_size_in_tib(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_size_in_tib", value)

    @_builtins.property
    @pulumi.getter(name="totalVolumeSizeInGib")
    def total_volume_size_in_gib(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Total size of the provisioned Volumes in GiB.
        """
        return pulumi.get(self, "total_volume_size_in_gib")

    @total_volume_size_in_gib.setter
    def total_volume_size_in_gib(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_volume_size_in_gib", value)

    @_builtins.property
    @pulumi.getter(name="volumeGroupCount")
    def volume_group_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Total number of volume groups in this Elastic SAN resource.
        """
        return pulumi.get(self, "volume_group_count")

    @volume_group_count.setter
    def volume_group_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "volume_group_count", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Logical zone for the Elastic SAN resource. Changing this forces a new resource to be created.

        > **Note:** `zones` cannot be specified if `sku.name` is set to `Premium_ZRS`.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.type_token("azure:elasticsan/elasticSan:ElasticSan")
class ElasticSan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_size_in_tib: Optional[pulumi.Input[_builtins.int]] = None,
                 extended_size_in_tib: Optional[pulumi.Input[_builtins.int]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[Union['ElasticSanSkuArgs', 'ElasticSanSkuArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Elastic SAN resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_elastic_san = azure.elasticsan.ElasticSan("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            base_size_in_tib=1,
            extended_size_in_tib=2,
            sku={
                "name": "example-value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ElasticSan` - 2023-01-01

        ## Import

        An existing Elastic SAN can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:elasticsan/elasticSan:ElasticSan example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ElasticSan/elasticSans/esan1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] base_size_in_tib: Specifies the base size of the Elastic SAN resource in TiB. Possible values are between `1` and `100`.
               
               > **Note:** When updating `base_size_in_tib`, the new value should be greater than the existing one.
        :param pulumi.Input[_builtins.int] extended_size_in_tib: Specifies the extended size of the Elastic SAN resource in TiB. Possible values are between `1` and `100`.
               
               > **Note:** `extended_size_in_tib` cannot be removed and when updating, the new value should be greater than the existing one.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Elastic SAN resource should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Elastic SAN resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group within which this Elastic SAN resource should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ElasticSanSkuArgs', 'ElasticSanSkuArgsDict']] sku: A `sku` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Elastic SAN resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Logical zone for the Elastic SAN resource. Changing this forces a new resource to be created.
               
               > **Note:** `zones` cannot be specified if `sku.name` is set to `Premium_ZRS`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ElasticSanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Elastic SAN resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_elastic_san = azure.elasticsan.ElasticSan("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            base_size_in_tib=1,
            extended_size_in_tib=2,
            sku={
                "name": "example-value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ElasticSan` - 2023-01-01

        ## Import

        An existing Elastic SAN can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:elasticsan/elasticSan:ElasticSan example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ElasticSan/elasticSans/esan1
        ```

        :param str resource_name: The name of the resource.
        :param ElasticSanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ElasticSanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_size_in_tib: Optional[pulumi.Input[_builtins.int]] = None,
                 extended_size_in_tib: Optional[pulumi.Input[_builtins.int]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[Union['ElasticSanSkuArgs', 'ElasticSanSkuArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ElasticSanArgs.__new__(ElasticSanArgs)

            if base_size_in_tib is None and not opts.urn:
                raise TypeError("Missing required property 'base_size_in_tib'")
            __props__.__dict__["base_size_in_tib"] = base_size_in_tib
            __props__.__dict__["extended_size_in_tib"] = extended_size_in_tib
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            __props__.__dict__["tags"] = tags
            __props__.__dict__["zones"] = zones
            __props__.__dict__["total_iops"] = None
            __props__.__dict__["total_mbps"] = None
            __props__.__dict__["total_size_in_tib"] = None
            __props__.__dict__["total_volume_size_in_gib"] = None
            __props__.__dict__["volume_group_count"] = None
        super(ElasticSan, __self__).__init__(
            'azure:elasticsan/elasticSan:ElasticSan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            base_size_in_tib: Optional[pulumi.Input[_builtins.int]] = None,
            extended_size_in_tib: Optional[pulumi.Input[_builtins.int]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku: Optional[pulumi.Input[Union['ElasticSanSkuArgs', 'ElasticSanSkuArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            total_iops: Optional[pulumi.Input[_builtins.int]] = None,
            total_mbps: Optional[pulumi.Input[_builtins.int]] = None,
            total_size_in_tib: Optional[pulumi.Input[_builtins.int]] = None,
            total_volume_size_in_gib: Optional[pulumi.Input[_builtins.int]] = None,
            volume_group_count: Optional[pulumi.Input[_builtins.int]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'ElasticSan':
        """
        Get an existing ElasticSan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] base_size_in_tib: Specifies the base size of the Elastic SAN resource in TiB. Possible values are between `1` and `100`.
               
               > **Note:** When updating `base_size_in_tib`, the new value should be greater than the existing one.
        :param pulumi.Input[_builtins.int] extended_size_in_tib: Specifies the extended size of the Elastic SAN resource in TiB. Possible values are between `1` and `100`.
               
               > **Note:** `extended_size_in_tib` cannot be removed and when updating, the new value should be greater than the existing one.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Elastic SAN resource should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Elastic SAN resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group within which this Elastic SAN resource should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ElasticSanSkuArgs', 'ElasticSanSkuArgsDict']] sku: A `sku` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Elastic SAN resource.
        :param pulumi.Input[_builtins.int] total_iops: Total Provisioned IOps of the Elastic SAN resource.
        :param pulumi.Input[_builtins.int] total_mbps: Total Provisioned MBps Elastic SAN resource.
        :param pulumi.Input[_builtins.int] total_size_in_tib: Total size of the Elastic SAN resource in TB.
        :param pulumi.Input[_builtins.int] total_volume_size_in_gib: Total size of the provisioned Volumes in GiB.
        :param pulumi.Input[_builtins.int] volume_group_count: Total number of volume groups in this Elastic SAN resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Logical zone for the Elastic SAN resource. Changing this forces a new resource to be created.
               
               > **Note:** `zones` cannot be specified if `sku.name` is set to `Premium_ZRS`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ElasticSanState.__new__(_ElasticSanState)

        __props__.__dict__["base_size_in_tib"] = base_size_in_tib
        __props__.__dict__["extended_size_in_tib"] = extended_size_in_tib
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku"] = sku
        __props__.__dict__["tags"] = tags
        __props__.__dict__["total_iops"] = total_iops
        __props__.__dict__["total_mbps"] = total_mbps
        __props__.__dict__["total_size_in_tib"] = total_size_in_tib
        __props__.__dict__["total_volume_size_in_gib"] = total_volume_size_in_gib
        __props__.__dict__["volume_group_count"] = volume_group_count
        __props__.__dict__["zones"] = zones
        return ElasticSan(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="baseSizeInTib")
    def base_size_in_tib(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the base size of the Elastic SAN resource in TiB. Possible values are between `1` and `100`.

        > **Note:** When updating `base_size_in_tib`, the new value should be greater than the existing one.
        """
        return pulumi.get(self, "base_size_in_tib")

    @_builtins.property
    @pulumi.getter(name="extendedSizeInTib")
    def extended_size_in_tib(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the extended size of the Elastic SAN resource in TiB. Possible values are between `1` and `100`.

        > **Note:** `extended_size_in_tib` cannot be removed and when updating, the new value should be greater than the existing one.
        """
        return pulumi.get(self, "extended_size_in_tib")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Elastic SAN resource should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of this Elastic SAN resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Resource Group within which this Elastic SAN resource should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Output['outputs.ElasticSanSku']:
        """
        A `sku` block as defined below.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Elastic SAN resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="totalIops")
    def total_iops(self) -> pulumi.Output[_builtins.int]:
        """
        Total Provisioned IOps of the Elastic SAN resource.
        """
        return pulumi.get(self, "total_iops")

    @_builtins.property
    @pulumi.getter(name="totalMbps")
    def total_mbps(self) -> pulumi.Output[_builtins.int]:
        """
        Total Provisioned MBps Elastic SAN resource.
        """
        return pulumi.get(self, "total_mbps")

    @_builtins.property
    @pulumi.getter(name="totalSizeInTib")
    def total_size_in_tib(self) -> pulumi.Output[_builtins.int]:
        """
        Total size of the Elastic SAN resource in TB.
        """
        return pulumi.get(self, "total_size_in_tib")

    @_builtins.property
    @pulumi.getter(name="totalVolumeSizeInGib")
    def total_volume_size_in_gib(self) -> pulumi.Output[_builtins.int]:
        """
        Total size of the provisioned Volumes in GiB.
        """
        return pulumi.get(self, "total_volume_size_in_gib")

    @_builtins.property
    @pulumi.getter(name="volumeGroupCount")
    def volume_group_count(self) -> pulumi.Output[_builtins.int]:
        """
        Total number of volume groups in this Elastic SAN resource.
        """
        return pulumi.get(self, "volume_group_count")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Logical zone for the Elastic SAN resource. Changing this forces a new resource to be created.

        > **Note:** `zones` cannot be specified if `sku.name` is set to `Premium_ZRS`.
        """
        return pulumi.get(self, "zones")

