# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'CacheAccessPolicyAccessRule',
    'CacheDefaultAccessPolicy',
    'CacheDefaultAccessPolicyAccessRule',
    'CacheDirectoryActiveDirectory',
    'CacheDirectoryFlatFile',
    'CacheDirectoryLdap',
    'CacheDirectoryLdapBind',
    'CacheDns',
    'CacheIdentity',
    'CacheNfsTargetNamespaceJunction',
]

@pulumi.output_type
class CacheAccessPolicyAccessRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "anonymousGid":
            suggest = "anonymous_gid"
        elif key == "anonymousUid":
            suggest = "anonymous_uid"
        elif key == "rootSquashEnabled":
            suggest = "root_squash_enabled"
        elif key == "submountAccessEnabled":
            suggest = "submount_access_enabled"
        elif key == "suidEnabled":
            suggest = "suid_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheAccessPolicyAccessRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheAccessPolicyAccessRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheAccessPolicyAccessRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access: _builtins.str,
                 scope: _builtins.str,
                 anonymous_gid: Optional[_builtins.int] = None,
                 anonymous_uid: Optional[_builtins.int] = None,
                 filter: Optional[_builtins.str] = None,
                 root_squash_enabled: Optional[_builtins.bool] = None,
                 submount_access_enabled: Optional[_builtins.bool] = None,
                 suid_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str access: The access level for this rule. Possible values are: `rw`, `ro`, `no`.
        :param _builtins.str scope: The scope of this rule. The `scope` and (potentially) the `filter` determine which clients match the rule. Possible values are: `default`, `network`, `host`.
               
               > **Note:** Each `access_rule` should set a unique `scope`.
        :param _builtins.int anonymous_gid: The anonymous GID used when `root_squash_enabled` is `true`.
        :param _builtins.int anonymous_uid: The anonymous UID used when `root_squash_enabled` is `true`.
        :param _builtins.str filter: The filter applied to the `scope` for this rule. The filter's format depends on its scope: `default` scope matches all clients and has no filter value; `network` scope takes a CIDR format; `host` takes an IP address or fully qualified domain name. If a client does not match any filter rule and there is no default rule, access is denied.
        :param _builtins.bool root_squash_enabled: Whether to enable [root squash](https://docs.microsoft.com/azure/hpc-cache/access-policies#root-squash)?
        :param _builtins.bool submount_access_enabled: Whether allow access to subdirectories under the root export?
        :param _builtins.bool suid_enabled: Whether [SUID](https://docs.microsoft.com/azure/hpc-cache/access-policies#suid) is allowed?
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "scope", scope)
        if anonymous_gid is not None:
            pulumi.set(__self__, "anonymous_gid", anonymous_gid)
        if anonymous_uid is not None:
            pulumi.set(__self__, "anonymous_uid", anonymous_uid)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if root_squash_enabled is not None:
            pulumi.set(__self__, "root_squash_enabled", root_squash_enabled)
        if submount_access_enabled is not None:
            pulumi.set(__self__, "submount_access_enabled", submount_access_enabled)
        if suid_enabled is not None:
            pulumi.set(__self__, "suid_enabled", suid_enabled)

    @_builtins.property
    @pulumi.getter
    def access(self) -> _builtins.str:
        """
        The access level for this rule. Possible values are: `rw`, `ro`, `no`.
        """
        return pulumi.get(self, "access")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> _builtins.str:
        """
        The scope of this rule. The `scope` and (potentially) the `filter` determine which clients match the rule. Possible values are: `default`, `network`, `host`.

        > **Note:** Each `access_rule` should set a unique `scope`.
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter(name="anonymousGid")
    def anonymous_gid(self) -> Optional[_builtins.int]:
        """
        The anonymous GID used when `root_squash_enabled` is `true`.
        """
        return pulumi.get(self, "anonymous_gid")

    @_builtins.property
    @pulumi.getter(name="anonymousUid")
    def anonymous_uid(self) -> Optional[_builtins.int]:
        """
        The anonymous UID used when `root_squash_enabled` is `true`.
        """
        return pulumi.get(self, "anonymous_uid")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        """
        The filter applied to the `scope` for this rule. The filter's format depends on its scope: `default` scope matches all clients and has no filter value; `network` scope takes a CIDR format; `host` takes an IP address or fully qualified domain name. If a client does not match any filter rule and there is no default rule, access is denied.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter(name="rootSquashEnabled")
    def root_squash_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable [root squash](https://docs.microsoft.com/azure/hpc-cache/access-policies#root-squash)?
        """
        return pulumi.get(self, "root_squash_enabled")

    @_builtins.property
    @pulumi.getter(name="submountAccessEnabled")
    def submount_access_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether allow access to subdirectories under the root export?
        """
        return pulumi.get(self, "submount_access_enabled")

    @_builtins.property
    @pulumi.getter(name="suidEnabled")
    def suid_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether [SUID](https://docs.microsoft.com/azure/hpc-cache/access-policies#suid) is allowed?
        """
        return pulumi.get(self, "suid_enabled")


@pulumi.output_type
class CacheDefaultAccessPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessRules":
            suggest = "access_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheDefaultAccessPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheDefaultAccessPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheDefaultAccessPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_rules: Sequence['outputs.CacheDefaultAccessPolicyAccessRule']):
        """
        :param Sequence['CacheDefaultAccessPolicyAccessRuleArgs'] access_rules: One or more `access_rule` blocks (up to three) as defined above.
        """
        pulumi.set(__self__, "access_rules", access_rules)

    @_builtins.property
    @pulumi.getter(name="accessRules")
    def access_rules(self) -> Sequence['outputs.CacheDefaultAccessPolicyAccessRule']:
        """
        One or more `access_rule` blocks (up to three) as defined above.
        """
        return pulumi.get(self, "access_rules")


@pulumi.output_type
class CacheDefaultAccessPolicyAccessRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "anonymousGid":
            suggest = "anonymous_gid"
        elif key == "anonymousUid":
            suggest = "anonymous_uid"
        elif key == "rootSquashEnabled":
            suggest = "root_squash_enabled"
        elif key == "submountAccessEnabled":
            suggest = "submount_access_enabled"
        elif key == "suidEnabled":
            suggest = "suid_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheDefaultAccessPolicyAccessRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheDefaultAccessPolicyAccessRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheDefaultAccessPolicyAccessRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access: _builtins.str,
                 scope: _builtins.str,
                 anonymous_gid: Optional[_builtins.int] = None,
                 anonymous_uid: Optional[_builtins.int] = None,
                 filter: Optional[_builtins.str] = None,
                 root_squash_enabled: Optional[_builtins.bool] = None,
                 submount_access_enabled: Optional[_builtins.bool] = None,
                 suid_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str access: The access level for this rule. Possible values are: `rw`, `ro`, `no`.
        :param _builtins.str scope: The scope of this rule. The `scope` and (potentially) the `filter` determine which clients match the rule. Possible values are: `default`, `network`, `host`.
               
               > **Note:** Each `access_rule` should set a unique `scope`.
        :param _builtins.int anonymous_gid: The anonymous GID used when `root_squash_enabled` is `true`.
        :param _builtins.int anonymous_uid: The anonymous UID used when `root_squash_enabled` is `true`.
        :param _builtins.str filter: The filter applied to the `scope` for this rule. The filter's format depends on its scope: `default` scope matches all clients and has no filter value; `network` scope takes a CIDR format; `host` takes an IP address or fully qualified domain name. If a client does not match any filter rule and there is no default rule, access is denied.
        :param _builtins.bool root_squash_enabled: Whether to enable [root squash](https://docs.microsoft.com/azure/hpc-cache/access-policies#root-squash)?
        :param _builtins.bool submount_access_enabled: Whether allow access to subdirectories under the root export?
        :param _builtins.bool suid_enabled: Whether [SUID](https://docs.microsoft.com/azure/hpc-cache/access-policies#suid) is allowed?
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "scope", scope)
        if anonymous_gid is not None:
            pulumi.set(__self__, "anonymous_gid", anonymous_gid)
        if anonymous_uid is not None:
            pulumi.set(__self__, "anonymous_uid", anonymous_uid)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if root_squash_enabled is not None:
            pulumi.set(__self__, "root_squash_enabled", root_squash_enabled)
        if submount_access_enabled is not None:
            pulumi.set(__self__, "submount_access_enabled", submount_access_enabled)
        if suid_enabled is not None:
            pulumi.set(__self__, "suid_enabled", suid_enabled)

    @_builtins.property
    @pulumi.getter
    def access(self) -> _builtins.str:
        """
        The access level for this rule. Possible values are: `rw`, `ro`, `no`.
        """
        return pulumi.get(self, "access")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> _builtins.str:
        """
        The scope of this rule. The `scope` and (potentially) the `filter` determine which clients match the rule. Possible values are: `default`, `network`, `host`.

        > **Note:** Each `access_rule` should set a unique `scope`.
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter(name="anonymousGid")
    def anonymous_gid(self) -> Optional[_builtins.int]:
        """
        The anonymous GID used when `root_squash_enabled` is `true`.
        """
        return pulumi.get(self, "anonymous_gid")

    @_builtins.property
    @pulumi.getter(name="anonymousUid")
    def anonymous_uid(self) -> Optional[_builtins.int]:
        """
        The anonymous UID used when `root_squash_enabled` is `true`.
        """
        return pulumi.get(self, "anonymous_uid")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        """
        The filter applied to the `scope` for this rule. The filter's format depends on its scope: `default` scope matches all clients and has no filter value; `network` scope takes a CIDR format; `host` takes an IP address or fully qualified domain name. If a client does not match any filter rule and there is no default rule, access is denied.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter(name="rootSquashEnabled")
    def root_squash_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable [root squash](https://docs.microsoft.com/azure/hpc-cache/access-policies#root-squash)?
        """
        return pulumi.get(self, "root_squash_enabled")

    @_builtins.property
    @pulumi.getter(name="submountAccessEnabled")
    def submount_access_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether allow access to subdirectories under the root export?
        """
        return pulumi.get(self, "submount_access_enabled")

    @_builtins.property
    @pulumi.getter(name="suidEnabled")
    def suid_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether [SUID](https://docs.microsoft.com/azure/hpc-cache/access-policies#suid) is allowed?
        """
        return pulumi.get(self, "suid_enabled")


@pulumi.output_type
class CacheDirectoryActiveDirectory(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheNetbiosName":
            suggest = "cache_netbios_name"
        elif key == "dnsPrimaryIp":
            suggest = "dns_primary_ip"
        elif key == "domainName":
            suggest = "domain_name"
        elif key == "domainNetbiosName":
            suggest = "domain_netbios_name"
        elif key == "dnsSecondaryIp":
            suggest = "dns_secondary_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheDirectoryActiveDirectory. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheDirectoryActiveDirectory.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheDirectoryActiveDirectory.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cache_netbios_name: _builtins.str,
                 dns_primary_ip: _builtins.str,
                 domain_name: _builtins.str,
                 domain_netbios_name: _builtins.str,
                 password: _builtins.str,
                 username: _builtins.str,
                 dns_secondary_ip: Optional[_builtins.str] = None):
        """
        :param _builtins.str cache_netbios_name: The NetBIOS name to assign to the HPC Cache when it joins the Active Directory domain as a server.
        :param _builtins.str dns_primary_ip: The primary DNS IP address used to resolve the Active Directory domain controller's FQDN.
        :param _builtins.str domain_name: The fully qualified domain name of the Active Directory domain controller.
        :param _builtins.str domain_netbios_name: The Active Directory domain's NetBIOS name.
        :param _builtins.str password: The password of the Active Directory domain administrator.
        :param _builtins.str username: The username of the Active Directory domain administrator.
        :param _builtins.str dns_secondary_ip: The secondary DNS IP address used to resolve the Active Directory domain controller's FQDN.
        """
        pulumi.set(__self__, "cache_netbios_name", cache_netbios_name)
        pulumi.set(__self__, "dns_primary_ip", dns_primary_ip)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "domain_netbios_name", domain_netbios_name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if dns_secondary_ip is not None:
            pulumi.set(__self__, "dns_secondary_ip", dns_secondary_ip)

    @_builtins.property
    @pulumi.getter(name="cacheNetbiosName")
    def cache_netbios_name(self) -> _builtins.str:
        """
        The NetBIOS name to assign to the HPC Cache when it joins the Active Directory domain as a server.
        """
        return pulumi.get(self, "cache_netbios_name")

    @_builtins.property
    @pulumi.getter(name="dnsPrimaryIp")
    def dns_primary_ip(self) -> _builtins.str:
        """
        The primary DNS IP address used to resolve the Active Directory domain controller's FQDN.
        """
        return pulumi.get(self, "dns_primary_ip")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        """
        The fully qualified domain name of the Active Directory domain controller.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="domainNetbiosName")
    def domain_netbios_name(self) -> _builtins.str:
        """
        The Active Directory domain's NetBIOS name.
        """
        return pulumi.get(self, "domain_netbios_name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The password of the Active Directory domain administrator.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The username of the Active Directory domain administrator.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="dnsSecondaryIp")
    def dns_secondary_ip(self) -> Optional[_builtins.str]:
        """
        The secondary DNS IP address used to resolve the Active Directory domain controller's FQDN.
        """
        return pulumi.get(self, "dns_secondary_ip")


@pulumi.output_type
class CacheDirectoryFlatFile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupFileUri":
            suggest = "group_file_uri"
        elif key == "passwordFileUri":
            suggest = "password_file_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheDirectoryFlatFile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheDirectoryFlatFile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheDirectoryFlatFile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_file_uri: _builtins.str,
                 password_file_uri: _builtins.str):
        """
        :param _builtins.str group_file_uri: The URI of the file containing group information (`/etc/group` file format in Unix-like OS).
        :param _builtins.str password_file_uri: The URI of the file containing user information (`/etc/passwd` file format in Unix-like OS).
        """
        pulumi.set(__self__, "group_file_uri", group_file_uri)
        pulumi.set(__self__, "password_file_uri", password_file_uri)

    @_builtins.property
    @pulumi.getter(name="groupFileUri")
    def group_file_uri(self) -> _builtins.str:
        """
        The URI of the file containing group information (`/etc/group` file format in Unix-like OS).
        """
        return pulumi.get(self, "group_file_uri")

    @_builtins.property
    @pulumi.getter(name="passwordFileUri")
    def password_file_uri(self) -> _builtins.str:
        """
        The URI of the file containing user information (`/etc/passwd` file format in Unix-like OS).
        """
        return pulumi.get(self, "password_file_uri")


@pulumi.output_type
class CacheDirectoryLdap(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseDn":
            suggest = "base_dn"
        elif key == "certificateValidationUri":
            suggest = "certificate_validation_uri"
        elif key == "downloadCertificateAutomatically":
            suggest = "download_certificate_automatically"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheDirectoryLdap. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheDirectoryLdap.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheDirectoryLdap.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_dn: _builtins.str,
                 server: _builtins.str,
                 bind: Optional['outputs.CacheDirectoryLdapBind'] = None,
                 certificate_validation_uri: Optional[_builtins.str] = None,
                 download_certificate_automatically: Optional[_builtins.bool] = None,
                 encrypted: Optional[_builtins.bool] = None):
        """
        :param _builtins.str base_dn: The base distinguished name (DN) for the LDAP domain.
        :param _builtins.str server: The FQDN or IP address of the LDAP server.
        :param 'CacheDirectoryLdapBindArgs' bind: A `bind` block as defined above.
        :param _builtins.str certificate_validation_uri: The URI of the CA certificate to validate the LDAP secure connection.
        :param _builtins.bool download_certificate_automatically: Whether the certificate should be automatically downloaded. This can be set to `true` only when `certificate_validation_uri` is provided.
        :param _builtins.bool encrypted: Whether the LDAP connection should be encrypted?
        """
        pulumi.set(__self__, "base_dn", base_dn)
        pulumi.set(__self__, "server", server)
        if bind is not None:
            pulumi.set(__self__, "bind", bind)
        if certificate_validation_uri is not None:
            pulumi.set(__self__, "certificate_validation_uri", certificate_validation_uri)
        if download_certificate_automatically is not None:
            pulumi.set(__self__, "download_certificate_automatically", download_certificate_automatically)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)

    @_builtins.property
    @pulumi.getter(name="baseDn")
    def base_dn(self) -> _builtins.str:
        """
        The base distinguished name (DN) for the LDAP domain.
        """
        return pulumi.get(self, "base_dn")

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.str:
        """
        The FQDN or IP address of the LDAP server.
        """
        return pulumi.get(self, "server")

    @_builtins.property
    @pulumi.getter
    def bind(self) -> Optional['outputs.CacheDirectoryLdapBind']:
        """
        A `bind` block as defined above.
        """
        return pulumi.get(self, "bind")

    @_builtins.property
    @pulumi.getter(name="certificateValidationUri")
    def certificate_validation_uri(self) -> Optional[_builtins.str]:
        """
        The URI of the CA certificate to validate the LDAP secure connection.
        """
        return pulumi.get(self, "certificate_validation_uri")

    @_builtins.property
    @pulumi.getter(name="downloadCertificateAutomatically")
    def download_certificate_automatically(self) -> Optional[_builtins.bool]:
        """
        Whether the certificate should be automatically downloaded. This can be set to `true` only when `certificate_validation_uri` is provided.
        """
        return pulumi.get(self, "download_certificate_automatically")

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> Optional[_builtins.bool]:
        """
        Whether the LDAP connection should be encrypted?
        """
        return pulumi.get(self, "encrypted")


@pulumi.output_type
class CacheDirectoryLdapBind(dict):
    def __init__(__self__, *,
                 dn: _builtins.str,
                 password: _builtins.str):
        """
        :param _builtins.str dn: The Bind Distinguished Name (DN) identity to be used in the secure LDAP connection.
        :param _builtins.str password: The Bind password to be used in the secure LDAP connection.
        """
        pulumi.set(__self__, "dn", dn)
        pulumi.set(__self__, "password", password)

    @_builtins.property
    @pulumi.getter
    def dn(self) -> _builtins.str:
        """
        The Bind Distinguished Name (DN) identity to be used in the secure LDAP connection.
        """
        return pulumi.get(self, "dn")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The Bind password to be used in the secure LDAP connection.
        """
        return pulumi.get(self, "password")


@pulumi.output_type
class CacheDns(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "searchDomain":
            suggest = "search_domain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheDns. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheDns.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheDns.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 servers: Sequence[_builtins.str],
                 search_domain: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] servers: A list of DNS servers for the HPC Cache. At most three IP(s) are allowed to set.
        :param _builtins.str search_domain: The DNS search domain for the HPC Cache.
        """
        pulumi.set(__self__, "servers", servers)
        if search_domain is not None:
            pulumi.set(__self__, "search_domain", search_domain)

    @_builtins.property
    @pulumi.getter
    def servers(self) -> Sequence[_builtins.str]:
        """
        A list of DNS servers for the HPC Cache. At most three IP(s) are allowed to set.
        """
        return pulumi.get(self, "servers")

    @_builtins.property
    @pulumi.getter(name="searchDomain")
    def search_domain(self) -> Optional[_builtins.str]:
        """
        The DNS search domain for the HPC Cache.
        """
        return pulumi.get(self, "search_domain")


@pulumi.output_type
class CacheIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this HPC Cache. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both). Changing this forces a new resource to be created.
        :param Sequence[_builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this HPC Cache. Changing this forces a new resource to be created.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param _builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param _builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this HPC Cache. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this HPC Cache. Changing this forces a new resource to be created.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class CacheNfsTargetNamespaceJunction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "namespacePath":
            suggest = "namespace_path"
        elif key == "nfsExport":
            suggest = "nfs_export"
        elif key == "accessPolicyName":
            suggest = "access_policy_name"
        elif key == "targetPath":
            suggest = "target_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheNfsTargetNamespaceJunction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheNfsTargetNamespaceJunction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheNfsTargetNamespaceJunction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespace_path: _builtins.str,
                 nfs_export: _builtins.str,
                 access_policy_name: Optional[_builtins.str] = None,
                 target_path: Optional[_builtins.str] = None):
        """
        :param _builtins.str namespace_path: The client-facing file path of this NFS target within the HPC Cache NFS Target.
        :param _builtins.str nfs_export: The NFS export of this NFS target within the HPC Cache NFS Target.
        :param _builtins.str access_policy_name: The name of the access policy applied to this target. Defaults to `default`.
        :param _builtins.str target_path: The relative subdirectory path from the `nfs_export` to map to the `namespace_path`. Defaults to `""`, in which case the whole `nfs_export` is exported.
        """
        pulumi.set(__self__, "namespace_path", namespace_path)
        pulumi.set(__self__, "nfs_export", nfs_export)
        if access_policy_name is not None:
            pulumi.set(__self__, "access_policy_name", access_policy_name)
        if target_path is not None:
            pulumi.set(__self__, "target_path", target_path)

    @_builtins.property
    @pulumi.getter(name="namespacePath")
    def namespace_path(self) -> _builtins.str:
        """
        The client-facing file path of this NFS target within the HPC Cache NFS Target.
        """
        return pulumi.get(self, "namespace_path")

    @_builtins.property
    @pulumi.getter(name="nfsExport")
    def nfs_export(self) -> _builtins.str:
        """
        The NFS export of this NFS target within the HPC Cache NFS Target.
        """
        return pulumi.get(self, "nfs_export")

    @_builtins.property
    @pulumi.getter(name="accessPolicyName")
    def access_policy_name(self) -> Optional[_builtins.str]:
        """
        The name of the access policy applied to this target. Defaults to `default`.
        """
        return pulumi.get(self, "access_policy_name")

    @_builtins.property
    @pulumi.getter(name="targetPath")
    def target_path(self) -> Optional[_builtins.str]:
        """
        The relative subdirectory path from the `nfs_export` to map to the `namespace_path`. Defaults to `""`, in which case the whole `nfs_export` is exported.
        """
        return pulumi.get(self, "target_path")


