# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EnrichmentArgs', 'Enrichment']

@pulumi.input_type
class EnrichmentArgs:
    def __init__(__self__, *,
                 endpoint_names: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 iothub_name: pulumi.Input[_builtins.str],
                 key: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a Enrichment resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] endpoint_names: The list of endpoints which will be enriched.
        :param pulumi.Input[_builtins.str] iothub_name: The IoTHub name of the enrichment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] key: The key of the enrichment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group under which the IoTHub resource is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] value: The value of the enrichment. Value can be any static string, the name of the IoT hub sending the message (use `$iothubname`) or information from the device twin (ex: `$twin.tags.latitude`)
        """
        pulumi.set(__self__, "endpoint_names", endpoint_names)
        pulumi.set(__self__, "iothub_name", iothub_name)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="endpointNames")
    def endpoint_names(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of endpoints which will be enriched.
        """
        return pulumi.get(self, "endpoint_names")

    @endpoint_names.setter
    def endpoint_names(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "endpoint_names", value)

    @_builtins.property
    @pulumi.getter(name="iothubName")
    def iothub_name(self) -> pulumi.Input[_builtins.str]:
        """
        The IoTHub name of the enrichment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iothub_name")

    @iothub_name.setter
    def iothub_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "iothub_name", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        The key of the enrichment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group under which the IoTHub resource is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        The value of the enrichment. Value can be any static string, the name of the IoT hub sending the message (use `$iothubname`) or information from the device twin (ex: `$twin.tags.latitude`)
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class _EnrichmentState:
    def __init__(__self__, *,
                 endpoint_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 iothub_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Enrichment resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] endpoint_names: The list of endpoints which will be enriched.
        :param pulumi.Input[_builtins.str] iothub_name: The IoTHub name of the enrichment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] key: The key of the enrichment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group under which the IoTHub resource is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] value: The value of the enrichment. Value can be any static string, the name of the IoT hub sending the message (use `$iothubname`) or information from the device twin (ex: `$twin.tags.latitude`)
        """
        if endpoint_names is not None:
            pulumi.set(__self__, "endpoint_names", endpoint_names)
        if iothub_name is not None:
            pulumi.set(__self__, "iothub_name", iothub_name)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="endpointNames")
    def endpoint_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of endpoints which will be enriched.
        """
        return pulumi.get(self, "endpoint_names")

    @endpoint_names.setter
    def endpoint_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "endpoint_names", value)

    @_builtins.property
    @pulumi.getter(name="iothubName")
    def iothub_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IoTHub name of the enrichment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iothub_name")

    @iothub_name.setter
    def iothub_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iothub_name", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key of the enrichment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group under which the IoTHub resource is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of the enrichment. Value can be any static string, the name of the IoT hub sending the message (use `$iothubname`) or information from the device twin (ex: `$twin.tags.latitude`)
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


@pulumi.type_token("azure:iot/enrichment:Enrichment")
class Enrichment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoint_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 iothub_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an IotHub Enrichment

        > **Note:** Enrichment can be defined either directly on the `iot.IoTHub` resource, or using the `iot.Enrichment` resources - but the two cannot be used together. If both are used against the same IoTHub, spurious changes will occur.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorageaccount",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="example",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_io_t_hub = azure.iot.IoTHub("example",
            name="exampleIothub",
            resource_group_name=example.name,
            location=example.location,
            sku={
                "name": "S1",
                "capacity": 1,
            },
            tags={
                "purpose": "testing",
            })
        example_endpoint_storage_container = azure.iot.EndpointStorageContainer("example",
            resource_group_name=example.name,
            iothub_id=example_io_t_hub.id,
            name="example",
            connection_string=example_account.primary_blob_connection_string,
            batch_frequency_in_seconds=60,
            max_chunk_size_in_bytes=10485760,
            container_name=example_container.name,
            encoding="Avro",
            file_name_format="{iothub}/{partition}_{YYYY}_{MM}_{DD}_{HH}_{mm}")
        example_route = azure.iot.Route("example",
            resource_group_name=example.name,
            iothub_name=example_io_t_hub.name,
            name="example",
            source="DeviceMessages",
            condition="true",
            endpoint_names=example_endpoint_storage_container.name,
            enabled=True)
        example_enrichment = azure.iot.Enrichment("example",
            resource_group_name=example.name,
            iothub_name=example_io_t_hub.name,
            key="example",
            value="my value",
            endpoint_names=[example_endpoint_storage_container.name])
        ```

        ## Import

        IoTHub Enrichment can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:iot/enrichment:Enrichment enrichment1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Devices/iotHubs/hub1/enrichments/enrichment1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] endpoint_names: The list of endpoints which will be enriched.
        :param pulumi.Input[_builtins.str] iothub_name: The IoTHub name of the enrichment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] key: The key of the enrichment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group under which the IoTHub resource is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] value: The value of the enrichment. Value can be any static string, the name of the IoT hub sending the message (use `$iothubname`) or information from the device twin (ex: `$twin.tags.latitude`)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnrichmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an IotHub Enrichment

        > **Note:** Enrichment can be defined either directly on the `iot.IoTHub` resource, or using the `iot.Enrichment` resources - but the two cannot be used together. If both are used against the same IoTHub, spurious changes will occur.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorageaccount",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="example",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_io_t_hub = azure.iot.IoTHub("example",
            name="exampleIothub",
            resource_group_name=example.name,
            location=example.location,
            sku={
                "name": "S1",
                "capacity": 1,
            },
            tags={
                "purpose": "testing",
            })
        example_endpoint_storage_container = azure.iot.EndpointStorageContainer("example",
            resource_group_name=example.name,
            iothub_id=example_io_t_hub.id,
            name="example",
            connection_string=example_account.primary_blob_connection_string,
            batch_frequency_in_seconds=60,
            max_chunk_size_in_bytes=10485760,
            container_name=example_container.name,
            encoding="Avro",
            file_name_format="{iothub}/{partition}_{YYYY}_{MM}_{DD}_{HH}_{mm}")
        example_route = azure.iot.Route("example",
            resource_group_name=example.name,
            iothub_name=example_io_t_hub.name,
            name="example",
            source="DeviceMessages",
            condition="true",
            endpoint_names=example_endpoint_storage_container.name,
            enabled=True)
        example_enrichment = azure.iot.Enrichment("example",
            resource_group_name=example.name,
            iothub_name=example_io_t_hub.name,
            key="example",
            value="my value",
            endpoint_names=[example_endpoint_storage_container.name])
        ```

        ## Import

        IoTHub Enrichment can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:iot/enrichment:Enrichment enrichment1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Devices/iotHubs/hub1/enrichments/enrichment1
        ```

        :param str resource_name: The name of the resource.
        :param EnrichmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnrichmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoint_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 iothub_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnrichmentArgs.__new__(EnrichmentArgs)

            if endpoint_names is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_names'")
            __props__.__dict__["endpoint_names"] = endpoint_names
            if iothub_name is None and not opts.urn:
                raise TypeError("Missing required property 'iothub_name'")
            __props__.__dict__["iothub_name"] = iothub_name
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
        super(Enrichment, __self__).__init__(
            'azure:iot/enrichment:Enrichment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            endpoint_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            iothub_name: Optional[pulumi.Input[_builtins.str]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            value: Optional[pulumi.Input[_builtins.str]] = None) -> 'Enrichment':
        """
        Get an existing Enrichment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] endpoint_names: The list of endpoints which will be enriched.
        :param pulumi.Input[_builtins.str] iothub_name: The IoTHub name of the enrichment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] key: The key of the enrichment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group under which the IoTHub resource is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] value: The value of the enrichment. Value can be any static string, the name of the IoT hub sending the message (use `$iothubname`) or information from the device twin (ex: `$twin.tags.latitude`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnrichmentState.__new__(_EnrichmentState)

        __props__.__dict__["endpoint_names"] = endpoint_names
        __props__.__dict__["iothub_name"] = iothub_name
        __props__.__dict__["key"] = key
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["value"] = value
        return Enrichment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="endpointNames")
    def endpoint_names(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of endpoints which will be enriched.
        """
        return pulumi.get(self, "endpoint_names")

    @_builtins.property
    @pulumi.getter(name="iothubName")
    def iothub_name(self) -> pulumi.Output[_builtins.str]:
        """
        The IoTHub name of the enrichment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iothub_name")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        The key of the enrichment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group under which the IoTHub resource is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Output[_builtins.str]:
        """
        The value of the enrichment. Value can be any static string, the name of the IoT hub sending the message (use `$iothubname`) or information from the device twin (ex: `$twin.tags.latitude`)
        """
        return pulumi.get(self, "value")

