# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetCertificateDataResult',
    'AwaitableGetCertificateDataResult',
    'get_certificate_data',
    'get_certificate_data_output',
]

@pulumi.output_type
class GetCertificateDataResult:
    """
    A collection of values returned by getCertificateData.
    """
    def __init__(__self__, certificates_count=None, expires=None, hex=None, id=None, key=None, key_vault_id=None, name=None, not_before=None, pem=None, tags=None, version=None):
        if certificates_count and not isinstance(certificates_count, int):
            raise TypeError("Expected argument 'certificates_count' to be a int")
        pulumi.set(__self__, "certificates_count", certificates_count)
        if expires and not isinstance(expires, str):
            raise TypeError("Expected argument 'expires' to be a str")
        pulumi.set(__self__, "expires", expires)
        if hex and not isinstance(hex, str):
            raise TypeError("Expected argument 'hex' to be a str")
        pulumi.set(__self__, "hex", hex)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if key_vault_id and not isinstance(key_vault_id, str):
            raise TypeError("Expected argument 'key_vault_id' to be a str")
        pulumi.set(__self__, "key_vault_id", key_vault_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if not_before and not isinstance(not_before, str):
            raise TypeError("Expected argument 'not_before' to be a str")
        pulumi.set(__self__, "not_before", not_before)
        if pem and not isinstance(pem, str):
            raise TypeError("Expected argument 'pem' to be a str")
        pulumi.set(__self__, "pem", pem)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="certificatesCount")
    def certificates_count(self) -> _builtins.int:
        """
        Amount of certificates in the chain in case Key Vault Certificate is a bundle (e.g. has an intermediate certificate).
        """
        return pulumi.get(self, "certificates_count")

    @_builtins.property
    @pulumi.getter
    def expires(self) -> _builtins.str:
        """
        Expiry date of certificate in RFC3339 format.
        """
        return pulumi.get(self, "expires")

    @_builtins.property
    @pulumi.getter
    def hex(self) -> _builtins.str:
        """
        The raw Key Vault Certificate data represented as a hexadecimal string.
        """
        return pulumi.get(self, "hex")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The Key Vault Certificate Key.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> _builtins.str:
        return pulumi.get(self, "key_vault_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="notBefore")
    def not_before(self) -> _builtins.str:
        """
        Not Before date of certificate in RFC3339 format.
        """
        return pulumi.get(self, "not_before")

    @_builtins.property
    @pulumi.getter
    def pem(self) -> _builtins.str:
        """
        The Key Vault Certificate in PEM format.
        """
        return pulumi.get(self, "pem")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        return pulumi.get(self, "version")


class AwaitableGetCertificateDataResult(GetCertificateDataResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateDataResult(
            certificates_count=self.certificates_count,
            expires=self.expires,
            hex=self.hex,
            id=self.id,
            key=self.key,
            key_vault_id=self.key_vault_id,
            name=self.name,
            not_before=self.not_before,
            pem=self.pem,
            tags=self.tags,
            version=self.version)


def get_certificate_data(key_vault_id: Optional[_builtins.str] = None,
                         name: Optional[_builtins.str] = None,
                         version: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateDataResult:
    """
    Use this data source to access data stored in an existing Key Vault Certificate.

    > **Note:** This data source uses the `GetSecret` function of the Azure API, to get the key of the certificate. Therefore you need secret/get permission

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.keyvault.get_key_vault(name="examplekv",
        resource_group_name="some-resource-group")
    example_get_certificate_data = azure.keyvault.get_certificate_data(name="secret-sauce",
        key_vault_id=example.id)
    pulumi.export("examplePem", example_get_certificate_data.pem)
    ```


    :param _builtins.str key_vault_id: Specifies the ID of the Key Vault instance where the Secret resides, available on the `keyvault.KeyVault` Data Source / Resource.
    :param _builtins.str name: Specifies the name of the Key Vault Secret.
    :param _builtins.str version: Specifies the version of the certificate to look up.  (Defaults to latest)
           
           > **Note:** The vault must be in the same subscription as the provider. If the vault is in another subscription, you must create an aliased provider for that subscription.
    """
    __args__ = dict()
    __args__['keyVaultId'] = key_vault_id
    __args__['name'] = name
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:keyvault/getCertificateData:getCertificateData', __args__, opts=opts, typ=GetCertificateDataResult).value

    return AwaitableGetCertificateDataResult(
        certificates_count=pulumi.get(__ret__, 'certificates_count'),
        expires=pulumi.get(__ret__, 'expires'),
        hex=pulumi.get(__ret__, 'hex'),
        id=pulumi.get(__ret__, 'id'),
        key=pulumi.get(__ret__, 'key'),
        key_vault_id=pulumi.get(__ret__, 'key_vault_id'),
        name=pulumi.get(__ret__, 'name'),
        not_before=pulumi.get(__ret__, 'not_before'),
        pem=pulumi.get(__ret__, 'pem'),
        tags=pulumi.get(__ret__, 'tags'),
        version=pulumi.get(__ret__, 'version'))
def get_certificate_data_output(key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                                name: Optional[pulumi.Input[_builtins.str]] = None,
                                version: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCertificateDataResult]:
    """
    Use this data source to access data stored in an existing Key Vault Certificate.

    > **Note:** This data source uses the `GetSecret` function of the Azure API, to get the key of the certificate. Therefore you need secret/get permission

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.keyvault.get_key_vault(name="examplekv",
        resource_group_name="some-resource-group")
    example_get_certificate_data = azure.keyvault.get_certificate_data(name="secret-sauce",
        key_vault_id=example.id)
    pulumi.export("examplePem", example_get_certificate_data.pem)
    ```


    :param _builtins.str key_vault_id: Specifies the ID of the Key Vault instance where the Secret resides, available on the `keyvault.KeyVault` Data Source / Resource.
    :param _builtins.str name: Specifies the name of the Key Vault Secret.
    :param _builtins.str version: Specifies the version of the certificate to look up.  (Defaults to latest)
           
           > **Note:** The vault must be in the same subscription as the provider. If the vault is in another subscription, you must create an aliased provider for that subscription.
    """
    __args__ = dict()
    __args__['keyVaultId'] = key_vault_id
    __args__['name'] = name
    __args__['version'] = version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:keyvault/getCertificateData:getCertificateData', __args__, opts=opts, typ=GetCertificateDataResult)
    return __ret__.apply(lambda __response__: GetCertificateDataResult(
        certificates_count=pulumi.get(__response__, 'certificates_count'),
        expires=pulumi.get(__response__, 'expires'),
        hex=pulumi.get(__response__, 'hex'),
        id=pulumi.get(__response__, 'id'),
        key=pulumi.get(__response__, 'key'),
        key_vault_id=pulumi.get(__response__, 'key_vault_id'),
        name=pulumi.get(__response__, 'name'),
        not_before=pulumi.get(__response__, 'not_before'),
        pem=pulumi.get(__response__, 'pem'),
        tags=pulumi.get(__response__, 'tags'),
        version=pulumi.get(__response__, 'version')))
