# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetManagedHardwareSecurityModuleRoleDefinitionResult',
    'AwaitableGetManagedHardwareSecurityModuleRoleDefinitionResult',
    'get_managed_hardware_security_module_role_definition',
    'get_managed_hardware_security_module_role_definition_output',
]

@pulumi.output_type
class GetManagedHardwareSecurityModuleRoleDefinitionResult:
    """
    A collection of values returned by getManagedHardwareSecurityModuleRoleDefinition.
    """
    def __init__(__self__, assignable_scopes=None, description=None, id=None, managed_hsm_id=None, name=None, permissions=None, resource_manager_id=None, role_name=None, role_type=None):
        if assignable_scopes and not isinstance(assignable_scopes, list):
            raise TypeError("Expected argument 'assignable_scopes' to be a list")
        pulumi.set(__self__, "assignable_scopes", assignable_scopes)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_hsm_id and not isinstance(managed_hsm_id, str):
            raise TypeError("Expected argument 'managed_hsm_id' to be a str")
        pulumi.set(__self__, "managed_hsm_id", managed_hsm_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if permissions and not isinstance(permissions, list):
            raise TypeError("Expected argument 'permissions' to be a list")
        pulumi.set(__self__, "permissions", permissions)
        if resource_manager_id and not isinstance(resource_manager_id, str):
            raise TypeError("Expected argument 'resource_manager_id' to be a str")
        pulumi.set(__self__, "resource_manager_id", resource_manager_id)
        if role_name and not isinstance(role_name, str):
            raise TypeError("Expected argument 'role_name' to be a str")
        pulumi.set(__self__, "role_name", role_name)
        if role_type and not isinstance(role_type, str):
            raise TypeError("Expected argument 'role_type' to be a str")
        pulumi.set(__self__, "role_type", role_type)

    @_builtins.property
    @pulumi.getter(name="assignableScopes")
    def assignable_scopes(self) -> Sequence[_builtins.str]:
        """
        A list of assignable role scopes. Possible values are `/` and `/keys`.
        """
        return pulumi.get(self, "assignable_scopes")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A text description of the Key Vault Managed Hardware Security Module Role Definition.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="managedHsmId")
    def managed_hsm_id(self) -> _builtins.str:
        return pulumi.get(self, "managed_hsm_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Sequence['outputs.GetManagedHardwareSecurityModuleRoleDefinitionPermissionResult']:
        """
        A `permission` block as defined below.
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter(name="resourceManagerId")
    def resource_manager_id(self) -> _builtins.str:
        """
        The ID of the Key Vault Managed Hardware Security Module Role Definition resource without base url.
        """
        return pulumi.get(self, "resource_manager_id")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> _builtins.str:
        """
        The display name of the Key Vault Managed Hardware Security Module Role Definition.
        """
        return pulumi.get(self, "role_name")

    @_builtins.property
    @pulumi.getter(name="roleType")
    def role_type(self) -> _builtins.str:
        """
        The type of the Key Vault Managed Hardware Security Module Role Definition. Possible values are `AKVBuiltInRole` and `CustomRole`.
        """
        return pulumi.get(self, "role_type")


class AwaitableGetManagedHardwareSecurityModuleRoleDefinitionResult(GetManagedHardwareSecurityModuleRoleDefinitionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedHardwareSecurityModuleRoleDefinitionResult(
            assignable_scopes=self.assignable_scopes,
            description=self.description,
            id=self.id,
            managed_hsm_id=self.managed_hsm_id,
            name=self.name,
            permissions=self.permissions,
            resource_manager_id=self.resource_manager_id,
            role_name=self.role_name,
            role_type=self.role_type)


def get_managed_hardware_security_module_role_definition(managed_hsm_id: Optional[_builtins.str] = None,
                                                         name: Optional[_builtins.str] = None,
                                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedHardwareSecurityModuleRoleDefinitionResult:
    """
    Use this data source to access information about an existing Key Vault Managed Hardware Security Module Role Definition.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.keyvault.get_managed_hardware_security_module_role_definition(managed_hsm_id=example_azurerm_key_vault_managed_hardware_security_module["id"],
        name="21dbd100-6940-42c2-9190-5d6cb909625b")
    pulumi.export("id", example.resource_manager_id)
    ```


    :param _builtins.str managed_hsm_id: The ID of the Key Vault Managed Hardware Security Module.
    :param _builtins.str name: The name in UUID notation of this Key Vault Managed Hardware Security Module Role Definition.
    """
    __args__ = dict()
    __args__['managedHsmId'] = managed_hsm_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:keyvault/getManagedHardwareSecurityModuleRoleDefinition:getManagedHardwareSecurityModuleRoleDefinition', __args__, opts=opts, typ=GetManagedHardwareSecurityModuleRoleDefinitionResult).value

    return AwaitableGetManagedHardwareSecurityModuleRoleDefinitionResult(
        assignable_scopes=pulumi.get(__ret__, 'assignable_scopes'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        managed_hsm_id=pulumi.get(__ret__, 'managed_hsm_id'),
        name=pulumi.get(__ret__, 'name'),
        permissions=pulumi.get(__ret__, 'permissions'),
        resource_manager_id=pulumi.get(__ret__, 'resource_manager_id'),
        role_name=pulumi.get(__ret__, 'role_name'),
        role_type=pulumi.get(__ret__, 'role_type'))
def get_managed_hardware_security_module_role_definition_output(managed_hsm_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                                name: Optional[pulumi.Input[_builtins.str]] = None,
                                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagedHardwareSecurityModuleRoleDefinitionResult]:
    """
    Use this data source to access information about an existing Key Vault Managed Hardware Security Module Role Definition.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.keyvault.get_managed_hardware_security_module_role_definition(managed_hsm_id=example_azurerm_key_vault_managed_hardware_security_module["id"],
        name="21dbd100-6940-42c2-9190-5d6cb909625b")
    pulumi.export("id", example.resource_manager_id)
    ```


    :param _builtins.str managed_hsm_id: The ID of the Key Vault Managed Hardware Security Module.
    :param _builtins.str name: The name in UUID notation of this Key Vault Managed Hardware Security Module Role Definition.
    """
    __args__ = dict()
    __args__['managedHsmId'] = managed_hsm_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:keyvault/getManagedHardwareSecurityModuleRoleDefinition:getManagedHardwareSecurityModuleRoleDefinition', __args__, opts=opts, typ=GetManagedHardwareSecurityModuleRoleDefinitionResult)
    return __ret__.apply(lambda __response__: GetManagedHardwareSecurityModuleRoleDefinitionResult(
        assignable_scopes=pulumi.get(__response__, 'assignable_scopes'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        managed_hsm_id=pulumi.get(__response__, 'managed_hsm_id'),
        name=pulumi.get(__response__, 'name'),
        permissions=pulumi.get(__response__, 'permissions'),
        resource_manager_id=pulumi.get(__response__, 'resource_manager_id'),
        role_name=pulumi.get(__response__, 'role_name'),
        role_type=pulumi.get(__response__, 'role_type')))
