# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetWorkspaceTableResult',
    'AwaitableGetWorkspaceTableResult',
    'get_workspace_table',
    'get_workspace_table_output',
]

@pulumi.output_type
class GetWorkspaceTableResult:
    """
    A collection of values returned by getWorkspaceTable.
    """
    def __init__(__self__, id=None, name=None, plan=None, retention_in_days=None, total_retention_in_days=None, workspace_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if plan and not isinstance(plan, str):
            raise TypeError("Expected argument 'plan' to be a str")
        pulumi.set(__self__, "plan", plan)
        if retention_in_days and not isinstance(retention_in_days, int):
            raise TypeError("Expected argument 'retention_in_days' to be a int")
        pulumi.set(__self__, "retention_in_days", retention_in_days)
        if total_retention_in_days and not isinstance(total_retention_in_days, int):
            raise TypeError("Expected argument 'total_retention_in_days' to be a int")
        pulumi.set(__self__, "total_retention_in_days", total_retention_in_days)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> _builtins.str:
        """
        The billing plan information for the Log Analytics Workspace Table.
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> _builtins.int:
        """
        The table's data retention in days.
        """
        return pulumi.get(self, "retention_in_days")

    @_builtins.property
    @pulumi.getter(name="totalRetentionInDays")
    def total_retention_in_days(self) -> _builtins.int:
        """
        The table's total data retention in days.
        """
        return pulumi.get(self, "total_retention_in_days")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> _builtins.str:
        return pulumi.get(self, "workspace_id")


class AwaitableGetWorkspaceTableResult(GetWorkspaceTableResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkspaceTableResult(
            id=self.id,
            name=self.name,
            plan=self.plan,
            retention_in_days=self.retention_in_days,
            total_retention_in_days=self.total_retention_in_days,
            workspace_id=self.workspace_id)


def get_workspace_table(name: Optional[_builtins.str] = None,
                        workspace_id: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkspaceTableResult:
    """
    Use this data source to access information about an existing Log Analytics Workspace Table.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.loganalytics.get_workspace_table(name="InsightsMetrics",
        workspace_id=example_azurerm_log_analytics_workspace["id"])
    pulumi.export("retentionInDays", example.retention_in_days)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.OperationalInsights` - 2022-10-01


    :param _builtins.str name: The name of this Log Analytics Workspace Table.
    :param _builtins.str workspace_id: The ID of the Log Analytics Workspace the table belongs to.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:loganalytics/getWorkspaceTable:getWorkspaceTable', __args__, opts=opts, typ=GetWorkspaceTableResult).value

    return AwaitableGetWorkspaceTableResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        plan=pulumi.get(__ret__, 'plan'),
        retention_in_days=pulumi.get(__ret__, 'retention_in_days'),
        total_retention_in_days=pulumi.get(__ret__, 'total_retention_in_days'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))
def get_workspace_table_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                               workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWorkspaceTableResult]:
    """
    Use this data source to access information about an existing Log Analytics Workspace Table.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.loganalytics.get_workspace_table(name="InsightsMetrics",
        workspace_id=example_azurerm_log_analytics_workspace["id"])
    pulumi.export("retentionInDays", example.retention_in_days)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.OperationalInsights` - 2022-10-01


    :param _builtins.str name: The name of this Log Analytics Workspace Table.
    :param _builtins.str workspace_id: The ID of the Log Analytics Workspace the table belongs to.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:loganalytics/getWorkspaceTable:getWorkspaceTable', __args__, opts=opts, typ=GetWorkspaceTableResult)
    return __ret__.apply(lambda __response__: GetWorkspaceTableResult(
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        plan=pulumi.get(__response__, 'plan'),
        retention_in_days=pulumi.get(__response__, 'retention_in_days'),
        total_retention_in_days=pulumi.get(__response__, 'total_retention_in_days'),
        workspace_id=pulumi.get(__response__, 'workspace_id')))
