# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ComputeClusterIdentityArgs',
    'ComputeClusterIdentityArgsDict',
    'ComputeClusterScaleSettingsArgs',
    'ComputeClusterScaleSettingsArgsDict',
    'ComputeClusterSshArgs',
    'ComputeClusterSshArgsDict',
    'ComputeInstanceAssignToUserArgs',
    'ComputeInstanceAssignToUserArgsDict',
    'ComputeInstanceIdentityArgs',
    'ComputeInstanceIdentityArgsDict',
    'ComputeInstanceSshArgs',
    'ComputeInstanceSshArgsDict',
    'InferenceClusterIdentityArgs',
    'InferenceClusterIdentityArgsDict',
    'InferenceClusterSslArgs',
    'InferenceClusterSslArgsDict',
    'SynapseSparkIdentityArgs',
    'SynapseSparkIdentityArgsDict',
    'WorkspaceEncryptionArgs',
    'WorkspaceEncryptionArgsDict',
    'WorkspaceFeatureStoreArgs',
    'WorkspaceFeatureStoreArgsDict',
    'WorkspaceIdentityArgs',
    'WorkspaceIdentityArgsDict',
    'WorkspaceManagedNetworkArgs',
    'WorkspaceManagedNetworkArgsDict',
    'WorkspaceServerlessComputeArgs',
    'WorkspaceServerlessComputeArgsDict',
]

MYPY = False

if not MYPY:
    class ComputeClusterIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this Machine Learning Compute Cluster. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both). Changing this forces a new resource to be created.
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Machine Learning Compute Cluster. Changing this forces a new resource to be created.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Principal ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Compute Cluster.
        """
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Tenant ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Compute Cluster.
        """
elif False:
    ComputeClusterIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ComputeClusterIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this Machine Learning Compute Cluster. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both). Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Machine Learning Compute Cluster. Changing this forces a new resource to be created.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param pulumi.Input[_builtins.str] principal_id: The Principal ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Compute Cluster.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Compute Cluster.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this Machine Learning Compute Cluster. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Machine Learning Compute Cluster. Changing this forces a new resource to be created.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Principal ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Compute Cluster.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Compute Cluster.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class ComputeClusterScaleSettingsArgsDict(TypedDict):
        max_node_count: pulumi.Input[_builtins.int]
        """
        Maximum node count.
        """
        min_node_count: pulumi.Input[_builtins.int]
        """
        Minimal node count.
        """
        scale_down_nodes_after_idle_duration: pulumi.Input[_builtins.str]
        """
        Node Idle Time Before Scale Down: defines the time until the compute is shutdown when it has gone into Idle state. Is defined according to W3C XML schema standard for duration.
        """
elif False:
    ComputeClusterScaleSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ComputeClusterScaleSettingsArgs:
    def __init__(__self__, *,
                 max_node_count: pulumi.Input[_builtins.int],
                 min_node_count: pulumi.Input[_builtins.int],
                 scale_down_nodes_after_idle_duration: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.int] max_node_count: Maximum node count.
        :param pulumi.Input[_builtins.int] min_node_count: Minimal node count.
        :param pulumi.Input[_builtins.str] scale_down_nodes_after_idle_duration: Node Idle Time Before Scale Down: defines the time until the compute is shutdown when it has gone into Idle state. Is defined according to W3C XML schema standard for duration.
        """
        pulumi.set(__self__, "max_node_count", max_node_count)
        pulumi.set(__self__, "min_node_count", min_node_count)
        pulumi.set(__self__, "scale_down_nodes_after_idle_duration", scale_down_nodes_after_idle_duration)

    @_builtins.property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> pulumi.Input[_builtins.int]:
        """
        Maximum node count.
        """
        return pulumi.get(self, "max_node_count")

    @max_node_count.setter
    def max_node_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "max_node_count", value)

    @_builtins.property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> pulumi.Input[_builtins.int]:
        """
        Minimal node count.
        """
        return pulumi.get(self, "min_node_count")

    @min_node_count.setter
    def min_node_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "min_node_count", value)

    @_builtins.property
    @pulumi.getter(name="scaleDownNodesAfterIdleDuration")
    def scale_down_nodes_after_idle_duration(self) -> pulumi.Input[_builtins.str]:
        """
        Node Idle Time Before Scale Down: defines the time until the compute is shutdown when it has gone into Idle state. Is defined according to W3C XML schema standard for duration.
        """
        return pulumi.get(self, "scale_down_nodes_after_idle_duration")

    @scale_down_nodes_after_idle_duration.setter
    def scale_down_nodes_after_idle_duration(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scale_down_nodes_after_idle_duration", value)


if not MYPY:
    class ComputeClusterSshArgsDict(TypedDict):
        admin_username: pulumi.Input[_builtins.str]
        """
        Name of the administrator user account which can be used to SSH to nodes. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        admin_password: NotRequired[pulumi.Input[_builtins.str]]
        """
        Password of the administrator user account. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        key_value: NotRequired[pulumi.Input[_builtins.str]]
        """
        SSH public key of the administrator user account. Changing this forces a new Machine Learning Compute Cluster to be created.

        > **Note:** At least one of `admin_password` and `key_value` shoud be specified.
        """
elif False:
    ComputeClusterSshArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ComputeClusterSshArgs:
    def __init__(__self__, *,
                 admin_username: pulumi.Input[_builtins.str],
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 key_value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] admin_username: Name of the administrator user account which can be used to SSH to nodes. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[_builtins.str] admin_password: Password of the administrator user account. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[_builtins.str] key_value: SSH public key of the administrator user account. Changing this forces a new Machine Learning Compute Cluster to be created.
               
               > **Note:** At least one of `admin_password` and `key_value` shoud be specified.
        """
        pulumi.set(__self__, "admin_username", admin_username)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if key_value is not None:
            pulumi.set(__self__, "key_value", key_value)

    @_builtins.property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the administrator user account which can be used to SSH to nodes. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "admin_username", value)

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password of the administrator user account. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_password", value)

    @_builtins.property
    @pulumi.getter(name="keyValue")
    def key_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SSH public key of the administrator user account. Changing this forces a new Machine Learning Compute Cluster to be created.

        > **Note:** At least one of `admin_password` and `key_value` shoud be specified.
        """
        return pulumi.get(self, "key_value")

    @key_value.setter
    def key_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_value", value)


if not MYPY:
    class ComputeInstanceAssignToUserArgsDict(TypedDict):
        object_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        User’s AAD Object Id.
        """
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        User’s AAD Tenant Id.
        """
elif False:
    ComputeInstanceAssignToUserArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ComputeInstanceAssignToUserArgs:
    def __init__(__self__, *,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] object_id: User’s AAD Object Id.
        :param pulumi.Input[_builtins.str] tenant_id: User’s AAD Tenant Id.
        """
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User’s AAD Object Id.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User’s AAD Tenant Id.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class ComputeInstanceIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this Machine Learning Compute Instance. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both). Changing this forces a new resource to be created.
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Machine Learning Compute Instance. Changing this forces a new resource to be created.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Principal ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Compute Instance.
        """
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Tenant ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Compute Instance.
        """
elif False:
    ComputeInstanceIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ComputeInstanceIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this Machine Learning Compute Instance. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both). Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Machine Learning Compute Instance. Changing this forces a new resource to be created.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param pulumi.Input[_builtins.str] principal_id: The Principal ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Compute Instance.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Compute Instance.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this Machine Learning Compute Instance. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Machine Learning Compute Instance. Changing this forces a new resource to be created.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Principal ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Compute Instance.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Compute Instance.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class ComputeInstanceSshArgsDict(TypedDict):
        public_key: pulumi.Input[_builtins.str]
        """
        Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t rsa -b 2048" to generate your SSH key pairs.
        """
        port: NotRequired[pulumi.Input[_builtins.int]]
        """
        Describes the port for connecting through SSH.
        """
        username: NotRequired[pulumi.Input[_builtins.str]]
        """
        The admin username of this Machine Learning Compute Instance.
        """
elif False:
    ComputeInstanceSshArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ComputeInstanceSshArgs:
    def __init__(__self__, *,
                 public_key: pulumi.Input[_builtins.str],
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] public_key: Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t rsa -b 2048" to generate your SSH key pairs.
        :param pulumi.Input[_builtins.int] port: Describes the port for connecting through SSH.
        :param pulumi.Input[_builtins.str] username: The admin username of this Machine Learning Compute Instance.
        """
        pulumi.set(__self__, "public_key", public_key)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t rsa -b 2048" to generate your SSH key pairs.
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "public_key", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Describes the port for connecting through SSH.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The admin username of this Machine Learning Compute Instance.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


if not MYPY:
    class InferenceClusterIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this Machine Learning Inference Cluster. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both). Changing this forces a new resource to be created.
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Machine Learning Inference Cluster. Changing this forces a new resource to be created.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Principal ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Inference Cluster.
        """
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Tenant ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Inference Cluster.
        """
elif False:
    InferenceClusterIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InferenceClusterIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this Machine Learning Inference Cluster. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both). Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Machine Learning Inference Cluster. Changing this forces a new resource to be created.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param pulumi.Input[_builtins.str] principal_id: The Principal ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Inference Cluster.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Inference Cluster.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this Machine Learning Inference Cluster. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Machine Learning Inference Cluster. Changing this forces a new resource to be created.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Principal ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Inference Cluster.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Inference Cluster.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class InferenceClusterSslArgsDict(TypedDict):
        cert: NotRequired[pulumi.Input[_builtins.str]]
        """
        The certificate for the SSL configuration.Conflicts with `ssl[0].leaf_domain_label`,`ssl[0].overwrite_existing_domain`. Changing this forces a new Machine Learning Inference Cluster to be created. Defaults to `""`.
        """
        cname: NotRequired[pulumi.Input[_builtins.str]]
        """
        The cname of the SSL configuration.Conflicts with `ssl[0].leaf_domain_label`,`ssl[0].overwrite_existing_domain`. Changing this forces a new Machine Learning Inference Cluster to be created. Defaults to `""`.
        """
        key: NotRequired[pulumi.Input[_builtins.str]]
        """
        The key content for the SSL configuration.Conflicts with `ssl[0].leaf_domain_label`,`ssl[0].overwrite_existing_domain`. Changing this forces a new Machine Learning Inference Cluster to be created. Defaults to `""`.
        """
        leaf_domain_label: NotRequired[pulumi.Input[_builtins.str]]
        """
        The leaf domain label for the SSL configuration. Conflicts with `ssl[0].cert`,`ssl[0].key`,`ssl[0].cname`. Changing this forces a new Machine Learning Inference Cluster to be created. Defaults to `""`.
        """
        overwrite_existing_domain: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether or not to overwrite existing leaf domain. Conflicts with `ssl[0].cert`,`ssl[0].key`,`ssl[0].cname` Changing this forces a new Machine Learning Inference Cluster to be created. Defaults to `""`.
        """
elif False:
    InferenceClusterSslArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InferenceClusterSslArgs:
    def __init__(__self__, *,
                 cert: Optional[pulumi.Input[_builtins.str]] = None,
                 cname: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 leaf_domain_label: Optional[pulumi.Input[_builtins.str]] = None,
                 overwrite_existing_domain: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] cert: The certificate for the SSL configuration.Conflicts with `ssl[0].leaf_domain_label`,`ssl[0].overwrite_existing_domain`. Changing this forces a new Machine Learning Inference Cluster to be created. Defaults to `""`.
        :param pulumi.Input[_builtins.str] cname: The cname of the SSL configuration.Conflicts with `ssl[0].leaf_domain_label`,`ssl[0].overwrite_existing_domain`. Changing this forces a new Machine Learning Inference Cluster to be created. Defaults to `""`.
        :param pulumi.Input[_builtins.str] key: The key content for the SSL configuration.Conflicts with `ssl[0].leaf_domain_label`,`ssl[0].overwrite_existing_domain`. Changing this forces a new Machine Learning Inference Cluster to be created. Defaults to `""`.
        :param pulumi.Input[_builtins.str] leaf_domain_label: The leaf domain label for the SSL configuration. Conflicts with `ssl[0].cert`,`ssl[0].key`,`ssl[0].cname`. Changing this forces a new Machine Learning Inference Cluster to be created. Defaults to `""`.
        :param pulumi.Input[_builtins.bool] overwrite_existing_domain: Whether or not to overwrite existing leaf domain. Conflicts with `ssl[0].cert`,`ssl[0].key`,`ssl[0].cname` Changing this forces a new Machine Learning Inference Cluster to be created. Defaults to `""`.
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if cname is not None:
            pulumi.set(__self__, "cname", cname)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if leaf_domain_label is not None:
            pulumi.set(__self__, "leaf_domain_label", leaf_domain_label)
        if overwrite_existing_domain is not None:
            pulumi.set(__self__, "overwrite_existing_domain", overwrite_existing_domain)

    @_builtins.property
    @pulumi.getter
    def cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate for the SSL configuration.Conflicts with `ssl[0].leaf_domain_label`,`ssl[0].overwrite_existing_domain`. Changing this forces a new Machine Learning Inference Cluster to be created. Defaults to `""`.
        """
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert", value)

    @_builtins.property
    @pulumi.getter
    def cname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cname of the SSL configuration.Conflicts with `ssl[0].leaf_domain_label`,`ssl[0].overwrite_existing_domain`. Changing this forces a new Machine Learning Inference Cluster to be created. Defaults to `""`.
        """
        return pulumi.get(self, "cname")

    @cname.setter
    def cname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cname", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key content for the SSL configuration.Conflicts with `ssl[0].leaf_domain_label`,`ssl[0].overwrite_existing_domain`. Changing this forces a new Machine Learning Inference Cluster to be created. Defaults to `""`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="leafDomainLabel")
    def leaf_domain_label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The leaf domain label for the SSL configuration. Conflicts with `ssl[0].cert`,`ssl[0].key`,`ssl[0].cname`. Changing this forces a new Machine Learning Inference Cluster to be created. Defaults to `""`.
        """
        return pulumi.get(self, "leaf_domain_label")

    @leaf_domain_label.setter
    def leaf_domain_label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "leaf_domain_label", value)

    @_builtins.property
    @pulumi.getter(name="overwriteExistingDomain")
    def overwrite_existing_domain(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to overwrite existing leaf domain. Conflicts with `ssl[0].cert`,`ssl[0].key`,`ssl[0].cname` Changing this forces a new Machine Learning Inference Cluster to be created. Defaults to `""`.
        """
        return pulumi.get(self, "overwrite_existing_domain")

    @overwrite_existing_domain.setter
    def overwrite_existing_domain(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "overwrite_existing_domain", value)


if not MYPY:
    class SynapseSparkIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this Machine Learning Synapse Spark. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both). Changing this forces a new resource to be created.
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Machine Learning Synapse Spark. Changing this forces a new resource to be created.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Principal ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Synapse Spark.
        """
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Tenant ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Synapse Spark.
        """
elif False:
    SynapseSparkIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SynapseSparkIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this Machine Learning Synapse Spark. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both). Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Machine Learning Synapse Spark. Changing this forces a new resource to be created.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param pulumi.Input[_builtins.str] principal_id: The Principal ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Synapse Spark.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Synapse Spark.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this Machine Learning Synapse Spark. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Machine Learning Synapse Spark. Changing this forces a new resource to be created.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Principal ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Synapse Spark.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Synapse Spark.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class WorkspaceEncryptionArgsDict(TypedDict):
        key_id: pulumi.Input[_builtins.str]
        """
        The Key Vault URI to access the encryption key.
        """
        key_vault_id: pulumi.Input[_builtins.str]
        """
        The ID of the keyVault where the customer owned encryption key is present.
        """
        user_assigned_identity_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Key Vault URI to access the encryption key.

        > **Note:** `user_assigned_identity_id` must set when`identity.type` is `UserAssigned` or service won't be able to find the assigned permissions.
        """
elif False:
    WorkspaceEncryptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkspaceEncryptionArgs:
    def __init__(__self__, *,
                 key_id: pulumi.Input[_builtins.str],
                 key_vault_id: pulumi.Input[_builtins.str],
                 user_assigned_identity_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] key_id: The Key Vault URI to access the encryption key.
        :param pulumi.Input[_builtins.str] key_vault_id: The ID of the keyVault where the customer owned encryption key is present.
        :param pulumi.Input[_builtins.str] user_assigned_identity_id: The Key Vault URI to access the encryption key.
               
               > **Note:** `user_assigned_identity_id` must set when`identity.type` is `UserAssigned` or service won't be able to find the assigned permissions.
        """
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "key_vault_id", key_vault_id)
        if user_assigned_identity_id is not None:
            pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Key Vault URI to access the encryption key.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_id", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the keyVault where the customer owned encryption key is present.
        """
        return pulumi.get(self, "key_vault_id")

    @key_vault_id.setter
    def key_vault_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_vault_id", value)

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Key Vault URI to access the encryption key.

        > **Note:** `user_assigned_identity_id` must set when`identity.type` is `UserAssigned` or service won't be able to find the assigned permissions.
        """
        return pulumi.get(self, "user_assigned_identity_id")

    @user_assigned_identity_id.setter
    def user_assigned_identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_assigned_identity_id", value)


if not MYPY:
    class WorkspaceFeatureStoreArgsDict(TypedDict):
        computer_spark_runtime_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        The version of Spark runtime.
        """
        offline_connection_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of offline store connection.
        """
        online_connection_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of online store connection.

        > **Note:** `feature_store` must be set when`kind` is `FeatureStore`
        """
elif False:
    WorkspaceFeatureStoreArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkspaceFeatureStoreArgs:
    def __init__(__self__, *,
                 computer_spark_runtime_version: Optional[pulumi.Input[_builtins.str]] = None,
                 offline_connection_name: Optional[pulumi.Input[_builtins.str]] = None,
                 online_connection_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] computer_spark_runtime_version: The version of Spark runtime.
        :param pulumi.Input[_builtins.str] offline_connection_name: The name of offline store connection.
        :param pulumi.Input[_builtins.str] online_connection_name: The name of online store connection.
               
               > **Note:** `feature_store` must be set when`kind` is `FeatureStore`
        """
        if computer_spark_runtime_version is not None:
            pulumi.set(__self__, "computer_spark_runtime_version", computer_spark_runtime_version)
        if offline_connection_name is not None:
            pulumi.set(__self__, "offline_connection_name", offline_connection_name)
        if online_connection_name is not None:
            pulumi.set(__self__, "online_connection_name", online_connection_name)

    @_builtins.property
    @pulumi.getter(name="computerSparkRuntimeVersion")
    def computer_spark_runtime_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of Spark runtime.
        """
        return pulumi.get(self, "computer_spark_runtime_version")

    @computer_spark_runtime_version.setter
    def computer_spark_runtime_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "computer_spark_runtime_version", value)

    @_builtins.property
    @pulumi.getter(name="offlineConnectionName")
    def offline_connection_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of offline store connection.
        """
        return pulumi.get(self, "offline_connection_name")

    @offline_connection_name.setter
    def offline_connection_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "offline_connection_name", value)

    @_builtins.property
    @pulumi.getter(name="onlineConnectionName")
    def online_connection_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of online store connection.

        > **Note:** `feature_store` must be set when`kind` is `FeatureStore`
        """
        return pulumi.get(self, "online_connection_name")

    @online_connection_name.setter
    def online_connection_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "online_connection_name", value)


if not MYPY:
    class WorkspaceIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this Machine Learning Workspace. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Machine Learning Workspace.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Principal ID associated with this Managed Service Identity.
        """
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Tenant ID associated with this Managed Service Identity.
        """
elif False:
    WorkspaceIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkspaceIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this Machine Learning Workspace. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Machine Learning Workspace.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param pulumi.Input[_builtins.str] principal_id: The Principal ID associated with this Managed Service Identity.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this Machine Learning Workspace. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Machine Learning Workspace.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class WorkspaceManagedNetworkArgsDict(TypedDict):
        isolation_mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        The isolation mode of the Machine Learning Workspace. Possible values are `Disabled`, `AllowOnlyApprovedOutbound`, and `AllowInternetOutbound`
        """
elif False:
    WorkspaceManagedNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkspaceManagedNetworkArgs:
    def __init__(__self__, *,
                 isolation_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] isolation_mode: The isolation mode of the Machine Learning Workspace. Possible values are `Disabled`, `AllowOnlyApprovedOutbound`, and `AllowInternetOutbound`
        """
        if isolation_mode is not None:
            pulumi.set(__self__, "isolation_mode", isolation_mode)

    @_builtins.property
    @pulumi.getter(name="isolationMode")
    def isolation_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The isolation mode of the Machine Learning Workspace. Possible values are `Disabled`, `AllowOnlyApprovedOutbound`, and `AllowInternetOutbound`
        """
        return pulumi.get(self, "isolation_mode")

    @isolation_mode.setter
    def isolation_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "isolation_mode", value)


if not MYPY:
    class WorkspaceServerlessComputeArgsDict(TypedDict):
        public_ip_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Should serverless compute nodes deployed in a custom Virtual Network have public IP addresses enabled for a workspace with private endpoint? Defaults to `false`.

        > **Note:** `public_ip_enabled` cannot be updated from `true` to `false` when `subnet_id` is not set. `public_ip_enabled` must be set to `true` if `subnet_id` is not set and when `public_network_access_enabled` is `false`.
        """
        subnet_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of an existing Virtual Network Subnet in which the serverless compute nodes should be deployed to.
        """
elif False:
    WorkspaceServerlessComputeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkspaceServerlessComputeArgs:
    def __init__(__self__, *,
                 public_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] public_ip_enabled: Should serverless compute nodes deployed in a custom Virtual Network have public IP addresses enabled for a workspace with private endpoint? Defaults to `false`.
               
               > **Note:** `public_ip_enabled` cannot be updated from `true` to `false` when `subnet_id` is not set. `public_ip_enabled` must be set to `true` if `subnet_id` is not set and when `public_network_access_enabled` is `false`.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of an existing Virtual Network Subnet in which the serverless compute nodes should be deployed to.
        """
        if public_ip_enabled is not None:
            pulumi.set(__self__, "public_ip_enabled", public_ip_enabled)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="publicIpEnabled")
    def public_ip_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should serverless compute nodes deployed in a custom Virtual Network have public IP addresses enabled for a workspace with private endpoint? Defaults to `false`.

        > **Note:** `public_ip_enabled` cannot be updated from `true` to `false` when `subnet_id` is not set. `public_ip_enabled` must be set to `true` if `subnet_id` is not set and when `public_network_access_enabled` is `false`.
        """
        return pulumi.get(self, "public_ip_enabled")

    @public_ip_enabled.setter
    def public_ip_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_ip_enabled", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of an existing Virtual Network Subnet in which the serverless compute nodes should be deployed to.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)


