# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ApplicationPlanArgs',
    'ApplicationPlanArgsDict',
    'DefinitionAuthorizationArgs',
    'DefinitionAuthorizationArgsDict',
]

MYPY = False

if not MYPY:
    class ApplicationPlanArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        Specifies the name of the plan from the marketplace. Changing this forces a new resource to be created.
        """
        product: pulumi.Input[_builtins.str]
        """
        Specifies the product of the plan from the marketplace. Changing this forces a new resource to be created.
        """
        publisher: pulumi.Input[_builtins.str]
        """
        Specifies the publisher of the plan. Changing this forces a new resource to be created.
        """
        version: pulumi.Input[_builtins.str]
        """
        Specifies the version of the plan from the marketplace. Changing this forces a new resource to be created.
        """
        promotion_code: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the promotion code to use with the plan. Changing this forces a new resource to be created.

        > **Note:** When `plan` is specified, legal terms must be accepted for this item on this subscription before creating the Managed Application. The `marketplace.Agreement` resource or AZ CLI tool can be used to do this.
        """
elif False:
    ApplicationPlanArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationPlanArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 product: pulumi.Input[_builtins.str],
                 publisher: pulumi.Input[_builtins.str],
                 version: pulumi.Input[_builtins.str],
                 promotion_code: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: Specifies the name of the plan from the marketplace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] product: Specifies the product of the plan from the marketplace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] publisher: Specifies the publisher of the plan. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] version: Specifies the version of the plan from the marketplace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] promotion_code: Specifies the promotion code to use with the plan. Changing this forces a new resource to be created.
               
               > **Note:** When `plan` is specified, legal terms must be accepted for this item on this subscription before creating the Managed Application. The `marketplace.Agreement` resource or AZ CLI tool can be used to do this.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "version", version)
        if promotion_code is not None:
            pulumi.set(__self__, "promotion_code", promotion_code)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the plan from the marketplace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def product(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the product of the plan from the marketplace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "product")

    @product.setter
    def product(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "product", value)

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the publisher of the plan. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "publisher", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the version of the plan from the marketplace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="promotionCode")
    def promotion_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the promotion code to use with the plan. Changing this forces a new resource to be created.

        > **Note:** When `plan` is specified, legal terms must be accepted for this item on this subscription before creating the Managed Application. The `marketplace.Agreement` resource or AZ CLI tool can be used to do this.
        """
        return pulumi.get(self, "promotion_code")

    @promotion_code.setter
    def promotion_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "promotion_code", value)


if not MYPY:
    class DefinitionAuthorizationArgsDict(TypedDict):
        role_definition_id: pulumi.Input[_builtins.str]
        """
        Specifies a role definition identifier for the provider. This role will define all the permissions that the provider must have on the managed application's container resource group. This role definition cannot have permission to delete the resource group.
        """
        service_principal_id: pulumi.Input[_builtins.str]
        """
        Specifies a service principal identifier for the provider. This is the identity that the provider will use to call ARM to manage the managed application resources.
        """
elif False:
    DefinitionAuthorizationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DefinitionAuthorizationArgs:
    def __init__(__self__, *,
                 role_definition_id: pulumi.Input[_builtins.str],
                 service_principal_id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] role_definition_id: Specifies a role definition identifier for the provider. This role will define all the permissions that the provider must have on the managed application's container resource group. This role definition cannot have permission to delete the resource group.
        :param pulumi.Input[_builtins.str] service_principal_id: Specifies a service principal identifier for the provider. This is the identity that the provider will use to call ARM to manage the managed application resources.
        """
        pulumi.set(__self__, "role_definition_id", role_definition_id)
        pulumi.set(__self__, "service_principal_id", service_principal_id)

    @_builtins.property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies a role definition identifier for the provider. This role will define all the permissions that the provider must have on the managed application's container resource group. This role definition cannot have permission to delete the resource group.
        """
        return pulumi.get(self, "role_definition_id")

    @role_definition_id.setter
    def role_definition_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_definition_id", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies a service principal identifier for the provider. This is the identity that the provider will use to call ARM to manage the managed application resources.
        """
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_principal_id", value)


