# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFailoverGroupResult',
    'AwaitableGetFailoverGroupResult',
    'get_failover_group',
    'get_failover_group_output',
]

@pulumi.output_type
class GetFailoverGroupResult:
    """
    A collection of values returned by getFailoverGroup.
    """
    def __init__(__self__, databases=None, id=None, name=None, partner_servers=None, read_write_endpoint_failover_policies=None, readonly_endpoint_failover_policy_enabled=None, server_id=None, tags=None):
        if databases and not isinstance(databases, list):
            raise TypeError("Expected argument 'databases' to be a list")
        pulumi.set(__self__, "databases", databases)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if partner_servers and not isinstance(partner_servers, list):
            raise TypeError("Expected argument 'partner_servers' to be a list")
        pulumi.set(__self__, "partner_servers", partner_servers)
        if read_write_endpoint_failover_policies and not isinstance(read_write_endpoint_failover_policies, list):
            raise TypeError("Expected argument 'read_write_endpoint_failover_policies' to be a list")
        pulumi.set(__self__, "read_write_endpoint_failover_policies", read_write_endpoint_failover_policies)
        if readonly_endpoint_failover_policy_enabled and not isinstance(readonly_endpoint_failover_policy_enabled, bool):
            raise TypeError("Expected argument 'readonly_endpoint_failover_policy_enabled' to be a bool")
        pulumi.set(__self__, "readonly_endpoint_failover_policy_enabled", readonly_endpoint_failover_policy_enabled)
        if server_id and not isinstance(server_id, str):
            raise TypeError("Expected argument 'server_id' to be a str")
        pulumi.set(__self__, "server_id", server_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def databases(self) -> Sequence[_builtins.str]:
        """
        A set of database names in the Failover Group.
        """
        return pulumi.get(self, "databases")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="partnerServers")
    def partner_servers(self) -> Sequence['outputs.GetFailoverGroupPartnerServerResult']:
        """
        A `partner_server` block as defined below.
        """
        return pulumi.get(self, "partner_servers")

    @_builtins.property
    @pulumi.getter(name="readWriteEndpointFailoverPolicies")
    def read_write_endpoint_failover_policies(self) -> Sequence['outputs.GetFailoverGroupReadWriteEndpointFailoverPolicyResult']:
        """
        A `read_write_endpoint_failover_policy` block as defined below.
        """
        return pulumi.get(self, "read_write_endpoint_failover_policies")

    @_builtins.property
    @pulumi.getter(name="readonlyEndpointFailoverPolicyEnabled")
    def readonly_endpoint_failover_policy_enabled(self) -> _builtins.bool:
        """
        Whether failover is enabled for the readonly endpoint.
        """
        return pulumi.get(self, "readonly_endpoint_failover_policy_enabled")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> _builtins.str:
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags which are assigned to the resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetFailoverGroupResult(GetFailoverGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFailoverGroupResult(
            databases=self.databases,
            id=self.id,
            name=self.name,
            partner_servers=self.partner_servers,
            read_write_endpoint_failover_policies=self.read_write_endpoint_failover_policies,
            readonly_endpoint_failover_policy_enabled=self.readonly_endpoint_failover_policy_enabled,
            server_id=self.server_id,
            tags=self.tags)


def get_failover_group(name: Optional[_builtins.str] = None,
                       server_id: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFailoverGroupResult:
    """
    Use this data source to access information about an existing Microsoft Azure SQL Failover Group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.mssql.get_failover_group(name="example",
        server_id="example-sql-server")
    pulumi.export("mssqlFailoverGroupId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Sql` - 2023-08-01-preview


    :param _builtins.str name: The name of the Failover Group.
    :param _builtins.str server_id: The ID of the primary SQL Server where the Failover Group exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['serverId'] = server_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:mssql/getFailoverGroup:getFailoverGroup', __args__, opts=opts, typ=GetFailoverGroupResult).value

    return AwaitableGetFailoverGroupResult(
        databases=pulumi.get(__ret__, 'databases'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        partner_servers=pulumi.get(__ret__, 'partner_servers'),
        read_write_endpoint_failover_policies=pulumi.get(__ret__, 'read_write_endpoint_failover_policies'),
        readonly_endpoint_failover_policy_enabled=pulumi.get(__ret__, 'readonly_endpoint_failover_policy_enabled'),
        server_id=pulumi.get(__ret__, 'server_id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_failover_group_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                              server_id: Optional[pulumi.Input[_builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFailoverGroupResult]:
    """
    Use this data source to access information about an existing Microsoft Azure SQL Failover Group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.mssql.get_failover_group(name="example",
        server_id="example-sql-server")
    pulumi.export("mssqlFailoverGroupId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Sql` - 2023-08-01-preview


    :param _builtins.str name: The name of the Failover Group.
    :param _builtins.str server_id: The ID of the primary SQL Server where the Failover Group exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['serverId'] = server_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:mssql/getFailoverGroup:getFailoverGroup', __args__, opts=opts, typ=GetFailoverGroupResult)
    return __ret__.apply(lambda __response__: GetFailoverGroupResult(
        databases=pulumi.get(__response__, 'databases'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        partner_servers=pulumi.get(__response__, 'partner_servers'),
        read_write_endpoint_failover_policies=pulumi.get(__response__, 'read_write_endpoint_failover_policies'),
        readonly_endpoint_failover_policy_enabled=pulumi.get(__response__, 'readonly_endpoint_failover_policy_enabled'),
        server_id=pulumi.get(__response__, 'server_id'),
        tags=pulumi.get(__response__, 'tags')))
