# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPoolResult',
    'AwaitableGetPoolResult',
    'get_pool',
    'get_pool_output',
]

@pulumi.output_type
class GetPoolResult:
    """
    A collection of values returned by getPool.
    """
    def __init__(__self__, account_name=None, cool_access_enabled=None, encryption_type=None, id=None, location=None, name=None, resource_group_name=None, service_level=None, size_in_tb=None):
        if account_name and not isinstance(account_name, str):
            raise TypeError("Expected argument 'account_name' to be a str")
        pulumi.set(__self__, "account_name", account_name)
        if cool_access_enabled and not isinstance(cool_access_enabled, bool):
            raise TypeError("Expected argument 'cool_access_enabled' to be a bool")
        pulumi.set(__self__, "cool_access_enabled", cool_access_enabled)
        if encryption_type and not isinstance(encryption_type, str):
            raise TypeError("Expected argument 'encryption_type' to be a str")
        pulumi.set(__self__, "encryption_type", encryption_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if service_level and not isinstance(service_level, str):
            raise TypeError("Expected argument 'service_level' to be a str")
        pulumi.set(__self__, "service_level", service_level)
        if size_in_tb and not isinstance(size_in_tb, int):
            raise TypeError("Expected argument 'size_in_tb' to be a int")
        pulumi.set(__self__, "size_in_tb", size_in_tb)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> _builtins.str:
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="coolAccessEnabled")
    def cool_access_enabled(self) -> _builtins.bool:
        """
        Whether the NetApp Pool can hold cool access enabled volumes.
        """
        return pulumi.get(self, "cool_access_enabled")

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> _builtins.str:
        """
        The encryption type of the pool.
        """
        return pulumi.get(self, "encryption_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the NetApp Pool exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="serviceLevel")
    def service_level(self) -> _builtins.str:
        """
        The service level of the file system.
        """
        return pulumi.get(self, "service_level")

    @_builtins.property
    @pulumi.getter(name="sizeInTb")
    def size_in_tb(self) -> _builtins.int:
        """
        Provisioned size of the pool in TB.
        """
        return pulumi.get(self, "size_in_tb")


class AwaitableGetPoolResult(GetPoolResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPoolResult(
            account_name=self.account_name,
            cool_access_enabled=self.cool_access_enabled,
            encryption_type=self.encryption_type,
            id=self.id,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            service_level=self.service_level,
            size_in_tb=self.size_in_tb)


def get_pool(account_name: Optional[_builtins.str] = None,
             name: Optional[_builtins.str] = None,
             resource_group_name: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPoolResult:
    """
    Uses this data source to access information about an existing NetApp Pool.

    ## NetApp Pool Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.netapp.get_pool(resource_group_name="acctestRG",
        account_name="acctestnetappaccount",
        name="acctestnetapppool")
    pulumi.export("netappPoolId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.NetApp` - 2025-01-01


    :param _builtins.str account_name: The name of the NetApp account where the NetApp pool exists.
    :param _builtins.str name: The name of the NetApp Pool.
    :param _builtins.str resource_group_name: The Name of the Resource Group where the NetApp Pool exists.
    """
    __args__ = dict()
    __args__['accountName'] = account_name
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:netapp/getPool:getPool', __args__, opts=opts, typ=GetPoolResult).value

    return AwaitableGetPoolResult(
        account_name=pulumi.get(__ret__, 'account_name'),
        cool_access_enabled=pulumi.get(__ret__, 'cool_access_enabled'),
        encryption_type=pulumi.get(__ret__, 'encryption_type'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        service_level=pulumi.get(__ret__, 'service_level'),
        size_in_tb=pulumi.get(__ret__, 'size_in_tb'))
def get_pool_output(account_name: Optional[pulumi.Input[_builtins.str]] = None,
                    name: Optional[pulumi.Input[_builtins.str]] = None,
                    resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPoolResult]:
    """
    Uses this data source to access information about an existing NetApp Pool.

    ## NetApp Pool Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.netapp.get_pool(resource_group_name="acctestRG",
        account_name="acctestnetappaccount",
        name="acctestnetapppool")
    pulumi.export("netappPoolId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.NetApp` - 2025-01-01


    :param _builtins.str account_name: The name of the NetApp account where the NetApp pool exists.
    :param _builtins.str name: The name of the NetApp Pool.
    :param _builtins.str resource_group_name: The Name of the Resource Group where the NetApp Pool exists.
    """
    __args__ = dict()
    __args__['accountName'] = account_name
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:netapp/getPool:getPool', __args__, opts=opts, typ=GetPoolResult)
    return __ret__.apply(lambda __response__: GetPoolResult(
        account_name=pulumi.get(__response__, 'account_name'),
        cool_access_enabled=pulumi.get(__response__, 'cool_access_enabled'),
        encryption_type=pulumi.get(__response__, 'encryption_type'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        service_level=pulumi.get(__response__, 'service_level'),
        size_in_tb=pulumi.get(__response__, 'size_in_tb')))
