# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSubnetResult',
    'AwaitableGetSubnetResult',
    'get_subnet',
    'get_subnet_output',
]

@pulumi.output_type
class GetSubnetResult:
    """
    A collection of values returned by getSubnet.
    """
    def __init__(__self__, address_prefix=None, address_prefixes=None, default_outbound_access_enabled=None, id=None, name=None, network_security_group_id=None, private_endpoint_network_policies=None, private_link_service_network_policies_enabled=None, resource_group_name=None, route_table_id=None, service_endpoints=None, virtual_network_name=None):
        if address_prefix and not isinstance(address_prefix, str):
            raise TypeError("Expected argument 'address_prefix' to be a str")
        pulumi.set(__self__, "address_prefix", address_prefix)
        if address_prefixes and not isinstance(address_prefixes, list):
            raise TypeError("Expected argument 'address_prefixes' to be a list")
        pulumi.set(__self__, "address_prefixes", address_prefixes)
        if default_outbound_access_enabled and not isinstance(default_outbound_access_enabled, bool):
            raise TypeError("Expected argument 'default_outbound_access_enabled' to be a bool")
        pulumi.set(__self__, "default_outbound_access_enabled", default_outbound_access_enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_security_group_id and not isinstance(network_security_group_id, str):
            raise TypeError("Expected argument 'network_security_group_id' to be a str")
        pulumi.set(__self__, "network_security_group_id", network_security_group_id)
        if private_endpoint_network_policies and not isinstance(private_endpoint_network_policies, str):
            raise TypeError("Expected argument 'private_endpoint_network_policies' to be a str")
        pulumi.set(__self__, "private_endpoint_network_policies", private_endpoint_network_policies)
        if private_link_service_network_policies_enabled and not isinstance(private_link_service_network_policies_enabled, bool):
            raise TypeError("Expected argument 'private_link_service_network_policies_enabled' to be a bool")
        pulumi.set(__self__, "private_link_service_network_policies_enabled", private_link_service_network_policies_enabled)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if route_table_id and not isinstance(route_table_id, str):
            raise TypeError("Expected argument 'route_table_id' to be a str")
        pulumi.set(__self__, "route_table_id", route_table_id)
        if service_endpoints and not isinstance(service_endpoints, list):
            raise TypeError("Expected argument 'service_endpoints' to be a list")
        pulumi.set(__self__, "service_endpoints", service_endpoints)
        if virtual_network_name and not isinstance(virtual_network_name, str):
            raise TypeError("Expected argument 'virtual_network_name' to be a str")
        pulumi.set(__self__, "virtual_network_name", virtual_network_name)

    @_builtins.property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> _builtins.str:
        return pulumi.get(self, "address_prefix")

    @_builtins.property
    @pulumi.getter(name="addressPrefixes")
    def address_prefixes(self) -> Sequence[_builtins.str]:
        """
        The address prefixes for the subnet.
        """
        return pulumi.get(self, "address_prefixes")

    @_builtins.property
    @pulumi.getter(name="defaultOutboundAccessEnabled")
    def default_outbound_access_enabled(self) -> _builtins.bool:
        """
        Is the default outbound access enabled for the subnet.
        """
        return pulumi.get(self, "default_outbound_access_enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupId")
    def network_security_group_id(self) -> _builtins.str:
        """
        The ID of the Network Security Group associated with the subnet.
        """
        return pulumi.get(self, "network_security_group_id")

    @_builtins.property
    @pulumi.getter(name="privateEndpointNetworkPolicies")
    def private_endpoint_network_policies(self) -> _builtins.str:
        """
        Enable or Disable network policies for the private endpoint on the subnet.
        """
        return pulumi.get(self, "private_endpoint_network_policies")

    @_builtins.property
    @pulumi.getter(name="privateLinkServiceNetworkPoliciesEnabled")
    def private_link_service_network_policies_enabled(self) -> _builtins.bool:
        """
        Enable or Disable network policies for the private link service on the subnet.
        """
        return pulumi.get(self, "private_link_service_network_policies_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> _builtins.str:
        """
        The ID of the Route Table associated with this subnet.
        """
        return pulumi.get(self, "route_table_id")

    @_builtins.property
    @pulumi.getter(name="serviceEndpoints")
    def service_endpoints(self) -> Sequence[_builtins.str]:
        """
        A list of Service Endpoints within this subnet.
        """
        return pulumi.get(self, "service_endpoints")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkName")
    def virtual_network_name(self) -> _builtins.str:
        return pulumi.get(self, "virtual_network_name")


class AwaitableGetSubnetResult(GetSubnetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubnetResult(
            address_prefix=self.address_prefix,
            address_prefixes=self.address_prefixes,
            default_outbound_access_enabled=self.default_outbound_access_enabled,
            id=self.id,
            name=self.name,
            network_security_group_id=self.network_security_group_id,
            private_endpoint_network_policies=self.private_endpoint_network_policies,
            private_link_service_network_policies_enabled=self.private_link_service_network_policies_enabled,
            resource_group_name=self.resource_group_name,
            route_table_id=self.route_table_id,
            service_endpoints=self.service_endpoints,
            virtual_network_name=self.virtual_network_name)


def get_subnet(name: Optional[_builtins.str] = None,
               resource_group_name: Optional[_builtins.str] = None,
               virtual_network_name: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubnetResult:
    """
    Use this data source to access information about an existing Subnet within a Virtual Network.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_subnet(name="backend",
        virtual_network_name="production",
        resource_group_name="networking")
    pulumi.export("subnetId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2024-05-01


    :param _builtins.str name: Specifies the name of the Subnet.
    :param _builtins.str resource_group_name: Specifies the name of the resource group the Virtual Network is located in.
    :param _builtins.str virtual_network_name: Specifies the name of the Virtual Network this Subnet is located within.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['virtualNetworkName'] = virtual_network_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:network/getSubnet:getSubnet', __args__, opts=opts, typ=GetSubnetResult).value

    return AwaitableGetSubnetResult(
        address_prefix=pulumi.get(__ret__, 'address_prefix'),
        address_prefixes=pulumi.get(__ret__, 'address_prefixes'),
        default_outbound_access_enabled=pulumi.get(__ret__, 'default_outbound_access_enabled'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        network_security_group_id=pulumi.get(__ret__, 'network_security_group_id'),
        private_endpoint_network_policies=pulumi.get(__ret__, 'private_endpoint_network_policies'),
        private_link_service_network_policies_enabled=pulumi.get(__ret__, 'private_link_service_network_policies_enabled'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        route_table_id=pulumi.get(__ret__, 'route_table_id'),
        service_endpoints=pulumi.get(__ret__, 'service_endpoints'),
        virtual_network_name=pulumi.get(__ret__, 'virtual_network_name'))
def get_subnet_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                      resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                      virtual_network_name: Optional[pulumi.Input[_builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSubnetResult]:
    """
    Use this data source to access information about an existing Subnet within a Virtual Network.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_subnet(name="backend",
        virtual_network_name="production",
        resource_group_name="networking")
    pulumi.export("subnetId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2024-05-01


    :param _builtins.str name: Specifies the name of the Subnet.
    :param _builtins.str resource_group_name: Specifies the name of the resource group the Virtual Network is located in.
    :param _builtins.str virtual_network_name: Specifies the name of the Virtual Network this Subnet is located within.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['virtualNetworkName'] = virtual_network_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:network/getSubnet:getSubnet', __args__, opts=opts, typ=GetSubnetResult)
    return __ret__.apply(lambda __response__: GetSubnetResult(
        address_prefix=pulumi.get(__response__, 'address_prefix'),
        address_prefixes=pulumi.get(__response__, 'address_prefixes'),
        default_outbound_access_enabled=pulumi.get(__response__, 'default_outbound_access_enabled'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        network_security_group_id=pulumi.get(__response__, 'network_security_group_id'),
        private_endpoint_network_policies=pulumi.get(__response__, 'private_endpoint_network_policies'),
        private_link_service_network_policies_enabled=pulumi.get(__response__, 'private_link_service_network_policies_enabled'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        route_table_id=pulumi.get(__response__, 'route_table_id'),
        service_endpoints=pulumi.get(__response__, 'service_endpoints'),
        virtual_network_name=pulumi.get(__response__, 'virtual_network_name')))
