# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RouteServerBgpConnectionArgs', 'RouteServerBgpConnection']

@pulumi.input_type
class RouteServerBgpConnectionArgs:
    def __init__(__self__, *,
                 peer_asn: pulumi.Input[_builtins.int],
                 peer_ip: pulumi.Input[_builtins.str],
                 route_server_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RouteServerBgpConnection resource.
        :param pulumi.Input[_builtins.int] peer_asn: The peer autonomous system number for the Route Server Bgp Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] peer_ip: The peer ip address for the Route Server Bgp Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] route_server_id: The ID of the Route Server within which this Bgp connection should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Route Server Bgp Connection. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "peer_asn", peer_asn)
        pulumi.set(__self__, "peer_ip", peer_ip)
        pulumi.set(__self__, "route_server_id", route_server_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> pulumi.Input[_builtins.int]:
        """
        The peer autonomous system number for the Route Server Bgp Connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "peer_asn")

    @peer_asn.setter
    def peer_asn(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "peer_asn", value)

    @_builtins.property
    @pulumi.getter(name="peerIp")
    def peer_ip(self) -> pulumi.Input[_builtins.str]:
        """
        The peer ip address for the Route Server Bgp Connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "peer_ip")

    @peer_ip.setter
    def peer_ip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "peer_ip", value)

    @_builtins.property
    @pulumi.getter(name="routeServerId")
    def route_server_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Route Server within which this Bgp connection should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "route_server_id")

    @route_server_id.setter
    def route_server_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "route_server_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Route Server Bgp Connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _RouteServerBgpConnectionState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_asn: Optional[pulumi.Input[_builtins.int]] = None,
                 peer_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 route_server_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RouteServerBgpConnection resources.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Route Server Bgp Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] peer_asn: The peer autonomous system number for the Route Server Bgp Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] peer_ip: The peer ip address for the Route Server Bgp Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] route_server_id: The ID of the Route Server within which this Bgp connection should be created. Changing this forces a new resource to be created.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)
        if peer_ip is not None:
            pulumi.set(__self__, "peer_ip", peer_ip)
        if route_server_id is not None:
            pulumi.set(__self__, "route_server_id", route_server_id)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Route Server Bgp Connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The peer autonomous system number for the Route Server Bgp Connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "peer_asn")

    @peer_asn.setter
    def peer_asn(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "peer_asn", value)

    @_builtins.property
    @pulumi.getter(name="peerIp")
    def peer_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The peer ip address for the Route Server Bgp Connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "peer_ip")

    @peer_ip.setter
    def peer_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_ip", value)

    @_builtins.property
    @pulumi.getter(name="routeServerId")
    def route_server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Route Server within which this Bgp connection should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "route_server_id")

    @route_server_id.setter
    def route_server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_server_id", value)


@pulumi.type_token("azure:network/routeServerBgpConnection:RouteServerBgpConnection")
class RouteServerBgpConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_asn: Optional[pulumi.Input[_builtins.int]] = None,
                 peer_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 route_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Bgp Connection for a Route Server

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vn",
            address_spaces=["10.0.0.0/16"],
            resource_group_name=example.name,
            location=example.location,
            tags={
                "environment": "Production",
            })
        example_subnet = azure.network.Subnet("example",
            name="RouteServerSubnet",
            virtual_network_name=example_virtual_network.name,
            resource_group_name=example.name,
            address_prefixes=["10.0.1.0/24"])
        example_public_ip = azure.network.PublicIp("example",
            name="example-pip",
            resource_group_name=example.name,
            location=example.location,
            allocation_method="Static",
            sku="Standard")
        example_route_server = azure.network.RouteServer("example",
            name="example-routerserver",
            resource_group_name=example.name,
            location=example.location,
            sku="Standard",
            public_ip_address_id=example_public_ip.id,
            subnet_id=example_subnet.id,
            branch_to_branch_traffic_enabled=True)
        example_route_server_bgp_connection = azure.network.RouteServerBgpConnection("example",
            name="example-rs-bgpconnection",
            route_server_id=example_route_server.id,
            peer_asn=65501,
            peer_ip="169.254.21.5")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2024-05-01

        ## Import

        Route Server Bgp Connections can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/routeServerBgpConnection:RouteServerBgpConnection example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/virtualHubs/routeServer1/bgpConnections/connection1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Route Server Bgp Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] peer_asn: The peer autonomous system number for the Route Server Bgp Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] peer_ip: The peer ip address for the Route Server Bgp Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] route_server_id: The ID of the Route Server within which this Bgp connection should be created. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteServerBgpConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Bgp Connection for a Route Server

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vn",
            address_spaces=["10.0.0.0/16"],
            resource_group_name=example.name,
            location=example.location,
            tags={
                "environment": "Production",
            })
        example_subnet = azure.network.Subnet("example",
            name="RouteServerSubnet",
            virtual_network_name=example_virtual_network.name,
            resource_group_name=example.name,
            address_prefixes=["10.0.1.0/24"])
        example_public_ip = azure.network.PublicIp("example",
            name="example-pip",
            resource_group_name=example.name,
            location=example.location,
            allocation_method="Static",
            sku="Standard")
        example_route_server = azure.network.RouteServer("example",
            name="example-routerserver",
            resource_group_name=example.name,
            location=example.location,
            sku="Standard",
            public_ip_address_id=example_public_ip.id,
            subnet_id=example_subnet.id,
            branch_to_branch_traffic_enabled=True)
        example_route_server_bgp_connection = azure.network.RouteServerBgpConnection("example",
            name="example-rs-bgpconnection",
            route_server_id=example_route_server.id,
            peer_asn=65501,
            peer_ip="169.254.21.5")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2024-05-01

        ## Import

        Route Server Bgp Connections can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/routeServerBgpConnection:RouteServerBgpConnection example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/virtualHubs/routeServer1/bgpConnections/connection1
        ```

        :param str resource_name: The name of the resource.
        :param RouteServerBgpConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteServerBgpConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_asn: Optional[pulumi.Input[_builtins.int]] = None,
                 peer_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 route_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteServerBgpConnectionArgs.__new__(RouteServerBgpConnectionArgs)

            __props__.__dict__["name"] = name
            if peer_asn is None and not opts.urn:
                raise TypeError("Missing required property 'peer_asn'")
            __props__.__dict__["peer_asn"] = peer_asn
            if peer_ip is None and not opts.urn:
                raise TypeError("Missing required property 'peer_ip'")
            __props__.__dict__["peer_ip"] = peer_ip
            if route_server_id is None and not opts.urn:
                raise TypeError("Missing required property 'route_server_id'")
            __props__.__dict__["route_server_id"] = route_server_id
        super(RouteServerBgpConnection, __self__).__init__(
            'azure:network/routeServerBgpConnection:RouteServerBgpConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            peer_asn: Optional[pulumi.Input[_builtins.int]] = None,
            peer_ip: Optional[pulumi.Input[_builtins.str]] = None,
            route_server_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'RouteServerBgpConnection':
        """
        Get an existing RouteServerBgpConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Route Server Bgp Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] peer_asn: The peer autonomous system number for the Route Server Bgp Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] peer_ip: The peer ip address for the Route Server Bgp Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] route_server_id: The ID of the Route Server within which this Bgp connection should be created. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouteServerBgpConnectionState.__new__(_RouteServerBgpConnectionState)

        __props__.__dict__["name"] = name
        __props__.__dict__["peer_asn"] = peer_asn
        __props__.__dict__["peer_ip"] = peer_ip
        __props__.__dict__["route_server_id"] = route_server_id
        return RouteServerBgpConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Route Server Bgp Connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> pulumi.Output[_builtins.int]:
        """
        The peer autonomous system number for the Route Server Bgp Connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "peer_asn")

    @_builtins.property
    @pulumi.getter(name="peerIp")
    def peer_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The peer ip address for the Route Server Bgp Connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "peer_ip")

    @_builtins.property
    @pulumi.getter(name="routeServerId")
    def route_server_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Route Server within which this Bgp connection should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "route_server_id")

