# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetApiKeyResult',
    'AwaitableGetApiKeyResult',
    'get_api_key',
    'get_api_key_output',
]

@pulumi.output_type
class GetApiKeyResult:
    """
    A collection of values returned by getApiKey.
    """
    def __init__(__self__, end_date_time=None, hint=None, id=None, name=None, nginx_deployment_id=None):
        if end_date_time and not isinstance(end_date_time, str):
            raise TypeError("Expected argument 'end_date_time' to be a str")
        pulumi.set(__self__, "end_date_time", end_date_time)
        if hint and not isinstance(hint, str):
            raise TypeError("Expected argument 'hint' to be a str")
        pulumi.set(__self__, "hint", hint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if nginx_deployment_id and not isinstance(nginx_deployment_id, str):
            raise TypeError("Expected argument 'nginx_deployment_id' to be a str")
        pulumi.set(__self__, "nginx_deployment_id", nginx_deployment_id)

    @_builtins.property
    @pulumi.getter(name="endDateTime")
    def end_date_time(self) -> _builtins.str:
        """
        The RFC3339 formatted time after which this Dataplane API Key is no longer valid.
        """
        return pulumi.get(self, "end_date_time")

    @_builtins.property
    @pulumi.getter
    def hint(self) -> _builtins.str:
        """
        The first three characters of the secret text to help identify it in use.
        """
        return pulumi.get(self, "hint")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nginxDeploymentId")
    def nginx_deployment_id(self) -> _builtins.str:
        return pulumi.get(self, "nginx_deployment_id")


class AwaitableGetApiKeyResult(GetApiKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiKeyResult(
            end_date_time=self.end_date_time,
            hint=self.hint,
            id=self.id,
            name=self.name,
            nginx_deployment_id=self.nginx_deployment_id)


def get_api_key(name: Optional[_builtins.str] = None,
                nginx_deployment_id: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiKeyResult:
    """
    Use this data source to access information about an existing NGINX Dataplane API Key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.nginx.get_api_key(name="existing",
        nginx_deployment_id=example_azurerm_nginx_deployment["id"])
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Nginx.NginxPlus` - 2024-11-01-preview


    :param _builtins.str name: The name of the NGINX Dataplane API Key.
    :param _builtins.str nginx_deployment_id: The ID of the NGINX Deployment that the API key is associated with.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['nginxDeploymentId'] = nginx_deployment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:nginx/getApiKey:getApiKey', __args__, opts=opts, typ=GetApiKeyResult).value

    return AwaitableGetApiKeyResult(
        end_date_time=pulumi.get(__ret__, 'end_date_time'),
        hint=pulumi.get(__ret__, 'hint'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        nginx_deployment_id=pulumi.get(__ret__, 'nginx_deployment_id'))
def get_api_key_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                       nginx_deployment_id: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApiKeyResult]:
    """
    Use this data source to access information about an existing NGINX Dataplane API Key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.nginx.get_api_key(name="existing",
        nginx_deployment_id=example_azurerm_nginx_deployment["id"])
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Nginx.NginxPlus` - 2024-11-01-preview


    :param _builtins.str name: The name of the NGINX Dataplane API Key.
    :param _builtins.str nginx_deployment_id: The ID of the NGINX Deployment that the API key is associated with.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['nginxDeploymentId'] = nginx_deployment_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:nginx/getApiKey:getApiKey', __args__, opts=opts, typ=GetApiKeyResult)
    return __ret__.apply(lambda __response__: GetApiKeyResult(
        end_date_time=pulumi.get(__response__, 'end_date_time'),
        hint=pulumi.get(__response__, 'hint'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        nginx_deployment_id=pulumi.get(__response__, 'nginx_deployment_id')))
