# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LocalRulestackRuleArgs', 'LocalRulestackRule']

@pulumi.input_type
class LocalRulestackRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 applications: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 destination: pulumi.Input['LocalRulestackRuleDestinationArgs'],
                 priority: pulumi.Input[_builtins.int],
                 rulestack_id: pulumi.Input[_builtins.str],
                 source: pulumi.Input['LocalRulestackRuleSourceArgs'],
                 audit_comment: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input['LocalRulestackRuleCategoryArgs']] = None,
                 decryption_rule_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 inspection_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negate_destination: Optional[pulumi.Input[_builtins.bool]] = None,
                 negate_source: Optional[pulumi.Input[_builtins.bool]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol_ports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a LocalRulestackRule resource.
        :param pulumi.Input[_builtins.str] action: The action to take on the rule being triggered. Possible values are `Allow`, `DenyResetBoth`, `DenyResetServer` and `DenySilent`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: Specifies a list of Applications.
        :param pulumi.Input['LocalRulestackRuleDestinationArgs'] destination: One or more `destination` blocks as defined below.
        :param pulumi.Input[_builtins.int] priority: The Priority of this rule. Rules are executed in numerical order. Changing this forces a new Palo Alto Local Rulestack Rule to be created.
               
               > **Note:** This is the primary identifier of a rule, as such it is not possible to change the Priority of a rule once created.
        :param pulumi.Input[_builtins.str] rulestack_id: The ID of the Local Rulestack in which to create this Rule. Changing this forces a new Palo Alto Local Rulestack Rule to be created.
        :param pulumi.Input['LocalRulestackRuleSourceArgs'] source: One or more `source` blocks as defined below.
        :param pulumi.Input[_builtins.str] audit_comment: The comment for Audit purposes.
        :param pulumi.Input['LocalRulestackRuleCategoryArgs'] category: A `category` block as defined below.
        :param pulumi.Input[_builtins.str] decryption_rule_type: The type of Decryption to perform on the rule. Possible values include `SSLInboundInspection`, `SSLOutboundInspection`, and `None`. Defaults to `None`.
        :param pulumi.Input[_builtins.str] description: The description for the rule.
        :param pulumi.Input[_builtins.bool] enabled: Should this Rule be enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] inspection_certificate_id: The ID of the certificate for inbound inspection. Only valid when `decryption_rule_type` is set to `SSLInboundInspection`.
        :param pulumi.Input[_builtins.bool] logging_enabled: Should Logging be enabled? Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Palo Alto Local Rulestack Rule.
        :param pulumi.Input[_builtins.bool] negate_destination: Should the inverse of the Destination configuration be used. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] negate_source: Should the inverse of the Source configuration be used. Defaults to `false`.
        :param pulumi.Input[_builtins.str] protocol: The Protocol and port to use in the form `[protocol]:[port_number]` e.g. `TCP:8080` or `UDP:53`. Conflicts with `protocol_ports`. Defaults to `application-default`.
               
               > **Note:** In 4.0 or later versions, the default of `protocol` will no longer be set by provider, exactly one of `protocol` and `protocol_ports` must be specified. You need to explicitly specify `protocol="application-default"` to keep the the current default of the `protocol`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protocol_ports: Specifies a list of Protocol:Port entries. E.g. `[ "TCP:80", "UDP:5431" ]`. Conflicts with `protocol`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Palo Alto Local Rulestack Rule.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "applications", applications)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "rulestack_id", rulestack_id)
        pulumi.set(__self__, "source", source)
        if audit_comment is not None:
            pulumi.set(__self__, "audit_comment", audit_comment)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if decryption_rule_type is not None:
            pulumi.set(__self__, "decryption_rule_type", decryption_rule_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if inspection_certificate_id is not None:
            pulumi.set(__self__, "inspection_certificate_id", inspection_certificate_id)
        if logging_enabled is not None:
            pulumi.set(__self__, "logging_enabled", logging_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if negate_destination is not None:
            pulumi.set(__self__, "negate_destination", negate_destination)
        if negate_source is not None:
            pulumi.set(__self__, "negate_source", negate_source)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if protocol_ports is not None:
            pulumi.set(__self__, "protocol_ports", protocol_ports)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        The action to take on the rule being triggered. Possible values are `Allow`, `DenyResetBoth`, `DenyResetServer` and `DenySilent`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def applications(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies a list of Applications.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "applications", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Input['LocalRulestackRuleDestinationArgs']:
        """
        One or more `destination` blocks as defined below.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['LocalRulestackRuleDestinationArgs']):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Input[_builtins.int]:
        """
        The Priority of this rule. Rules are executed in numerical order. Changing this forces a new Palo Alto Local Rulestack Rule to be created.

        > **Note:** This is the primary identifier of a rule, as such it is not possible to change the Priority of a rule once created.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="rulestackId")
    def rulestack_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Local Rulestack in which to create this Rule. Changing this forces a new Palo Alto Local Rulestack Rule to be created.
        """
        return pulumi.get(self, "rulestack_id")

    @rulestack_id.setter
    def rulestack_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rulestack_id", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Input['LocalRulestackRuleSourceArgs']:
        """
        One or more `source` blocks as defined below.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['LocalRulestackRuleSourceArgs']):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="auditComment")
    def audit_comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The comment for Audit purposes.
        """
        return pulumi.get(self, "audit_comment")

    @audit_comment.setter
    def audit_comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "audit_comment", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input['LocalRulestackRuleCategoryArgs']]:
        """
        A `category` block as defined below.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input['LocalRulestackRuleCategoryArgs']]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="decryptionRuleType")
    def decryption_rule_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of Decryption to perform on the rule. Possible values include `SSLInboundInspection`, `SSLOutboundInspection`, and `None`. Defaults to `None`.
        """
        return pulumi.get(self, "decryption_rule_type")

    @decryption_rule_type.setter
    def decryption_rule_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "decryption_rule_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should this Rule be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="inspectionCertificateId")
    def inspection_certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the certificate for inbound inspection. Only valid when `decryption_rule_type` is set to `SSLInboundInspection`.
        """
        return pulumi.get(self, "inspection_certificate_id")

    @inspection_certificate_id.setter
    def inspection_certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "inspection_certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="loggingEnabled")
    def logging_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should Logging be enabled? Defaults to `false`.
        """
        return pulumi.get(self, "logging_enabled")

    @logging_enabled.setter
    def logging_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "logging_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Palo Alto Local Rulestack Rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="negateDestination")
    def negate_destination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the inverse of the Destination configuration be used. Defaults to `false`.
        """
        return pulumi.get(self, "negate_destination")

    @negate_destination.setter
    def negate_destination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "negate_destination", value)

    @_builtins.property
    @pulumi.getter(name="negateSource")
    def negate_source(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the inverse of the Source configuration be used. Defaults to `false`.
        """
        return pulumi.get(self, "negate_source")

    @negate_source.setter
    def negate_source(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "negate_source", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Protocol and port to use in the form `[protocol]:[port_number]` e.g. `TCP:8080` or `UDP:53`. Conflicts with `protocol_ports`. Defaults to `application-default`.

        > **Note:** In 4.0 or later versions, the default of `protocol` will no longer be set by provider, exactly one of `protocol` and `protocol_ports` must be specified. You need to explicitly specify `protocol="application-default"` to keep the the current default of the `protocol`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="protocolPorts")
    def protocol_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Protocol:Port entries. E.g. `[ "TCP:80", "UDP:5431" ]`. Conflicts with `protocol`.
        """
        return pulumi.get(self, "protocol_ports")

    @protocol_ports.setter
    def protocol_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "protocol_ports", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Palo Alto Local Rulestack Rule.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _LocalRulestackRuleState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_comment: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input['LocalRulestackRuleCategoryArgs']] = None,
                 decryption_rule_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input['LocalRulestackRuleDestinationArgs']] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 inspection_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negate_destination: Optional[pulumi.Input[_builtins.bool]] = None,
                 negate_source: Optional[pulumi.Input[_builtins.bool]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol_ports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rulestack_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input['LocalRulestackRuleSourceArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering LocalRulestackRule resources.
        :param pulumi.Input[_builtins.str] action: The action to take on the rule being triggered. Possible values are `Allow`, `DenyResetBoth`, `DenyResetServer` and `DenySilent`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: Specifies a list of Applications.
        :param pulumi.Input[_builtins.str] audit_comment: The comment for Audit purposes.
        :param pulumi.Input['LocalRulestackRuleCategoryArgs'] category: A `category` block as defined below.
        :param pulumi.Input[_builtins.str] decryption_rule_type: The type of Decryption to perform on the rule. Possible values include `SSLInboundInspection`, `SSLOutboundInspection`, and `None`. Defaults to `None`.
        :param pulumi.Input[_builtins.str] description: The description for the rule.
        :param pulumi.Input['LocalRulestackRuleDestinationArgs'] destination: One or more `destination` blocks as defined below.
        :param pulumi.Input[_builtins.bool] enabled: Should this Rule be enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] inspection_certificate_id: The ID of the certificate for inbound inspection. Only valid when `decryption_rule_type` is set to `SSLInboundInspection`.
        :param pulumi.Input[_builtins.bool] logging_enabled: Should Logging be enabled? Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Palo Alto Local Rulestack Rule.
        :param pulumi.Input[_builtins.bool] negate_destination: Should the inverse of the Destination configuration be used. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] negate_source: Should the inverse of the Source configuration be used. Defaults to `false`.
        :param pulumi.Input[_builtins.int] priority: The Priority of this rule. Rules are executed in numerical order. Changing this forces a new Palo Alto Local Rulestack Rule to be created.
               
               > **Note:** This is the primary identifier of a rule, as such it is not possible to change the Priority of a rule once created.
        :param pulumi.Input[_builtins.str] protocol: The Protocol and port to use in the form `[protocol]:[port_number]` e.g. `TCP:8080` or `UDP:53`. Conflicts with `protocol_ports`. Defaults to `application-default`.
               
               > **Note:** In 4.0 or later versions, the default of `protocol` will no longer be set by provider, exactly one of `protocol` and `protocol_ports` must be specified. You need to explicitly specify `protocol="application-default"` to keep the the current default of the `protocol`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protocol_ports: Specifies a list of Protocol:Port entries. E.g. `[ "TCP:80", "UDP:5431" ]`. Conflicts with `protocol`.
        :param pulumi.Input[_builtins.str] rulestack_id: The ID of the Local Rulestack in which to create this Rule. Changing this forces a new Palo Alto Local Rulestack Rule to be created.
        :param pulumi.Input['LocalRulestackRuleSourceArgs'] source: One or more `source` blocks as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Palo Alto Local Rulestack Rule.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if audit_comment is not None:
            pulumi.set(__self__, "audit_comment", audit_comment)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if decryption_rule_type is not None:
            pulumi.set(__self__, "decryption_rule_type", decryption_rule_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if inspection_certificate_id is not None:
            pulumi.set(__self__, "inspection_certificate_id", inspection_certificate_id)
        if logging_enabled is not None:
            pulumi.set(__self__, "logging_enabled", logging_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if negate_destination is not None:
            pulumi.set(__self__, "negate_destination", negate_destination)
        if negate_source is not None:
            pulumi.set(__self__, "negate_source", negate_source)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if protocol_ports is not None:
            pulumi.set(__self__, "protocol_ports", protocol_ports)
        if rulestack_id is not None:
            pulumi.set(__self__, "rulestack_id", rulestack_id)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The action to take on the rule being triggered. Possible values are `Allow`, `DenyResetBoth`, `DenyResetServer` and `DenySilent`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Applications.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "applications", value)

    @_builtins.property
    @pulumi.getter(name="auditComment")
    def audit_comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The comment for Audit purposes.
        """
        return pulumi.get(self, "audit_comment")

    @audit_comment.setter
    def audit_comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "audit_comment", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input['LocalRulestackRuleCategoryArgs']]:
        """
        A `category` block as defined below.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input['LocalRulestackRuleCategoryArgs']]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="decryptionRuleType")
    def decryption_rule_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of Decryption to perform on the rule. Possible values include `SSLInboundInspection`, `SSLOutboundInspection`, and `None`. Defaults to `None`.
        """
        return pulumi.get(self, "decryption_rule_type")

    @decryption_rule_type.setter
    def decryption_rule_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "decryption_rule_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input['LocalRulestackRuleDestinationArgs']]:
        """
        One or more `destination` blocks as defined below.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input['LocalRulestackRuleDestinationArgs']]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should this Rule be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="inspectionCertificateId")
    def inspection_certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the certificate for inbound inspection. Only valid when `decryption_rule_type` is set to `SSLInboundInspection`.
        """
        return pulumi.get(self, "inspection_certificate_id")

    @inspection_certificate_id.setter
    def inspection_certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "inspection_certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="loggingEnabled")
    def logging_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should Logging be enabled? Defaults to `false`.
        """
        return pulumi.get(self, "logging_enabled")

    @logging_enabled.setter
    def logging_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "logging_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Palo Alto Local Rulestack Rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="negateDestination")
    def negate_destination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the inverse of the Destination configuration be used. Defaults to `false`.
        """
        return pulumi.get(self, "negate_destination")

    @negate_destination.setter
    def negate_destination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "negate_destination", value)

    @_builtins.property
    @pulumi.getter(name="negateSource")
    def negate_source(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the inverse of the Source configuration be used. Defaults to `false`.
        """
        return pulumi.get(self, "negate_source")

    @negate_source.setter
    def negate_source(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "negate_source", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Priority of this rule. Rules are executed in numerical order. Changing this forces a new Palo Alto Local Rulestack Rule to be created.

        > **Note:** This is the primary identifier of a rule, as such it is not possible to change the Priority of a rule once created.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Protocol and port to use in the form `[protocol]:[port_number]` e.g. `TCP:8080` or `UDP:53`. Conflicts with `protocol_ports`. Defaults to `application-default`.

        > **Note:** In 4.0 or later versions, the default of `protocol` will no longer be set by provider, exactly one of `protocol` and `protocol_ports` must be specified. You need to explicitly specify `protocol="application-default"` to keep the the current default of the `protocol`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="protocolPorts")
    def protocol_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Protocol:Port entries. E.g. `[ "TCP:80", "UDP:5431" ]`. Conflicts with `protocol`.
        """
        return pulumi.get(self, "protocol_ports")

    @protocol_ports.setter
    def protocol_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "protocol_ports", value)

    @_builtins.property
    @pulumi.getter(name="rulestackId")
    def rulestack_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Local Rulestack in which to create this Rule. Changing this forces a new Palo Alto Local Rulestack Rule to be created.
        """
        return pulumi.get(self, "rulestack_id")

    @rulestack_id.setter
    def rulestack_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rulestack_id", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['LocalRulestackRuleSourceArgs']]:
        """
        One or more `source` blocks as defined below.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['LocalRulestackRuleSourceArgs']]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Palo Alto Local Rulestack Rule.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:paloalto/localRulestackRule:LocalRulestackRule")
class LocalRulestackRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_comment: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input[Union['LocalRulestackRuleCategoryArgs', 'LocalRulestackRuleCategoryArgsDict']]] = None,
                 decryption_rule_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[Union['LocalRulestackRuleDestinationArgs', 'LocalRulestackRuleDestinationArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 inspection_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negate_destination: Optional[pulumi.Input[_builtins.bool]] = None,
                 negate_source: Optional[pulumi.Input[_builtins.bool]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol_ports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rulestack_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[Union['LocalRulestackRuleSourceArgs', 'LocalRulestackRuleSourceArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Palo Alto Local Rulestack Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="rg-example",
            location="West Europe")
        example_local_rulestack = azure.paloalto.LocalRulestack("example",
            name="lrs-example",
            resource_group_name=example.name,
            location=example.location)
        example_local_rulestack_rule = azure.paloalto.LocalRulestackRule("example",
            name="example-rule",
            rulestack_id=example_local_rulestack.id,
            priority=1000,
            action="Allow",
            protocol="application-default",
            applications=["any"],
            source={
                "cidrs": ["10.0.0.0/8"],
            },
            destination={
                "cidrs": ["192.168.16.0/24"],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `PaloAltoNetworks.Cloudngfw` - 2022-08-29

        ## Import

        Palo Alto Local Rulestack Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:paloalto/localRulestackRule:LocalRulestackRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/PaloAltoNetworks.Cloudngfw/localRulestacks/myLocalRulestack/localRules/myRule1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: The action to take on the rule being triggered. Possible values are `Allow`, `DenyResetBoth`, `DenyResetServer` and `DenySilent`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: Specifies a list of Applications.
        :param pulumi.Input[_builtins.str] audit_comment: The comment for Audit purposes.
        :param pulumi.Input[Union['LocalRulestackRuleCategoryArgs', 'LocalRulestackRuleCategoryArgsDict']] category: A `category` block as defined below.
        :param pulumi.Input[_builtins.str] decryption_rule_type: The type of Decryption to perform on the rule. Possible values include `SSLInboundInspection`, `SSLOutboundInspection`, and `None`. Defaults to `None`.
        :param pulumi.Input[_builtins.str] description: The description for the rule.
        :param pulumi.Input[Union['LocalRulestackRuleDestinationArgs', 'LocalRulestackRuleDestinationArgsDict']] destination: One or more `destination` blocks as defined below.
        :param pulumi.Input[_builtins.bool] enabled: Should this Rule be enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] inspection_certificate_id: The ID of the certificate for inbound inspection. Only valid when `decryption_rule_type` is set to `SSLInboundInspection`.
        :param pulumi.Input[_builtins.bool] logging_enabled: Should Logging be enabled? Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Palo Alto Local Rulestack Rule.
        :param pulumi.Input[_builtins.bool] negate_destination: Should the inverse of the Destination configuration be used. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] negate_source: Should the inverse of the Source configuration be used. Defaults to `false`.
        :param pulumi.Input[_builtins.int] priority: The Priority of this rule. Rules are executed in numerical order. Changing this forces a new Palo Alto Local Rulestack Rule to be created.
               
               > **Note:** This is the primary identifier of a rule, as such it is not possible to change the Priority of a rule once created.
        :param pulumi.Input[_builtins.str] protocol: The Protocol and port to use in the form `[protocol]:[port_number]` e.g. `TCP:8080` or `UDP:53`. Conflicts with `protocol_ports`. Defaults to `application-default`.
               
               > **Note:** In 4.0 or later versions, the default of `protocol` will no longer be set by provider, exactly one of `protocol` and `protocol_ports` must be specified. You need to explicitly specify `protocol="application-default"` to keep the the current default of the `protocol`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protocol_ports: Specifies a list of Protocol:Port entries. E.g. `[ "TCP:80", "UDP:5431" ]`. Conflicts with `protocol`.
        :param pulumi.Input[_builtins.str] rulestack_id: The ID of the Local Rulestack in which to create this Rule. Changing this forces a new Palo Alto Local Rulestack Rule to be created.
        :param pulumi.Input[Union['LocalRulestackRuleSourceArgs', 'LocalRulestackRuleSourceArgsDict']] source: One or more `source` blocks as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Palo Alto Local Rulestack Rule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LocalRulestackRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Palo Alto Local Rulestack Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="rg-example",
            location="West Europe")
        example_local_rulestack = azure.paloalto.LocalRulestack("example",
            name="lrs-example",
            resource_group_name=example.name,
            location=example.location)
        example_local_rulestack_rule = azure.paloalto.LocalRulestackRule("example",
            name="example-rule",
            rulestack_id=example_local_rulestack.id,
            priority=1000,
            action="Allow",
            protocol="application-default",
            applications=["any"],
            source={
                "cidrs": ["10.0.0.0/8"],
            },
            destination={
                "cidrs": ["192.168.16.0/24"],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `PaloAltoNetworks.Cloudngfw` - 2022-08-29

        ## Import

        Palo Alto Local Rulestack Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:paloalto/localRulestackRule:LocalRulestackRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/PaloAltoNetworks.Cloudngfw/localRulestacks/myLocalRulestack/localRules/myRule1
        ```

        :param str resource_name: The name of the resource.
        :param LocalRulestackRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LocalRulestackRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_comment: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input[Union['LocalRulestackRuleCategoryArgs', 'LocalRulestackRuleCategoryArgsDict']]] = None,
                 decryption_rule_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[Union['LocalRulestackRuleDestinationArgs', 'LocalRulestackRuleDestinationArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 inspection_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 negate_destination: Optional[pulumi.Input[_builtins.bool]] = None,
                 negate_source: Optional[pulumi.Input[_builtins.bool]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol_ports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rulestack_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[Union['LocalRulestackRuleSourceArgs', 'LocalRulestackRuleSourceArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LocalRulestackRuleArgs.__new__(LocalRulestackRuleArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if applications is None and not opts.urn:
                raise TypeError("Missing required property 'applications'")
            __props__.__dict__["applications"] = applications
            __props__.__dict__["audit_comment"] = audit_comment
            __props__.__dict__["category"] = category
            __props__.__dict__["decryption_rule_type"] = decryption_rule_type
            __props__.__dict__["description"] = description
            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["inspection_certificate_id"] = inspection_certificate_id
            __props__.__dict__["logging_enabled"] = logging_enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["negate_destination"] = negate_destination
            __props__.__dict__["negate_source"] = negate_source
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["protocol_ports"] = protocol_ports
            if rulestack_id is None and not opts.urn:
                raise TypeError("Missing required property 'rulestack_id'")
            __props__.__dict__["rulestack_id"] = rulestack_id
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["tags"] = tags
        super(LocalRulestackRule, __self__).__init__(
            'azure:paloalto/localRulestackRule:LocalRulestackRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            applications: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            audit_comment: Optional[pulumi.Input[_builtins.str]] = None,
            category: Optional[pulumi.Input[Union['LocalRulestackRuleCategoryArgs', 'LocalRulestackRuleCategoryArgsDict']]] = None,
            decryption_rule_type: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destination: Optional[pulumi.Input[Union['LocalRulestackRuleDestinationArgs', 'LocalRulestackRuleDestinationArgsDict']]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            inspection_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
            logging_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            negate_destination: Optional[pulumi.Input[_builtins.bool]] = None,
            negate_source: Optional[pulumi.Input[_builtins.bool]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            protocol_ports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            rulestack_id: Optional[pulumi.Input[_builtins.str]] = None,
            source: Optional[pulumi.Input[Union['LocalRulestackRuleSourceArgs', 'LocalRulestackRuleSourceArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'LocalRulestackRule':
        """
        Get an existing LocalRulestackRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: The action to take on the rule being triggered. Possible values are `Allow`, `DenyResetBoth`, `DenyResetServer` and `DenySilent`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applications: Specifies a list of Applications.
        :param pulumi.Input[_builtins.str] audit_comment: The comment for Audit purposes.
        :param pulumi.Input[Union['LocalRulestackRuleCategoryArgs', 'LocalRulestackRuleCategoryArgsDict']] category: A `category` block as defined below.
        :param pulumi.Input[_builtins.str] decryption_rule_type: The type of Decryption to perform on the rule. Possible values include `SSLInboundInspection`, `SSLOutboundInspection`, and `None`. Defaults to `None`.
        :param pulumi.Input[_builtins.str] description: The description for the rule.
        :param pulumi.Input[Union['LocalRulestackRuleDestinationArgs', 'LocalRulestackRuleDestinationArgsDict']] destination: One or more `destination` blocks as defined below.
        :param pulumi.Input[_builtins.bool] enabled: Should this Rule be enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] inspection_certificate_id: The ID of the certificate for inbound inspection. Only valid when `decryption_rule_type` is set to `SSLInboundInspection`.
        :param pulumi.Input[_builtins.bool] logging_enabled: Should Logging be enabled? Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Palo Alto Local Rulestack Rule.
        :param pulumi.Input[_builtins.bool] negate_destination: Should the inverse of the Destination configuration be used. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] negate_source: Should the inverse of the Source configuration be used. Defaults to `false`.
        :param pulumi.Input[_builtins.int] priority: The Priority of this rule. Rules are executed in numerical order. Changing this forces a new Palo Alto Local Rulestack Rule to be created.
               
               > **Note:** This is the primary identifier of a rule, as such it is not possible to change the Priority of a rule once created.
        :param pulumi.Input[_builtins.str] protocol: The Protocol and port to use in the form `[protocol]:[port_number]` e.g. `TCP:8080` or `UDP:53`. Conflicts with `protocol_ports`. Defaults to `application-default`.
               
               > **Note:** In 4.0 or later versions, the default of `protocol` will no longer be set by provider, exactly one of `protocol` and `protocol_ports` must be specified. You need to explicitly specify `protocol="application-default"` to keep the the current default of the `protocol`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protocol_ports: Specifies a list of Protocol:Port entries. E.g. `[ "TCP:80", "UDP:5431" ]`. Conflicts with `protocol`.
        :param pulumi.Input[_builtins.str] rulestack_id: The ID of the Local Rulestack in which to create this Rule. Changing this forces a new Palo Alto Local Rulestack Rule to be created.
        :param pulumi.Input[Union['LocalRulestackRuleSourceArgs', 'LocalRulestackRuleSourceArgsDict']] source: One or more `source` blocks as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Palo Alto Local Rulestack Rule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LocalRulestackRuleState.__new__(_LocalRulestackRuleState)

        __props__.__dict__["action"] = action
        __props__.__dict__["applications"] = applications
        __props__.__dict__["audit_comment"] = audit_comment
        __props__.__dict__["category"] = category
        __props__.__dict__["decryption_rule_type"] = decryption_rule_type
        __props__.__dict__["description"] = description
        __props__.__dict__["destination"] = destination
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["inspection_certificate_id"] = inspection_certificate_id
        __props__.__dict__["logging_enabled"] = logging_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["negate_destination"] = negate_destination
        __props__.__dict__["negate_source"] = negate_source
        __props__.__dict__["priority"] = priority
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["protocol_ports"] = protocol_ports
        __props__.__dict__["rulestack_id"] = rulestack_id
        __props__.__dict__["source"] = source
        __props__.__dict__["tags"] = tags
        return LocalRulestackRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[_builtins.str]:
        """
        The action to take on the rule being triggered. Possible values are `Allow`, `DenyResetBoth`, `DenyResetServer` and `DenySilent`.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def applications(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies a list of Applications.
        """
        return pulumi.get(self, "applications")

    @_builtins.property
    @pulumi.getter(name="auditComment")
    def audit_comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The comment for Audit purposes.
        """
        return pulumi.get(self, "audit_comment")

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Output[Optional['outputs.LocalRulestackRuleCategory']]:
        """
        A `category` block as defined below.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="decryptionRuleType")
    def decryption_rule_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of Decryption to perform on the rule. Possible values include `SSLInboundInspection`, `SSLOutboundInspection`, and `None`. Defaults to `None`.
        """
        return pulumi.get(self, "decryption_rule_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description for the rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Output['outputs.LocalRulestackRuleDestination']:
        """
        One or more `destination` blocks as defined below.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should this Rule be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="inspectionCertificateId")
    def inspection_certificate_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the certificate for inbound inspection. Only valid when `decryption_rule_type` is set to `SSLInboundInspection`.
        """
        return pulumi.get(self, "inspection_certificate_id")

    @_builtins.property
    @pulumi.getter(name="loggingEnabled")
    def logging_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should Logging be enabled? Defaults to `false`.
        """
        return pulumi.get(self, "logging_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Palo Alto Local Rulestack Rule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="negateDestination")
    def negate_destination(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the inverse of the Destination configuration be used. Defaults to `false`.
        """
        return pulumi.get(self, "negate_destination")

    @_builtins.property
    @pulumi.getter(name="negateSource")
    def negate_source(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the inverse of the Source configuration be used. Defaults to `false`.
        """
        return pulumi.get(self, "negate_source")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[_builtins.int]:
        """
        The Priority of this rule. Rules are executed in numerical order. Changing this forces a new Palo Alto Local Rulestack Rule to be created.

        > **Note:** This is the primary identifier of a rule, as such it is not possible to change the Priority of a rule once created.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Protocol and port to use in the form `[protocol]:[port_number]` e.g. `TCP:8080` or `UDP:53`. Conflicts with `protocol_ports`. Defaults to `application-default`.

        > **Note:** In 4.0 or later versions, the default of `protocol` will no longer be set by provider, exactly one of `protocol` and `protocol_ports` must be specified. You need to explicitly specify `protocol="application-default"` to keep the the current default of the `protocol`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="protocolPorts")
    def protocol_ports(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of Protocol:Port entries. E.g. `[ "TCP:80", "UDP:5431" ]`. Conflicts with `protocol`.
        """
        return pulumi.get(self, "protocol_ports")

    @_builtins.property
    @pulumi.getter(name="rulestackId")
    def rulestack_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Local Rulestack in which to create this Rule. Changing this forces a new Palo Alto Local Rulestack Rule to be created.
        """
        return pulumi.get(self, "rulestack_id")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output['outputs.LocalRulestackRuleSource']:
        """
        One or more `source` blocks as defined below.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Palo Alto Local Rulestack Rule.
        """
        return pulumi.get(self, "tags")

