# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VirtualMachineConfigurationAssignmentArgs', 'VirtualMachineConfigurationAssignment']

@pulumi.input_type
class VirtualMachineConfigurationAssignmentArgs:
    def __init__(__self__, *,
                 configuration: pulumi.Input['VirtualMachineConfigurationAssignmentConfigurationArgs'],
                 virtual_machine_id: pulumi.Input[_builtins.str],
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VirtualMachineConfigurationAssignment resource.
        :param pulumi.Input['VirtualMachineConfigurationAssignmentConfigurationArgs'] configuration: A `configuration` block as defined below.
        :param pulumi.Input[_builtins.str] virtual_machine_id: The resource ID of the Policy Virtual Machine which this Guest Configuration Assignment should apply to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The Azure location where the Policy Virtual Machine Configuration Assignment should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Guest Configuration that will be assigned in this Guest Configuration Assignment. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> pulumi.Input['VirtualMachineConfigurationAssignmentConfigurationArgs']:
        """
        A `configuration` block as defined below.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: pulumi.Input['VirtualMachineConfigurationAssignmentConfigurationArgs']):
        pulumi.set(self, "configuration", value)

    @_builtins.property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource ID of the Policy Virtual Machine which this Guest Configuration Assignment should apply to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "virtual_machine_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure location where the Policy Virtual Machine Configuration Assignment should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Guest Configuration that will be assigned in this Guest Configuration Assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _VirtualMachineConfigurationAssignmentState:
    def __init__(__self__, *,
                 configuration: Optional[pulumi.Input['VirtualMachineConfigurationAssignmentConfigurationArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VirtualMachineConfigurationAssignment resources.
        :param pulumi.Input['VirtualMachineConfigurationAssignmentConfigurationArgs'] configuration: A `configuration` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure location where the Policy Virtual Machine Configuration Assignment should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Guest Configuration that will be assigned in this Guest Configuration Assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_machine_id: The resource ID of the Policy Virtual Machine which this Guest Configuration Assignment should apply to. Changing this forces a new resource to be created.
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['VirtualMachineConfigurationAssignmentConfigurationArgs']]:
        """
        A `configuration` block as defined below.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['VirtualMachineConfigurationAssignmentConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure location where the Policy Virtual Machine Configuration Assignment should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Guest Configuration that will be assigned in this Guest Configuration Assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the Policy Virtual Machine which this Guest Configuration Assignment should apply to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_machine_id", value)


@pulumi.type_token("azure:policy/virtualMachineConfigurationAssignment:VirtualMachineConfigurationAssignment")
class VirtualMachineConfigurationAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union['VirtualMachineConfigurationAssignmentConfigurationArgs', 'VirtualMachineConfigurationAssignmentConfigurationArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Applies a Guest Configuration Policy to a Virtual Machine.

        > **Note:** You can create Guest Configuration Policies without defining a `compute.Extension` resource, however the policies will not be executed until a `compute.Extension` has been provisioned to the virtual machine.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-gca",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="example-nic",
            resource_group_name=example.name,
            location=example.location,
            ip_configurations=[{
                "name": "internal",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_windows_virtual_machine = azure.compute.WindowsVirtualMachine("example",
            name="examplevm",
            resource_group_name=example.name,
            location=example.location,
            size="Standard_F2",
            admin_username="adminuser",
            admin_password="P@$$w0rd1234!",
            network_interface_ids=[example_network_interface.id],
            identity={
                "type": "SystemAssigned",
            },
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "Standard_LRS",
            },
            source_image_reference={
                "publisher": "MicrosoftWindowsServer",
                "offer": "WindowsServer",
                "sku": "2019-Datacenter",
                "version": "latest",
            })
        example_extension = azure.compute.Extension("example",
            name="AzurePolicyforWindows",
            virtual_machine_id=example_windows_virtual_machine.id,
            publisher="Microsoft.GuestConfiguration",
            type="ConfigurationforWindows",
            type_handler_version="1.29",
            auto_upgrade_minor_version=True)
        example_virtual_machine_configuration_assignment = azure.policy.VirtualMachineConfigurationAssignment("example",
            name="AzureWindowsBaseline",
            location=example_windows_virtual_machine.location,
            virtual_machine_id=example_windows_virtual_machine.id,
            configuration={
                "assignment_type": "ApplyAndMonitor",
                "version": "1.*",
                "parameters": [
                    {
                        "name": "Minimum Password Length;ExpectedValue",
                        "value": "16",
                    },
                    {
                        "name": "Minimum Password Age;ExpectedValue",
                        "value": "0",
                    },
                    {
                        "name": "Maximum Password Age;ExpectedValue",
                        "value": "30,45",
                    },
                    {
                        "name": "Enforce Password History;ExpectedValue",
                        "value": "10",
                    },
                    {
                        "name": "Password Must Meet Complexity Requirements;ExpectedValue",
                        "value": "1",
                    },
                ],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute` - 2020-06-25

        ## Import

        Policy Virtual Machine Configuration Assignments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:policy/virtualMachineConfigurationAssignment:VirtualMachineConfigurationAssignment example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Compute/virtualMachines/vm1/providers/Microsoft.GuestConfiguration/guestConfigurationAssignments/assignment1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['VirtualMachineConfigurationAssignmentConfigurationArgs', 'VirtualMachineConfigurationAssignmentConfigurationArgsDict']] configuration: A `configuration` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure location where the Policy Virtual Machine Configuration Assignment should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Guest Configuration that will be assigned in this Guest Configuration Assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_machine_id: The resource ID of the Policy Virtual Machine which this Guest Configuration Assignment should apply to. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualMachineConfigurationAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Applies a Guest Configuration Policy to a Virtual Machine.

        > **Note:** You can create Guest Configuration Policies without defining a `compute.Extension` resource, however the policies will not be executed until a `compute.Extension` has been provisioned to the virtual machine.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-gca",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="example-nic",
            resource_group_name=example.name,
            location=example.location,
            ip_configurations=[{
                "name": "internal",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_windows_virtual_machine = azure.compute.WindowsVirtualMachine("example",
            name="examplevm",
            resource_group_name=example.name,
            location=example.location,
            size="Standard_F2",
            admin_username="adminuser",
            admin_password="P@$$w0rd1234!",
            network_interface_ids=[example_network_interface.id],
            identity={
                "type": "SystemAssigned",
            },
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "Standard_LRS",
            },
            source_image_reference={
                "publisher": "MicrosoftWindowsServer",
                "offer": "WindowsServer",
                "sku": "2019-Datacenter",
                "version": "latest",
            })
        example_extension = azure.compute.Extension("example",
            name="AzurePolicyforWindows",
            virtual_machine_id=example_windows_virtual_machine.id,
            publisher="Microsoft.GuestConfiguration",
            type="ConfigurationforWindows",
            type_handler_version="1.29",
            auto_upgrade_minor_version=True)
        example_virtual_machine_configuration_assignment = azure.policy.VirtualMachineConfigurationAssignment("example",
            name="AzureWindowsBaseline",
            location=example_windows_virtual_machine.location,
            virtual_machine_id=example_windows_virtual_machine.id,
            configuration={
                "assignment_type": "ApplyAndMonitor",
                "version": "1.*",
                "parameters": [
                    {
                        "name": "Minimum Password Length;ExpectedValue",
                        "value": "16",
                    },
                    {
                        "name": "Minimum Password Age;ExpectedValue",
                        "value": "0",
                    },
                    {
                        "name": "Maximum Password Age;ExpectedValue",
                        "value": "30,45",
                    },
                    {
                        "name": "Enforce Password History;ExpectedValue",
                        "value": "10",
                    },
                    {
                        "name": "Password Must Meet Complexity Requirements;ExpectedValue",
                        "value": "1",
                    },
                ],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute` - 2020-06-25

        ## Import

        Policy Virtual Machine Configuration Assignments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:policy/virtualMachineConfigurationAssignment:VirtualMachineConfigurationAssignment example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Compute/virtualMachines/vm1/providers/Microsoft.GuestConfiguration/guestConfigurationAssignments/assignment1
        ```

        :param str resource_name: The name of the resource.
        :param VirtualMachineConfigurationAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualMachineConfigurationAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration: Optional[pulumi.Input[Union['VirtualMachineConfigurationAssignmentConfigurationArgs', 'VirtualMachineConfigurationAssignmentConfigurationArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualMachineConfigurationAssignmentArgs.__new__(VirtualMachineConfigurationAssignmentArgs)

            if configuration is None and not opts.urn:
                raise TypeError("Missing required property 'configuration'")
            __props__.__dict__["configuration"] = configuration
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if virtual_machine_id is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_machine_id'")
            __props__.__dict__["virtual_machine_id"] = virtual_machine_id
        super(VirtualMachineConfigurationAssignment, __self__).__init__(
            'azure:policy/virtualMachineConfigurationAssignment:VirtualMachineConfigurationAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            configuration: Optional[pulumi.Input[Union['VirtualMachineConfigurationAssignmentConfigurationArgs', 'VirtualMachineConfigurationAssignmentConfigurationArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VirtualMachineConfigurationAssignment':
        """
        Get an existing VirtualMachineConfigurationAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['VirtualMachineConfigurationAssignmentConfigurationArgs', 'VirtualMachineConfigurationAssignmentConfigurationArgsDict']] configuration: A `configuration` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure location where the Policy Virtual Machine Configuration Assignment should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Guest Configuration that will be assigned in this Guest Configuration Assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_machine_id: The resource ID of the Policy Virtual Machine which this Guest Configuration Assignment should apply to. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualMachineConfigurationAssignmentState.__new__(_VirtualMachineConfigurationAssignmentState)

        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["virtual_machine_id"] = virtual_machine_id
        return VirtualMachineConfigurationAssignment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> pulumi.Output['outputs.VirtualMachineConfigurationAssignmentConfiguration']:
        """
        A `configuration` block as defined below.
        """
        return pulumi.get(self, "configuration")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure location where the Policy Virtual Machine Configuration Assignment should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Guest Configuration that will be assigned in this Guest Configuration Assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource ID of the Policy Virtual Machine which this Guest Configuration Assignment should apply to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_machine_id")

