# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'CacheIdentity',
    'CachePatchSchedule',
    'CacheRedisConfiguration',
    'EnterpriseDatabaseModule',
    'GetCachePatchScheduleResult',
    'GetCacheRedisConfigurationResult',
]

@pulumi.output_type
class CacheIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Redis Cluster. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        :param Sequence[_builtins.str] identity_ids: A list of User Assigned Managed Identity IDs to be assigned to this Redis Cluster.
               
               > **NOTE:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Redis Cluster. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of User Assigned Managed Identity IDs to be assigned to this Redis Cluster.

        > **NOTE:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class CachePatchSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "maintenanceWindow":
            suggest = "maintenance_window"
        elif key == "startHourUtc":
            suggest = "start_hour_utc"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CachePatchSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CachePatchSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CachePatchSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: _builtins.str,
                 maintenance_window: Optional[_builtins.str] = None,
                 start_hour_utc: Optional[_builtins.int] = None):
        """
        :param _builtins.str day_of_week: the Weekday name - possible values include `Monday`, `Tuesday`, `Wednesday` etc.
        :param _builtins.str maintenance_window: The ISO 8601 timespan which specifies the amount of time the Redis Cache can be updated. Defaults to `PT5H`.
        :param _builtins.int start_hour_utc: the Start Hour for maintenance in UTC - possible values range from `0 - 23`.
               
               > **Note:** The Patch Window lasts for `5` hours from the `start_hour_utc`.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if start_hour_utc is not None:
            pulumi.set(__self__, "start_hour_utc", start_hour_utc)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> _builtins.str:
        """
        the Weekday name - possible values include `Monday`, `Tuesday`, `Wednesday` etc.
        """
        return pulumi.get(self, "day_of_week")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[_builtins.str]:
        """
        The ISO 8601 timespan which specifies the amount of time the Redis Cache can be updated. Defaults to `PT5H`.
        """
        return pulumi.get(self, "maintenance_window")

    @_builtins.property
    @pulumi.getter(name="startHourUtc")
    def start_hour_utc(self) -> Optional[_builtins.int]:
        """
        the Start Hour for maintenance in UTC - possible values range from `0 - 23`.

        > **Note:** The Patch Window lasts for `5` hours from the `start_hour_utc`.
        """
        return pulumi.get(self, "start_hour_utc")


@pulumi.output_type
class CacheRedisConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeDirectoryAuthenticationEnabled":
            suggest = "active_directory_authentication_enabled"
        elif key == "aofBackupEnabled":
            suggest = "aof_backup_enabled"
        elif key == "aofStorageConnectionString0":
            suggest = "aof_storage_connection_string0"
        elif key == "aofStorageConnectionString1":
            suggest = "aof_storage_connection_string1"
        elif key == "authenticationEnabled":
            suggest = "authentication_enabled"
        elif key == "dataPersistenceAuthenticationMethod":
            suggest = "data_persistence_authentication_method"
        elif key == "maxfragmentationmemoryReserved":
            suggest = "maxfragmentationmemory_reserved"
        elif key == "maxmemoryDelta":
            suggest = "maxmemory_delta"
        elif key == "maxmemoryPolicy":
            suggest = "maxmemory_policy"
        elif key == "maxmemoryReserved":
            suggest = "maxmemory_reserved"
        elif key == "notifyKeyspaceEvents":
            suggest = "notify_keyspace_events"
        elif key == "rdbBackupEnabled":
            suggest = "rdb_backup_enabled"
        elif key == "rdbBackupFrequency":
            suggest = "rdb_backup_frequency"
        elif key == "rdbBackupMaxSnapshotCount":
            suggest = "rdb_backup_max_snapshot_count"
        elif key == "rdbStorageConnectionString":
            suggest = "rdb_storage_connection_string"
        elif key == "storageAccountSubscriptionId":
            suggest = "storage_account_subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheRedisConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheRedisConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheRedisConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_directory_authentication_enabled: Optional[_builtins.bool] = None,
                 aof_backup_enabled: Optional[_builtins.bool] = None,
                 aof_storage_connection_string0: Optional[_builtins.str] = None,
                 aof_storage_connection_string1: Optional[_builtins.str] = None,
                 authentication_enabled: Optional[_builtins.bool] = None,
                 data_persistence_authentication_method: Optional[_builtins.str] = None,
                 maxclients: Optional[_builtins.int] = None,
                 maxfragmentationmemory_reserved: Optional[_builtins.int] = None,
                 maxmemory_delta: Optional[_builtins.int] = None,
                 maxmemory_policy: Optional[_builtins.str] = None,
                 maxmemory_reserved: Optional[_builtins.int] = None,
                 notify_keyspace_events: Optional[_builtins.str] = None,
                 rdb_backup_enabled: Optional[_builtins.bool] = None,
                 rdb_backup_frequency: Optional[_builtins.int] = None,
                 rdb_backup_max_snapshot_count: Optional[_builtins.int] = None,
                 rdb_storage_connection_string: Optional[_builtins.str] = None,
                 storage_account_subscription_id: Optional[_builtins.str] = None):
        """
        :param _builtins.bool active_directory_authentication_enabled: Enable Microsoft Entra (AAD) authentication. Defaults to `false`.
        :param _builtins.bool aof_backup_enabled: Enable or disable AOF persistence for this Redis Cache. Defaults to `false`.
               
               > **NOTE:** `aof_backup_enabled` can only be set when SKU is `Premium`.
        :param _builtins.str aof_storage_connection_string0: First Storage Account connection string for AOF persistence.
        :param _builtins.str aof_storage_connection_string1: Second Storage Account connection string for AOF persistence.
               
               Example usage:
        :param _builtins.bool authentication_enabled: If set to `false`, the Redis instance will be accessible without authentication. Defaults to `true`.
               
               > **NOTE:** `authentication_enabled` can only be set to `false` if a `subnet_id` is specified; and only works if there aren't existing instances within the subnet with `authentication_enabled` set to `true`.
        :param _builtins.str data_persistence_authentication_method: Preferred auth method to communicate to storage account used for data persistence. Possible values are `SAS` and `ManagedIdentity`.
        :param _builtins.int maxclients: Returns the max number of connected clients at the same time.
        :param _builtins.int maxfragmentationmemory_reserved: Value in megabytes reserved to accommodate for memory fragmentation. Defaults are shown below.
        :param _builtins.int maxmemory_delta: The max-memory delta for this Redis instance. Defaults are shown below.
        :param _builtins.str maxmemory_policy: How Redis will select what to remove when `maxmemory` is reached. Defaults to `volatile-lru`.
        :param _builtins.int maxmemory_reserved: Value in megabytes reserved for non-cache usage e.g. failover. Defaults are shown below.
        :param _builtins.str notify_keyspace_events: Keyspace notifications allows clients to subscribe to Pub/Sub channels in order to receive events affecting the Redis data set in some way. [Reference](https://redis.io/topics/notifications#configuration)
        :param _builtins.bool rdb_backup_enabled: Is Backup Enabled? Only supported on Premium SKUs. Defaults to `false`.
               
               > **NOTE:** If `rdb_backup_enabled` set to `true`, `rdb_storage_connection_string` must also be set.
        :param _builtins.int rdb_backup_frequency: The Backup Frequency in Minutes. Only supported on Premium SKUs. Possible values are: `15`, `30`, `60`, `360`, `720` and `1440`.
        :param _builtins.int rdb_backup_max_snapshot_count: The maximum number of snapshots to create as a backup. Only supported for Premium SKUs.
        :param _builtins.str rdb_storage_connection_string: The Connection String to the Storage Account. Only supported for Premium SKUs. In the format: `DefaultEndpointsProtocol=https;BlobEndpoint=${azurerm_storage_account.example.primary_blob_endpoint};AccountName=${azurerm_storage_account.example.name};AccountKey=${azurerm_storage_account.example.primary_access_key}`.
               
               > **NOTE:** There's a bug in the Redis API where the original storage connection string isn't being returned, which [is being tracked in this issue](https://github.com/Azure/azure-rest-api-specs/issues/3037). In the interim you can use [the `ignoreChanges` attribute to ignore changes to this field](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) e.g.:
        :param _builtins.str storage_account_subscription_id: The ID of the Subscription containing the Storage Account.
        """
        if active_directory_authentication_enabled is not None:
            pulumi.set(__self__, "active_directory_authentication_enabled", active_directory_authentication_enabled)
        if aof_backup_enabled is not None:
            pulumi.set(__self__, "aof_backup_enabled", aof_backup_enabled)
        if aof_storage_connection_string0 is not None:
            pulumi.set(__self__, "aof_storage_connection_string0", aof_storage_connection_string0)
        if aof_storage_connection_string1 is not None:
            pulumi.set(__self__, "aof_storage_connection_string1", aof_storage_connection_string1)
        if authentication_enabled is not None:
            pulumi.set(__self__, "authentication_enabled", authentication_enabled)
        if data_persistence_authentication_method is not None:
            pulumi.set(__self__, "data_persistence_authentication_method", data_persistence_authentication_method)
        if maxclients is not None:
            pulumi.set(__self__, "maxclients", maxclients)
        if maxfragmentationmemory_reserved is not None:
            pulumi.set(__self__, "maxfragmentationmemory_reserved", maxfragmentationmemory_reserved)
        if maxmemory_delta is not None:
            pulumi.set(__self__, "maxmemory_delta", maxmemory_delta)
        if maxmemory_policy is not None:
            pulumi.set(__self__, "maxmemory_policy", maxmemory_policy)
        if maxmemory_reserved is not None:
            pulumi.set(__self__, "maxmemory_reserved", maxmemory_reserved)
        if notify_keyspace_events is not None:
            pulumi.set(__self__, "notify_keyspace_events", notify_keyspace_events)
        if rdb_backup_enabled is not None:
            pulumi.set(__self__, "rdb_backup_enabled", rdb_backup_enabled)
        if rdb_backup_frequency is not None:
            pulumi.set(__self__, "rdb_backup_frequency", rdb_backup_frequency)
        if rdb_backup_max_snapshot_count is not None:
            pulumi.set(__self__, "rdb_backup_max_snapshot_count", rdb_backup_max_snapshot_count)
        if rdb_storage_connection_string is not None:
            pulumi.set(__self__, "rdb_storage_connection_string", rdb_storage_connection_string)
        if storage_account_subscription_id is not None:
            pulumi.set(__self__, "storage_account_subscription_id", storage_account_subscription_id)

    @_builtins.property
    @pulumi.getter(name="activeDirectoryAuthenticationEnabled")
    def active_directory_authentication_enabled(self) -> Optional[_builtins.bool]:
        """
        Enable Microsoft Entra (AAD) authentication. Defaults to `false`.
        """
        return pulumi.get(self, "active_directory_authentication_enabled")

    @_builtins.property
    @pulumi.getter(name="aofBackupEnabled")
    def aof_backup_enabled(self) -> Optional[_builtins.bool]:
        """
        Enable or disable AOF persistence for this Redis Cache. Defaults to `false`.

        > **NOTE:** `aof_backup_enabled` can only be set when SKU is `Premium`.
        """
        return pulumi.get(self, "aof_backup_enabled")

    @_builtins.property
    @pulumi.getter(name="aofStorageConnectionString0")
    def aof_storage_connection_string0(self) -> Optional[_builtins.str]:
        """
        First Storage Account connection string for AOF persistence.
        """
        return pulumi.get(self, "aof_storage_connection_string0")

    @_builtins.property
    @pulumi.getter(name="aofStorageConnectionString1")
    def aof_storage_connection_string1(self) -> Optional[_builtins.str]:
        """
        Second Storage Account connection string for AOF persistence.

        Example usage:
        """
        return pulumi.get(self, "aof_storage_connection_string1")

    @_builtins.property
    @pulumi.getter(name="authenticationEnabled")
    def authentication_enabled(self) -> Optional[_builtins.bool]:
        """
        If set to `false`, the Redis instance will be accessible without authentication. Defaults to `true`.

        > **NOTE:** `authentication_enabled` can only be set to `false` if a `subnet_id` is specified; and only works if there aren't existing instances within the subnet with `authentication_enabled` set to `true`.
        """
        return pulumi.get(self, "authentication_enabled")

    @_builtins.property
    @pulumi.getter(name="dataPersistenceAuthenticationMethod")
    def data_persistence_authentication_method(self) -> Optional[_builtins.str]:
        """
        Preferred auth method to communicate to storage account used for data persistence. Possible values are `SAS` and `ManagedIdentity`.
        """
        return pulumi.get(self, "data_persistence_authentication_method")

    @_builtins.property
    @pulumi.getter
    def maxclients(self) -> Optional[_builtins.int]:
        """
        Returns the max number of connected clients at the same time.
        """
        return pulumi.get(self, "maxclients")

    @_builtins.property
    @pulumi.getter(name="maxfragmentationmemoryReserved")
    def maxfragmentationmemory_reserved(self) -> Optional[_builtins.int]:
        """
        Value in megabytes reserved to accommodate for memory fragmentation. Defaults are shown below.
        """
        return pulumi.get(self, "maxfragmentationmemory_reserved")

    @_builtins.property
    @pulumi.getter(name="maxmemoryDelta")
    def maxmemory_delta(self) -> Optional[_builtins.int]:
        """
        The max-memory delta for this Redis instance. Defaults are shown below.
        """
        return pulumi.get(self, "maxmemory_delta")

    @_builtins.property
    @pulumi.getter(name="maxmemoryPolicy")
    def maxmemory_policy(self) -> Optional[_builtins.str]:
        """
        How Redis will select what to remove when `maxmemory` is reached. Defaults to `volatile-lru`.
        """
        return pulumi.get(self, "maxmemory_policy")

    @_builtins.property
    @pulumi.getter(name="maxmemoryReserved")
    def maxmemory_reserved(self) -> Optional[_builtins.int]:
        """
        Value in megabytes reserved for non-cache usage e.g. failover. Defaults are shown below.
        """
        return pulumi.get(self, "maxmemory_reserved")

    @_builtins.property
    @pulumi.getter(name="notifyKeyspaceEvents")
    def notify_keyspace_events(self) -> Optional[_builtins.str]:
        """
        Keyspace notifications allows clients to subscribe to Pub/Sub channels in order to receive events affecting the Redis data set in some way. [Reference](https://redis.io/topics/notifications#configuration)
        """
        return pulumi.get(self, "notify_keyspace_events")

    @_builtins.property
    @pulumi.getter(name="rdbBackupEnabled")
    def rdb_backup_enabled(self) -> Optional[_builtins.bool]:
        """
        Is Backup Enabled? Only supported on Premium SKUs. Defaults to `false`.

        > **NOTE:** If `rdb_backup_enabled` set to `true`, `rdb_storage_connection_string` must also be set.
        """
        return pulumi.get(self, "rdb_backup_enabled")

    @_builtins.property
    @pulumi.getter(name="rdbBackupFrequency")
    def rdb_backup_frequency(self) -> Optional[_builtins.int]:
        """
        The Backup Frequency in Minutes. Only supported on Premium SKUs. Possible values are: `15`, `30`, `60`, `360`, `720` and `1440`.
        """
        return pulumi.get(self, "rdb_backup_frequency")

    @_builtins.property
    @pulumi.getter(name="rdbBackupMaxSnapshotCount")
    def rdb_backup_max_snapshot_count(self) -> Optional[_builtins.int]:
        """
        The maximum number of snapshots to create as a backup. Only supported for Premium SKUs.
        """
        return pulumi.get(self, "rdb_backup_max_snapshot_count")

    @_builtins.property
    @pulumi.getter(name="rdbStorageConnectionString")
    def rdb_storage_connection_string(self) -> Optional[_builtins.str]:
        """
        The Connection String to the Storage Account. Only supported for Premium SKUs. In the format: `DefaultEndpointsProtocol=https;BlobEndpoint=${azurerm_storage_account.example.primary_blob_endpoint};AccountName=${azurerm_storage_account.example.name};AccountKey=${azurerm_storage_account.example.primary_access_key}`.

        > **NOTE:** There's a bug in the Redis API where the original storage connection string isn't being returned, which [is being tracked in this issue](https://github.com/Azure/azure-rest-api-specs/issues/3037). In the interim you can use [the `ignoreChanges` attribute to ignore changes to this field](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) e.g.:
        """
        return pulumi.get(self, "rdb_storage_connection_string")

    @_builtins.property
    @pulumi.getter(name="storageAccountSubscriptionId")
    def storage_account_subscription_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Subscription containing the Storage Account.
        """
        return pulumi.get(self, "storage_account_subscription_id")


@pulumi.output_type
class EnterpriseDatabaseModule(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 args: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name which should be used for this module. Possible values are `RedisBloom`, `RedisTimeSeries`, `RediSearch` and `RedisJSON`. Changing this forces a new Redis Enterprise Database to be created.
        :param _builtins.str args: Configuration options for the module (e.g. `ERROR_RATE 0.00 INITIAL_SIZE 400`). Changing this forces a new resource to be created. Defaults to `""`.
        """
        pulumi.set(__self__, "name", name)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name which should be used for this module. Possible values are `RedisBloom`, `RedisTimeSeries`, `RediSearch` and `RedisJSON`. Changing this forces a new Redis Enterprise Database to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[_builtins.str]:
        """
        Configuration options for the module (e.g. `ERROR_RATE 0.00 INITIAL_SIZE 400`). Changing this forces a new resource to be created. Defaults to `""`.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "version")


@pulumi.output_type
class GetCachePatchScheduleResult(dict):
    def __init__(__self__, *,
                 day_of_week: _builtins.str,
                 maintenance_window: _builtins.str,
                 start_hour_utc: _builtins.int):
        """
        :param _builtins.str day_of_week: the Weekday name for the patch item
        :param _builtins.str maintenance_window: The ISO 8601 timespan which specifies the amount of time the Redis Cache can be updated.
        :param _builtins.int start_hour_utc: The Start Hour for maintenance in UTC
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "maintenance_window", maintenance_window)
        pulumi.set(__self__, "start_hour_utc", start_hour_utc)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> _builtins.str:
        """
        the Weekday name for the patch item
        """
        return pulumi.get(self, "day_of_week")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> _builtins.str:
        """
        The ISO 8601 timespan which specifies the amount of time the Redis Cache can be updated.
        """
        return pulumi.get(self, "maintenance_window")

    @_builtins.property
    @pulumi.getter(name="startHourUtc")
    def start_hour_utc(self) -> _builtins.int:
        """
        The Start Hour for maintenance in UTC
        """
        return pulumi.get(self, "start_hour_utc")


@pulumi.output_type
class GetCacheRedisConfigurationResult(dict):
    def __init__(__self__, *,
                 active_directory_authentication_enabled: _builtins.bool,
                 aof_backup_enabled: _builtins.bool,
                 aof_storage_connection_string0: _builtins.str,
                 aof_storage_connection_string1: _builtins.str,
                 authentication_enabled: _builtins.bool,
                 data_persistence_authentication_method: _builtins.str,
                 maxclients: _builtins.int,
                 maxfragmentationmemory_reserved: _builtins.int,
                 maxmemory_delta: _builtins.int,
                 maxmemory_policy: _builtins.str,
                 maxmemory_reserved: _builtins.int,
                 notify_keyspace_events: _builtins.str,
                 rdb_backup_enabled: _builtins.bool,
                 rdb_backup_frequency: _builtins.int,
                 rdb_backup_max_snapshot_count: _builtins.int,
                 rdb_storage_connection_string: _builtins.str,
                 storage_account_subscription_id: _builtins.str):
        """
        :param _builtins.bool active_directory_authentication_enabled: Specifies if Microsoft Entra (AAD) authentication is enabled.
        :param _builtins.int maxfragmentationmemory_reserved: Value in megabytes reserved to accommodate for memory fragmentation.
        :param _builtins.int maxmemory_delta: The max-memory delta for this Redis instance.
        :param _builtins.str maxmemory_policy: How Redis will select what to remove when `maxmemory` is reached.
        :param _builtins.int maxmemory_reserved: The value in megabytes reserved for non-cache usage e.g. failover
        :param _builtins.bool rdb_backup_enabled: Is Backup Enabled? Only supported on Premium SKUs.
        :param _builtins.int rdb_backup_frequency: The Backup Frequency in Minutes. Only supported on Premium SKUs.
        :param _builtins.int rdb_backup_max_snapshot_count: The maximum number of snapshots that can be created as a backup.
        :param _builtins.str rdb_storage_connection_string: The Connection String to the Storage Account. Only supported for Premium SKUs.
        :param _builtins.str storage_account_subscription_id: The ID of the Subscription containing the Storage Account.
        """
        pulumi.set(__self__, "active_directory_authentication_enabled", active_directory_authentication_enabled)
        pulumi.set(__self__, "aof_backup_enabled", aof_backup_enabled)
        pulumi.set(__self__, "aof_storage_connection_string0", aof_storage_connection_string0)
        pulumi.set(__self__, "aof_storage_connection_string1", aof_storage_connection_string1)
        pulumi.set(__self__, "authentication_enabled", authentication_enabled)
        pulumi.set(__self__, "data_persistence_authentication_method", data_persistence_authentication_method)
        pulumi.set(__self__, "maxclients", maxclients)
        pulumi.set(__self__, "maxfragmentationmemory_reserved", maxfragmentationmemory_reserved)
        pulumi.set(__self__, "maxmemory_delta", maxmemory_delta)
        pulumi.set(__self__, "maxmemory_policy", maxmemory_policy)
        pulumi.set(__self__, "maxmemory_reserved", maxmemory_reserved)
        pulumi.set(__self__, "notify_keyspace_events", notify_keyspace_events)
        pulumi.set(__self__, "rdb_backup_enabled", rdb_backup_enabled)
        pulumi.set(__self__, "rdb_backup_frequency", rdb_backup_frequency)
        pulumi.set(__self__, "rdb_backup_max_snapshot_count", rdb_backup_max_snapshot_count)
        pulumi.set(__self__, "rdb_storage_connection_string", rdb_storage_connection_string)
        pulumi.set(__self__, "storage_account_subscription_id", storage_account_subscription_id)

    @_builtins.property
    @pulumi.getter(name="activeDirectoryAuthenticationEnabled")
    def active_directory_authentication_enabled(self) -> _builtins.bool:
        """
        Specifies if Microsoft Entra (AAD) authentication is enabled.
        """
        return pulumi.get(self, "active_directory_authentication_enabled")

    @_builtins.property
    @pulumi.getter(name="aofBackupEnabled")
    def aof_backup_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "aof_backup_enabled")

    @_builtins.property
    @pulumi.getter(name="aofStorageConnectionString0")
    def aof_storage_connection_string0(self) -> _builtins.str:
        return pulumi.get(self, "aof_storage_connection_string0")

    @_builtins.property
    @pulumi.getter(name="aofStorageConnectionString1")
    def aof_storage_connection_string1(self) -> _builtins.str:
        return pulumi.get(self, "aof_storage_connection_string1")

    @_builtins.property
    @pulumi.getter(name="authenticationEnabled")
    def authentication_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "authentication_enabled")

    @_builtins.property
    @pulumi.getter(name="dataPersistenceAuthenticationMethod")
    def data_persistence_authentication_method(self) -> _builtins.str:
        return pulumi.get(self, "data_persistence_authentication_method")

    @_builtins.property
    @pulumi.getter
    def maxclients(self) -> _builtins.int:
        return pulumi.get(self, "maxclients")

    @_builtins.property
    @pulumi.getter(name="maxfragmentationmemoryReserved")
    def maxfragmentationmemory_reserved(self) -> _builtins.int:
        """
        Value in megabytes reserved to accommodate for memory fragmentation.
        """
        return pulumi.get(self, "maxfragmentationmemory_reserved")

    @_builtins.property
    @pulumi.getter(name="maxmemoryDelta")
    def maxmemory_delta(self) -> _builtins.int:
        """
        The max-memory delta for this Redis instance.
        """
        return pulumi.get(self, "maxmemory_delta")

    @_builtins.property
    @pulumi.getter(name="maxmemoryPolicy")
    def maxmemory_policy(self) -> _builtins.str:
        """
        How Redis will select what to remove when `maxmemory` is reached.
        """
        return pulumi.get(self, "maxmemory_policy")

    @_builtins.property
    @pulumi.getter(name="maxmemoryReserved")
    def maxmemory_reserved(self) -> _builtins.int:
        """
        The value in megabytes reserved for non-cache usage e.g. failover
        """
        return pulumi.get(self, "maxmemory_reserved")

    @_builtins.property
    @pulumi.getter(name="notifyKeyspaceEvents")
    def notify_keyspace_events(self) -> _builtins.str:
        return pulumi.get(self, "notify_keyspace_events")

    @_builtins.property
    @pulumi.getter(name="rdbBackupEnabled")
    def rdb_backup_enabled(self) -> _builtins.bool:
        """
        Is Backup Enabled? Only supported on Premium SKUs.
        """
        return pulumi.get(self, "rdb_backup_enabled")

    @_builtins.property
    @pulumi.getter(name="rdbBackupFrequency")
    def rdb_backup_frequency(self) -> _builtins.int:
        """
        The Backup Frequency in Minutes. Only supported on Premium SKUs.
        """
        return pulumi.get(self, "rdb_backup_frequency")

    @_builtins.property
    @pulumi.getter(name="rdbBackupMaxSnapshotCount")
    def rdb_backup_max_snapshot_count(self) -> _builtins.int:
        """
        The maximum number of snapshots that can be created as a backup.
        """
        return pulumi.get(self, "rdb_backup_max_snapshot_count")

    @_builtins.property
    @pulumi.getter(name="rdbStorageConnectionString")
    def rdb_storage_connection_string(self) -> _builtins.str:
        """
        The Connection String to the Storage Account. Only supported for Premium SKUs.
        """
        return pulumi.get(self, "rdb_storage_connection_string")

    @_builtins.property
    @pulumi.getter(name="storageAccountSubscriptionId")
    def storage_account_subscription_id(self) -> _builtins.str:
        """
        The ID of the Subscription containing the Storage Account.
        """
        return pulumi.get(self, "storage_account_subscription_id")


