# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'HciClusterIdentity',
    'HciDeploymentSettingScaleUnit',
    'HciDeploymentSettingScaleUnitCluster',
    'HciDeploymentSettingScaleUnitHostNetwork',
    'HciDeploymentSettingScaleUnitHostNetworkIntent',
    'HciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverride',
    'HciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverride',
    'HciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverride',
    'HciDeploymentSettingScaleUnitHostNetworkStorageNetwork',
    'HciDeploymentSettingScaleUnitInfrastructureNetwork',
    'HciDeploymentSettingScaleUnitInfrastructureNetworkIpPool',
    'HciDeploymentSettingScaleUnitOptionalService',
    'HciDeploymentSettingScaleUnitPhysicalNode',
    'HciDeploymentSettingScaleUnitStorage',
    'HciLogicalNetworkSubnet',
    'HciLogicalNetworkSubnetIpPool',
    'HciLogicalNetworkSubnetRoute',
    'HciMarketplaceGalleryImageIdentifier',
    'HciNetworkInterfaceIpConfiguration',
    'GetHciClusterIdentityResult',
]

@pulumi.output_type
class HciClusterIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HciClusterIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HciClusterIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HciClusterIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on the Azure Stack HCI Cluster. Possible value is `SystemAssigned`.
        :param _builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param _builtins.str tenant_id: The Tenant ID of the Azure Active Directory which is used by the Azure Stack HCI Cluster. Changing this forces a new resource to be created.
               
               > **Note:** If unspecified the Tenant ID of the Provider will be used.
        """
        pulumi.set(__self__, "type", type)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on the Azure Stack HCI Cluster. Possible value is `SystemAssigned`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID of the Azure Active Directory which is used by the Azure Stack HCI Cluster. Changing this forces a new resource to be created.

        > **Note:** If unspecified the Tenant ID of the Provider will be used.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class HciDeploymentSettingScaleUnit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeDirectoryOrganizationalUnitPath":
            suggest = "active_directory_organizational_unit_path"
        elif key == "domainFqdn":
            suggest = "domain_fqdn"
        elif key == "hostNetwork":
            suggest = "host_network"
        elif key == "infrastructureNetworks":
            suggest = "infrastructure_networks"
        elif key == "namePrefix":
            suggest = "name_prefix"
        elif key == "optionalService":
            suggest = "optional_service"
        elif key == "physicalNodes":
            suggest = "physical_nodes"
        elif key == "secretsLocation":
            suggest = "secrets_location"
        elif key == "bitlockerBootVolumeEnabled":
            suggest = "bitlocker_boot_volume_enabled"
        elif key == "bitlockerDataVolumeEnabled":
            suggest = "bitlocker_data_volume_enabled"
        elif key == "credentialGuardEnabled":
            suggest = "credential_guard_enabled"
        elif key == "driftControlEnabled":
            suggest = "drift_control_enabled"
        elif key == "drtmProtectionEnabled":
            suggest = "drtm_protection_enabled"
        elif key == "episodicDataUploadEnabled":
            suggest = "episodic_data_upload_enabled"
        elif key == "euLocationEnabled":
            suggest = "eu_location_enabled"
        elif key == "hvciProtectionEnabled":
            suggest = "hvci_protection_enabled"
        elif key == "sideChannelMitigationEnabled":
            suggest = "side_channel_mitigation_enabled"
        elif key == "smbClusterEncryptionEnabled":
            suggest = "smb_cluster_encryption_enabled"
        elif key == "smbSigningEnabled":
            suggest = "smb_signing_enabled"
        elif key == "streamingDataClientEnabled":
            suggest = "streaming_data_client_enabled"
        elif key == "wdacEnabled":
            suggest = "wdac_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HciDeploymentSettingScaleUnit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HciDeploymentSettingScaleUnit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HciDeploymentSettingScaleUnit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_directory_organizational_unit_path: _builtins.str,
                 cluster: 'outputs.HciDeploymentSettingScaleUnitCluster',
                 domain_fqdn: _builtins.str,
                 host_network: 'outputs.HciDeploymentSettingScaleUnitHostNetwork',
                 infrastructure_networks: Sequence['outputs.HciDeploymentSettingScaleUnitInfrastructureNetwork'],
                 name_prefix: _builtins.str,
                 optional_service: 'outputs.HciDeploymentSettingScaleUnitOptionalService',
                 physical_nodes: Sequence['outputs.HciDeploymentSettingScaleUnitPhysicalNode'],
                 secrets_location: _builtins.str,
                 storage: 'outputs.HciDeploymentSettingScaleUnitStorage',
                 bitlocker_boot_volume_enabled: Optional[_builtins.bool] = None,
                 bitlocker_data_volume_enabled: Optional[_builtins.bool] = None,
                 credential_guard_enabled: Optional[_builtins.bool] = None,
                 drift_control_enabled: Optional[_builtins.bool] = None,
                 drtm_protection_enabled: Optional[_builtins.bool] = None,
                 episodic_data_upload_enabled: Optional[_builtins.bool] = None,
                 eu_location_enabled: Optional[_builtins.bool] = None,
                 hvci_protection_enabled: Optional[_builtins.bool] = None,
                 side_channel_mitigation_enabled: Optional[_builtins.bool] = None,
                 smb_cluster_encryption_enabled: Optional[_builtins.bool] = None,
                 smb_signing_enabled: Optional[_builtins.bool] = None,
                 streaming_data_client_enabled: Optional[_builtins.bool] = None,
                 wdac_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str active_directory_organizational_unit_path: Specify the full name of the Active Directory Organizational Unit container object prepared for the deployment, including the domain components. For example:`OU=HCI01,DC=contoso,DC=com`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param 'HciDeploymentSettingScaleUnitClusterArgs' cluster: A `cluster` block as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.str domain_fqdn: Specifies the FQDN for deploying cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param 'HciDeploymentSettingScaleUnitHostNetworkArgs' host_network: A `host_network` block as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param Sequence['HciDeploymentSettingScaleUnitInfrastructureNetworkArgs'] infrastructure_networks: One or more `infrastructure_network` blocks as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.str name_prefix: Specifies the name prefix to deploy cluster. It must be 1-8 characters long and contain only letters, numbers and hyphens Changing this forces a new Stack HCI Deployment Setting to be created.
        :param 'HciDeploymentSettingScaleUnitOptionalServiceArgs' optional_service: A `optional_service` block as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param Sequence['HciDeploymentSettingScaleUnitPhysicalNodeArgs'] physical_nodes: One or more `physical_node` blocks as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.str secrets_location: The URI to the Key Vault or secret store. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param 'HciDeploymentSettingScaleUnitStorageArgs' storage: A `storage` block as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.bool bitlocker_boot_volume_enabled: Whether to enable BitLocker for boot volume. Possible values are `true` and `false`. When set to `true`, BitLocker XTS_AES 256-bit encryption is enabled for all data-at-rest on the OS volume of your Azure Stack HCI cluster. This setting is TPM-hardware dependent. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.bool bitlocker_data_volume_enabled: Whether to enable BitLocker for data volume. Possible values are `true` and `false`. When set to `true`, BitLocker XTS-AES 256-bit encryption is enabled for all data-at-rest on your Azure Stack HCI cluster shared volumes. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.bool credential_guard_enabled: Whether to enable credential guard. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.bool drift_control_enabled: Whether to enable drift control. Possible values are `true` and `false`. When set to `true`, the security baseline is re-applied regularly. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.bool drtm_protection_enabled: Whether to enable DRTM protection. Possible values are `true` and `false`. When set to `true`, Secure Boot is enabled on your Azure HCI cluster. This setting is hardware dependent. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.bool episodic_data_upload_enabled: Whether to collect log data to facilitate quicker issue resolution. Possible values are `true` and `false`. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.bool eu_location_enabled: Whether to store data sent to Microsoft in EU. The log and diagnostic data is sent to the appropriate diagnostics servers depending upon where your cluster resides. Setting this to `false` results in all data sent to Microsoft to be stored outside of the EU. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.bool hvci_protection_enabled: Whether to enable HVCI protection. Possible values are `true` and `false`. When set to `true`, Hypervisor-protected Code Integrity is enabled on your Azure HCI cluster. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.bool side_channel_mitigation_enabled: Whether to enable side channel mitigation. Possible values are `true` and `false`. When set to `true`, all side channel mitigations are enabled on your Azure HCI cluster. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.bool smb_cluster_encryption_enabled: Whether to enable SMB cluster encryption. Possible values are `true` and `false`. When set to `true`, cluster east-west traffic is encrypted. Defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.bool smb_signing_enabled: Whether to enable SMB signing. Possible values are `true` and `false`. When set to `true`, the SMB default instance requires sign in for the client and server services. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.bool streaming_data_client_enabled: Whether the telemetry data will be sent to Microsoft. Possible values are `true` and `false`. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.bool wdac_enabled: Whether to enable WDAC. Possible values are `true` and `false`. When set to `true`, applications and the code that you can run on your Azure Stack HCI cluster are limited. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        pulumi.set(__self__, "active_directory_organizational_unit_path", active_directory_organizational_unit_path)
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "domain_fqdn", domain_fqdn)
        pulumi.set(__self__, "host_network", host_network)
        pulumi.set(__self__, "infrastructure_networks", infrastructure_networks)
        pulumi.set(__self__, "name_prefix", name_prefix)
        pulumi.set(__self__, "optional_service", optional_service)
        pulumi.set(__self__, "physical_nodes", physical_nodes)
        pulumi.set(__self__, "secrets_location", secrets_location)
        pulumi.set(__self__, "storage", storage)
        if bitlocker_boot_volume_enabled is not None:
            pulumi.set(__self__, "bitlocker_boot_volume_enabled", bitlocker_boot_volume_enabled)
        if bitlocker_data_volume_enabled is not None:
            pulumi.set(__self__, "bitlocker_data_volume_enabled", bitlocker_data_volume_enabled)
        if credential_guard_enabled is not None:
            pulumi.set(__self__, "credential_guard_enabled", credential_guard_enabled)
        if drift_control_enabled is not None:
            pulumi.set(__self__, "drift_control_enabled", drift_control_enabled)
        if drtm_protection_enabled is not None:
            pulumi.set(__self__, "drtm_protection_enabled", drtm_protection_enabled)
        if episodic_data_upload_enabled is not None:
            pulumi.set(__self__, "episodic_data_upload_enabled", episodic_data_upload_enabled)
        if eu_location_enabled is not None:
            pulumi.set(__self__, "eu_location_enabled", eu_location_enabled)
        if hvci_protection_enabled is not None:
            pulumi.set(__self__, "hvci_protection_enabled", hvci_protection_enabled)
        if side_channel_mitigation_enabled is not None:
            pulumi.set(__self__, "side_channel_mitigation_enabled", side_channel_mitigation_enabled)
        if smb_cluster_encryption_enabled is not None:
            pulumi.set(__self__, "smb_cluster_encryption_enabled", smb_cluster_encryption_enabled)
        if smb_signing_enabled is not None:
            pulumi.set(__self__, "smb_signing_enabled", smb_signing_enabled)
        if streaming_data_client_enabled is not None:
            pulumi.set(__self__, "streaming_data_client_enabled", streaming_data_client_enabled)
        if wdac_enabled is not None:
            pulumi.set(__self__, "wdac_enabled", wdac_enabled)

    @_builtins.property
    @pulumi.getter(name="activeDirectoryOrganizationalUnitPath")
    def active_directory_organizational_unit_path(self) -> _builtins.str:
        """
        Specify the full name of the Active Directory Organizational Unit container object prepared for the deployment, including the domain components. For example:`OU=HCI01,DC=contoso,DC=com`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "active_directory_organizational_unit_path")

    @_builtins.property
    @pulumi.getter
    def cluster(self) -> 'outputs.HciDeploymentSettingScaleUnitCluster':
        """
        A `cluster` block as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "cluster")

    @_builtins.property
    @pulumi.getter(name="domainFqdn")
    def domain_fqdn(self) -> _builtins.str:
        """
        Specifies the FQDN for deploying cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "domain_fqdn")

    @_builtins.property
    @pulumi.getter(name="hostNetwork")
    def host_network(self) -> 'outputs.HciDeploymentSettingScaleUnitHostNetwork':
        """
        A `host_network` block as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "host_network")

    @_builtins.property
    @pulumi.getter(name="infrastructureNetworks")
    def infrastructure_networks(self) -> Sequence['outputs.HciDeploymentSettingScaleUnitInfrastructureNetwork']:
        """
        One or more `infrastructure_network` blocks as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "infrastructure_networks")

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> _builtins.str:
        """
        Specifies the name prefix to deploy cluster. It must be 1-8 characters long and contain only letters, numbers and hyphens Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "name_prefix")

    @_builtins.property
    @pulumi.getter(name="optionalService")
    def optional_service(self) -> 'outputs.HciDeploymentSettingScaleUnitOptionalService':
        """
        A `optional_service` block as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "optional_service")

    @_builtins.property
    @pulumi.getter(name="physicalNodes")
    def physical_nodes(self) -> Sequence['outputs.HciDeploymentSettingScaleUnitPhysicalNode']:
        """
        One or more `physical_node` blocks as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "physical_nodes")

    @_builtins.property
    @pulumi.getter(name="secretsLocation")
    def secrets_location(self) -> _builtins.str:
        """
        The URI to the Key Vault or secret store. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "secrets_location")

    @_builtins.property
    @pulumi.getter
    def storage(self) -> 'outputs.HciDeploymentSettingScaleUnitStorage':
        """
        A `storage` block as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "storage")

    @_builtins.property
    @pulumi.getter(name="bitlockerBootVolumeEnabled")
    def bitlocker_boot_volume_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable BitLocker for boot volume. Possible values are `true` and `false`. When set to `true`, BitLocker XTS_AES 256-bit encryption is enabled for all data-at-rest on the OS volume of your Azure Stack HCI cluster. This setting is TPM-hardware dependent. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "bitlocker_boot_volume_enabled")

    @_builtins.property
    @pulumi.getter(name="bitlockerDataVolumeEnabled")
    def bitlocker_data_volume_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable BitLocker for data volume. Possible values are `true` and `false`. When set to `true`, BitLocker XTS-AES 256-bit encryption is enabled for all data-at-rest on your Azure Stack HCI cluster shared volumes. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "bitlocker_data_volume_enabled")

    @_builtins.property
    @pulumi.getter(name="credentialGuardEnabled")
    def credential_guard_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable credential guard. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "credential_guard_enabled")

    @_builtins.property
    @pulumi.getter(name="driftControlEnabled")
    def drift_control_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable drift control. Possible values are `true` and `false`. When set to `true`, the security baseline is re-applied regularly. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "drift_control_enabled")

    @_builtins.property
    @pulumi.getter(name="drtmProtectionEnabled")
    def drtm_protection_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable DRTM protection. Possible values are `true` and `false`. When set to `true`, Secure Boot is enabled on your Azure HCI cluster. This setting is hardware dependent. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "drtm_protection_enabled")

    @_builtins.property
    @pulumi.getter(name="episodicDataUploadEnabled")
    def episodic_data_upload_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to collect log data to facilitate quicker issue resolution. Possible values are `true` and `false`. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "episodic_data_upload_enabled")

    @_builtins.property
    @pulumi.getter(name="euLocationEnabled")
    def eu_location_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to store data sent to Microsoft in EU. The log and diagnostic data is sent to the appropriate diagnostics servers depending upon where your cluster resides. Setting this to `false` results in all data sent to Microsoft to be stored outside of the EU. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "eu_location_enabled")

    @_builtins.property
    @pulumi.getter(name="hvciProtectionEnabled")
    def hvci_protection_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable HVCI protection. Possible values are `true` and `false`. When set to `true`, Hypervisor-protected Code Integrity is enabled on your Azure HCI cluster. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "hvci_protection_enabled")

    @_builtins.property
    @pulumi.getter(name="sideChannelMitigationEnabled")
    def side_channel_mitigation_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable side channel mitigation. Possible values are `true` and `false`. When set to `true`, all side channel mitigations are enabled on your Azure HCI cluster. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "side_channel_mitigation_enabled")

    @_builtins.property
    @pulumi.getter(name="smbClusterEncryptionEnabled")
    def smb_cluster_encryption_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable SMB cluster encryption. Possible values are `true` and `false`. When set to `true`, cluster east-west traffic is encrypted. Defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "smb_cluster_encryption_enabled")

    @_builtins.property
    @pulumi.getter(name="smbSigningEnabled")
    def smb_signing_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable SMB signing. Possible values are `true` and `false`. When set to `true`, the SMB default instance requires sign in for the client and server services. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "smb_signing_enabled")

    @_builtins.property
    @pulumi.getter(name="streamingDataClientEnabled")
    def streaming_data_client_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether the telemetry data will be sent to Microsoft. Possible values are `true` and `false`. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "streaming_data_client_enabled")

    @_builtins.property
    @pulumi.getter(name="wdacEnabled")
    def wdac_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable WDAC. Possible values are `true` and `false`. When set to `true`, applications and the code that you can run on your Azure Stack HCI cluster are limited. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "wdac_enabled")


@pulumi.output_type
class HciDeploymentSettingScaleUnitCluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureServiceEndpoint":
            suggest = "azure_service_endpoint"
        elif key == "cloudAccountName":
            suggest = "cloud_account_name"
        elif key == "witnessPath":
            suggest = "witness_path"
        elif key == "witnessType":
            suggest = "witness_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HciDeploymentSettingScaleUnitCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HciDeploymentSettingScaleUnitCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HciDeploymentSettingScaleUnitCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_service_endpoint: _builtins.str,
                 cloud_account_name: _builtins.str,
                 name: _builtins.str,
                 witness_path: _builtins.str,
                 witness_type: _builtins.str):
        """
        :param _builtins.str azure_service_endpoint: Specifies the Azure blob service endpoint, for example, `core.windows.net`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.str cloud_account_name: Specifies the Azure Storage account name of the cloud witness for the Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.str name: Specifies the name of the cluster. It must be 3-15 characters long and contain only letters, numbers and hyphens. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.str witness_path: Specifies the fileshare path of the local witness for the Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.str witness_type: Specifies the type of the witness. Possible values are `Cloud`, `FileShare`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        pulumi.set(__self__, "azure_service_endpoint", azure_service_endpoint)
        pulumi.set(__self__, "cloud_account_name", cloud_account_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "witness_path", witness_path)
        pulumi.set(__self__, "witness_type", witness_type)

    @_builtins.property
    @pulumi.getter(name="azureServiceEndpoint")
    def azure_service_endpoint(self) -> _builtins.str:
        """
        Specifies the Azure blob service endpoint, for example, `core.windows.net`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "azure_service_endpoint")

    @_builtins.property
    @pulumi.getter(name="cloudAccountName")
    def cloud_account_name(self) -> _builtins.str:
        """
        Specifies the Azure Storage account name of the cloud witness for the Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "cloud_account_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the cluster. It must be 3-15 characters long and contain only letters, numbers and hyphens. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="witnessPath")
    def witness_path(self) -> _builtins.str:
        """
        Specifies the fileshare path of the local witness for the Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "witness_path")

    @_builtins.property
    @pulumi.getter(name="witnessType")
    def witness_type(self) -> _builtins.str:
        """
        Specifies the type of the witness. Possible values are `Cloud`, `FileShare`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "witness_type")


@pulumi.output_type
class HciDeploymentSettingScaleUnitHostNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageNetworks":
            suggest = "storage_networks"
        elif key == "storageAutoIpEnabled":
            suggest = "storage_auto_ip_enabled"
        elif key == "storageConnectivitySwitchlessEnabled":
            suggest = "storage_connectivity_switchless_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HciDeploymentSettingScaleUnitHostNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HciDeploymentSettingScaleUnitHostNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HciDeploymentSettingScaleUnitHostNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 intents: Sequence['outputs.HciDeploymentSettingScaleUnitHostNetworkIntent'],
                 storage_networks: Sequence['outputs.HciDeploymentSettingScaleUnitHostNetworkStorageNetwork'],
                 storage_auto_ip_enabled: Optional[_builtins.bool] = None,
                 storage_connectivity_switchless_enabled: Optional[_builtins.bool] = None):
        """
        :param Sequence['HciDeploymentSettingScaleUnitHostNetworkIntentArgs'] intents: One or more `intent` blocks as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param Sequence['HciDeploymentSettingScaleUnitHostNetworkStorageNetworkArgs'] storage_networks: One or more `storage_network` blocks as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.bool storage_auto_ip_enabled: Whether allows users to specify IPs and Mask for Storage NICs when Network ATC is not assigning the IPs for storage automatically. Optional parameter required only for [3 nodes switchless deployments](https://learn.microsoft.com/azure-stack/hci/concepts/physical-network-requirements?tabs=overview%2C23H2reqs#using-switchless). Possible values are `true` and `false`. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.bool storage_connectivity_switchless_enabled: Defines how the storage adapters between nodes are connected either switch or switch less. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        pulumi.set(__self__, "intents", intents)
        pulumi.set(__self__, "storage_networks", storage_networks)
        if storage_auto_ip_enabled is not None:
            pulumi.set(__self__, "storage_auto_ip_enabled", storage_auto_ip_enabled)
        if storage_connectivity_switchless_enabled is not None:
            pulumi.set(__self__, "storage_connectivity_switchless_enabled", storage_connectivity_switchless_enabled)

    @_builtins.property
    @pulumi.getter
    def intents(self) -> Sequence['outputs.HciDeploymentSettingScaleUnitHostNetworkIntent']:
        """
        One or more `intent` blocks as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "intents")

    @_builtins.property
    @pulumi.getter(name="storageNetworks")
    def storage_networks(self) -> Sequence['outputs.HciDeploymentSettingScaleUnitHostNetworkStorageNetwork']:
        """
        One or more `storage_network` blocks as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "storage_networks")

    @_builtins.property
    @pulumi.getter(name="storageAutoIpEnabled")
    def storage_auto_ip_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether allows users to specify IPs and Mask for Storage NICs when Network ATC is not assigning the IPs for storage automatically. Optional parameter required only for [3 nodes switchless deployments](https://learn.microsoft.com/azure-stack/hci/concepts/physical-network-requirements?tabs=overview%2C23H2reqs#using-switchless). Possible values are `true` and `false`. Defaults to `true`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "storage_auto_ip_enabled")

    @_builtins.property
    @pulumi.getter(name="storageConnectivitySwitchlessEnabled")
    def storage_connectivity_switchless_enabled(self) -> Optional[_builtins.bool]:
        """
        Defines how the storage adapters between nodes are connected either switch or switch less. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "storage_connectivity_switchless_enabled")


@pulumi.output_type
class HciDeploymentSettingScaleUnitHostNetworkIntent(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trafficTypes":
            suggest = "traffic_types"
        elif key == "adapterPropertyOverride":
            suggest = "adapter_property_override"
        elif key == "adapterPropertyOverrideEnabled":
            suggest = "adapter_property_override_enabled"
        elif key == "qosPolicyOverride":
            suggest = "qos_policy_override"
        elif key == "qosPolicyOverrideEnabled":
            suggest = "qos_policy_override_enabled"
        elif key == "virtualSwitchConfigurationOverride":
            suggest = "virtual_switch_configuration_override"
        elif key == "virtualSwitchConfigurationOverrideEnabled":
            suggest = "virtual_switch_configuration_override_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HciDeploymentSettingScaleUnitHostNetworkIntent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HciDeploymentSettingScaleUnitHostNetworkIntent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HciDeploymentSettingScaleUnitHostNetworkIntent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 adapters: Sequence[_builtins.str],
                 name: _builtins.str,
                 traffic_types: Sequence[_builtins.str],
                 adapter_property_override: Optional['outputs.HciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverride'] = None,
                 adapter_property_override_enabled: Optional[_builtins.bool] = None,
                 qos_policy_override: Optional['outputs.HciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverride'] = None,
                 qos_policy_override_enabled: Optional[_builtins.bool] = None,
                 virtual_switch_configuration_override: Optional['outputs.HciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverride'] = None,
                 virtual_switch_configuration_override_enabled: Optional[_builtins.bool] = None):
        """
        :param Sequence[_builtins.str] adapters: Specifies a list of ID of network interfaces used for the network intent. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.str name: Specifies the name of the intent. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param Sequence[_builtins.str] traffic_types: Specifies a list of network traffic types. Possible values are `Compute`, `Storage`, `Management`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param 'HciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverrideArgs' adapter_property_override: A `adapter_property_override` block as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.bool adapter_property_override_enabled: Whether to override adapter properties. Possible values are `true` and `false`. defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param 'HciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverrideArgs' qos_policy_override: A `qos_policy_override` block as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.bool qos_policy_override_enabled: Whether to override QoS policy. Possible values are `true` and `false`. defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param 'HciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverrideArgs' virtual_switch_configuration_override: A `virtual_switch_configuration_override` block as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.bool virtual_switch_configuration_override_enabled: Whether to override virtual switch configuration. Possible values are `true` and `false`. defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        pulumi.set(__self__, "adapters", adapters)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "traffic_types", traffic_types)
        if adapter_property_override is not None:
            pulumi.set(__self__, "adapter_property_override", adapter_property_override)
        if adapter_property_override_enabled is not None:
            pulumi.set(__self__, "adapter_property_override_enabled", adapter_property_override_enabled)
        if qos_policy_override is not None:
            pulumi.set(__self__, "qos_policy_override", qos_policy_override)
        if qos_policy_override_enabled is not None:
            pulumi.set(__self__, "qos_policy_override_enabled", qos_policy_override_enabled)
        if virtual_switch_configuration_override is not None:
            pulumi.set(__self__, "virtual_switch_configuration_override", virtual_switch_configuration_override)
        if virtual_switch_configuration_override_enabled is not None:
            pulumi.set(__self__, "virtual_switch_configuration_override_enabled", virtual_switch_configuration_override_enabled)

    @_builtins.property
    @pulumi.getter
    def adapters(self) -> Sequence[_builtins.str]:
        """
        Specifies a list of ID of network interfaces used for the network intent. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "adapters")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the intent. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="trafficTypes")
    def traffic_types(self) -> Sequence[_builtins.str]:
        """
        Specifies a list of network traffic types. Possible values are `Compute`, `Storage`, `Management`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "traffic_types")

    @_builtins.property
    @pulumi.getter(name="adapterPropertyOverride")
    def adapter_property_override(self) -> Optional['outputs.HciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverride']:
        """
        A `adapter_property_override` block as defined above. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "adapter_property_override")

    @_builtins.property
    @pulumi.getter(name="adapterPropertyOverrideEnabled")
    def adapter_property_override_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to override adapter properties. Possible values are `true` and `false`. defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "adapter_property_override_enabled")

    @_builtins.property
    @pulumi.getter(name="qosPolicyOverride")
    def qos_policy_override(self) -> Optional['outputs.HciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverride']:
        """
        A `qos_policy_override` block as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "qos_policy_override")

    @_builtins.property
    @pulumi.getter(name="qosPolicyOverrideEnabled")
    def qos_policy_override_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to override QoS policy. Possible values are `true` and `false`. defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "qos_policy_override_enabled")

    @_builtins.property
    @pulumi.getter(name="virtualSwitchConfigurationOverride")
    def virtual_switch_configuration_override(self) -> Optional['outputs.HciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverride']:
        """
        A `virtual_switch_configuration_override` block as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "virtual_switch_configuration_override")

    @_builtins.property
    @pulumi.getter(name="virtualSwitchConfigurationOverrideEnabled")
    def virtual_switch_configuration_override_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to override virtual switch configuration. Possible values are `true` and `false`. defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "virtual_switch_configuration_override_enabled")


@pulumi.output_type
class HciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jumboPacket":
            suggest = "jumbo_packet"
        elif key == "networkDirect":
            suggest = "network_direct"
        elif key == "networkDirectTechnology":
            suggest = "network_direct_technology"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HciDeploymentSettingScaleUnitHostNetworkIntentAdapterPropertyOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 jumbo_packet: Optional[_builtins.str] = None,
                 network_direct: Optional[_builtins.str] = None,
                 network_direct_technology: Optional[_builtins.str] = None):
        """
        :param _builtins.str jumbo_packet: The jumbo frame size of the adapter. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.str network_direct: The network direct of the adapter. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.str network_direct_technology: The network direct technology of the adapter. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        if jumbo_packet is not None:
            pulumi.set(__self__, "jumbo_packet", jumbo_packet)
        if network_direct is not None:
            pulumi.set(__self__, "network_direct", network_direct)
        if network_direct_technology is not None:
            pulumi.set(__self__, "network_direct_technology", network_direct_technology)

    @_builtins.property
    @pulumi.getter(name="jumboPacket")
    def jumbo_packet(self) -> Optional[_builtins.str]:
        """
        The jumbo frame size of the adapter. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "jumbo_packet")

    @_builtins.property
    @pulumi.getter(name="networkDirect")
    def network_direct(self) -> Optional[_builtins.str]:
        """
        The network direct of the adapter. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "network_direct")

    @_builtins.property
    @pulumi.getter(name="networkDirectTechnology")
    def network_direct_technology(self) -> Optional[_builtins.str]:
        """
        The network direct technology of the adapter. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "network_direct_technology")


@pulumi.output_type
class HciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bandwidthPercentageSmb":
            suggest = "bandwidth_percentage_smb"
        elif key == "priorityValue8021ActionCluster":
            suggest = "priority_value8021_action_cluster"
        elif key == "priorityValue8021ActionSmb":
            suggest = "priority_value8021_action_smb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HciDeploymentSettingScaleUnitHostNetworkIntentQosPolicyOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bandwidth_percentage_smb: Optional[_builtins.str] = None,
                 priority_value8021_action_cluster: Optional[_builtins.str] = None,
                 priority_value8021_action_smb: Optional[_builtins.str] = None):
        """
        :param _builtins.str bandwidth_percentage_smb: Specifies the percentage of the allocated storage traffic bandwidth. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.str priority_value8021_action_cluster: Specifies the Cluster traffic priority. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.str priority_value8021_action_smb: Specifies the Priority Flow Control where Data Center Bridging (DCB) is used. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        if bandwidth_percentage_smb is not None:
            pulumi.set(__self__, "bandwidth_percentage_smb", bandwidth_percentage_smb)
        if priority_value8021_action_cluster is not None:
            pulumi.set(__self__, "priority_value8021_action_cluster", priority_value8021_action_cluster)
        if priority_value8021_action_smb is not None:
            pulumi.set(__self__, "priority_value8021_action_smb", priority_value8021_action_smb)

    @_builtins.property
    @pulumi.getter(name="bandwidthPercentageSmb")
    def bandwidth_percentage_smb(self) -> Optional[_builtins.str]:
        """
        Specifies the percentage of the allocated storage traffic bandwidth. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "bandwidth_percentage_smb")

    @_builtins.property
    @pulumi.getter(name="priorityValue8021ActionCluster")
    def priority_value8021_action_cluster(self) -> Optional[_builtins.str]:
        """
        Specifies the Cluster traffic priority. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "priority_value8021_action_cluster")

    @_builtins.property
    @pulumi.getter(name="priorityValue8021ActionSmb")
    def priority_value8021_action_smb(self) -> Optional[_builtins.str]:
        """
        Specifies the Priority Flow Control where Data Center Bridging (DCB) is used. This parameter should only be modified based on your OEM guidance. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "priority_value8021_action_smb")


@pulumi.output_type
class HciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableIov":
            suggest = "enable_iov"
        elif key == "loadBalancingAlgorithm":
            suggest = "load_balancing_algorithm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HciDeploymentSettingScaleUnitHostNetworkIntentVirtualSwitchConfigurationOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_iov: Optional[_builtins.str] = None,
                 load_balancing_algorithm: Optional[_builtins.str] = None):
        """
        :param _builtins.str enable_iov: Specifies the IoV enable status for Virtual Switch. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.str load_balancing_algorithm: Specifies the load balancing algorithm for Virtual Switch. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        if enable_iov is not None:
            pulumi.set(__self__, "enable_iov", enable_iov)
        if load_balancing_algorithm is not None:
            pulumi.set(__self__, "load_balancing_algorithm", load_balancing_algorithm)

    @_builtins.property
    @pulumi.getter(name="enableIov")
    def enable_iov(self) -> Optional[_builtins.str]:
        """
        Specifies the IoV enable status for Virtual Switch. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "enable_iov")

    @_builtins.property
    @pulumi.getter(name="loadBalancingAlgorithm")
    def load_balancing_algorithm(self) -> Optional[_builtins.str]:
        """
        Specifies the load balancing algorithm for Virtual Switch. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "load_balancing_algorithm")


@pulumi.output_type
class HciDeploymentSettingScaleUnitHostNetworkStorageNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkAdapterName":
            suggest = "network_adapter_name"
        elif key == "vlanId":
            suggest = "vlan_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HciDeploymentSettingScaleUnitHostNetworkStorageNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HciDeploymentSettingScaleUnitHostNetworkStorageNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HciDeploymentSettingScaleUnitHostNetworkStorageNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 network_adapter_name: _builtins.str,
                 vlan_id: _builtins.str):
        """
        :param _builtins.str name: The name of the storage network. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.str network_adapter_name: The name of the network adapter. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.str vlan_id: Specifies the ID for the VLAN storage network. This setting is applied to the network interfaces that route the storage and VM migration traffic. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_adapter_name", network_adapter_name)
        pulumi.set(__self__, "vlan_id", vlan_id)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the storage network. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkAdapterName")
    def network_adapter_name(self) -> _builtins.str:
        """
        The name of the network adapter. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "network_adapter_name")

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> _builtins.str:
        """
        Specifies the ID for the VLAN storage network. This setting is applied to the network interfaces that route the storage and VM migration traffic. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "vlan_id")


@pulumi.output_type
class HciDeploymentSettingScaleUnitInfrastructureNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsServers":
            suggest = "dns_servers"
        elif key == "ipPools":
            suggest = "ip_pools"
        elif key == "subnetMask":
            suggest = "subnet_mask"
        elif key == "dhcpEnabled":
            suggest = "dhcp_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HciDeploymentSettingScaleUnitInfrastructureNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HciDeploymentSettingScaleUnitInfrastructureNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HciDeploymentSettingScaleUnitInfrastructureNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_servers: Sequence[_builtins.str],
                 gateway: _builtins.str,
                 ip_pools: Sequence['outputs.HciDeploymentSettingScaleUnitInfrastructureNetworkIpPool'],
                 subnet_mask: _builtins.str,
                 dhcp_enabled: Optional[_builtins.bool] = None):
        """
        :param Sequence[_builtins.str] dns_servers: Specifies a list of IPv4 addresses of the DNS servers in your environment. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.str gateway: Specifies the default gateway that should be used for the provided IP address space. It should be in the format of an IPv4 IP address. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param Sequence['HciDeploymentSettingScaleUnitInfrastructureNetworkIpPoolArgs'] ip_pools: One or more `ip_pool` blocks as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.str subnet_mask: Specifies the subnet mask that matches the provided IP address space. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.bool dhcp_enabled: Whether DHCP is enabled for hosts and cluster IPs. Possible values are `true` and `false`. defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.
               
               > **Note:** If `dhcp_enabled` is set to `false`, the deployment will use static IPs. If set to `true`, the gateway and DNS servers are not required.
        """
        pulumi.set(__self__, "dns_servers", dns_servers)
        pulumi.set(__self__, "gateway", gateway)
        pulumi.set(__self__, "ip_pools", ip_pools)
        pulumi.set(__self__, "subnet_mask", subnet_mask)
        if dhcp_enabled is not None:
            pulumi.set(__self__, "dhcp_enabled", dhcp_enabled)

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Sequence[_builtins.str]:
        """
        Specifies a list of IPv4 addresses of the DNS servers in your environment. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "dns_servers")

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> _builtins.str:
        """
        Specifies the default gateway that should be used for the provided IP address space. It should be in the format of an IPv4 IP address. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "gateway")

    @_builtins.property
    @pulumi.getter(name="ipPools")
    def ip_pools(self) -> Sequence['outputs.HciDeploymentSettingScaleUnitInfrastructureNetworkIpPool']:
        """
        One or more `ip_pool` blocks as defined below. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "ip_pools")

    @_builtins.property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> _builtins.str:
        """
        Specifies the subnet mask that matches the provided IP address space. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "subnet_mask")

    @_builtins.property
    @pulumi.getter(name="dhcpEnabled")
    def dhcp_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether DHCP is enabled for hosts and cluster IPs. Possible values are `true` and `false`. defaults to `false`. Changing this forces a new Stack HCI Deployment Setting to be created.

        > **Note:** If `dhcp_enabled` is set to `false`, the deployment will use static IPs. If set to `true`, the gateway and DNS servers are not required.
        """
        return pulumi.get(self, "dhcp_enabled")


@pulumi.output_type
class HciDeploymentSettingScaleUnitInfrastructureNetworkIpPool(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endingAddress":
            suggest = "ending_address"
        elif key == "startingAddress":
            suggest = "starting_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HciDeploymentSettingScaleUnitInfrastructureNetworkIpPool. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HciDeploymentSettingScaleUnitInfrastructureNetworkIpPool.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HciDeploymentSettingScaleUnitInfrastructureNetworkIpPool.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ending_address: _builtins.str,
                 starting_address: _builtins.str):
        """
        :param _builtins.str ending_address: Specifies starting IP address for the management network. A minimum of six free, contiguous IPv4 addresses (excluding your host IPs) are needed for infrastructure services such as clustering. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.str starting_address: Specifies ending IP address for the management network. A minimum of six free, contiguous IPv4 addresses (excluding your host IPs) are needed for infrastructure services such as clustering. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        pulumi.set(__self__, "ending_address", ending_address)
        pulumi.set(__self__, "starting_address", starting_address)

    @_builtins.property
    @pulumi.getter(name="endingAddress")
    def ending_address(self) -> _builtins.str:
        """
        Specifies starting IP address for the management network. A minimum of six free, contiguous IPv4 addresses (excluding your host IPs) are needed for infrastructure services such as clustering. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "ending_address")

    @_builtins.property
    @pulumi.getter(name="startingAddress")
    def starting_address(self) -> _builtins.str:
        """
        Specifies ending IP address for the management network. A minimum of six free, contiguous IPv4 addresses (excluding your host IPs) are needed for infrastructure services such as clustering. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "starting_address")


@pulumi.output_type
class HciDeploymentSettingScaleUnitOptionalService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customLocation":
            suggest = "custom_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HciDeploymentSettingScaleUnitOptionalService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HciDeploymentSettingScaleUnitOptionalService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HciDeploymentSettingScaleUnitOptionalService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_location: _builtins.str):
        """
        :param _builtins.str custom_location: Specifies the name of custom location. A custom location will be created after the deployment is completed. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        pulumi.set(__self__, "custom_location", custom_location)

    @_builtins.property
    @pulumi.getter(name="customLocation")
    def custom_location(self) -> _builtins.str:
        """
        Specifies the name of custom location. A custom location will be created after the deployment is completed. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "custom_location")


@pulumi.output_type
class HciDeploymentSettingScaleUnitPhysicalNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipv4Address":
            suggest = "ipv4_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HciDeploymentSettingScaleUnitPhysicalNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HciDeploymentSettingScaleUnitPhysicalNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HciDeploymentSettingScaleUnitPhysicalNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipv4_address: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str ipv4_address: Specifies the IPv4 address assigned to each physical server on your Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        :param _builtins.str name: The NETBIOS name of each physical server on your Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        pulumi.set(__self__, "ipv4_address", ipv4_address)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> _builtins.str:
        """
        Specifies the IPv4 address assigned to each physical server on your Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "ipv4_address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The NETBIOS name of each physical server on your Azure Stack HCI cluster. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class HciDeploymentSettingScaleUnitStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationMode":
            suggest = "configuration_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HciDeploymentSettingScaleUnitStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HciDeploymentSettingScaleUnitStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HciDeploymentSettingScaleUnitStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration_mode: _builtins.str):
        """
        :param _builtins.str configuration_mode: The configuration mode of storage. If set to `Express` and your storage is configured as per best practices based on the number of nodes in the cluster. Possible values are `Express`, `InfraOnly` and `KeepStorage`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        pulumi.set(__self__, "configuration_mode", configuration_mode)

    @_builtins.property
    @pulumi.getter(name="configurationMode")
    def configuration_mode(self) -> _builtins.str:
        """
        The configuration mode of storage. If set to `Express` and your storage is configured as per best practices based on the number of nodes in the cluster. Possible values are `Express`, `InfraOnly` and `KeepStorage`. Changing this forces a new Stack HCI Deployment Setting to be created.
        """
        return pulumi.get(self, "configuration_mode")


@pulumi.output_type
class HciLogicalNetworkSubnet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAllocationMethod":
            suggest = "ip_allocation_method"
        elif key == "addressPrefix":
            suggest = "address_prefix"
        elif key == "ipPools":
            suggest = "ip_pools"
        elif key == "vlanId":
            suggest = "vlan_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HciLogicalNetworkSubnet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HciLogicalNetworkSubnet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HciLogicalNetworkSubnet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_allocation_method: _builtins.str,
                 address_prefix: Optional[_builtins.str] = None,
                 ip_pools: Optional[Sequence['outputs.HciLogicalNetworkSubnetIpPool']] = None,
                 routes: Optional[Sequence['outputs.HciLogicalNetworkSubnetRoute']] = None,
                 vlan_id: Optional[_builtins.int] = None):
        """
        :param _builtins.str ip_allocation_method: The IP address allocation method for the subnet. Possible values are `Dynamic` and `Static`. Changing this forces a new resource to be created.
        :param _builtins.str address_prefix: The address prefix in CIDR notation. Changing this forces a new resource to be created.
        :param Sequence['HciLogicalNetworkSubnetIpPoolArgs'] ip_pools: One or more `ip_pool` block as defined above. Changing this forces a new resource to be created.
               
               > **Note:** If `ip_pool` is not specified, it will be assigned by the server. If you experience a diff you may need to add this to `ignore_changes`.
        :param Sequence['HciLogicalNetworkSubnetRouteArgs'] routes: A `route` block as defined above. Changing this forces a new resource to be created.
        :param _builtins.int vlan_id: The VLAN ID for the Logical Network. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "ip_allocation_method", ip_allocation_method)
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if ip_pools is not None:
            pulumi.set(__self__, "ip_pools", ip_pools)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)

    @_builtins.property
    @pulumi.getter(name="ipAllocationMethod")
    def ip_allocation_method(self) -> _builtins.str:
        """
        The IP address allocation method for the subnet. Possible values are `Dynamic` and `Static`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "ip_allocation_method")

    @_builtins.property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[_builtins.str]:
        """
        The address prefix in CIDR notation. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "address_prefix")

    @_builtins.property
    @pulumi.getter(name="ipPools")
    def ip_pools(self) -> Optional[Sequence['outputs.HciLogicalNetworkSubnetIpPool']]:
        """
        One or more `ip_pool` block as defined above. Changing this forces a new resource to be created.

        > **Note:** If `ip_pool` is not specified, it will be assigned by the server. If you experience a diff you may need to add this to `ignore_changes`.
        """
        return pulumi.get(self, "ip_pools")

    @_builtins.property
    @pulumi.getter
    def routes(self) -> Optional[Sequence['outputs.HciLogicalNetworkSubnetRoute']]:
        """
        A `route` block as defined above. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "routes")

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[_builtins.int]:
        """
        The VLAN ID for the Logical Network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vlan_id")


@pulumi.output_type
class HciLogicalNetworkSubnetIpPool(dict):
    def __init__(__self__, *,
                 end: _builtins.str,
                 start: _builtins.str):
        """
        :param _builtins.str end: The IPv4 address of the end of the IP address pool. Changing this forces a new resource to be created.
        :param _builtins.str start: The IPv4 address of the start of the IP address pool. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "start", start)

    @_builtins.property
    @pulumi.getter
    def end(self) -> _builtins.str:
        """
        The IPv4 address of the end of the IP address pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "end")

    @_builtins.property
    @pulumi.getter
    def start(self) -> _builtins.str:
        """
        The IPv4 address of the start of the IP address pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class HciLogicalNetworkSubnetRoute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressPrefix":
            suggest = "address_prefix"
        elif key == "nextHopIpAddress":
            suggest = "next_hop_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HciLogicalNetworkSubnetRoute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HciLogicalNetworkSubnetRoute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HciLogicalNetworkSubnetRoute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_prefix: _builtins.str,
                 next_hop_ip_address: _builtins.str,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str address_prefix: The Address in CIDR notation. Changing this forces a new resource to be created.
        :param _builtins.str next_hop_ip_address: The IPv4 address of the next hop. Changing this forces a new resource to be created.
        :param _builtins.str name: The name of the route. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "address_prefix", address_prefix)
        pulumi.set(__self__, "next_hop_ip_address", next_hop_ip_address)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> _builtins.str:
        """
        The Address in CIDR notation. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "address_prefix")

    @_builtins.property
    @pulumi.getter(name="nextHopIpAddress")
    def next_hop_ip_address(self) -> _builtins.str:
        """
        The IPv4 address of the next hop. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "next_hop_ip_address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the route. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class HciMarketplaceGalleryImageIdentifier(dict):
    def __init__(__self__, *,
                 offer: _builtins.str,
                 publisher: _builtins.str,
                 sku: _builtins.str):
        """
        :param _builtins.str offer: The offer of the Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param _builtins.str publisher: The publisher of the Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param _builtins.str sku: The sku of the Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        pulumi.set(__self__, "offer", offer)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "sku", sku)

    @_builtins.property
    @pulumi.getter
    def offer(self) -> _builtins.str:
        """
        The offer of the Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "offer")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        """
        The publisher of the Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "publisher")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> _builtins.str:
        """
        The sku of the Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "sku")


@pulumi.output_type
class HciNetworkInterfaceIpConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "prefixLength":
            suggest = "prefix_length"
        elif key == "privateIpAddress":
            suggest = "private_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HciNetworkInterfaceIpConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HciNetworkInterfaceIpConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HciNetworkInterfaceIpConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: _builtins.str,
                 gateway: Optional[_builtins.str] = None,
                 prefix_length: Optional[_builtins.str] = None,
                 private_ip_address: Optional[_builtins.str] = None):
        """
        :param _builtins.str subnet_id: The resource ID of the Stack HCI Logical Network bound to the IP configuration. Changing this forces a new resource to be created.
        :param _builtins.str gateway: The IPv4 address of the gateway for the Network Interface.
        :param _builtins.str prefix_length: The prefix length for the address of the Network Interface.
        :param _builtins.str private_ip_address: The IPv4 address of the IP configuration. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if prefix_length is not None:
            pulumi.set(__self__, "prefix_length", prefix_length)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The resource ID of the Stack HCI Logical Network bound to the IP configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> Optional[_builtins.str]:
        """
        The IPv4 address of the gateway for the Network Interface.
        """
        return pulumi.get(self, "gateway")

    @_builtins.property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> Optional[_builtins.str]:
        """
        The prefix length for the address of the Network Interface.
        """
        return pulumi.get(self, "prefix_length")

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[_builtins.str]:
        """
        The IPv4 address of the IP configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "private_ip_address")


@pulumi.output_type
class GetHciClusterIdentityResult(dict):
    def __init__(__self__, *,
                 principal_id: _builtins.str,
                 tenant_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param _builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        :param _builtins.str type: (Required) The type of Managed Service Identity configured on the Azure Stack HCI Cluster.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        (Required) The type of Managed Service Identity configured on the Azure Stack HCI Cluster.
        """
        return pulumi.get(self, "type")


