# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTableEntitiesResult',
    'AwaitableGetTableEntitiesResult',
    'get_table_entities',
    'get_table_entities_output',
]

@pulumi.output_type
class GetTableEntitiesResult:
    """
    A collection of values returned by getTableEntities.
    """
    def __init__(__self__, filter=None, id=None, items=None, selects=None, storage_table_id=None):
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if selects and not isinstance(selects, list):
            raise TypeError("Expected argument 'selects' to be a list")
        pulumi.set(__self__, "selects", selects)
        if storage_table_id and not isinstance(storage_table_id, str):
            raise TypeError("Expected argument 'storage_table_id' to be a str")
        pulumi.set(__self__, "storage_table_id", storage_table_id)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> _builtins.str:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetTableEntitiesItemResult']:
        """
        A list of `items` blocks as defined below.
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter
    def selects(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "selects")

    @_builtins.property
    @pulumi.getter(name="storageTableId")
    def storage_table_id(self) -> _builtins.str:
        return pulumi.get(self, "storage_table_id")


class AwaitableGetTableEntitiesResult(GetTableEntitiesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTableEntitiesResult(
            filter=self.filter,
            id=self.id,
            items=self.items,
            selects=self.selects,
            storage_table_id=self.storage_table_id)


def get_table_entities(filter: Optional[_builtins.str] = None,
                       selects: Optional[Sequence[_builtins.str]] = None,
                       storage_table_id: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTableEntitiesResult:
    """
    Use this data source to access information about an existing Storage Table Entity.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.storage.get_table_entities(storage_table_id=example_azurerm_storage_table["id"],
        filter="PartitionKey eq 'example'")
    ```


    :param _builtins.str filter: The filter used to retrieve the entities.
    :param Sequence[_builtins.str] selects: A list of properties to select from the returned Storage Table Entities.
    :param _builtins.str storage_table_id: The Storage Table ID where the entities exist.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['selects'] = selects
    __args__['storageTableId'] = storage_table_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:storage/getTableEntities:getTableEntities', __args__, opts=opts, typ=GetTableEntitiesResult).value

    return AwaitableGetTableEntitiesResult(
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        selects=pulumi.get(__ret__, 'selects'),
        storage_table_id=pulumi.get(__ret__, 'storage_table_id'))
def get_table_entities_output(filter: Optional[pulumi.Input[_builtins.str]] = None,
                              selects: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                              storage_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTableEntitiesResult]:
    """
    Use this data source to access information about an existing Storage Table Entity.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.storage.get_table_entities(storage_table_id=example_azurerm_storage_table["id"],
        filter="PartitionKey eq 'example'")
    ```


    :param _builtins.str filter: The filter used to retrieve the entities.
    :param Sequence[_builtins.str] selects: A list of properties to select from the returned Storage Table Entities.
    :param _builtins.str storage_table_id: The Storage Table ID where the entities exist.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['selects'] = selects
    __args__['storageTableId'] = storage_table_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:storage/getTableEntities:getTableEntities', __args__, opts=opts, typ=GetTableEntitiesResult)
    return __ret__.apply(lambda __response__: GetTableEntitiesResult(
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        selects=pulumi.get(__response__, 'selects'),
        storage_table_id=pulumi.get(__response__, 'storage_table_id')))
