# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['JobStorageAccountArgs', 'JobStorageAccount']

@pulumi.input_type
class JobStorageAccountArgs:
    def __init__(__self__, *,
                 authentication_mode: pulumi.Input[_builtins.str],
                 storage_account_name: pulumi.Input[_builtins.str],
                 stream_analytics_job_id: pulumi.Input[_builtins.str],
                 storage_account_key: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a JobStorageAccount resource.
        :param pulumi.Input[_builtins.str] authentication_mode: The authentication mode for the Stream Analytics Job's Storage Account. Possible values are `ConnectionString`, and `Msi`.
        :param pulumi.Input[_builtins.str] stream_analytics_job_id: The ID of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "authentication_mode", authentication_mode)
        pulumi.set(__self__, "storage_account_name", storage_account_name)
        pulumi.set(__self__, "stream_analytics_job_id", stream_analytics_job_id)
        if storage_account_key is not None:
            pulumi.set(__self__, "storage_account_key", storage_account_key)

    @_builtins.property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> pulumi.Input[_builtins.str]:
        """
        The authentication mode for the Stream Analytics Job's Storage Account. Possible values are `ConnectionString`, and `Msi`.
        """
        return pulumi.get(self, "authentication_mode")

    @authentication_mode.setter
    def authentication_mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "authentication_mode", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "storage_account_name")

    @storage_account_name.setter
    def storage_account_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_account_name", value)

    @_builtins.property
    @pulumi.getter(name="streamAnalyticsJobId")
    def stream_analytics_job_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "stream_analytics_job_id")

    @stream_analytics_job_id.setter
    def stream_analytics_job_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "stream_analytics_job_id", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountKey")
    def storage_account_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "storage_account_key")

    @storage_account_key.setter
    def storage_account_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_key", value)


@pulumi.input_type
class _JobStorageAccountState:
    def __init__(__self__, *,
                 authentication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_analytics_job_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering JobStorageAccount resources.
        :param pulumi.Input[_builtins.str] authentication_mode: The authentication mode for the Stream Analytics Job's Storage Account. Possible values are `ConnectionString`, and `Msi`.
        :param pulumi.Input[_builtins.str] stream_analytics_job_id: The ID of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        if authentication_mode is not None:
            pulumi.set(__self__, "authentication_mode", authentication_mode)
        if storage_account_key is not None:
            pulumi.set(__self__, "storage_account_key", storage_account_key)
        if storage_account_name is not None:
            pulumi.set(__self__, "storage_account_name", storage_account_name)
        if stream_analytics_job_id is not None:
            pulumi.set(__self__, "stream_analytics_job_id", stream_analytics_job_id)

    @_builtins.property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication mode for the Stream Analytics Job's Storage Account. Possible values are `ConnectionString`, and `Msi`.
        """
        return pulumi.get(self, "authentication_mode")

    @authentication_mode.setter
    def authentication_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_mode", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountKey")
    def storage_account_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "storage_account_key")

    @storage_account_key.setter
    def storage_account_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_key", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "storage_account_name")

    @storage_account_name.setter
    def storage_account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_name", value)

    @_builtins.property
    @pulumi.getter(name="streamAnalyticsJobId")
    def stream_analytics_job_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "stream_analytics_job_id")

    @stream_analytics_job_id.setter
    def stream_analytics_job_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stream_analytics_job_id", value)


@pulumi.type_token("azure:streamanalytics/jobStorageAccount:JobStorageAccount")
class JobStorageAccount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_analytics_job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Stream Analytics Job Storage Account. Use this resource for managing the Job Storage Account using `Msi` authentication with a `SystemAssigned` identity.

        > **Note:** The Job Storage Account for a Stream Analytics Job can be managed on the `streamanalytics.Job` resource with the `job_storage_account` block, or with this resource. We do not recommend managing the Job Storage Account through both means as this can lead to conflicts.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_job = azure.streamanalytics.Job("example",
            name="example-job",
            resource_group_name=example.name,
            location=example.location,
            compatibility_level="1.2",
            data_locale="en-GB",
            events_late_arrival_max_delay_in_seconds=60,
            events_out_of_order_max_delay_in_seconds=50,
            events_out_of_order_policy="Adjust",
            output_error_policy="Drop",
            streaming_units=3,
            sku_name="StandardV2",
            identity={
                "type": "SystemAssigned",
            },
            tags={
                "environment": "Example",
            },
            transformation_query=\"\"\"    SELECT *
            INTO [YourOutputAlias]
            FROM [YourInputAlias]
        \"\"\")
        example_account = azure.storage.Account("example",
            name="exampleaccount",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_job_storage_account = azure.streamanalytics.JobStorageAccount("example",
            stream_analytics_job_id=example_job.id,
            storage_account_name=example_account.name,
            authentication_mode="Msi")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StreamAnalytics` - 2021-10-01-preview

        ## Import

        Stream Analytics Job Storage Accounts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:streamanalytics/jobStorageAccount:JobStorageAccount example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.StreamAnalytics/streamingJobs/job1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authentication_mode: The authentication mode for the Stream Analytics Job's Storage Account. Possible values are `ConnectionString`, and `Msi`.
        :param pulumi.Input[_builtins.str] stream_analytics_job_id: The ID of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobStorageAccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Stream Analytics Job Storage Account. Use this resource for managing the Job Storage Account using `Msi` authentication with a `SystemAssigned` identity.

        > **Note:** The Job Storage Account for a Stream Analytics Job can be managed on the `streamanalytics.Job` resource with the `job_storage_account` block, or with this resource. We do not recommend managing the Job Storage Account through both means as this can lead to conflicts.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_job = azure.streamanalytics.Job("example",
            name="example-job",
            resource_group_name=example.name,
            location=example.location,
            compatibility_level="1.2",
            data_locale="en-GB",
            events_late_arrival_max_delay_in_seconds=60,
            events_out_of_order_max_delay_in_seconds=50,
            events_out_of_order_policy="Adjust",
            output_error_policy="Drop",
            streaming_units=3,
            sku_name="StandardV2",
            identity={
                "type": "SystemAssigned",
            },
            tags={
                "environment": "Example",
            },
            transformation_query=\"\"\"    SELECT *
            INTO [YourOutputAlias]
            FROM [YourInputAlias]
        \"\"\")
        example_account = azure.storage.Account("example",
            name="exampleaccount",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_job_storage_account = azure.streamanalytics.JobStorageAccount("example",
            stream_analytics_job_id=example_job.id,
            storage_account_name=example_account.name,
            authentication_mode="Msi")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StreamAnalytics` - 2021-10-01-preview

        ## Import

        Stream Analytics Job Storage Accounts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:streamanalytics/jobStorageAccount:JobStorageAccount example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.StreamAnalytics/streamingJobs/job1
        ```

        :param str resource_name: The name of the resource.
        :param JobStorageAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobStorageAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_analytics_job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobStorageAccountArgs.__new__(JobStorageAccountArgs)

            if authentication_mode is None and not opts.urn:
                raise TypeError("Missing required property 'authentication_mode'")
            __props__.__dict__["authentication_mode"] = authentication_mode
            __props__.__dict__["storage_account_key"] = None if storage_account_key is None else pulumi.Output.secret(storage_account_key)
            if storage_account_name is None and not opts.urn:
                raise TypeError("Missing required property 'storage_account_name'")
            __props__.__dict__["storage_account_name"] = storage_account_name
            if stream_analytics_job_id is None and not opts.urn:
                raise TypeError("Missing required property 'stream_analytics_job_id'")
            __props__.__dict__["stream_analytics_job_id"] = stream_analytics_job_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["storageAccountKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(JobStorageAccount, __self__).__init__(
            'azure:streamanalytics/jobStorageAccount:JobStorageAccount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_mode: Optional[pulumi.Input[_builtins.str]] = None,
            storage_account_key: Optional[pulumi.Input[_builtins.str]] = None,
            storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
            stream_analytics_job_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'JobStorageAccount':
        """
        Get an existing JobStorageAccount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authentication_mode: The authentication mode for the Stream Analytics Job's Storage Account. Possible values are `ConnectionString`, and `Msi`.
        :param pulumi.Input[_builtins.str] stream_analytics_job_id: The ID of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobStorageAccountState.__new__(_JobStorageAccountState)

        __props__.__dict__["authentication_mode"] = authentication_mode
        __props__.__dict__["storage_account_key"] = storage_account_key
        __props__.__dict__["storage_account_name"] = storage_account_name
        __props__.__dict__["stream_analytics_job_id"] = stream_analytics_job_id
        return JobStorageAccount(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The authentication mode for the Stream Analytics Job's Storage Account. Possible values are `ConnectionString`, and `Msi`.
        """
        return pulumi.get(self, "authentication_mode")

    @_builtins.property
    @pulumi.getter(name="storageAccountKey")
    def storage_account_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "storage_account_key")

    @_builtins.property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "storage_account_name")

    @_builtins.property
    @pulumi.getter(name="streamAnalyticsJobId")
    def stream_analytics_job_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "stream_analytics_job_id")

