# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ServicesCommunicationsGatewayServiceLocation',
]

@pulumi.output_type
class ServicesCommunicationsGatewayServiceLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorAddresses":
            suggest = "operator_addresses"
        elif key == "allowedMediaSourceAddressPrefixes":
            suggest = "allowed_media_source_address_prefixes"
        elif key == "allowedSignalingSourceAddressPrefixes":
            suggest = "allowed_signaling_source_address_prefixes"
        elif key == "esrpAddresses":
            suggest = "esrp_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicesCommunicationsGatewayServiceLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicesCommunicationsGatewayServiceLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicesCommunicationsGatewayServiceLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: _builtins.str,
                 operator_addresses: Sequence[_builtins.str],
                 allowed_media_source_address_prefixes: Optional[Sequence[_builtins.str]] = None,
                 allowed_signaling_source_address_prefixes: Optional[Sequence[_builtins.str]] = None,
                 esrp_addresses: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str location: Specifies the region in which the resources needed for Teams Calling will be deployed.
        :param Sequence[_builtins.str] operator_addresses: IP address to use to contact the operator network from this region.
        :param Sequence[_builtins.str] allowed_media_source_address_prefixes: Specifies the allowed source IP address or CIDR ranges for media.
        :param Sequence[_builtins.str] allowed_signaling_source_address_prefixes: Specifies the allowed source IP address or CIDR ranges for signaling.
        :param Sequence[_builtins.str] esrp_addresses: IP address to use to contact the ESRP from this region.
               
               !> **Note:** The `esrp_addresses` must be specified for each `service_location` when the`e911_type` is set to `DirectToEsrp`.  The `esrp_addresses` must not be specified for each `service_location` when the`e911_type` is set to `Standard`.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "operator_addresses", operator_addresses)
        if allowed_media_source_address_prefixes is not None:
            pulumi.set(__self__, "allowed_media_source_address_prefixes", allowed_media_source_address_prefixes)
        if allowed_signaling_source_address_prefixes is not None:
            pulumi.set(__self__, "allowed_signaling_source_address_prefixes", allowed_signaling_source_address_prefixes)
        if esrp_addresses is not None:
            pulumi.set(__self__, "esrp_addresses", esrp_addresses)

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        Specifies the region in which the resources needed for Teams Calling will be deployed.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="operatorAddresses")
    def operator_addresses(self) -> Sequence[_builtins.str]:
        """
        IP address to use to contact the operator network from this region.
        """
        return pulumi.get(self, "operator_addresses")

    @_builtins.property
    @pulumi.getter(name="allowedMediaSourceAddressPrefixes")
    def allowed_media_source_address_prefixes(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the allowed source IP address or CIDR ranges for media.
        """
        return pulumi.get(self, "allowed_media_source_address_prefixes")

    @_builtins.property
    @pulumi.getter(name="allowedSignalingSourceAddressPrefixes")
    def allowed_signaling_source_address_prefixes(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the allowed source IP address or CIDR ranges for signaling.
        """
        return pulumi.get(self, "allowed_signaling_source_address_prefixes")

    @_builtins.property
    @pulumi.getter(name="esrpAddresses")
    def esrp_addresses(self) -> Optional[Sequence[_builtins.str]]:
        """
        IP address to use to contact the ESRP from this region.

        !> **Note:** The `esrp_addresses` must be specified for each `service_location` when the`e911_type` is set to `DirectToEsrp`.  The `esrp_addresses` must not be specified for each `service_location` when the`e911_type` is set to `Standard`.
        """
        return pulumi.get(self, "esrp_addresses")


