# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'PolicyCustomRule',
    'PolicyCustomRuleMatchCondition',
    'PolicyCustomRuleMatchConditionMatchVariable',
    'PolicyManagedRules',
    'PolicyManagedRulesExclusion',
    'PolicyManagedRulesExclusionExcludedRuleSet',
    'PolicyManagedRulesExclusionExcludedRuleSetRuleGroup',
    'PolicyManagedRulesManagedRuleSet',
    'PolicyManagedRulesManagedRuleSetRuleGroupOverride',
    'PolicyManagedRulesManagedRuleSetRuleGroupOverrideRule',
    'PolicyPolicySettings',
    'PolicyPolicySettingsLogScrubbing',
    'PolicyPolicySettingsLogScrubbingRule',
]

@pulumi.output_type
class PolicyCustomRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchConditions":
            suggest = "match_conditions"
        elif key == "ruleType":
            suggest = "rule_type"
        elif key == "groupRateLimitBy":
            suggest = "group_rate_limit_by"
        elif key == "rateLimitDuration":
            suggest = "rate_limit_duration"
        elif key == "rateLimitThreshold":
            suggest = "rate_limit_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyCustomRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyCustomRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyCustomRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: _builtins.str,
                 match_conditions: Sequence['outputs.PolicyCustomRuleMatchCondition'],
                 priority: _builtins.int,
                 rule_type: _builtins.str,
                 enabled: Optional[_builtins.bool] = None,
                 group_rate_limit_by: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 rate_limit_duration: Optional[_builtins.str] = None,
                 rate_limit_threshold: Optional[_builtins.int] = None):
        """
        :param _builtins.str action: Type of action. Possible values are `Allow`, `Block`, `JSChallenge` and `Log`.
               
               > **Note:** If the `rule_type` is specified as `RateLimitRule`, the `Allow` is not supported.
        :param Sequence['PolicyCustomRuleMatchConditionArgs'] match_conditions: One or more `match_conditions` blocks as defined below.
        :param _builtins.int priority: Describes priority of the rule. Rules with a lower value will be evaluated before rules with a higher value.
        :param _builtins.str rule_type: Describes the type of rule. Possible values are `MatchRule`, `RateLimitRule` and `Invalid`.
        :param _builtins.bool enabled: Describes if the policy is in enabled state or disabled state. Defaults to `true`.
        :param _builtins.str group_rate_limit_by: Specifies what grouping the rate limit will count requests by. Possible values are `GeoLocation`, `ClientAddr` and `None`.
        :param _builtins.str name: Gets name of the resource that is unique within a policy. This name can be used to access the resource.
        :param _builtins.str rate_limit_duration: Specifies the duration at which the rate limit policy will be applied. Should be used with `RateLimitRule` rule type. Possible values are `FiveMins` and `OneMin`.
        :param _builtins.int rate_limit_threshold: Specifies the threshold value for the rate limit policy. Must be greater than or equal to 1 if provided.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "match_conditions", match_conditions)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "rule_type", rule_type)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if group_rate_limit_by is not None:
            pulumi.set(__self__, "group_rate_limit_by", group_rate_limit_by)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rate_limit_duration is not None:
            pulumi.set(__self__, "rate_limit_duration", rate_limit_duration)
        if rate_limit_threshold is not None:
            pulumi.set(__self__, "rate_limit_threshold", rate_limit_threshold)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        Type of action. Possible values are `Allow`, `Block`, `JSChallenge` and `Log`.

        > **Note:** If the `rule_type` is specified as `RateLimitRule`, the `Allow` is not supported.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="matchConditions")
    def match_conditions(self) -> Sequence['outputs.PolicyCustomRuleMatchCondition']:
        """
        One or more `match_conditions` blocks as defined below.
        """
        return pulumi.get(self, "match_conditions")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        Describes priority of the rule. Rules with a lower value will be evaluated before rules with a higher value.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> _builtins.str:
        """
        Describes the type of rule. Possible values are `MatchRule`, `RateLimitRule` and `Invalid`.
        """
        return pulumi.get(self, "rule_type")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Describes if the policy is in enabled state or disabled state. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="groupRateLimitBy")
    def group_rate_limit_by(self) -> Optional[_builtins.str]:
        """
        Specifies what grouping the rate limit will count requests by. Possible values are `GeoLocation`, `ClientAddr` and `None`.
        """
        return pulumi.get(self, "group_rate_limit_by")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Gets name of the resource that is unique within a policy. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="rateLimitDuration")
    def rate_limit_duration(self) -> Optional[_builtins.str]:
        """
        Specifies the duration at which the rate limit policy will be applied. Should be used with `RateLimitRule` rule type. Possible values are `FiveMins` and `OneMin`.
        """
        return pulumi.get(self, "rate_limit_duration")

    @_builtins.property
    @pulumi.getter(name="rateLimitThreshold")
    def rate_limit_threshold(self) -> Optional[_builtins.int]:
        """
        Specifies the threshold value for the rate limit policy. Must be greater than or equal to 1 if provided.
        """
        return pulumi.get(self, "rate_limit_threshold")


@pulumi.output_type
class PolicyCustomRuleMatchCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchVariables":
            suggest = "match_variables"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negationCondition":
            suggest = "negation_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyCustomRuleMatchCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyCustomRuleMatchCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyCustomRuleMatchCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_variables: Sequence['outputs.PolicyCustomRuleMatchConditionMatchVariable'],
                 operator: _builtins.str,
                 match_values: Optional[Sequence[_builtins.str]] = None,
                 negation_condition: Optional[_builtins.bool] = None,
                 transforms: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence['PolicyCustomRuleMatchConditionMatchVariableArgs'] match_variables: One or more `match_variables` blocks as defined below.
        :param _builtins.str operator: Describes operator to be matched. Possible values are `Any`, `IPMatch`, `GeoMatch`, `Equal`, `Contains`, `LessThan`, `GreaterThan`, `LessThanOrEqual`, `GreaterThanOrEqual`, `BeginsWith`, `EndsWith` and `Regex`.
        :param Sequence[_builtins.str] match_values: A list of match values. This is **Required** when the `operator` is not `Any`.
        :param _builtins.bool negation_condition: Describes if this is negate condition or not
        :param Sequence[_builtins.str] transforms: A list of transformations to do before the match is attempted. Possible values are `HtmlEntityDecode`, `Lowercase`, `RemoveNulls`, `Trim`, `Uppercase`, `UrlDecode` and `UrlEncode`.
        """
        pulumi.set(__self__, "match_variables", match_variables)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negation_condition is not None:
            pulumi.set(__self__, "negation_condition", negation_condition)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @_builtins.property
    @pulumi.getter(name="matchVariables")
    def match_variables(self) -> Sequence['outputs.PolicyCustomRuleMatchConditionMatchVariable']:
        """
        One or more `match_variables` blocks as defined below.
        """
        return pulumi.get(self, "match_variables")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        Describes operator to be matched. Possible values are `Any`, `IPMatch`, `GeoMatch`, `Equal`, `Contains`, `LessThan`, `GreaterThan`, `LessThanOrEqual`, `GreaterThanOrEqual`, `BeginsWith`, `EndsWith` and `Regex`.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of match values. This is **Required** when the `operator` is not `Any`.
        """
        return pulumi.get(self, "match_values")

    @_builtins.property
    @pulumi.getter(name="negationCondition")
    def negation_condition(self) -> Optional[_builtins.bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negation_condition")

    @_builtins.property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of transformations to do before the match is attempted. Possible values are `HtmlEntityDecode`, `Lowercase`, `RemoveNulls`, `Trim`, `Uppercase`, `UrlDecode` and `UrlEncode`.
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class PolicyCustomRuleMatchConditionMatchVariable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "variableName":
            suggest = "variable_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyCustomRuleMatchConditionMatchVariable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyCustomRuleMatchConditionMatchVariable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyCustomRuleMatchConditionMatchVariable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 variable_name: _builtins.str,
                 selector: Optional[_builtins.str] = None):
        """
        :param _builtins.str variable_name: The name of the Match Variable. Possible values are `RemoteAddr`, `RequestMethod`, `QueryString`, `PostArgs`, `RequestUri`, `RequestHeaders`, `RequestBody` and `RequestCookies`.
        :param _builtins.str selector: Describes field of the matchVariable collection
        """
        pulumi.set(__self__, "variable_name", variable_name)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @_builtins.property
    @pulumi.getter(name="variableName")
    def variable_name(self) -> _builtins.str:
        """
        The name of the Match Variable. Possible values are `RemoteAddr`, `RequestMethod`, `QueryString`, `PostArgs`, `RequestUri`, `RequestHeaders`, `RequestBody` and `RequestCookies`.
        """
        return pulumi.get(self, "variable_name")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> Optional[_builtins.str]:
        """
        Describes field of the matchVariable collection
        """
        return pulumi.get(self, "selector")


@pulumi.output_type
class PolicyManagedRules(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "managedRuleSets":
            suggest = "managed_rule_sets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyManagedRules. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyManagedRules.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyManagedRules.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 managed_rule_sets: Sequence['outputs.PolicyManagedRulesManagedRuleSet'],
                 exclusions: Optional[Sequence['outputs.PolicyManagedRulesExclusion']] = None):
        """
        :param Sequence['PolicyManagedRulesManagedRuleSetArgs'] managed_rule_sets: One or more `managed_rule_set` block defined below.
        :param Sequence['PolicyManagedRulesExclusionArgs'] exclusions: One or more `exclusion` block defined below.
        """
        pulumi.set(__self__, "managed_rule_sets", managed_rule_sets)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)

    @_builtins.property
    @pulumi.getter(name="managedRuleSets")
    def managed_rule_sets(self) -> Sequence['outputs.PolicyManagedRulesManagedRuleSet']:
        """
        One or more `managed_rule_set` block defined below.
        """
        return pulumi.get(self, "managed_rule_sets")

    @_builtins.property
    @pulumi.getter
    def exclusions(self) -> Optional[Sequence['outputs.PolicyManagedRulesExclusion']]:
        """
        One or more `exclusion` block defined below.
        """
        return pulumi.get(self, "exclusions")


@pulumi.output_type
class PolicyManagedRulesExclusion(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchVariable":
            suggest = "match_variable"
        elif key == "selectorMatchOperator":
            suggest = "selector_match_operator"
        elif key == "excludedRuleSet":
            suggest = "excluded_rule_set"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyManagedRulesExclusion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyManagedRulesExclusion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyManagedRulesExclusion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_variable: _builtins.str,
                 selector: _builtins.str,
                 selector_match_operator: _builtins.str,
                 excluded_rule_set: Optional['outputs.PolicyManagedRulesExclusionExcludedRuleSet'] = None):
        """
        :param _builtins.str match_variable: The name of the Match Variable. Possible values: `RequestArgKeys`, `RequestArgNames`, `RequestArgValues`, `RequestCookieKeys`, `RequestCookieNames`, `RequestCookieValues`, `RequestHeaderKeys`, `RequestHeaderNames`, `RequestHeaderValues`.
        :param _builtins.str selector: Describes field of the matchVariable collection.
        :param _builtins.str selector_match_operator: Describes operator to be matched. Possible values: `Contains`, `EndsWith`, `Equals`, `EqualsAny`, `StartsWith`.
        :param 'PolicyManagedRulesExclusionExcludedRuleSetArgs' excluded_rule_set: One or more `excluded_rule_set` block defined below.
        """
        pulumi.set(__self__, "match_variable", match_variable)
        pulumi.set(__self__, "selector", selector)
        pulumi.set(__self__, "selector_match_operator", selector_match_operator)
        if excluded_rule_set is not None:
            pulumi.set(__self__, "excluded_rule_set", excluded_rule_set)

    @_builtins.property
    @pulumi.getter(name="matchVariable")
    def match_variable(self) -> _builtins.str:
        """
        The name of the Match Variable. Possible values: `RequestArgKeys`, `RequestArgNames`, `RequestArgValues`, `RequestCookieKeys`, `RequestCookieNames`, `RequestCookieValues`, `RequestHeaderKeys`, `RequestHeaderNames`, `RequestHeaderValues`.
        """
        return pulumi.get(self, "match_variable")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> _builtins.str:
        """
        Describes field of the matchVariable collection.
        """
        return pulumi.get(self, "selector")

    @_builtins.property
    @pulumi.getter(name="selectorMatchOperator")
    def selector_match_operator(self) -> _builtins.str:
        """
        Describes operator to be matched. Possible values: `Contains`, `EndsWith`, `Equals`, `EqualsAny`, `StartsWith`.
        """
        return pulumi.get(self, "selector_match_operator")

    @_builtins.property
    @pulumi.getter(name="excludedRuleSet")
    def excluded_rule_set(self) -> Optional['outputs.PolicyManagedRulesExclusionExcludedRuleSet']:
        """
        One or more `excluded_rule_set` block defined below.
        """
        return pulumi.get(self, "excluded_rule_set")


@pulumi.output_type
class PolicyManagedRulesExclusionExcludedRuleSet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleGroups":
            suggest = "rule_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyManagedRulesExclusionExcludedRuleSet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyManagedRulesExclusionExcludedRuleSet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyManagedRulesExclusionExcludedRuleSet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_groups: Optional[Sequence['outputs.PolicyManagedRulesExclusionExcludedRuleSetRuleGroup']] = None,
                 type: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param Sequence['PolicyManagedRulesExclusionExcludedRuleSetRuleGroupArgs'] rule_groups: One or more `rule_group` block defined below.
        :param _builtins.str type: The rule set type. Possible values are `Microsoft_DefaultRuleSet`, `Microsoft_BotManagerRuleSet` and `OWASP`. Defaults to `OWASP`.
        :param _builtins.str version: The rule set version. Possible values are `1.0`, `1.1` (for rule set type `Microsoft_BotManagerRuleSet`), `2.1` (for rule set type `Microsoft_DefaultRuleSet`) and `3.2` (for rule set type `OWASP`). Defaults to `3.2`.
        """
        if rule_groups is not None:
            pulumi.set(__self__, "rule_groups", rule_groups)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="ruleGroups")
    def rule_groups(self) -> Optional[Sequence['outputs.PolicyManagedRulesExclusionExcludedRuleSetRuleGroup']]:
        """
        One or more `rule_group` block defined below.
        """
        return pulumi.get(self, "rule_groups")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The rule set type. Possible values are `Microsoft_DefaultRuleSet`, `Microsoft_BotManagerRuleSet` and `OWASP`. Defaults to `OWASP`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The rule set version. Possible values are `1.0`, `1.1` (for rule set type `Microsoft_BotManagerRuleSet`), `2.1` (for rule set type `Microsoft_DefaultRuleSet`) and `3.2` (for rule set type `OWASP`). Defaults to `3.2`.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class PolicyManagedRulesExclusionExcludedRuleSetRuleGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleGroupName":
            suggest = "rule_group_name"
        elif key == "excludedRules":
            suggest = "excluded_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyManagedRulesExclusionExcludedRuleSetRuleGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyManagedRulesExclusionExcludedRuleSetRuleGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyManagedRulesExclusionExcludedRuleSetRuleGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_group_name: _builtins.str,
                 excluded_rules: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str rule_group_name: The name of rule group for exclusion. Possible values are `BadBots`, `crs_20_protocol_violations`, `crs_21_protocol_anomalies`, `crs_23_request_limits`, `crs_30_http_policy`, `crs_35_bad_robots`, `crs_40_generic_attacks`, `crs_41_sql_injection_attacks`, `crs_41_xss_attacks`, `crs_42_tight_security`, `crs_45_trojans`, `crs_49_inbound_blocking`, `General`, `GoodBots`, `KnownBadBots`, `Known-CVEs`, `REQUEST-911-METHOD-ENFORCEMENT`, `REQUEST-913-SCANNER-DETECTION`, `REQUEST-920-PROTOCOL-ENFORCEMENT`, `REQUEST-921-PROTOCOL-ATTACK`, `REQUEST-930-APPLICATION-ATTACK-LFI`, `REQUEST-931-APPLICATION-ATTACK-RFI`, `REQUEST-932-APPLICATION-ATTACK-RCE`, `REQUEST-933-APPLICATION-ATTACK-PHP`, `REQUEST-941-APPLICATION-ATTACK-XSS`, `REQUEST-942-APPLICATION-ATTACK-SQLI`, `REQUEST-943-APPLICATION-ATTACK-SESSION-FIXATION`, `REQUEST-944-APPLICATION-ATTACK-JAVA`, `UnknownBots`, `METHOD-ENFORCEMENT`, `PROTOCOL-ENFORCEMENT`, `PROTOCOL-ATTACK`, `LFI`, `RFI`, `RCE`, `PHP`, `NODEJS`, `XSS`, `SQLI`, `FIX`, `JAVA`, `MS-ThreatIntel-WebShells`, `MS-ThreatIntel-AppSec`, `MS-ThreatIntel-SQLI` and `MS-ThreatIntel-CVEs`.
               `MS-ThreatIntel-AppSec`, `MS-ThreatIntel-SQLI` and `MS-ThreatIntel-CVEs`.
        :param Sequence[_builtins.str] excluded_rules: One or more Rule IDs for exclusion.
        """
        pulumi.set(__self__, "rule_group_name", rule_group_name)
        if excluded_rules is not None:
            pulumi.set(__self__, "excluded_rules", excluded_rules)

    @_builtins.property
    @pulumi.getter(name="ruleGroupName")
    def rule_group_name(self) -> _builtins.str:
        """
        The name of rule group for exclusion. Possible values are `BadBots`, `crs_20_protocol_violations`, `crs_21_protocol_anomalies`, `crs_23_request_limits`, `crs_30_http_policy`, `crs_35_bad_robots`, `crs_40_generic_attacks`, `crs_41_sql_injection_attacks`, `crs_41_xss_attacks`, `crs_42_tight_security`, `crs_45_trojans`, `crs_49_inbound_blocking`, `General`, `GoodBots`, `KnownBadBots`, `Known-CVEs`, `REQUEST-911-METHOD-ENFORCEMENT`, `REQUEST-913-SCANNER-DETECTION`, `REQUEST-920-PROTOCOL-ENFORCEMENT`, `REQUEST-921-PROTOCOL-ATTACK`, `REQUEST-930-APPLICATION-ATTACK-LFI`, `REQUEST-931-APPLICATION-ATTACK-RFI`, `REQUEST-932-APPLICATION-ATTACK-RCE`, `REQUEST-933-APPLICATION-ATTACK-PHP`, `REQUEST-941-APPLICATION-ATTACK-XSS`, `REQUEST-942-APPLICATION-ATTACK-SQLI`, `REQUEST-943-APPLICATION-ATTACK-SESSION-FIXATION`, `REQUEST-944-APPLICATION-ATTACK-JAVA`, `UnknownBots`, `METHOD-ENFORCEMENT`, `PROTOCOL-ENFORCEMENT`, `PROTOCOL-ATTACK`, `LFI`, `RFI`, `RCE`, `PHP`, `NODEJS`, `XSS`, `SQLI`, `FIX`, `JAVA`, `MS-ThreatIntel-WebShells`, `MS-ThreatIntel-AppSec`, `MS-ThreatIntel-SQLI` and `MS-ThreatIntel-CVEs`.
        `MS-ThreatIntel-AppSec`, `MS-ThreatIntel-SQLI` and `MS-ThreatIntel-CVEs`.
        """
        return pulumi.get(self, "rule_group_name")

    @_builtins.property
    @pulumi.getter(name="excludedRules")
    def excluded_rules(self) -> Optional[Sequence[_builtins.str]]:
        """
        One or more Rule IDs for exclusion.
        """
        return pulumi.get(self, "excluded_rules")


@pulumi.output_type
class PolicyManagedRulesManagedRuleSet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleGroupOverrides":
            suggest = "rule_group_overrides"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyManagedRulesManagedRuleSet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyManagedRulesManagedRuleSet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyManagedRulesManagedRuleSet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 version: _builtins.str,
                 rule_group_overrides: Optional[Sequence['outputs.PolicyManagedRulesManagedRuleSetRuleGroupOverride']] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str version: The rule set version. Possible values: `0.1`, `1.0`, `1.1`, `2.1`, `2.2.9`, `3.0`, `3.1` and `3.2`.
        :param Sequence['PolicyManagedRulesManagedRuleSetRuleGroupOverrideArgs'] rule_group_overrides: One or more `rule_group_override` block defined below.
        :param _builtins.str type: The rule set type. Possible values: `Microsoft_BotManagerRuleSet`, `Microsoft_DefaultRuleSet` and `OWASP`. Defaults to `OWASP`.
        """
        pulumi.set(__self__, "version", version)
        if rule_group_overrides is not None:
            pulumi.set(__self__, "rule_group_overrides", rule_group_overrides)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The rule set version. Possible values: `0.1`, `1.0`, `1.1`, `2.1`, `2.2.9`, `3.0`, `3.1` and `3.2`.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="ruleGroupOverrides")
    def rule_group_overrides(self) -> Optional[Sequence['outputs.PolicyManagedRulesManagedRuleSetRuleGroupOverride']]:
        """
        One or more `rule_group_override` block defined below.
        """
        return pulumi.get(self, "rule_group_overrides")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The rule set type. Possible values: `Microsoft_BotManagerRuleSet`, `Microsoft_DefaultRuleSet` and `OWASP`. Defaults to `OWASP`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PolicyManagedRulesManagedRuleSetRuleGroupOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleGroupName":
            suggest = "rule_group_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyManagedRulesManagedRuleSetRuleGroupOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyManagedRulesManagedRuleSetRuleGroupOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyManagedRulesManagedRuleSetRuleGroupOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_group_name: _builtins.str,
                 rules: Optional[Sequence['outputs.PolicyManagedRulesManagedRuleSetRuleGroupOverrideRule']] = None):
        """
        :param _builtins.str rule_group_name: The name of the Rule Group. Possible values are `BadBots`, `crs_20_protocol_violations`, `crs_21_protocol_anomalies`, `crs_23_request_limits`, `crs_30_http_policy`, `crs_35_bad_robots`, `crs_40_generic_attacks`, `crs_41_sql_injection_attacks`, `crs_41_xss_attacks`, `crs_42_tight_security`, `crs_45_trojans`, `crs_49_inbound_blocking`, `General`, `GoodBots`, `KnownBadBots`, `Known-CVEs`, `REQUEST-911-METHOD-ENFORCEMENT`, `REQUEST-913-SCANNER-DETECTION`, `REQUEST-920-PROTOCOL-ENFORCEMENT`, `REQUEST-921-PROTOCOL-ATTACK`, `REQUEST-930-APPLICATION-ATTACK-LFI`, `REQUEST-931-APPLICATION-ATTACK-RFI`, `REQUEST-932-APPLICATION-ATTACK-RCE`, `REQUEST-933-APPLICATION-ATTACK-PHP`, `REQUEST-941-APPLICATION-ATTACK-XSS`, `REQUEST-942-APPLICATION-ATTACK-SQLI`, `REQUEST-943-APPLICATION-ATTACK-SESSION-FIXATION`, `REQUEST-944-APPLICATION-ATTACK-JAVA`, `UnknownBots`, `METHOD-ENFORCEMENT`, `PROTOCOL-ENFORCEMENT`, `PROTOCOL-ATTACK`, `LFI`, `RFI`, `RCE`, `PHP`, `NODEJS`, `XSS`, `SQLI`, `FIX`, `JAVA`, `MS-ThreatIntel-WebShells`, `MS-ThreatIntel-AppSec`, `MS-ThreatIntel-SQLI` and `MS-ThreatIntel-CVEs`MS-ThreatIntel-WebShells`,.
        :param Sequence['PolicyManagedRulesManagedRuleSetRuleGroupOverrideRuleArgs'] rules: One or more `rule` block defined below.
        """
        pulumi.set(__self__, "rule_group_name", rule_group_name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter(name="ruleGroupName")
    def rule_group_name(self) -> _builtins.str:
        """
        The name of the Rule Group. Possible values are `BadBots`, `crs_20_protocol_violations`, `crs_21_protocol_anomalies`, `crs_23_request_limits`, `crs_30_http_policy`, `crs_35_bad_robots`, `crs_40_generic_attacks`, `crs_41_sql_injection_attacks`, `crs_41_xss_attacks`, `crs_42_tight_security`, `crs_45_trojans`, `crs_49_inbound_blocking`, `General`, `GoodBots`, `KnownBadBots`, `Known-CVEs`, `REQUEST-911-METHOD-ENFORCEMENT`, `REQUEST-913-SCANNER-DETECTION`, `REQUEST-920-PROTOCOL-ENFORCEMENT`, `REQUEST-921-PROTOCOL-ATTACK`, `REQUEST-930-APPLICATION-ATTACK-LFI`, `REQUEST-931-APPLICATION-ATTACK-RFI`, `REQUEST-932-APPLICATION-ATTACK-RCE`, `REQUEST-933-APPLICATION-ATTACK-PHP`, `REQUEST-941-APPLICATION-ATTACK-XSS`, `REQUEST-942-APPLICATION-ATTACK-SQLI`, `REQUEST-943-APPLICATION-ATTACK-SESSION-FIXATION`, `REQUEST-944-APPLICATION-ATTACK-JAVA`, `UnknownBots`, `METHOD-ENFORCEMENT`, `PROTOCOL-ENFORCEMENT`, `PROTOCOL-ATTACK`, `LFI`, `RFI`, `RCE`, `PHP`, `NODEJS`, `XSS`, `SQLI`, `FIX`, `JAVA`, `MS-ThreatIntel-WebShells`, `MS-ThreatIntel-AppSec`, `MS-ThreatIntel-SQLI` and `MS-ThreatIntel-CVEs`MS-ThreatIntel-WebShells`,.
        """
        return pulumi.get(self, "rule_group_name")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.PolicyManagedRulesManagedRuleSetRuleGroupOverrideRule']]:
        """
        One or more `rule` block defined below.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class PolicyManagedRulesManagedRuleSetRuleGroupOverrideRule(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 action: Optional[_builtins.str] = None,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str id: Identifier for the managed rule.
        :param _builtins.str action: Describes the override action to be applied when rule matches. Possible values are `Allow`, `AnomalyScoring`, `Block`, `JSChallenge` and `Log`. `JSChallenge` is only valid for rulesets of type `Microsoft_BotManagerRuleSet`.
        :param _builtins.bool enabled: Describes if the managed rule is in enabled state or disabled state. Defaults to `false`.
        """
        pulumi.set(__self__, "id", id)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Identifier for the managed rule.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        """
        Describes the override action to be applied when rule matches. Possible values are `Allow`, `AnomalyScoring`, `Block`, `JSChallenge` and `Log`. `JSChallenge` is only valid for rulesets of type `Microsoft_BotManagerRuleSet`.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Describes if the managed rule is in enabled state or disabled state. Defaults to `false`.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class PolicyPolicySettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileUploadEnforcement":
            suggest = "file_upload_enforcement"
        elif key == "fileUploadLimitInMb":
            suggest = "file_upload_limit_in_mb"
        elif key == "jsChallengeCookieExpirationInMinutes":
            suggest = "js_challenge_cookie_expiration_in_minutes"
        elif key == "logScrubbing":
            suggest = "log_scrubbing"
        elif key == "maxRequestBodySizeInKb":
            suggest = "max_request_body_size_in_kb"
        elif key == "requestBodyCheck":
            suggest = "request_body_check"
        elif key == "requestBodyEnforcement":
            suggest = "request_body_enforcement"
        elif key == "requestBodyInspectLimitInKb":
            suggest = "request_body_inspect_limit_in_kb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyPolicySettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyPolicySettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyPolicySettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 file_upload_enforcement: Optional[_builtins.bool] = None,
                 file_upload_limit_in_mb: Optional[_builtins.int] = None,
                 js_challenge_cookie_expiration_in_minutes: Optional[_builtins.int] = None,
                 log_scrubbing: Optional['outputs.PolicyPolicySettingsLogScrubbing'] = None,
                 max_request_body_size_in_kb: Optional[_builtins.int] = None,
                 mode: Optional[_builtins.str] = None,
                 request_body_check: Optional[_builtins.bool] = None,
                 request_body_enforcement: Optional[_builtins.bool] = None,
                 request_body_inspect_limit_in_kb: Optional[_builtins.int] = None):
        """
        :param _builtins.bool enabled: Describes if the policy is in enabled state or disabled state. Defaults to `true`.
        :param _builtins.bool file_upload_enforcement: Whether the firewall should block a request with upload size greater then `file_upload_limit_in_mb`.
        :param _builtins.int file_upload_limit_in_mb: The File Upload Limit in MB. Accepted values are in the range `1` to `4000`. Defaults to `100`.
        :param _builtins.int js_challenge_cookie_expiration_in_minutes: Specifies the JavaScript challenge cookie validity lifetime in minutes. The user is challenged after the lifetime expires. Accepted values are in the range `5` to `1440`. Defaults to `30`.
        :param 'PolicyPolicySettingsLogScrubbingArgs' log_scrubbing: One `log_scrubbing` block as defined below.
        :param _builtins.int max_request_body_size_in_kb: The Maximum Request Body Size in KB. Accepted values are in the range `8` to `2000`. Defaults to `128`.
        :param _builtins.str mode: Describes if it is in detection mode or prevention mode at the policy level. Valid values are `Detection` and `Prevention`. Defaults to `Prevention`.
        :param _builtins.bool request_body_check: Is Request Body Inspection enabled? Defaults to `true`.
        :param _builtins.bool request_body_enforcement: Whether the firewall should block a request with body size greater then `max_request_body_size_in_kb`. Defaults to `true`.
        :param _builtins.int request_body_inspect_limit_in_kb: Specifies the maximum request body inspection limit in KB for the Web Application Firewall. Defaults to `128`.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if file_upload_enforcement is not None:
            pulumi.set(__self__, "file_upload_enforcement", file_upload_enforcement)
        if file_upload_limit_in_mb is not None:
            pulumi.set(__self__, "file_upload_limit_in_mb", file_upload_limit_in_mb)
        if js_challenge_cookie_expiration_in_minutes is not None:
            pulumi.set(__self__, "js_challenge_cookie_expiration_in_minutes", js_challenge_cookie_expiration_in_minutes)
        if log_scrubbing is not None:
            pulumi.set(__self__, "log_scrubbing", log_scrubbing)
        if max_request_body_size_in_kb is not None:
            pulumi.set(__self__, "max_request_body_size_in_kb", max_request_body_size_in_kb)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if request_body_check is not None:
            pulumi.set(__self__, "request_body_check", request_body_check)
        if request_body_enforcement is not None:
            pulumi.set(__self__, "request_body_enforcement", request_body_enforcement)
        if request_body_inspect_limit_in_kb is not None:
            pulumi.set(__self__, "request_body_inspect_limit_in_kb", request_body_inspect_limit_in_kb)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Describes if the policy is in enabled state or disabled state. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="fileUploadEnforcement")
    def file_upload_enforcement(self) -> Optional[_builtins.bool]:
        """
        Whether the firewall should block a request with upload size greater then `file_upload_limit_in_mb`.
        """
        return pulumi.get(self, "file_upload_enforcement")

    @_builtins.property
    @pulumi.getter(name="fileUploadLimitInMb")
    def file_upload_limit_in_mb(self) -> Optional[_builtins.int]:
        """
        The File Upload Limit in MB. Accepted values are in the range `1` to `4000`. Defaults to `100`.
        """
        return pulumi.get(self, "file_upload_limit_in_mb")

    @_builtins.property
    @pulumi.getter(name="jsChallengeCookieExpirationInMinutes")
    def js_challenge_cookie_expiration_in_minutes(self) -> Optional[_builtins.int]:
        """
        Specifies the JavaScript challenge cookie validity lifetime in minutes. The user is challenged after the lifetime expires. Accepted values are in the range `5` to `1440`. Defaults to `30`.
        """
        return pulumi.get(self, "js_challenge_cookie_expiration_in_minutes")

    @_builtins.property
    @pulumi.getter(name="logScrubbing")
    def log_scrubbing(self) -> Optional['outputs.PolicyPolicySettingsLogScrubbing']:
        """
        One `log_scrubbing` block as defined below.
        """
        return pulumi.get(self, "log_scrubbing")

    @_builtins.property
    @pulumi.getter(name="maxRequestBodySizeInKb")
    def max_request_body_size_in_kb(self) -> Optional[_builtins.int]:
        """
        The Maximum Request Body Size in KB. Accepted values are in the range `8` to `2000`. Defaults to `128`.
        """
        return pulumi.get(self, "max_request_body_size_in_kb")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.str]:
        """
        Describes if it is in detection mode or prevention mode at the policy level. Valid values are `Detection` and `Prevention`. Defaults to `Prevention`.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="requestBodyCheck")
    def request_body_check(self) -> Optional[_builtins.bool]:
        """
        Is Request Body Inspection enabled? Defaults to `true`.
        """
        return pulumi.get(self, "request_body_check")

    @_builtins.property
    @pulumi.getter(name="requestBodyEnforcement")
    def request_body_enforcement(self) -> Optional[_builtins.bool]:
        """
        Whether the firewall should block a request with body size greater then `max_request_body_size_in_kb`. Defaults to `true`.
        """
        return pulumi.get(self, "request_body_enforcement")

    @_builtins.property
    @pulumi.getter(name="requestBodyInspectLimitInKb")
    def request_body_inspect_limit_in_kb(self) -> Optional[_builtins.int]:
        """
        Specifies the maximum request body inspection limit in KB for the Web Application Firewall. Defaults to `128`.
        """
        return pulumi.get(self, "request_body_inspect_limit_in_kb")


@pulumi.output_type
class PolicyPolicySettingsLogScrubbing(dict):
    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 rules: Optional[Sequence['outputs.PolicyPolicySettingsLogScrubbingRule']] = None):
        """
        :param _builtins.bool enabled: Whether the log scrubbing is enabled or disabled. Defaults to `true`.
        :param Sequence['PolicyPolicySettingsLogScrubbingRuleArgs'] rules: One or more `scrubbing_rule` blocks as define below.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Whether the log scrubbing is enabled or disabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.PolicyPolicySettingsLogScrubbingRule']]:
        """
        One or more `scrubbing_rule` blocks as define below.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class PolicyPolicySettingsLogScrubbingRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchVariable":
            suggest = "match_variable"
        elif key == "selectorMatchOperator":
            suggest = "selector_match_operator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyPolicySettingsLogScrubbingRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyPolicySettingsLogScrubbingRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyPolicySettingsLogScrubbingRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_variable: _builtins.str,
                 enabled: Optional[_builtins.bool] = None,
                 selector: Optional[_builtins.str] = None,
                 selector_match_operator: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Describes if the managed rule is in enabled state or disabled state. Defaults to `false`.
        :param _builtins.str selector: When matchVariable is a collection, operator used to specify which elements in the collection this rule applies to.
        """
        pulumi.set(__self__, "match_variable", match_variable)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if selector_match_operator is not None:
            pulumi.set(__self__, "selector_match_operator", selector_match_operator)

    @_builtins.property
    @pulumi.getter(name="matchVariable")
    def match_variable(self) -> _builtins.str:
        return pulumi.get(self, "match_variable")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Describes if the managed rule is in enabled state or disabled state. Defaults to `false`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> Optional[_builtins.str]:
        """
        When matchVariable is a collection, operator used to specify which elements in the collection this rule applies to.
        """
        return pulumi.get(self, "selector")

    @_builtins.property
    @pulumi.getter(name="selectorMatchOperator")
    def selector_match_operator(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "selector_match_operator")


