import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApplicationLoadbalancerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer#datacenter_id ApplicationLoadbalancer#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer#id ApplicationLoadbalancer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Collection of the Application Load Balancer IP addresses. (Inbound and outbound) IPs of the listenerLan are customer-reserved public IPs for the public Load Balancers, and private IPs for the private Load Balancers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer#ips ApplicationLoadbalancer#ips}
    */
    readonly ips?: string[];
    /**
    * Collection of private IP addresses with the subnet mask of the Application Load Balancer. IPs must contain valid a subnet mask. If no IP is provided, the system will generate an IP with /24 subnet.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer#lb_private_ips ApplicationLoadbalancer#lb_private_ips}
    */
    readonly lbPrivateIps?: string[];
    /**
    * ID of the listening (inbound) LAN.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer#listener_lan ApplicationLoadbalancer#listener_lan}
    */
    readonly listenerLan: number;
    /**
    * The name of the Application Load Balancer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer#name ApplicationLoadbalancer#name}
    */
    readonly name: string;
    /**
    * ID of the balanced private target LAN (outbound).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer#target_lan ApplicationLoadbalancer#target_lan}
    */
    readonly targetLan: number;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer#timeouts ApplicationLoadbalancer#timeouts}
    */
    readonly timeouts?: ApplicationLoadbalancerTimeouts;
}
export interface ApplicationLoadbalancerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer#create ApplicationLoadbalancer#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer#default ApplicationLoadbalancer#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer#delete ApplicationLoadbalancer#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer#update ApplicationLoadbalancer#update}
    */
    readonly update?: string;
}
export declare function applicationLoadbalancerTimeoutsToTerraform(struct?: ApplicationLoadbalancerTimeoutsOutputReference | ApplicationLoadbalancerTimeouts | cdktf.IResolvable): any;
export declare class ApplicationLoadbalancerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationLoadbalancerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationLoadbalancerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer ionoscloud_application_loadbalancer}
*/
export declare class ApplicationLoadbalancer extends cdktf.TerraformResource {
    static readonly tfResourceType = "ionoscloud_application_loadbalancer";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer ionoscloud_application_loadbalancer} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApplicationLoadbalancerConfig
    */
    constructor(scope: Construct, id: string, config: ApplicationLoadbalancerConfig);
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ips?;
    get ips(): string[];
    set ips(value: string[]);
    resetIps(): void;
    get ipsInput(): string[] | undefined;
    private _lbPrivateIps?;
    get lbPrivateIps(): string[];
    set lbPrivateIps(value: string[]);
    resetLbPrivateIps(): void;
    get lbPrivateIpsInput(): string[] | undefined;
    private _listenerLan?;
    get listenerLan(): number;
    set listenerLan(value: number);
    get listenerLanInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _targetLan?;
    get targetLan(): number;
    set targetLan(value: number);
    get targetLanInput(): number | undefined;
    private _timeouts;
    get timeouts(): ApplicationLoadbalancerTimeoutsOutputReference;
    putTimeouts(value: ApplicationLoadbalancerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApplicationLoadbalancerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
