import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudApplicationLoadbalancerForwardingruleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/application_loadbalancer_forwardingrule#application_loadbalancer_id DataIonoscloudApplicationLoadbalancerForwardingrule#application_loadbalancer_id}
    */
    readonly applicationLoadbalancerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/application_loadbalancer_forwardingrule#datacenter_id DataIonoscloudApplicationLoadbalancerForwardingrule#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/application_loadbalancer_forwardingrule#id DataIonoscloudApplicationLoadbalancerForwardingrule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the Application Load Balancer forwarding rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/application_loadbalancer_forwardingrule#name DataIonoscloudApplicationLoadbalancerForwardingrule#name}
    */
    readonly name?: string;
    /**
    * Whether partial matching is allowed or not when using name argument.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/application_loadbalancer_forwardingrule#partial_match DataIonoscloudApplicationLoadbalancerForwardingrule#partial_match}
    */
    readonly partialMatch?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/application_loadbalancer_forwardingrule#timeouts DataIonoscloudApplicationLoadbalancerForwardingrule#timeouts}
    */
    readonly timeouts?: DataIonoscloudApplicationLoadbalancerForwardingruleTimeouts;
}
export interface DataIonoscloudApplicationLoadbalancerForwardingruleHttpRulesConditions {
}
export declare function dataIonoscloudApplicationLoadbalancerForwardingruleHttpRulesConditionsToTerraform(struct?: DataIonoscloudApplicationLoadbalancerForwardingruleHttpRulesConditions): any;
export declare class DataIonoscloudApplicationLoadbalancerForwardingruleHttpRulesConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudApplicationLoadbalancerForwardingruleHttpRulesConditions | undefined;
    set internalValue(value: DataIonoscloudApplicationLoadbalancerForwardingruleHttpRulesConditions | undefined);
    get condition(): string;
    get key(): string;
    get negate(): cdktf.IResolvable;
    get type(): string;
    get value(): string;
}
export declare class DataIonoscloudApplicationLoadbalancerForwardingruleHttpRulesConditionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudApplicationLoadbalancerForwardingruleHttpRulesConditionsOutputReference;
}
export interface DataIonoscloudApplicationLoadbalancerForwardingruleHttpRules {
}
export declare function dataIonoscloudApplicationLoadbalancerForwardingruleHttpRulesToTerraform(struct?: DataIonoscloudApplicationLoadbalancerForwardingruleHttpRules): any;
export declare class DataIonoscloudApplicationLoadbalancerForwardingruleHttpRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudApplicationLoadbalancerForwardingruleHttpRules | undefined;
    set internalValue(value: DataIonoscloudApplicationLoadbalancerForwardingruleHttpRules | undefined);
    private _conditions;
    get conditions(): DataIonoscloudApplicationLoadbalancerForwardingruleHttpRulesConditionsList;
    get contentType(): string;
    get dropQuery(): cdktf.IResolvable;
    get location(): string;
    get name(): string;
    get responseMessage(): string;
    get statusCode(): number;
    get targetGroup(): string;
    get type(): string;
}
export declare class DataIonoscloudApplicationLoadbalancerForwardingruleHttpRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudApplicationLoadbalancerForwardingruleHttpRulesOutputReference;
}
export interface DataIonoscloudApplicationLoadbalancerForwardingruleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/application_loadbalancer_forwardingrule#create DataIonoscloudApplicationLoadbalancerForwardingrule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/application_loadbalancer_forwardingrule#default DataIonoscloudApplicationLoadbalancerForwardingrule#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/application_loadbalancer_forwardingrule#delete DataIonoscloudApplicationLoadbalancerForwardingrule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/application_loadbalancer_forwardingrule#update DataIonoscloudApplicationLoadbalancerForwardingrule#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudApplicationLoadbalancerForwardingruleTimeoutsToTerraform(struct?: DataIonoscloudApplicationLoadbalancerForwardingruleTimeoutsOutputReference | DataIonoscloudApplicationLoadbalancerForwardingruleTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudApplicationLoadbalancerForwardingruleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudApplicationLoadbalancerForwardingruleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudApplicationLoadbalancerForwardingruleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/application_loadbalancer_forwardingrule ionoscloud_application_loadbalancer_forwardingrule}
*/
export declare class DataIonoscloudApplicationLoadbalancerForwardingrule extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_application_loadbalancer_forwardingrule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/application_loadbalancer_forwardingrule ionoscloud_application_loadbalancer_forwardingrule} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudApplicationLoadbalancerForwardingruleConfig
    */
    constructor(scope: Construct, id: string, config: DataIonoscloudApplicationLoadbalancerForwardingruleConfig);
    private _applicationLoadbalancerId?;
    get applicationLoadbalancerId(): string;
    set applicationLoadbalancerId(value: string);
    get applicationLoadbalancerIdInput(): string | undefined;
    get clientTimeout(): number;
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    private _httpRules;
    get httpRules(): DataIonoscloudApplicationLoadbalancerForwardingruleHttpRulesList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get listenerIp(): string;
    get listenerPort(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _partialMatch?;
    get partialMatch(): boolean | cdktf.IResolvable;
    set partialMatch(value: boolean | cdktf.IResolvable);
    resetPartialMatch(): void;
    get partialMatchInput(): boolean | cdktf.IResolvable | undefined;
    get protocol(): string;
    get serverCertificates(): string[];
    private _timeouts;
    get timeouts(): DataIonoscloudApplicationLoadbalancerForwardingruleTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudApplicationLoadbalancerForwardingruleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataIonoscloudApplicationLoadbalancerForwardingruleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
