import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TargetGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Balancing algorithm.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group#algorithm TargetGroup#algorithm}
    */
    readonly algorithm: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group#id TargetGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the target group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group#name TargetGroup#name}
    */
    readonly name: string;
    /**
    * Balancing protocol.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group#protocol TargetGroup#protocol}
    */
    readonly protocol: string;
    /**
    * health_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group#health_check TargetGroup#health_check}
    */
    readonly healthCheck?: TargetGroupHealthCheck;
    /**
    * http_health_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group#http_health_check TargetGroup#http_health_check}
    */
    readonly httpHealthCheck?: TargetGroupHttpHealthCheck;
    /**
    * targets block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group#targets TargetGroup#targets}
    */
    readonly targets: TargetGroupTargets[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group#timeouts TargetGroup#timeouts}
    */
    readonly timeouts?: TargetGroupTimeouts;
}
export interface TargetGroupHealthCheck {
    /**
    * The interval in milliseconds between consecutive health checks; default is 2000.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group#check_interval TargetGroup#check_interval}
    */
    readonly checkInterval?: number;
    /**
    * The maximum time in milliseconds to wait for a target to respond to a check. For target VMs with 'Check Interval' set, the lesser of the two  values is used once the TCP connection is established.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group#check_timeout TargetGroup#check_timeout}
    */
    readonly checkTimeout?: number;
    /**
    * The maximum number of attempts to reconnect to a target after a connection failure. Valid range is 0 to 65535, and default is three reconnection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group#retries TargetGroup#retries}
    */
    readonly retries?: number;
}
export declare function targetGroupHealthCheckToTerraform(struct?: TargetGroupHealthCheckOutputReference | TargetGroupHealthCheck): any;
export declare class TargetGroupHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): TargetGroupHealthCheck | undefined;
    set internalValue(value: TargetGroupHealthCheck | undefined);
    private _checkInterval?;
    get checkInterval(): number;
    set checkInterval(value: number);
    resetCheckInterval(): void;
    get checkIntervalInput(): number | undefined;
    private _checkTimeout?;
    get checkTimeout(): number;
    set checkTimeout(value: number);
    resetCheckTimeout(): void;
    get checkTimeoutInput(): number | undefined;
    private _retries?;
    get retries(): number;
    set retries(value: number);
    resetRetries(): void;
    get retriesInput(): number | undefined;
}
export interface TargetGroupHttpHealthCheck {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group#match_type TargetGroup#match_type}
    */
    readonly matchType: string;
    /**
    * The method for the HTTP health check.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group#method TargetGroup#method}
    */
    readonly method?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group#negate TargetGroup#negate}
    */
    readonly negate?: boolean | cdktf.IResolvable;
    /**
    * The path (destination URL) for the HTTP health check request; the default is /.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group#path TargetGroup#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group#regex TargetGroup#regex}
    */
    readonly regex?: boolean | cdktf.IResolvable;
    /**
    * The response returned by the request, depending on the match type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group#response TargetGroup#response}
    */
    readonly response: string;
}
export declare function targetGroupHttpHealthCheckToTerraform(struct?: TargetGroupHttpHealthCheckOutputReference | TargetGroupHttpHealthCheck): any;
export declare class TargetGroupHttpHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): TargetGroupHttpHealthCheck | undefined;
    set internalValue(value: TargetGroupHttpHealthCheck | undefined);
    private _matchType?;
    get matchType(): string;
    set matchType(value: string);
    get matchTypeInput(): string | undefined;
    private _method?;
    get method(): string;
    set method(value: string);
    resetMethod(): void;
    get methodInput(): string | undefined;
    private _negate?;
    get negate(): boolean | cdktf.IResolvable;
    set negate(value: boolean | cdktf.IResolvable);
    resetNegate(): void;
    get negateInput(): boolean | cdktf.IResolvable | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _regex?;
    get regex(): boolean | cdktf.IResolvable;
    set regex(value: boolean | cdktf.IResolvable);
    resetRegex(): void;
    get regexInput(): boolean | cdktf.IResolvable | undefined;
    private _response?;
    get response(): string;
    set response(value: string);
    get responseInput(): string | undefined;
}
export interface TargetGroupTargets {
    /**
    * Makes the target available only if it accepts periodic health check TCP connection attempts; when turned off, the target is considered always available. The health check only consists of a connection attempt to the address and port of the target. Default is True.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group#health_check_enabled TargetGroup#health_check_enabled}
    */
    readonly healthCheckEnabled?: boolean | cdktf.IResolvable;
    /**
    * The IP of the balanced target VM.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group#ip TargetGroup#ip}
    */
    readonly ip: string;
    /**
    * Maintenance mode prevents the target from receiving balanced traffic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group#maintenance_enabled TargetGroup#maintenance_enabled}
    */
    readonly maintenanceEnabled?: boolean | cdktf.IResolvable;
    /**
    * The port of the balanced target service; valid range is 1 to 65535.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group#port TargetGroup#port}
    */
    readonly port: number;
    /**
    * Traffic is distributed in proportion to target weight, relative to the combined weight of all targets. A target with higher weight receives a greater share of traffic. Valid range is 0 to 256 and default is 1; targets with weight of 0 do not participate in load balancing but still accept persistent connections. It is best use values in the middle of the range to leave room for later adjustments.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group#weight TargetGroup#weight}
    */
    readonly weight: number;
}
export declare function targetGroupTargetsToTerraform(struct?: TargetGroupTargets | cdktf.IResolvable): any;
export declare class TargetGroupTargetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TargetGroupTargets | cdktf.IResolvable | undefined;
    set internalValue(value: TargetGroupTargets | cdktf.IResolvable | undefined);
    private _healthCheckEnabled?;
    get healthCheckEnabled(): boolean | cdktf.IResolvable;
    set healthCheckEnabled(value: boolean | cdktf.IResolvable);
    resetHealthCheckEnabled(): void;
    get healthCheckEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ip?;
    get ip(): string;
    set ip(value: string);
    get ipInput(): string | undefined;
    private _maintenanceEnabled?;
    get maintenanceEnabled(): boolean | cdktf.IResolvable;
    set maintenanceEnabled(value: boolean | cdktf.IResolvable);
    resetMaintenanceEnabled(): void;
    get maintenanceEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
}
export declare class TargetGroupTargetsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: TargetGroupTargets[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TargetGroupTargetsOutputReference;
}
export interface TargetGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group#create TargetGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group#default TargetGroup#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group#delete TargetGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group#update TargetGroup#update}
    */
    readonly update?: string;
}
export declare function targetGroupTimeoutsToTerraform(struct?: TargetGroupTimeoutsOutputReference | TargetGroupTimeouts | cdktf.IResolvable): any;
export declare class TargetGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): TargetGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: TargetGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group ionoscloud_target_group}
*/
export declare class TargetGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "ionoscloud_target_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/r/target_group ionoscloud_target_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TargetGroupConfig
    */
    constructor(scope: Construct, id: string, config: TargetGroupConfig);
    private _algorithm?;
    get algorithm(): string;
    set algorithm(value: string);
    get algorithmInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _healthCheck;
    get healthCheck(): TargetGroupHealthCheckOutputReference;
    putHealthCheck(value: TargetGroupHealthCheck): void;
    resetHealthCheck(): void;
    get healthCheckInput(): TargetGroupHealthCheck | undefined;
    private _httpHealthCheck;
    get httpHealthCheck(): TargetGroupHttpHealthCheckOutputReference;
    putHttpHealthCheck(value: TargetGroupHttpHealthCheck): void;
    resetHttpHealthCheck(): void;
    get httpHealthCheckInput(): TargetGroupHttpHealthCheck | undefined;
    private _targets;
    get targets(): TargetGroupTargetsList;
    putTargets(value: TargetGroupTargets[] | cdktf.IResolvable): void;
    get targetsInput(): cdktf.IResolvable | TargetGroupTargets[] | undefined;
    private _timeouts;
    get timeouts(): TargetGroupTimeoutsOutputReference;
    putTimeouts(value: TargetGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | TargetGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
