# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.apm_traces.src.oci_cli_apm_traces.generated import apm_traces_service_cli


@click.command(cli_util.override('attributes.attributes_root_group.command_name', 'attributes'), cls=CommandGroupWithAlias, help=cli_util.override('attributes.attributes_root_group.help', """Use the Application Performance Monitoring Trace Explorer API to query traces and associated spans in Trace Explorer. For more information, see [Application Performance Monitoring]."""), short_help=cli_util.override('attributes.attributes_root_group.short_help', """Application Performance Monitoring Trace Explorer API"""))
@cli_util.help_option_group
def attributes_root_group():
    pass


@click.command(cli_util.override('attributes.auto_activate_status_group.command_name', 'auto-activate-status'), cls=CommandGroupWithAlias, help="""Status of autoactivation for the given data key in the APM Domain.""")
@cli_util.help_option_group
def auto_activate_status_group():
    pass


@click.command(cli_util.override('attributes.auto_activate_toggle_status_group.command_name', 'auto-activate-toggle-status'), cls=CommandGroupWithAlias, help="""Response of a auto-activate toggle operation.""")
@cli_util.help_option_group
def auto_activate_toggle_status_group():
    pass


@click.command(cli_util.override('attributes.bulk_update_attribute_status_group.command_name', 'bulk-update-attribute-status'), cls=CommandGroupWithAlias, help="""Response of a bulk update attribute operation.""")
@cli_util.help_option_group
def bulk_update_attribute_status_group():
    pass


@click.command(cli_util.override('attributes.bulk_pin_status_group.command_name', 'bulk-pin-status'), cls=CommandGroupWithAlias, help="""Response of a bulk attribute pin operation.""")
@cli_util.help_option_group
def bulk_pin_status_group():
    pass


@click.command(cli_util.override('attributes.bulk_update_notes_status_group.command_name', 'bulk-update-notes-status'), cls=CommandGroupWithAlias, help="""Response of a bulk update notes operation.""")
@cli_util.help_option_group
def bulk_update_notes_status_group():
    pass


@click.command(cli_util.override('attributes.bulk_activation_status_group.command_name', 'bulk-activation-status'), cls=CommandGroupWithAlias, help="""Response of a bulk attribute activation operation.""")
@cli_util.help_option_group
def bulk_activation_status_group():
    pass


@click.command(cli_util.override('attributes.bulk_unpin_status_group.command_name', 'bulk-unpin-status'), cls=CommandGroupWithAlias, help="""Response of a bulk attribute unpin operation.""")
@cli_util.help_option_group
def bulk_unpin_status_group():
    pass


@click.command(cli_util.override('attributes.bulk_de_activation_status_group.command_name', 'bulk-de-activation-status'), cls=CommandGroupWithAlias, help="""Response of a bulk attribute deactivation operation.""")
@cli_util.help_option_group
def bulk_de_activation_status_group():
    pass


apm_traces_service_cli.apm_traces_service_group.add_command(attributes_root_group)
attributes_root_group.add_command(auto_activate_status_group)
attributes_root_group.add_command(auto_activate_toggle_status_group)
attributes_root_group.add_command(bulk_update_attribute_status_group)
attributes_root_group.add_command(bulk_pin_status_group)
attributes_root_group.add_command(bulk_update_notes_status_group)
attributes_root_group.add_command(bulk_activation_status_group)
attributes_root_group.add_command(bulk_unpin_status_group)
attributes_root_group.add_command(bulk_de_activation_status_group)


@bulk_activation_status_group.command(name=cli_util.override('attributes.bulk_activate_attribute.command_name', 'bulk-activate-attribute'), help=u"""Activates a set of attributes for the given APM Domain.  The API is not case-sensitive.  Any duplicates present in the bulk activation request are deduplicated and only unique attributes are activated.  A maximum number of 700 string attributes and 100 numeric attributes can be activated in an APM Domain subject to the available string and numeric slots.  Once an attribute has been activated, it may take sometime for it to be appear in searches as ingest might not have picked up the changes or any associated caches might not have refreshed.  The bulk activation operation is atomic, and the operation succeeds only if all the attributes in the request have been processed successfully and they get a success status back.  If the processing of any attribute results in a processing or validation error, then none of the attributes in the bulk request are activated.  Attributes that are activated are unpinned by default if they are pinned. \n[Command Reference](bulkActivateAttribute)""")
@cli_util.option('--apm-domain-id', required=True, help=u"""The APM Domain ID for the intended request.""")
@cli_util.option('--attribute-details', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Collection of objects containing the details about individual attribute to be activated.

This option is a JSON list with items of type BulkActivateAttributeDetail.  For documentation on BulkActivateAttributeDetail please see our API reference: https://docs.cloud.oracle.com/api/#/en/attributes/20200630/datatypes/BulkActivateAttributeDetail.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'attribute-details': {'module': 'apm_traces', 'class': 'list[BulkActivateAttributeDetail]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'attribute-details': {'module': 'apm_traces', 'class': 'list[BulkActivateAttributeDetail]'}}, output_type={'module': 'apm_traces', 'class': 'BulkActivationStatus'})
@cli_util.wrap_exceptions
def bulk_activate_attribute(ctx, from_json, apm_domain_id, attribute_details):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if attribute_details is not None:
        _details['attributeDetails'] = cli_util.parse_json_parameter("attribute_details", attribute_details)

    client = cli_util.build_client('apm_traces', 'attributes', ctx)
    result = client.bulk_activate_attribute(
        apm_domain_id=apm_domain_id,
        bulk_activate_attribute_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@bulk_de_activation_status_group.command(name=cli_util.override('attributes.bulk_de_activate_attribute.command_name', 'bulk-de-activate-attribute'), help=u"""Deactivates a set of attributes for the given APM Domain.  The API is case in-sensitive.  Any duplicates present in the bulk deactivation request are deduplicated and only unique attributes are deactivated.  A maximum number of 700 string attributes and 100 numeric attributes can be deactivated in an APM Domain subject to the available string and numeric slots.  Out of box attributes (Trace and Span) cannot be deactivated, and will result in a processing error.  Once an attribute has been deactivated, it may take sometime for it to disappear in searches as ingest might not have picked up the changes or any associated caches might not have refreshed.  The bulk deactivation operation is atomic, and the operation succeeds only if all the attributes in the request have been processed successfully and they get a success status back.  If the processing of any attribute results in a processing or validation error, then none of the attributes in the bulk request are deactivated. \n[Command Reference](bulkDeActivateAttribute)""")
@cli_util.option('--apm-domain-id', required=True, help=u"""The APM Domain ID for the intended request.""")
@cli_util.option('--attribute-details', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Collection of objects containing the details about individual attribute to be deactivated.

This option is a JSON list with items of type BulkDeActivateAttributeDetail.  For documentation on BulkDeActivateAttributeDetail please see our API reference: https://docs.cloud.oracle.com/api/#/en/attributes/20200630/datatypes/BulkDeActivateAttributeDetail.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'attribute-details': {'module': 'apm_traces', 'class': 'list[BulkDeActivateAttributeDetail]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'attribute-details': {'module': 'apm_traces', 'class': 'list[BulkDeActivateAttributeDetail]'}}, output_type={'module': 'apm_traces', 'class': 'BulkDeActivationStatus'})
@cli_util.wrap_exceptions
def bulk_de_activate_attribute(ctx, from_json, apm_domain_id, attribute_details):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if attribute_details is not None:
        _details['attributeDetails'] = cli_util.parse_json_parameter("attribute_details", attribute_details)

    client = cli_util.build_client('apm_traces', 'attributes', ctx)
    result = client.bulk_de_activate_attribute(
        apm_domain_id=apm_domain_id,
        bulk_de_activate_attribute_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@bulk_pin_status_group.command(name=cli_util.override('attributes.bulk_pin_attribute.command_name', 'bulk-pin-attribute'), help=u"""Pin a set of attributes in the APM Domain.  Attributes that are marked pinned are not autoactivated by ingest. Attributes that are deactivated are pinned by default. \n[Command Reference](bulkPinAttribute)""")
@cli_util.option('--apm-domain-id', required=True, help=u"""The APM Domain ID for the intended request.""")
@cli_util.option('--attribute-details', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Collection of objects containing the details about individual attribute to be pinned.

This option is a JSON list with items of type BulkPinAttributeDetail.  For documentation on BulkPinAttributeDetail please see our API reference: https://docs.cloud.oracle.com/api/#/en/attributes/20200630/datatypes/BulkPinAttributeDetail.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'attribute-details': {'module': 'apm_traces', 'class': 'list[BulkPinAttributeDetail]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'attribute-details': {'module': 'apm_traces', 'class': 'list[BulkPinAttributeDetail]'}}, output_type={'module': 'apm_traces', 'class': 'BulkPinStatus'})
@cli_util.wrap_exceptions
def bulk_pin_attribute(ctx, from_json, apm_domain_id, attribute_details):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if attribute_details is not None:
        _details['attributeDetails'] = cli_util.parse_json_parameter("attribute_details", attribute_details)

    client = cli_util.build_client('apm_traces', 'attributes', ctx)
    result = client.bulk_pin_attribute(
        apm_domain_id=apm_domain_id,
        bulk_pin_attribute_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@bulk_unpin_status_group.command(name=cli_util.override('attributes.bulk_unpin_attribute.command_name', 'bulk-unpin-attribute'), help=u"""Unpin a set of attributes in the APM Domain. \n[Command Reference](bulkUnpinAttribute)""")
@cli_util.option('--apm-domain-id', required=True, help=u"""The APM Domain ID for the intended request.""")
@cli_util.option('--attribute-details', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Collection of objects containing the details about individual attribute to be unpinned.

This option is a JSON list with items of type BulkUnpinAttributeDetail.  For documentation on BulkUnpinAttributeDetail please see our API reference: https://docs.cloud.oracle.com/api/#/en/attributes/20200630/datatypes/BulkUnpinAttributeDetail.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'attribute-details': {'module': 'apm_traces', 'class': 'list[BulkUnpinAttributeDetail]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'attribute-details': {'module': 'apm_traces', 'class': 'list[BulkUnpinAttributeDetail]'}}, output_type={'module': 'apm_traces', 'class': 'BulkUnpinStatus'})
@cli_util.wrap_exceptions
def bulk_unpin_attribute(ctx, from_json, apm_domain_id, attribute_details):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if attribute_details is not None:
        _details['attributeDetails'] = cli_util.parse_json_parameter("attribute_details", attribute_details)

    client = cli_util.build_client('apm_traces', 'attributes', ctx)
    result = client.bulk_unpin_attribute(
        apm_domain_id=apm_domain_id,
        bulk_unpin_attribute_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@bulk_update_attribute_status_group.command(name=cli_util.override('attributes.bulk_update_attribute.command_name', 'bulk-update-attribute'), help=u"""Update a set of attribute properties in the APM Domain. \n[Command Reference](bulkUpdateAttribute)""")
@cli_util.option('--apm-domain-id', required=True, help=u"""The APM Domain ID for the intended request.""")
@cli_util.option('--attribute-details', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Collection of objects containing the details about individual attribute for which properties are to be updated.

This option is a JSON list with items of type BulkUpdateAttributeDetail.  For documentation on BulkUpdateAttributeDetail please see our API reference: https://docs.cloud.oracle.com/api/#/en/attributes/20200630/datatypes/BulkUpdateAttributeDetail.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'attribute-details': {'module': 'apm_traces', 'class': 'list[BulkUpdateAttributeDetail]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'attribute-details': {'module': 'apm_traces', 'class': 'list[BulkUpdateAttributeDetail]'}}, output_type={'module': 'apm_traces', 'class': 'BulkUpdateAttributeStatus'})
@cli_util.wrap_exceptions
def bulk_update_attribute(ctx, from_json, apm_domain_id, attribute_details):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if attribute_details is not None:
        _details['attributeDetails'] = cli_util.parse_json_parameter("attribute_details", attribute_details)

    client = cli_util.build_client('apm_traces', 'attributes', ctx)
    result = client.bulk_update_attribute(
        apm_domain_id=apm_domain_id,
        bulk_update_attribute_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@bulk_update_notes_status_group.command(name=cli_util.override('attributes.bulk_update_attribute_notes.command_name', 'bulk-update-attribute-notes'), help=u"""Add or edit notes to a set of attributes in the APM Domain.  Notes can be added to either an active or an inactive attribute.  The notes will be preserved even if the attribute changes state (when an active attribute is deactivated or when an inactive attribute is activated). \n[Command Reference](bulkUpdateAttributeNotes)""")
@cli_util.option('--apm-domain-id', required=True, help=u"""The APM Domain ID for the intended request.""")
@cli_util.option('--attribute-details', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Collection of objects containing the details about individual attribute for which notes are to be updated.

This option is a JSON list with items of type BulkUpdateAttributeNotesDetail.  For documentation on BulkUpdateAttributeNotesDetail please see our API reference: https://docs.cloud.oracle.com/api/#/en/attributes/20200630/datatypes/BulkUpdateAttributeNotesDetail.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'attribute-details': {'module': 'apm_traces', 'class': 'list[BulkUpdateAttributeNotesDetail]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'attribute-details': {'module': 'apm_traces', 'class': 'list[BulkUpdateAttributeNotesDetail]'}}, output_type={'module': 'apm_traces', 'class': 'BulkUpdateNotesStatus'})
@cli_util.wrap_exceptions
def bulk_update_attribute_notes(ctx, from_json, apm_domain_id, attribute_details):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if attribute_details is not None:
        _details['attributeDetails'] = cli_util.parse_json_parameter("attribute_details", attribute_details)

    client = cli_util.build_client('apm_traces', 'attributes', ctx)
    result = client.bulk_update_attribute_notes(
        apm_domain_id=apm_domain_id,
        bulk_update_attribute_notes_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@auto_activate_status_group.command(name=cli_util.override('attributes.get_status_auto_activate.command_name', 'get-status-auto-activate'), help=u"""Get autoactivation status for a private data key or public data key in the APM Domain. \n[Command Reference](getStatusAutoActivate)""")
@cli_util.option('--apm-domain-id', required=True, help=u"""The APM Domain ID for the intended request.""")
@cli_util.option('--data-key-type', required=True, type=custom_types.CliCaseInsensitiveChoice(["PRIVATE_DATA_KEY", "PUBLIC_DATA_KEY"]), help=u"""Data key type for which auto-activate needs to be turned on or off.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'apm_traces', 'class': 'AutoActivateStatus'})
@cli_util.wrap_exceptions
def get_status_auto_activate(ctx, from_json, apm_domain_id, data_key_type):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('apm_traces', 'attributes', ctx)
    result = client.get_status_auto_activate(
        apm_domain_id=apm_domain_id,
        data_key_type=data_key_type,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@auto_activate_toggle_status_group.command(name=cli_util.override('attributes.put_toggle_auto_activate.command_name', 'put-toggle-auto-activate'), help=u"""Turn on or off autoactivate for private data key or public data key traffic a given APM Domain. \n[Command Reference](putToggleAutoActivate)""")
@cli_util.option('--apm-domain-id', required=True, help=u"""The APM Domain ID for the intended request.""")
@cli_util.option('--is-auto-activate-on', required=True, type=click.BOOL, help=u"""Autoactivate toggle switch.  Set to true to turn on auto-activate.  Set to false to turn off auto-activate.""")
@cli_util.option('--data-key-type', required=True, type=custom_types.CliCaseInsensitiveChoice(["PRIVATE_DATA_KEY", "PUBLIC_DATA_KEY"]), help=u"""Data key type for which auto-activate needs to be turned on or off.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'apm_traces', 'class': 'AutoActivateToggleStatus'})
@cli_util.wrap_exceptions
def put_toggle_auto_activate(ctx, from_json, apm_domain_id, is_auto_activate_on, data_key_type):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('apm_traces', 'attributes', ctx)
    result = client.put_toggle_auto_activate(
        apm_domain_id=apm_domain_id,
        is_auto_activate_on=is_auto_activate_on,
        data_key_type=data_key_type,
        **kwargs
    )
    cli_util.render_response(result, ctx)
