# coding: utf-8
# Copyright (c) 2016, 2021, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# Copyright (c) 2020, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.


import click
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from services.management_agent.src.oci_cli_management_agent.generated import managementagent_cli
from oci_cli import custom_types  # noqa: F401


# Group name shortening
# Update version-parameterconflict to  agent-version
@cli_util.copy_params_from_generated_command(managementagent_cli.list_management_agents, params_to_exclude=['version_parameterconflict'])
@managementagent_cli.management_agent_group.command(name=cli_util.override('management_agent.management_agent_group.command_name', 'list'), help=u"""Returns a list of Management Agent.""")
@cli_util.option('--agent-version', help=u"""Filter to return only Management Agents having the particular agent version.""")
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'plugin-name': {'module': 'management_agent', 'class': 'list[string]'}}, output_type={'module': 'management_agent', 'class': 'list[ManagementAgentSummary]'})
@cli_util.wrap_exceptions
def version_parameterconflict_extended(ctx, **kwargs):
    if 'agent_version' in kwargs:
        kwargs['version_parameterconflict'] = kwargs['agent_version']
        kwargs.pop('agent_version')
    ctx.invoke(managementagent_cli.list_management_agents, **kwargs)


# Update management-agent-id to  agent-id
# @management_agent_group.command(name=cli_util.override('management_agent.delete_management_agent.command_name', 'delete'), help=u"""Deletes a Management Agent resource by identifier""")
# @cli_util.option('--management-agent-id', required=True, help=u"""Unique Management Agent identifier""")
@cli_util.copy_params_from_generated_command(managementagent_cli.delete_management_agent, params_to_exclude=['management_agent_id'])
@managementagent_cli.management_agent_group.command(name=cli_util.override('management_agent.delete_management_agent.command_name', 'delete'), help=u"""Deletes a Management Agent resource by identifier""")
@cli_util.option('--agent-id', required=True, help=u"""Unique Management Agent identifier""")
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_management_agent(ctx, **kwargs):
    if 'agent_id' in kwargs:
        kwargs['management_agent_id'] = kwargs['agent_id']
        kwargs.pop('agent_id')
    ctx.invoke(managementagent_cli.delete_management_agent, **kwargs)


# Update management-agent-id to  agent-id
# @management_agent_group.command(name=cli_util.override('management_agent.get_management_agent.command_name', 'get'), help=u"""Gets complete details of the inventory of a given agent id""")
# @cli_util.option('--management-agent-id', required=True, help=u"""Unique Management Agent identifier""")
@cli_util.copy_params_from_generated_command(managementagent_cli.get_management_agent, params_to_exclude=['management_agent_id'])
@managementagent_cli.management_agent_group.command(name=cli_util.override('management_agent.get_management_agent.command_name', 'get'), help=u"""Gets complete details of the inventory of a given agent id""")
@cli_util.option('--agent-id', required=True, help=u"""Unique Management Agent identifier""")
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'management_agent', 'class': 'ManagementAgent'})
@cli_util.wrap_exceptions
def get_management_agent(ctx, **kwargs):
    if 'agent_id' in kwargs:
        kwargs['management_agent_id'] = kwargs['agent_id']
        kwargs.pop('agent_id')
    ctx.invoke(managementagent_cli.get_management_agent, **kwargs)


# Update management-agent-id to  agent-id
# @management_agent_group.command(name=cli_util.override('management_agent.update_management_agent.command_name', 'update'), help=u"""API to update the console managed properties of the Management Agent.""")
# @cli_util.option('--management-agent-id', required=True, help=u"""Unique Management Agent identifier""")
@cli_util.copy_params_from_generated_command(managementagent_cli.update_management_agent, params_to_exclude=['management_agent_id'])
@managementagent_cli.management_agent_group.command(name=cli_util.override('management_agent.update_management_agent.command_name', 'update'), help=u"""API to update the console managed properties of the Management Agent.""")
@cli_util.option('--agent-id', required=True, help=u"""Unique Management Agent identifier""")
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'management_agent', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'management_agent', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'management_agent', 'class': 'ManagementAgent'})
@cli_util.wrap_exceptions
def update_management_agent(ctx, **kwargs):
    if 'agent_id' in kwargs:
        kwargs['management_agent_id'] = kwargs['agent_id']
        kwargs.pop('agent_id')
    ctx.invoke(managementagent_cli.update_management_agent, **kwargs)


# Update management-agent-install-key-id to install-key
# @management_agent_install_key_group.command(name=cli_util.override('management_agent.update_management_agent_install_key.command_name', 'update'), help=u"""API to update the modifiable properties of the Management Agent install key.""")
# @cli_util.option('--management-agent-install-key-id', required=True, help=u"""Unique Management Agent Install Key identifier""")
#
@cli_util.copy_params_from_generated_command(managementagent_cli.update_management_agent_install_key, params_to_exclude=['management_agent_install_key_id'])
@managementagent_cli.management_agent_install_key_group.command(name=cli_util.override('management_agent.update_management_agent_install_key.command_name', 'update'), help=u"""API to update the modifiable properties of the Management Agent install key.""")
@cli_util.option('--install-key-id', required=True, help=u"""Unique Management Agent Install Key identifier""")
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'management_agent', 'class': 'ManagementAgentInstallKey'})
@cli_util.wrap_exceptions
def update_management_agent_install_key(ctx, **kwargs):
    if 'install_key_id' in kwargs:
        kwargs['management_agent_install_key_id'] = kwargs['install_key_id']
        kwargs.pop('install_key_id')
    ctx.invoke(managementagent_cli.update_management_agent_install_key, **kwargs)


# Update management-agent-install-key-id to install-key
# @management_agent_install_key_group.command(name=cli_util.override('management_agent.delete_management_agent_install_key.command_name', 'delete'), help=u"""Deletes a Management Agent install Key resource by identifier""")
# @cli_util.option('--management-agent-install-key-id', required=True, help=u"""Unique Management Agent Install Key identifier""")
#
@cli_util.copy_params_from_generated_command(managementagent_cli.delete_management_agent_install_key, params_to_exclude=['management_agent_install_key_id'])
@managementagent_cli.management_agent_install_key_group.command(name=cli_util.override('management_agent.delete_management_agent_install_key.command_name', 'delete'), help=u"""Deletes a Management Agent install Key resource by identifier""")
@cli_util.option('--install-key-id', required=True, help=u"""Unique Management Agent Install Key identifier""")
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_management_agent_install_key(ctx, **kwargs):
    if 'install_key_id' in kwargs:
        kwargs['management_agent_install_key_id'] = kwargs['install_key_id']
        kwargs.pop('install_key_id')
    ctx.invoke(managementagent_cli.delete_management_agent_install_key, **kwargs)


# Update management-agent-install-key-id to install-key
# @management_agent_install_key_group.command(name=cli_util.override('management_agent.get_management_agent_install_key.command_name', 'get'), help=u"""Gets complete details of the Agent install Key for a given key id""")
# @cli_util.option('--management-agent-install-key-id', required=True, help=u"""Unique Management Agent Install Key identifier""")
#
@cli_util.copy_params_from_generated_command(managementagent_cli.get_management_agent_install_key, params_to_exclude=['management_agent_install_key_id'])
@managementagent_cli.management_agent_install_key_group.command(name=cli_util.override('management_agent.get_management_agent_install_key.command_name', 'get'), help=u"""Gets complete details of the Agent install Key for a given key id""")
@cli_util.option('--install-key-id', required=True, help=u"""Unique Management Agent Install Key identifier""")
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'management_agent', 'class': 'ManagementAgentInstallKey'})
@cli_util.wrap_exceptions
def get_management_agent_install_key(ctx, **kwargs):
    if 'install_key_id' in kwargs:
        kwargs['management_agent_install_key_id'] = kwargs['install_key_id']
        kwargs.pop('install_key_id')
    ctx.invoke(managementagent_cli.get_management_agent_install_key, **kwargs)


# Rename management_agent management_agent   to   management_agent agent
cli_util.rename_command(managementagent_cli, managementagent_cli.management_agent_root_group, managementagent_cli.management_agent_group, "agent")
cli_util.rename_command(managementagent_cli, managementagent_cli.management_agent_root_group, managementagent_cli.management_agent_image_group, "agent-image")
cli_util.rename_command(managementagent_cli, managementagent_cli.management_agent_root_group, managementagent_cli.management_agent_install_key_group, "install-key")

# Rename
#   oci management-agent install-key get-management-agent-install-key-content
#  to
#   oci management-agent install-key get-install-key-content
cli_util.rename_command(managementagent_cli, managementagent_cli.management_agent_install_key_group, managementagent_cli.get_management_agent_install_key_content, "get-install-key-content")

# Rename
#  oci management-agent management-agent-plugin list
# to
#  oci management-agent plugin list
cli_util.rename_command(managementagent_cli, managementagent_cli.management_agent_root_group, managementagent_cli.management_agent_plugin_group, "plugin")


# Rename
#  oci management-agent agent summarize-management-agent-counts
# to
#  oci management-agent agent summarize-agent-counts
cli_util.rename_command(managementagent_cli, managementagent_cli.management_agent_group, managementagent_cli.summarize_management_agent_counts, "summarize-agent-counts")

# Rename
#  oci management-agent agent summarize-management-agent-plugin-counts
# to
#  oci management-agent agent summarize-plugin-counts
cli_util.rename_command(managementagent_cli, managementagent_cli.management_agent_group, managementagent_cli.summarize_management_agent_plugin_counts, "summarize-plugin-counts")


#  oci management-agent agent summarize-management-agent-plugin-counts --group-by   clashes with --group-by for agent
@cli_util.copy_params_from_generated_command(managementagent_cli.summarize_management_agent_plugin_counts, params_to_exclude=['group_by'])
@managementagent_cli.management_agent_group.command(name=cli_util.override('management_agent.summarize-plugin-counts.command_name', 'summarize-plugin-counts'), help=u"""Gets count of the inventory of management agent plugins for a given compartment id and group by parameter. Supported groupBy parameter: pluginName \n[Command Reference](summarizeManagementAgentPluginCounts)""")
@cli_util.option('--plugin-group-by', required=True, type=custom_types.CliCaseInsensitiveChoice(["pluginName"]), help=u"""The field by which to group Management Agent Plugins""")
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'management_agent', 'class': 'ManagementAgentPluginAggregationCollection'})
@cli_util.wrap_exceptions
def summarize_management_agent_plugin_counts(ctx, **kwargs):
    if 'plugin_group_by' in kwargs:
        kwargs['group_by'] = kwargs['plugin_group_by']
        kwargs.pop('plugin_group_by')
    ctx.invoke(managementagent_cli.summarize_management_agent_plugin_counts, **kwargs)


# oci management-agent agent create-data-source-create-prometheus-emitter-data-source-details -> oci management-agent agent create-prometheus-datasource
cli_util.rename_command(managementagent_cli, managementagent_cli.management_agent_group, managementagent_cli.create_data_source_create_prometheus_emitter_data_source_details, "create-prometheus-datasource")


# oci management-agent agent update-data-source-update-prometheus-emitter-data-source-details -> oci management-agent agent update-prometheus-datasource
cli_util.rename_command(managementagent_cli, managementagent_cli.management_agent_group, managementagent_cli.update_data_source_update_prometheus_emitter_data_source_details, "update-prometheus-datasource")


@cli_util.copy_params_from_generated_command(managementagent_cli.create_data_source_create_prometheus_emitter_data_source_details, params_to_exclude=['read_data_limit_in_kilobytes'])
@managementagent_cli.management_agent_group.command(name=managementagent_cli.create_data_source_create_prometheus_emitter_data_source_details.name, help=managementagent_cli.create_data_source_create_prometheus_emitter_data_source_details.help)
@cli_util.option('--read-data-limit', help=u"""Number in kilobytes. The limit on the data being sent, not to exceed the agent's fixed limit of 400 (KB).""")
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'metric-dimensions': {'module': 'management_agent', 'class': 'list[MetricDimension]'}})
@cli_util.wrap_exceptions
def create_data_source_create_prometheus_emitter_data_source_details_extended(ctx, **kwargs):

    if 'read_data_limit' in kwargs:
        kwargs['read_data_limit_in_kilobytes'] = kwargs['read_data_limit']
        kwargs.pop('read_data_limit')

    ctx.invoke(managementagent_cli.create_data_source_create_prometheus_emitter_data_source_details, **kwargs)


@cli_util.copy_params_from_generated_command(managementagent_cli.update_data_source_update_prometheus_emitter_data_source_details, params_to_exclude=['read_data_limit_in_kilobytes'])
@managementagent_cli.management_agent_group.command(name=managementagent_cli.update_data_source_update_prometheus_emitter_data_source_details.name, help=managementagent_cli.update_data_source_update_prometheus_emitter_data_source_details.help)
@cli_util.option('--read-data-limit', help=u"""Number in kilobytes. The limit on the data being sent, not to exceed the agent's fixed limit of 400 (KB).""")
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'metric-dimensions': {'module': 'management_agent', 'class': 'list[MetricDimension]'}})
@cli_util.wrap_exceptions
def update_data_source_update_prometheus_emitter_data_source_details_extended(ctx, **kwargs):

    if 'read_data_limit' in kwargs:
        kwargs['read_data_limit_in_kilobytes'] = kwargs['read_data_limit']
        kwargs.pop('read_data_limit')

    ctx.invoke(managementagent_cli.update_data_source_update_prometheus_emitter_data_source_details, **kwargs)


# Remove create-data-source from oci management-agent agent
managementagent_cli.management_agent_group.commands.pop(managementagent_cli.create_data_source.name)


# Remove update-data-source from oci management-agent agent
managementagent_cli.management_agent_group.commands.pop(managementagent_cli.update_data_source.name)
