# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20191001

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.osp_gateway.src.oci_cli_osp_gateway.generated import osp_gateway_service_cli


@click.command(cli_util.override('address_rule_service.address_rule_service_root_group.command_name', 'address-rule-service'), cls=CommandGroupWithAlias, help=cli_util.override('address_rule_service.address_rule_service_root_group.help', """This site describes all the Rest endpoints of OSP Gateway."""), short_help=cli_util.override('address_rule_service.address_rule_service_root_group.short_help', """OSP Gateway API"""))
@cli_util.help_option_group
def address_rule_service_root_group():
    pass


@click.command(cli_util.override('address_rule_service.address_rule_group.command_name', 'address-rule'), cls=CommandGroupWithAlias, help="""Addres rule information""")
@cli_util.help_option_group
def address_rule_group():
    pass


osp_gateway_service_cli.osp_gateway_service_group.add_command(address_rule_service_root_group)
address_rule_service_root_group.add_command(address_rule_group)


@address_rule_group.command(name=cli_util.override('address_rule_service.get_address_rule.command_name', 'get'), help=u"""Get the address rule for the compartment based on the country code \n[Command Reference](getAddressRule)""")
@cli_util.option('--osp-home-region', required=True, help=u"""The home region's public name of the logged in user.""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment.""")
@cli_util.option('--country-code', required=True, help=u"""Country code for the address rule in ISO-3166-1 2-letter format.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'osp_gateway', 'class': 'AddressRule'})
@cli_util.wrap_exceptions
def get_address_rule(ctx, from_json, osp_home_region, compartment_id, country_code):

    if isinstance(country_code, six.string_types) and len(country_code.strip()) == 0:
        raise click.UsageError('Parameter --country-code cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('osp_gateway', 'address_rule_service', ctx)
    result = client.get_address_rule(
        osp_home_region=osp_home_region,
        compartment_id=compartment_id,
        country_code=country_code,
        **kwargs
    )
    cli_util.render_response(result, ctx)
